////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: Container 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _CONTAINER_H_
#define _CONTAINER_H_

#include <item.h>
#include <addbulk.t>
#include <itemcount.t>
#include <listcont.t>

#pragma C+

/*
 *  Container: Item
 *
 *  This object can contain other objects.  The isContainer property
 *  is set to true.  The default lDesc displays a list of the
 *  objects inside the Container, if any.  The maxBulk property
 *  specifies the maximum amount of bulk the Container can contain.
 */
class Container: Item
    isContainer = true      // Item can contain other items
    isOpen = true           // in fact, it can't be closed at all
    maxBulk = 10            // maximum bulk the container can contain
    boardingPrep = "in"
    unboardingPrep = "out of"         
    lDesc = {
        if (self.canSenseContents(sight, nil) 
        && itemCount(self.contents) != 0) {
            "In <<self.theDesc>> %you% see%s% "; listCont(self); ". ";
        } else {
            "There's nothing in "; self.theDesc; ". ";
        }
    }
    
    canSenseLocations(sense, isVantage) = {
        return self.canSenseContents(sense, isVantage);
    }
    /*
     *  Does the object allow its contents to be sensed?
     */
    canSenseContents(sense, isVantage) = {
        if (self.isOpen || isVantage)
            return true;
        else return self.material.senseThru(sense);
    }
    
    verDoLookin(actor) = {}
    doLookin(actor) = {
        self.doSearch(actor);
    }
    
    verIoPutIn(actor) = {}
    ioPutIn(actor, dobj) = {
        if (addBulk(self.contents) + dobj.bulk > self.maxBulk) {
            "%You% can't fit <<dobj.thatDesc>> in "; self.theDesc; ". ";
        } else {
            dobj.doPutIn(actor, self);
        }
    }
    
    verDoSearch(actor) = {}
    doSearch(actor) = {
        if (self.canSenseContents(sight, nil) && itemCount(self.contents) != 0)
            "In <<self.theDesc>> %you% see%s% <<listCont(self)>>. ";
        else
            "There's nothing in <<self.theDesc>>. ";
    }
;

#pragma C-

#endif /* _CONTAINER_H_ */
