////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: Destination 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _DESTINATION_H_
#define _DESTINATION_H_

#pragma C+

/*----------------------------------------------------------------------
 *  MIX-IN CLASS:   This class must always preced any non-mix-in classes
 *                  in a superclass list - this is required because a
 *                  mix-in can't override default methods in the root of
 *                  the hierarchy.
 *--------------------------------------------------------------------*/

/*
 *  Destination: object
 *
 *  A Destination is used in place of a Room for a direction
 *  property.  The destination property specifies the Room that
 *  is reached if the Destination is successfully negotiated; when the
 *  Destination is not successfully negotiated, destination should
 *  display an appropriate message and return nil.
 */
class Destination: object
    isDestination = true
    leadsTo = nil
    /*
     *  A Destination has an obstacle when it cannot be successfully
     *  negotiated. If this is the case the method should return true;
     *  otherwise it should return nil, meaning passage is allowed.
     */
    hasObstacle = {return nil;}
    destination = {
        /* This object isn't anywhere, so there's nowhere to go */
        if (self.location == nil)
            return self.noExit;
            
        if (self.hasObstacle)
            return nil;
        else return self.findDest;
    } 
    findDest = {return self.leadsTo;}
    noExit = { 
        "%You% can't go that way. "; 
        return nil; 
    }
;

#pragma C-

#endif /* _DESTINATION_H_ */
