////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: Doorway 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _DOORWAY_H_
#define _DOORWAY_H_

#include <openable.h>
#include <passageway.h>

#pragma C+

/*
 *  Doorway: Openable, Passageway
 *
 *  A Doorway is a Destination that impedes progress when it is closed.
 *  When the Doorway is open (isOpen == true), the user ends up in
 *  the Room specified in the leadsTo property upon going through
 *  the Doorway.  Since a Doorway is a Destination, use the Doorway object
 *  for a direction property of the Room containing the Doorway.
 *  
 *  If noAutoOpen is not set to true, the Doorway will automatically
 *  be opened when the player tries to walk through the Doorway, unless
 *  the Doorway is locked (isLocked == true).  If the Doorway is locked,
 *  it can be unlocked simply by typing "unlock door", unless the
 *  myKey property is set, in which case the object specified in
 *  myKey must be used to unlock the door.  Note that the Doorway can
 *  only be relocked by the player under the circumstances that allow
 *  unlocking, plus the property isLockable must be set to true.
 *  By default, the Doorway is closed; set isOpen to true if the Doorway
 *  is to start out open (and be sure to open the other side as well).
 *  
 *  otherSide specifies the corresponding Doorway object in the
 *  destination room (leadsTo), if any.  If otherSide is
 *  specified, its isOpen and isLocked properties will be
 *  kept in sync automatically.
 */
class Doorway: Openable, Passageway
    isDoor = true  
    isOpen = nil         // Item starts out closed
    lDesc = {
        if (self.isOpen)
            "\^<<self.itIsDesc>> open. ";
        else {
            if (self.isLocked)
                "\^<<self.itIsDesc>> closed and locked. ";
            else
                "\^<<self.itIsDesc>> closed. ";
        }
    }
    /*
     *  A Doorway has an obstacle if it is not open and can't
     *  automatically be opened or it is not open and is locked.
     *  Otherwise passage is allowed.
     */
    hasObstacle = {
        if (self.isOpen)
            return nil;
        else if (!self.isLocked && !self.noAutoOpen) {
            self.setIsOpen(true);
            "(Opening << self.theDesc >>)\n";
            return nil;
        } else {
            "%You%'ll have to open << self.theDesc >> first. ";
            setit(self);
            return true;
        }
    }  
    verDoKnock(actor) = {}
    doKnock(actor) = { "There is no answer. "; }
;

#pragma C-

#endif /* _DOORWAY_H_ */
