////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: Gateway 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _GATEWAY_H_
#define _GATEWAY_H_

#include <raisable.h>
#include <passageway.h>

#pragma C+

/*
 *  Gateway: Raisable, Passageway
 *
 *  A Gateway is a Destination that impedes progress when it is either
 *  lowered or raised, depending upon which direction blocks access.
 *  You can change the direction of access by setting the object's 
 *  accessState.
 *
 *  Gateways should code a location and leadsTo property to indicate
 *  where the Gateway resides and where it leads to when the Destination
 *  has been successfully negotiated.
 */
class Gateway: Raisable, Passageway
    isGate = true  
    isRaised = nil          // Item starts out lowered
    gateAccessState = true      // Item is passable when "raised"
    isGateActive = {return (self.gateAccessState == self.isRaised);}
    lDesc = {
        "\^<<self.itIsDesc>> ";
        if (self.isRaised)
            "raised";
        else "lowered";
        if (self.isLockable && self.isLocked)
            " and locked";
        ". ";
    }
    /*
     *  A Gateway has an obstacle when it's not active and it cannot
     *  automatically be raised (it may be locked). Otherwise passage is
     *  permitted.
     */
    hasObstacle = {
        if (self.isGateActive)
            return nil;
        else if (!self.isLocked && !self.noAutoRaise) {
            if (self.isRaised) {
                self.setIsRaised(nil);
                "(Lowering";
            } else {
                self.setIsRaised(true);
                "(Raising";
            }
            " << self.theDesc >>)\n";
            return nil;
        } else {
            "%You%'ll have to <<self.isRaised ? "lower" : "raise">> 
            << self.theDesc >> first. ";
            setit(self);
            return true;
        }
    } 
;

#pragma C-

#endif /* _GATEWAY_H_ */
