////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: Hidden 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _HIDDEN_H_
#define _HIDDEN_H_

#pragma C+

/*----------------------------------------------------------------------
 *  MARKER CLASS:   This class must always follow any non-marker classes
 *                  in a superclass list. Marker classes define no 
 *                  behaviours and rely entirely upon the library 
 *                  mechanism.
 *--------------------------------------------------------------------*/

/*
 *  Hidden: object
 *
 *  This is an object that is hidden with one of the Hider classes. 
 *  A Hidden object doesn't have any special properties in its
 *  own right, but all objects hidden with one of the Hider classes
 *  must be of class Hidden so that initSearch() can find
 *  them.
 */
class Hidden: object
;

#pragma C-

#endif /* _HIDDEN_H_ */
