////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: Item 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _ITEM_H_
#define _ITEM_H_

#include <thing.h>

#pragma C+

/*
 *  Item: Thing
 *
 *  A basic Item which can be picked up by the player.  It has no weight
 *  (0) and minimal bulk (1).  The weight property should be set
 *  to a non-zero value for heavy objects.  The bulk property
 *  should be set to a value greater than 1 for bulky objects, and to
 *  zero for objects that are very small and take essentially no effort
 *  to hold---or, more precisely, don't detract at all from the player's
 *  ability to hold other objects (for example, a piece of paper).
 */
class Item: Thing
    bulk    = 1
    weight  = 0
;

#pragma C-

#endif /* _ITEM_H_ */
