////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: SwitchItem 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _SWITCH_ITEM_H_
#define _SWITCH_ITEM_H_

#include <fixeditem.h>

#pragma C+

/*
 *  SwitchItem: FixedItem
 *
 *  This is a class for things that can be turned on and off by the
 *  player.  The only special property is isActive, which is nil
 *  if the switch is turned off and true when turned on.  The object
 *  accepts the commands "turn it on" and "turn it off," as well as
 *  synonymous constructions, and updates isActive accordingly.
 */
class SwitchItem: FixedItem
    isSwitchable = true
    verDoSwitch(actor) = {}
    doSwitch(actor) = {
        self.isActive = !self.isActive;
        "Okay, "; self.theDesc; " <<self.isDesc>> now switched ";
        if (self.isActive)
            "on";
        else
            "off";
        ". ";
    }
    verDoTurnon(actor) = {
        /*
         *   You can't turn on something in the dark unless you're
         *   carrying it.  You also can't turn something on if it's
         *   already on.  
         */
        if (!actor.location.isLit(actor) && !actor.isCarrying(self))
            "It's pitch black.";
        else if (self.isActive)
            "\^<<self.itIsDesc>> already turned on! ";
    }
    verDoTurnoff(actor) = {
        if (!self.isActive)
            "\^<<self.itIsDesc>> already turned off! ";
    }
    doTurnoff(actor) = {
        self.isActive = nil;
        "Okay, <<self.itIsDesc>> now turned off. ";
    }
    doTurnon(actor) = {
        self.isActive = true;
        "Okay, <<self.itIsDesc>> now turned on. ";
    }
;

#pragma C-

#endif /* _SWITCH_ITEM_H_ */
