////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: UnderHider 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _UNDER_HIDER_H_
#define _UNDER_HIDER_H_

#include <hider.h>

#pragma C+

/*
 *  UnderHider: hider
 *
 *  This is an object that can have other objects placed under it.  The
 *  objects placed under it can only be found by looking under the object;
 *  see the description of hider for more information.  You should
 *  set the underLoc property of each hidden object to point to
 *  the underHider.
 *  
 *  Note that an underHider doesn't allow the player to put anything
 *  under the object during the game.  Instead, it's to make it easy for the
 *  game writer to set up hidden objects while implementing the game.  All you
 *  need to do to place an object under another object is declare the top
 *  object as an UnderHider, then declare the hidden object normally,
 *  except use underLoc rather than location to specify the
 *  location of the hidden object.  The BehindHider and SearchHider
 *  objects work similarly.
 *  
 *  The objects hidden with UnderHider must be of class Hidden.
 */
class UnderHider: Hider
    underCont = []         /* list of items under me (set up by initSearch) */
    verDoLookunder(actor) = {}
    doLookunder(actor) = {
        if (self.underCont == nil)
            "There's nothing else under <<self.theDesc>>. ";
        else
            self.underCont = self.searchObj(actor, self.underCont);
    }
;

#pragma C-

#endif /* _UNDER_HIDER_H_ */
