////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: Wearable 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _WEARABLE_H_
#define _WEARABLE_H_

#include <addbulk.t>

#pragma C+

/*----------------------------------------------------------------------
 *  MIX-IN CLASS:   This class must always preced any non-mix-in classes
 *                  in a superclass list - this is required because a
 *                  mix-in can't override default methods in the root of
 *                  the hierarchy.
 *--------------------------------------------------------------------*/

/*
 *  Wearable: object
 *
 *  Something that can be worn.  By default, the only thing that
 *  happens when the class is worn is that its wearer property
 *  is set to true.  If you want more to happen, override the
 *  doWear(actor) property.  Note that, when a Wearable
 *  is being worn, certain operations will cause it to be removed (for
 *  example, dropping it causes it to be removed).  If you want
 *  something else to happen, override the checkDrop method;
 *  if you want to disallow such actions while the object is worn,
 *  use an exit statement in the checkDrop method.
 */
class Wearable: object
    isWearable = true
    /*
     *  The wearer attribute is set when a ClothingItem object is put
     *  on. The attribute points to the object that is wearing the
     *  ClothingItem object. This means that clothing can have different
     *  locations, but be worn by the same actor.
     */
    wearer = nil
    /*
     *  isWorn 
     *
     *  Method returns true if the object is being worn; otherwise it
     *  returns nil.
     */
    isWorn = {
        if (self.wearer)
            return true;
        else
            return nil;
    }
    /*
     *  isWornby(actor)
     *
     *  Method returns true if the object is being worn by the specified
     *  actor; otherwise returns nil.
     */
    isWornBy(actor) = {
        if (self.wearer == actor)
            return true;
        else
            return nil;
    }
    verDoUnwear(actor) = {
        if (!self.isWornBy(actor)) {
            "%You're% not wearing <<self.theDesc>>. ";
        }
    }
    doUnwear(actor) = {
        /* ensure that maximum bulk is not exceeded */
        if (addBulk(actor.contents) + self.bulk > actor.maxBulk) {
            "%You% could drop <<self.theDesc>>, but %your% hands are
            too full to carry <<self.itObjDesc>>. ";
        } else {
            /* doff the item */
            "Okay, %you're% no longer wearing "; self.theDesc; ". ";
            self.wearer = nil;
        }
    }
    verDoWear(actor) = {
        if (self.isWornBy(actor)) {
            "%You're% already wearing <<self.theDesc>>1 ! ";
        }
    }
    doWear(actor) = {
        local ret, str, lst, flags;
        /* 
         *   if the actor is not directly carrying it (in other words,
         *   it's either not in the player's inventory at all, or it's
         *   within a container within the actor's inventory), take it --
         *   the actor must be directly holding the object for this to
         *   succeed 
         */
        if (self.location != actor) {
            /* try taking it */
            "(First taking _dobj_)\n";
            if (command(actor, takeVerb, self, EC_HIDE_SUCCESS) != 0)
                exit;

            /* 
             *   make certain it ended up where we want it - the command
             *   might have failed without actually indicating failure 
             */
            if (self.location != actor)
                exit;
        }

        /* wear it */
        "Okay, %you're% now wearing _dobj_. ";
        self.wearer = actor;
    }
    doSynonym('Unwear') = 'Unboard'
;

#pragma C-

#endif /* _WEARABLE_H_ */
