////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: WysiwygTable 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _WYSIWYG_TABLE_H_
#define _WYSIWYG_TABLE_H_

#include <wysiwyg.h>

#pragma C+

/*
 *	WysiwygTable: Wysiwyg
 *
 *	The WysiwygTable is a Wysiwyg which formats the heading, body, and footer
 *	areas into table rows (three in total) which gives each section a separate 
 *	border.
 *
 *	Additionally, each section of the table can then have its own background
 *	color as well as font style.
 */
class WysiwygTable: Wysiwyg
#ifdef USE_HTML_STATUS

    lDesc = {
        if (systemInfo(__SYSINFO_SYSINFO) == true
        and systemInfo(__SYSINFO_HTML) == 1) {
        	self.tableFmtBegin;
        	if (length(self.headerText) > 0)
        		self.displayHeader;
        	if (length(self.bodyText) > 0)
        		self.displayBody;
        	if (length(self.footerText) > 0)
        		self.displayFooter;
        	self.tableFmtEnd;
        } else {
        	if (length(self.headerText) > 0)
        		self.printWysiwyg(self.headerText);
        	if (length(self.bodyText) > 0)
        		self.printWysiwyg(self.bodyText);
        	if (length(self.footerText) > 0)
        		self.printWysiwyg(self.footerText);
		}
    }
    
#else 	/* USE_HTML_STATUS */
    
    lDesc = {
    	if (length(self.headerText) > 0)
      		self.printWysiwig(self.headerText);
   		if (length(self.bodyText) > 0)
       		self.printWysiwig(self.bodyText);
     	if (length(self.footerText) > 0)
     		self.printWysiwig(self.footerText);
    }
    
#endif	/* USE_HTML_STATUS */
    
	displayHeader = {
        self.headerBGCOLOR;
        self.headerFont;
        self.headerFmtBegin;
        self.printWysiwyg(self.headerText);
        self.headerFmtEnd;
    }
    displayBody = {
        self.bodyFmtBegin;
        self.bodyBGCOLOR;
        self.bodyFont;
        self.printWysiwyg(self.bodyText);
        self.bodyFmtEnd;        
    }
    displayFooter = {
        self.footerBGCOLOR;
        self.footerFont;
        self.footerFmtBegin;
        self.printWysiwyg(self.footerText);
        self.footerFmtEnd;        
    }
    tableFmtBegin = {
        "<BR>
        <P>
        <CENTER>
        <TABLE BORDER=1 CELLPADDING=15>";
    }
    tableFmtEnd = {
        "</TABLE>
        </CENTER>
        </P>";        
    }
    headerBGCOLOR = {
        "<TR BGCOLOR=\"#AAAAAA\">
        <TD BGCOLOR=\"#AAAAAA\">";        
    }
    headerFont = {
        "<FONT COLOR=YELLOW SIZE=\"+1\" FACE=\"Courier New,Courier New\">";
    }
    headerFmtBegin = {
        "<P>
        <B>
        <CENTER>";
    }
    headerFmtEnd = {
        "</CENTER>
        </B>
        </P>
        </FONT>
        </TD>
        </TR>";
    }
    bodyBGCOLOR = { self.headerBGCOLOR; }
    bodyFont = {
        "<FONT COLOR=WHITE FACE=\"Courier New,Courier New\">";  
    }
    bodyFmtBegin = {
        "<P>";
    }
    bodyFmtEnd = {
        "</P>
        </FONT>
        </TD>
        </TR>";
    }
    footerBGCOLOR = { self.headerBGCOLOR; }
    footerFont = {
        "<FONT COLOR=YELLOW SIZE=\"-2\" FACE=\"Courier New,Courier New\">";
    }
    footerFmtBegin = {   
        "<P>
        <B>
        <CENTER>";
    }
    footerFmtEnd = {
        "</CENTER>
        </B>		
        </P>
        </FONT>
        </TD>
        </TR>";
    }
;

#pragma C-

#endif /* _WYSIWYG_TABLE_H_ */
