////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: Constants 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _CONSTANTS_H_
#define _CONSTANTS_H_

#pragma C+

/* ------------------------------------------------------------------------ */
/*
 *   Constants for parser status codes.  These codes are passed to
 *   parseError and parseErrorParam to indicate which message these
 *   routines should display.  In addition, these codes are returned by
 *   parserResolveObjects.
 */

#define PRS_SUCCESS           0                                  /* success */

#define PRSERR_BAD_PUNCT      1       /* I don't understand the punctuation */
#define PRSERR_UNK_WORD       2                    /* I don't know the word */
#define PRSERR_TOO_MANY_OBJS  3      /* The word refers to too many objects */
#define PRSERR_ALL_OF         4    /* You left something out after "all of" */
#define PRSERR_BOTH_OF        5   /* You left something out after "both of" */
#define PRSERR_OF_NOUN        6               /* Expected a noun after "of" */
#define PRSERR_ART_NOUN       7    /* An article must be followed by a noun */
#define PRSERR_DONT_SEE_ANY   9                  /* I don't see any %s here */
#define PRSERR_TOO_MANY_OBJS2 10   /* Referring to too many objects with %s */
#define PRSERR_TOO_MANY_OBJS3 11           /* Referring to too many objects */
#define PRSERR_ONE_ACTOR      12        /* You can only speak to one person */
#define PRSERR_DONT_KNOW_REF  13     /* Don't know what you're referring to */
#define PRSERR_DONT_KNOW_REF2 14     /* Don't know what you're referring to */
#define PRSERR_DONT_SEE_REF   15      /* Don't see what you're referring to */
#define PRSERR_DONT_SEE_ANY2  16               /* You don't see any %s here */
#define PRSERR_NO_MULTI_IO    25     /* can't use multiple indirect objects */
#define PRSERR_NO_AGAIN       26            /* There's no command to repeat */
#define PRSERR_BAD_AGAIN      27           /* You can't repeat that command */
#define PRSERR_NO_MULTI       28   /* can't use multiple objects w/this cmd */
#define PRSERR_ANY_OF         29   /* You left something out after "any of" */
#define PRSERR_ONLY_SEE       30                  /* I only see %d of those */
#define PRSERR_CANT_TALK      31                  /* You can't talk to that */
#define PRSERR_INT_PPC_INV    32      /* internal: invalid preparseCmd list */
#define PRSERR_INT_PPC_LONG   33  /* internal: preparseCmd command too long */
#define PRSERR_INT_PPC_LOOP   34              /* internal: preparseCmd loop */
#define PRSERR_DONT_SEE_ANY_MORE 38     /* You don't see that here any more */
#define PRSERR_DONT_SEE_THAT  39                 /* You don't see that here */

#define PRSERR_NO_NEW_NUM     40        /* can't create new numbered object */
#define PRSERR_BAD_DIS_STAT   41        /* invalid status from disambigXobj */
#define PRSERR_EMPTY_DISAMBIG 42        /* empty response to disambig query */
#define PRSERR_DISAMBIG_RETRY 43   /* retry object disambig response as cmd */
#define PRSERR_AMBIGUOUS      44                 /* objects still ambiguous */
#define PRSERR_OOPS_UPDATE    45             /* command corrected by "oops" */

#define PRSERR_TRY_AGAIN      100                  /* Let's try it again... */
#define PRSERR_WHICH_PFX      101                /* Which %s do you mean... */
#define PRSERR_WHICH_COMMA    102                                /* (comma) */
#define PRSERR_WHICH_OR       103                               /* ...or... */
#define PRSERR_WHICH_QUESTION 104                        /* (question mark) */

#define PRSERR_DONTKNOW_PFX   110                 /* I don't know how to... */
#define PRSERR_DONTKNOW_SPC   111                                /* (space) */
#define PRSERR_DONTKNOW_ANY   112                            /* ...anything */
#define PRSERR_DONTKNOW_TO    113                               /* ...to... */
#define PRSERR_DONTKNOW_SPC2  114                                /* (space) */
#define PRSERR_DONTKNOW_END   115                               /* (period) */

#define PRSERR_MULTI          120     /* (colon) for multiple-object prefix */

#define PRSERR_ASSUME_OPEN    130     /* (open paren) for defaulted objects */
#define PRSERR_ASSUME_CLOSE   131                          /* (close paren) */
#define PRSERR_ASSUME_SPC     132                                /* (space) */

#define PRSERR_WHAT_PFX       140                 /* What do you want to... */
#define PRSERR_WHAT_IT        141                               /* ...it... */
#define PRSERR_WHAT_TO        142                               /* ...to... */
#define PRSERR_WHAT_END       143                        /* (question mark) */
#define PRSERR_WHAT_THEM      144                             /* ...them... */
#define PRSERR_WHAT_HIM       145                              /* ...him... */
#define PRSERR_WHAT_HER       146                              /* ...her... */
#define PRSERR_WHAT_THEM2     147                             /* ...them... */
#define PRSERR_WHAT_PFX2      148                    /* What do you want... */
#define PRSERR_WHAT_TOSPC     149                               /* ...to... */

#define PRSERR_MORE_SPECIFIC  160        /* you'll have to be more specific */

#define PRSERR_NOREACH_MULTI  200     /* (colon) for prefixing unreachables */


/* ------------------------------------------------------------------------ */
/* 
 *   constants for the event codes returned by the inputevent() intrinsic
 *   function 
 */
#define INPUT_EVENT_KEY        1
#define INPUT_EVENT_TIMEOUT    2
#define INPUT_EVENT_HREF       3
#define INPUT_EVENT_NOTIMEOUT  4
#define INPUT_EVENT_EOF        5

/*
 *   constants for inputdialog() 
 */
#define INDLG_OK               1
#define INDLG_OKCANCEL         2
#define INDLG_YESNO            3
#define INDLG_YESNOCANCEL      4

#define INDLG_ICON_NONE        0
#define INDLG_ICON_WARNING     1
#define INDLG_ICON_INFO        2
#define INDLG_ICON_QUESTION    3
#define INDLG_ICON_ERROR       4

#define INDLG_LBL_OK           1
#define INDLG_LBL_CANCEL       2
#define INDLG_LBL_YES          3
#define INDLG_LBL_NO           4

/*
 *   constants for gettime() type codes 
 */
#define GETTIME_DATE_AND_TIME  1
#define GETTIME_TICKS          2

/*
 *   constants for askfile() prompt type codes 
 */
#define ASKFILE_PROMPT_OPEN    1       /* open an existing file for reading */
#define ASKFILE_PROMPT_SAVE    2                        /* save to the file */

/*
 *   constants for askfile() flags 
 */
#define ASKFILE_EXT_RESULT     1                   /* extended result codes */

/*
 *   askfile() return codes - these are returned in the first element of
 *   the list returned from askfile() when ASKFILE_EXT_RESULT is used in
 *   the 'flags' parameter 
 */
#define ASKFILE_SUCCESS        0  /* success - 2nd list element is filename */
#define ASKFILE_FAILURE        1     /* an error occurred asking for a file */
#define ASKFILE_CANCEL         2       /* player canceled the file selector */

/*
 *   constants for askfile() file type codes 
 */
#define FILE_TYPE_GAME    0                      /* a game data file (.gam) */
#define FILE_TYPE_SAVE    1                          /* a saved game (.sav) */
#define FILE_TYPE_LOG     2                      /* a transcript (log) file */
#define FILE_TYPE_DATA    4         /* general data file (used for fopen()) */
#define FILE_TYPE_CMD     5                           /* command input file */
#define FILE_TYPE_TEXT    7                                    /* text file */
#define FILE_TYPE_BIN     8                             /* binary data file */
#define FILE_TYPE_UNKNOWN 11                           /* unknown file type */

/*
 *   constants for execCommand() flags 
 */
#define EC_HIDE_SUCCESS   1                        /* hide success messages */
#define EC_HIDE_ERROR     2                          /* hide error messages */
#define EC_SKIP_VALIDDO   4                /* skip direct object validation */
#define EC_SKIP_VALIDIO   8              /* skip indirect object validation */

/* 
 *   constants for execCommand() return codes
 */
#define EC_SUCCESS        0                        /* successful completion */
#define EC_EXIT           1013                           /* "exit" executed */
#define EC_ABORT          1014                          /* "abort" executed */
#define EC_ASKDO          1015                          /* "askdo" executed */
#define EC_ASKIO          1016                          /* "askio" executed */
#define EC_EXITOBJ        1019                        /* "exitobj" executed */
#define EC_INVAL_SYNTAX   1200                /* invalid sentence structure */
#define EC_VERDO_FAILED   1201                          /* verDoVerb failed */
#define EC_VERIO_FAILED   1202                          /* verIoVerb failed */
#define EC_NO_VERDO       1203               /* no verDoVerb method defined */
#define EC_NO_VERIO       1204               /* no verIoVerb method defined */
#define EC_INVAL_DOBJ     1205           /* direct object validation failed */
#define EC_INVAL_IOBJ     1206         /* indirect object validation failed */

/*
 *   constants for parserGetObj object codes 
 */
#define PO_ACTOR    1                                              /* actor */
#define PO_VERB     2                                    /* deepverb object */
#define PO_DOBJ     3                                      /* direct object */
#define PO_PREP     4   /* preposition object (introducing indirect object) */
#define PO_IOBJ     5                                    /* indirect object */
#define PO_IT       6                                /* get the "it" object */
#define PO_HIM      7                               /* get the "him" object */
#define PO_HER      8                               /* get the "her" object */
#define PO_THEM     9                              /* get the "them" object */

/*
 *   constants for parseNounPhrase return codes 
 */
#define PNP_ERROR        1                      /* noun phrase syntax error */
#define PNP_USE_DEFAULT  2                        /* use default processing */

/*
 *   constants for disambigDobj and disambigIobj status codes 
 */
#define DISAMBIG_CONTINUE    1     /* continue disambiguation for this list */
#define DISAMBIG_DONE        2                    /* list is fully resolved */
#define DISAMBIG_ERROR       3      /* disambiguation failed; abort command */
#define DISAMBIG_PARSE_RESP  4         /* parse interactive response string */
#define DISAMBIG_PROMPTED    5 /* prompted for response, but didn't read it */

/*
 *   Parser word types.  These values may be combined, since a given word
 *   may appear in the dictionary with multiple types.  To test for a
 *   particular type, use the bitwise AND operator:
 *   
 *   ((typ & PRSTYP_NOUN) != 0).  
 */
#define PRSTYP_ARTICLE  1                                     /* the, a, an */
#define PRSTYP_ADJ      2                                      /* adjective */
#define PRSTYP_NOUN     4                                           /* noun */
#define PRSTYP_PREP     8                                    /* preposition */
#define PRSTYP_VERB     16                                          /* verb */
#define PRSTYP_SPEC     32          /* special words - "of", ",", ".", etc. */
#define PRSTYP_PLURAL   64                                        /* plural */
#define PRSTYP_UNKNOWN  128                    /* word is not in dictionary */

/*
 *   Parser noun-phrase flags.  These values may be combined; to test for
 *   a single flag, use the bitwise AND operator:
 *   
 *   ((flag & PRSFLG_UNKNOWN) != 0) 
 */
#define PRSFLG_ALL      1                                          /* "all" */
#define PRSFLG_EXCEPT   2   /* "except" or "but" (used in "all except ...") */
#define PRSFLG_IT       4                                           /* "it" */
#define PRSFLG_THEM     8                                         /* "them" */
#define PRSFLG_NUM      16                                      /* a number */
#define PRSFLG_COUNT    32          /* noun phrase uses a count - "3 coins" */
#define PRSFLG_PLURAL   64   /* noun phrase is a plural usage - "the coins" */
#define PRSFLG_ANY      128          /* noun phrase uses "any" - "any coin" */
#define PRSFLG_HIM      256                                        /* "him" */
#define PRSFLG_HER      512                                        /* "her" */
#define PRSFLG_STR      1024                             /* a quoted string */
#define PRSFLG_UNKNOWN  2048        /* noun phrase contains an unknown word */
#define PRSFLG_ENDADJ   4096            /* noun phrase ends in an adjective */
#define PRSFLG_TRUNC    8192           /* noun phrase uses a truncated word */

/*
 *   Constants for parserResolveObjects usage codes 
 */
#define PRO_RESOLVE_DOBJ  1                                /* direct object */
#define PRO_RESOLVE_IOBJ  2                              /* indirect object */
#define PRO_RESOLVE_ACTOR 3                                        /* actor */

/*
 *   Constants for result codes from restore() 
 */
#define RESTORE_SUCCESS          0                               /* success */
#define RESTORE_FILE_NOT_FOUND   1                        /* file not found */
#define RESTORE_NOT_SAVE_FILE    2                 /* not a saved game file */
#define RESTORE_BAD_FMT_VSN      3      /* incompatible file format version */
#define RESTORE_BAD_GAME_VSN     4 /* file saved by another game or version */
#define RESTORE_READ_ERROR       5           /* error reading from the file */
#define RESTORE_NO_PARAM_FILE    6    /* no parameter file for restore(nil) */

/*
 *   Constants for defined() function.  When passed as the optional third
 *   argument to defined(), these flags specify what type of information
 *   is returned from defined().
 *   
 *   By default, defined(obj, &prop) returns true if the property is
 *   defined or inherited by the object, nil if not.  The DEFINED_ANY flag
 *   has the same effect.
 *   
 *   When DEFINED_DIRECTLY is used, the function returns true only if the
 *   property is directly defined by the object, not merely inherited from
 *   a superclass.
 *   
 *   When DEFINED_INHERITS is used, the function returns true only if the
 *   property is inherited from a superclass, and returns nil if the
 *   property isn't defined at all or is defined directly by the object.
 *   
 *   When DEFINED_GET_CLASS is used, the function returns the object that
 *   actually defines the property; this will be the object itself if the
 *   object overrides the property, otherwise it will be the superclass
 *   from which the object inherits the property.  The function returns
 *   nil if the property isn't defined or inherited at all for the object.
 */
#define DEFINED_ANY         1  /* default: property is defined or inherited */
#define DEFINED_DIRECTLY    2             /* defined directly by the object */
#define DEFINED_INHERITS    3            /* inherited, not defined directly */
#define DEFINED_GET_CLASS   4                     /* get the defining class */

/*
 *   Constants for datatype() and proptype() 
 */
#define DTY_NUMBER  1                                             /* number */
#define DTY_OBJECT  2                                             /* object */
#define DTY_SSTRING 3                         /* single-quoted string value */
#define DTY_NIL     5                                                /* nil */
#define DTY_CODE    6                                        /* method code */
#define DTY_LIST    7                                               /* list */
#define DTY_TRUE    8                                               /* true */
#define DTY_DSTRING 9                               /* double-quoted string */
#define DTY_FUNCPTR 10                                  /* function pointer */
#define DTY_PROP    13  

/*
 *  Constants for listcontgen()
 */                                /* property pointer */
#define LCG_TALL        1
#define LCG_CHECKVIS    2
#define LCG_RECURSE     4
#define LCG_DEFART      8
#define LCG_NOART       16
#define LCG_LISTALL     32
#define LCG_NOLISTGROUP 64
#define LCG_SHOWPREFIX  128

/*
 *  Constants for global.commandPhase
 */
#define CP_PARSING      1
#define CP_EXECUTION    2
#define CP_PRECOMMAND   3
#define CP_PREACTION    4
#define CP_ACTION       5
#define CP_POSTACTION   6
#define CP_DAEMON       7
#define CP_ENDCOMMAND   8

/* ------------------------------------------------------------------------ */
/*
 *   Define compound prepositions.  Since prepositions that appear in
 *   parsed sentences must be single words, we must define any logical
 *   prepositions that consist of two or more words here.  Note that
 *   only two words can be pasted together at once; to paste more, use
 *   a second step.  For example,  'out from under' must be defined in
 *   two steps:
 *
 *     compoundWord 'out' 'from' 'outfrom';
 *     compoundWord 'outfrom' 'under' 'outfromunder';
 *
 *   Listed below are the compound prepositions that were built in to
 *   version 1.0 of the TADS run-time.
 */
compoundWord 'on' 'to' 'onto';           /* on to --> onto */
compoundWord 'in' 'to' 'into';           /* in to --> into */
compoundWord 'in' 'between' 'inbetween'; /* and so forth */
compoundWord 'down' 'in' 'downin';
compoundWord 'down' 'on' 'downon';
compoundWord 'up' 'on' 'upon';
compoundWord 'out' 'of' 'outof';
compoundWord 'off' 'of' 'offof';
compoundWord 'i' 'wide' 'i_wide';
compoundWord 'invent' 'wide' 'i_wide';
compoundWord 'inventory' 'wide' 'i_wide';
compoundWord 'i' 'tall' 'i_tall';
compoundWord 'invent' 'tall' 'i_tall';
compoundWord 'inventory' 'tall' 'i_tall';
compoundWord 'wait' 'until' 'waituntil';
compoundWord 'wait' 'for' 'waitfor';
compoundWord 'text' 'style' 'text_style';
;

/*
 *   Format strings:  these associate keywords with properties.  When
 *   a keyword appears in output between percent signs (%), the matching
 *   property of the current command's actor is evaluated and substituted
 *   for the keyword (and the percent signs).  For example, if you have:
 *
 *      formatstring 'you' fmtYou;
 *
 *   and the command being processed is:
 *
 *      fred, pick up the paper
 *
 *   and the "fred" actor has fmtYou = "he", and this string is output:
 *
 *      "%You% can't see that here."
 *
 *   Then the actual output is:  "He can't see that here."
 *
 *   The format strings are chosen to look like normal output (minus the
 *   percent signs, of course) when the actor is the player character (Me).
 */
formatstring 'you' fmtYou;
formatstring 'yourself' fmtYourself;
formatstring 'your' fmtYour;
formatstring 'you\'re' fmtYoure;
formatstring 'youm' fmtYoum;
formatstring 'you\'ve' fmtYouve;
formatstring 's' fmtS;
formatstring 'es' fmtEs;
formatstring 'have' fmtHave;
formatstring 'do' fmtDo;
formatstring 'are' fmtAre;
formatstring 'me' fmtMe;
;

/*
 *   Special Word List: This list defines the special words that the
 *   parser needs for input commands.  If the list is not provided, the
 *   parser uses the old defaults.  The list below is the same as the old
 *   defaults.  Note - the words in this list must appear in the order
 *   shown below.
 */
specialWords
    'of',                        /* used in phrases such as "piece of paper" */
    'and',             /* conjunction for noun lists or to separate commands */
    'then',                              /* conjunction to separate commands */
    'all' = 'everything',               /* refers to every accessible object */
    'both',      /* used with plurals, or to answer disambiguation questions */
    'but' = 'except',                      /* used to exclude items from ALL */
    'one',                       /* used to answer questions:  "the red one" */
    'ones',                        /* likewise for plurals:  "the blue ones" */
    'it' = 'there',              /* refers to last single direct object used */
    'them',                             /* refers to last direct object list */
    'him',                       /* refers to last masculine actor mentioned */
    'her',                        /* refers to last feminine actor mentioned */
    'any' = 'either'         /* pick object arbitrarily from ambiguous list */
;

#pragma C-

#endif /* _CONSTANTS_H_ */
