////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: addWeight() 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _ADD_WEIGHT_T_
#define _ADD_WEIGHT_T_

#pragma C+

/*
 *  addWeight: function(list)
 *
 *  Adds the weights of the objects in list and returns the sum.
 *  The weight of an object is given by its weight property.  This
 *  routine includes the weights of all of the contents of each object,
 *  and the weights of their contents, and so forth.
 */
addWeight: function(l) {
    local tot, i, c, totWeight;

    tot = length(l);
    i = 1;
    totWeight = 0;
    while (i <= tot) {
        c = l[i];
        totWeight = totWeight + c.weight;
        if (length(c.contents))
            totWeight = totWeight + addWeight(c.contents);
        i = i + 1;
    }
    return totWeight;
}

#pragma C-

#endif /* _ADD_WEIGHT_T_ */
