////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: command() 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _COMMAND_T_
#define _COMMAND_T_

#include <global.t>
#include <queue.t>
#include <gactor.t>
#include <gverb.t>
#include <gdobj.t>
#include <gprep.t>
#include <giobj.t>
#include <gstatus.t>
#include <nestoutcapture.t>

#pragma C+

/*
 *  command: function
 *
 *  This is a simple cover function for the built-in function 
 *  execCommand. This cover function displays any outcaptured 
 *  display.
 */
command: function(actor, verb, ...) {
    local dobj, prep, iobj, flags = 0;
    local lst, ret, str, v, i, len, remList = [];
    local sActor, sVerb, sDobj, sPrep, sIobj, sStatus;
    
    if (argcount > 2) {
        v = getarg(3);
        if (datatype(v) == DTY_OBJECT)
            dobj = v;
        else
            flags = v;
    }
    if (argcount > 3) {
        v = getarg(4);
        if (datatype(v) == DTY_OBJECT)
            prep = v;
        else
            flags = v;
    }
    if (argcount > 4) {
        v = getarg(5);
        if (datatype(v) == DTY_OBJECT)
            iobj = v;
        else
            flags = v;
    }
    if (argcount > 5) flags = getarg(6);

    // Save global variables
    sActor = gActor();
    sVerb = gVerb();
    sDobj = gDobj();
    sPrep = gPrep();
    sIobj = gIobj();
    sStatus = gStatus();
    
    str = nestOutcapture(nil, true);
    
    if (str != '')
        queue.queueMessage(gActor(), gVerb(), gDobj(), gPrep(), 
            gIobj(), gStatus(), str);
    
    lst = queue.list;
    
    /* execCommand() */
    ret = execCommand(actor, verb, dobj, prep, iobj, flags);
    
    if (((flags & EC_HIDE_SUCCESS) == EC_HIDE_SUCCESS 
        && ret == EC_SUCCESS)
    || ((flags & EC_HIDE_ERROR) == EC_HIDE_ERROR 
        && ret != EC_SUCCESS)) {
        remList = queue.list - lst;
        queue.list = lst;
    }
    
    // Clean-up messages removed from the queue
    len = length(remList);
    for (i = 1; i <= len; ++i)
        delete remList[i];
    
    // Restore global variables
    gActor(sActor);
    gVerb(sVerb);
    gDobj(sDobj);
    gPrep(sPrep);
    gIobj(sIobj);
    gStatus(sStatus);
    
    nestOutcapture(true);
    return ret;
}

#pragma C-

#endif /* _COMMAND_T_ */
