////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: gLocation() 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _G_LOCATION_T_
#define _G_LOCATION_T_

#include <global.t>

#pragma C+

/*
 *  gLocation(sense)
 *
 *  Function returns the "scope ceiling" for the actor's location. If
 *  passed a sense parameter the function returns the scope ceiling
 *  based on the accessibility of the sense.
 */
gLocation: function(...) {
    local loc, sense, actor = gActor();
    
    if (argcount == 1) sense = getarg(1);
    if (sense == nil) sense = sight;
    
    loc = actor;
    while(loc) {
        if (loc.location == nil)
            break;
        if (!loc.canSenseLocations(sense, loc == actor))
            break;
        loc = loc.location;
    }
    return loc;
}

#pragma C-

#endif /* _G_LOCATION_T_ */
