////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: languageNumber() 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _LANGUAGE_NUMBER_T_
#define _LANGUAGE_NUMBER_T_

#pragma C+

/*
 *	languageNumber(n)
 *	
 *	Converts a number into english words.
 */
languageNumber: function( n ) {
    local f;
    if (n == 0) {
        "zero";
        return nil; 
    }
    if (n < 0) {
        "minus "; n = -n; 
    }
    if (n >= 1000000) {
        languageNumber(n/1000000);
        " million"; 
        n = n % 1000000; 
        f = 1; 
    }
    if (n >= 1000) {
        if (f == 1)
            ", ";
        languageNumber(n/1000);
        " thousand"; 
        n = n % 1000; 
        f = 1; 
    }
    if (n >= 100) { 
        if (f == 1)
            ", ";
        languageNumber(n/100);
        " hundred"; 
        n = n % 100; 
        f=1; 
    }
    if (n == 0) return nil;

#ifndef USE_DIALECT_US

    if (f == 1)
        " and ";

#else

    if (f == 1)
        " ";
#endif

    switch(n) {   
        case 1:  
            "one";
            break;
        case 2:
            "two";
            break;
        case 3:
            "three";
            break;
        case 4: 
            "four";
            break;
        case 5:  
            "five";
            break;
        case 6:  
            "six";
            break;
        case 7:  
            "seven";
            break;
        case 8:  
            "eight";
            break;
        case 9:  
            "nine";
            break;
        case 10: 
            "ten";
            break;
        case 11:
            "eleven";
            break;
        case 12: 
            "twelve";
            break;
        case 13: 
            "thirteen";
            break;
        case 14:
            "fourteen";
            break;
        case 15:
            "fifteen";
            break;
        case 16:
            "sixteen";
            break;
        case 17: 
            "seventeen";
            break;
        case 18:
            "eighteen";
            break;
        case 19:
            "nineteen";
            break;
        default:
            switch(n/10) {  
                case 2:
                    "twenty";
                    break;
                case 3:
                    "thirty";
                    break;
                case 4:
                    "forty";
                    break;
                case 5: 
                    "fifty";
                    break;
                case 6:
                    "sixty";
                    break;
                case 7:
                    "seventy";
                    break;
                case 8: 
                    "eighty";
                    break;
                case 9:
                    "ninety";
                    break;
          }
          if (n % 10 != 0) {
            "-"; 
            languageNumber(n%10);
          }
  }
}

#pragma C-

#endif /* LANGUAGE_NUMBER_T_ */
