////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: scoreRank() 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _SCORE_RANK_T_
#define _SCORE_RANK_T_

#include <clock.h>
#include <global.t>

#pragma C+

/*
 *   The scoreRank() function displays how well the player is doing.
 *   This default definition doesn't do anything aside from displaying
 *   the current and maximum scores.  Some game designers like to
 *   provide a ranking that goes with various scores ("Novice Adventurer,"
 *   "Expert," and so forth); this is the place to do so if desired.
 *
 *   Note that "global.maxScore" defines the maximum number of points
 *   possible in the game; change the property in the "global" object
 *   if necessary.
 */
scoreRank: function {
	if (global.timeStatus == nil || global.timeStatus == 1) {
		"In a total of "; 
		say(gameClock.getElapseTime(CLOCK_ELAPSETIME_MSG));
		", you have achieved a score of ";
		say( global.score ); " points out of a possible ";
		say( global.maxScore ); ".\n";
	} else {
   		 "In a total of "; say(global.turnSoFar);
   		 " turns, you have achieved a score of ";
    		say(global.score); " points out of a possible ";
    		say(global.maxScore); ".\n";
	}
}

#pragma C-

#endif /* _SCORE_RANK_T_ */
