//
//  XTHtmlTagLi.m
//  TadsTerp
//
//  Created by Rune Berg on 21/05/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import "XTHtmlTag_private.h"
#import "XTHtmlTagLi.h"
#import "XTHtmlTagOl.h"
#import "XTHtmlTagUl.h"
#import "XTBaseTextHandler.h"


@implementation XTHtmlTagLi

+ (NSString *)name
{
	return @"li";
}

+ (BOOL)standalone
{
	return NO;
}

- (BOOL)blockLevel
{
	//TODO exp. what about <li> ouside <ol>/<ul>?
	//TODO only if in <ol> or <ul> !!
	
	return YES;
}

- (void)format:(NSObject<XTOutputFormatterProtocol> *)formatter
   textHandler:(XTBaseTextHandler *)textHandler
{
	[super format:formatter textHandler:textHandler];

	NSArray *formattedElements = [formatter handleHtmlTagLiOpen:self];
	[textHandler receiveFormattedElements:formattedElements];
}

- (void)formatExit:(NSObject<XTOutputFormatterProtocol> *)formatter
	   textHandler:(XTBaseTextHandler *)textHandler
{
	NSArray *formattedElements = [formatter handleHtmlTagLiClose:self];
	[textHandler receiveFormattedElements:formattedElements];

	[super formatExit:formatter textHandler:textHandler];
}

- (XTFormattingSpecification *)makeFormattingSpecificationFrom:(XTFormattingSpecification *)formattingSpec
{
	XTFormattingSpecification *res = [XTFormattingSpecification specificationFrom:formattingSpec];
	
	res.inListItem = YES;
	
	if ([self.container isKindOfClass:[XTHtmlTagUl class]]) {
		//TODO !!! refactor vs TagUL:
		for (XTPair *attrNameAndValue in self.attributesArray) {
			if ([self attributeNameAndValue:attrNameAndValue hasName:@"plain"]) {
				res.listBulletType = XT_LIST_BULLET_TYPE_UL_PLAIN;
			} else if ([self attributeNameAndValue:attrNameAndValue hasName:XT_LIST_BULLET_TYPE_ATTR_NAME withCaseInsensitiveValue:XT_LIST_BULLET_TYPE_ATTR_VALUE_DISC]) {
				res.listBulletType = XT_LIST_BULLET_TYPE_DISC;
			} else 	if ([self attributeNameAndValue:attrNameAndValue hasName:XT_LIST_BULLET_TYPE_ATTR_NAME withCaseInsensitiveValue:XT_LIST_BULLET_TYPE_ATTR_VALUE_SQUARE]) {
				res.listBulletType = XT_LIST_BULLET_TYPE_SQUARE;
			} else 	if ([self attributeNameAndValue:attrNameAndValue hasName:XT_LIST_BULLET_TYPE_ATTR_NAME withCaseInsensitiveValue:XT_LIST_BULLET_TYPE_ATTR_VALUE_CIRCLE]) {
				res.listBulletType = XT_LIST_BULLET_TYPE_CIRCLE;
			}
		}
	} else if ([self.container isKindOfClass:[XTHtmlTagOl class]]) {
		//TODO !!! refactor vs TagOL (? #value vs #start & #seqnum):
		for (XTPair *attrNameAndValue in self.attributesArray) {
			if ([self attributeNameAndValue:attrNameAndValue hasName:@"plain"]) {
				res.listBulletType = XT_LIST_BULLET_TYPE_OL_PLAIN_FROM_LI;
			} else if ([self attributeNameAndValue:attrNameAndValue hasName:XT_LIST_BULLET_TYPE_ATTR_NAME withCaseSensitiveValue:@"1"]) {
				res.listBulletType = XT_LIST_BULLET_TYPE_OL_DECIMAL;
			} else if ([self attributeNameAndValue:attrNameAndValue hasName:XT_LIST_BULLET_TYPE_ATTR_NAME withCaseSensitiveValue:@"a"]) {
				res.listBulletType = XT_LIST_BULLET_TYPE_OL_LOWER_ALPHA;
			} else if ([self attributeNameAndValue:attrNameAndValue hasName:XT_LIST_BULLET_TYPE_ATTR_NAME withCaseSensitiveValue:@"A"]) {
				res.listBulletType = XT_LIST_BULLET_TYPE_OL_UPPER_ALPHA;
			} else if ([self attributeNameAndValue:attrNameAndValue hasName:XT_LIST_BULLET_TYPE_ATTR_NAME withCaseSensitiveValue:@"i"]) {
				res.listBulletType = XT_LIST_BULLET_TYPE_OL_LOWER_ROMAN;
			} else if ([self attributeNameAndValue:attrNameAndValue hasName:XT_LIST_BULLET_TYPE_ATTR_NAME withCaseSensitiveValue:@"I"]) {
				res.listBulletType = XT_LIST_BULLET_TYPE_OL_UPPER_ROMAN;
			} else if ([self attributeNameAndValue:attrNameAndValue hasName:@"value"]) {
				XTHtmlTagOl *castCpntainer = (XTHtmlTagOl *)self.container;
				NSNumber *attrValue = [self attributeAsNumber:@"value"];
				[castCpntainer setItemIndexFromValue:attrValue];
			}
		}

	}

	return res;
}

- (XTHtmlTagContainer *)findCorrectContainer:(XTHtmlTagContainer *)defaultContainer
{
	XTHtmlTagContainer *res = defaultContainer;
	
	for (XTHtmlTagContainer *container = defaultContainer;
		 container != nil;
		 container = container.container) {
		
		if ([container isKindOfClass:[XTHtmlTagOl class]] || [container isKindOfClass:[XTHtmlTagUl class]]) {
			// Our nearest <ol> or <ul> is the one
			res = container;
			break;
		}
	}
	
	return res;
}

@end
