//
//  XTBanner.h
//  XTads
//
//  Created by Rune Berg on 14/12/15.
//  Copyright © 2015 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "XTGameWindowController.h"
#import "XTBannerContainerView.h"
#import "XTOutputTextView.h"


@interface XTBannerHandler : NSObject <NSTextViewDelegate>

@property (weak) XTGameWindowController *gameWindowController;
@property (weak) XTOutputTextHandler *outputTextHandler;
@property XTOutputFormatter *outputFormatter;
	//TODO should be in .m
@property (readonly) NSUInteger bannerIndex;
@property NSUInteger type; // "wintype"
@property NSUInteger alignment; // "align"
@property NSUInteger size; //"siz"
@property NSUInteger sizeUnits; // "sizunits"
@property NSUInteger style; // "style"
@property BOOL isSizedToContent;
@property CGFloat sizeOfContents; //TODO readonly?

// for T2 banner tag "previous" attr:
@property BOOL isBeingCreated;
@property NSNumber *initialSize;
@property NSUInteger initialSizeUnits;
@property BOOL wasInitiallySizedToContents;
@property BOOL wasInitiallySizedToPrevious;
@property CGFloat initialSizeOfContents;
@property BOOL hadUnspecifiedSizeLastTime;
@property BOOL hadPreviousSizeLastTime;

@property NSString *tagId; // for T2 <banner id="...">

@property (readonly) NSUInteger usableWidthInPoints;
@property (readonly) NSUInteger usableHeightInPoints;
@property (readonly) NSUInteger usableHeightInRows;
@property (readonly) NSUInteger usableWidthInColumns;

@property (nonatomic) BOOL htmlMode;
@property BOOL isForTradStatusLine;
@property BOOL tagBannerNeedsSizeToContent;

@property (weak) NSView *rootBannerContainerView; // for main area's banner handler only
@property NSScrollView *scrollView;
@property (unsafe_unretained) XTOutputTextView *outputTextView;
	//TODO type should be common super for XTOutputTextView and XTBannerTextView

+ (void)resetStaticState;

+ (instancetype)handlerForMainOutputArea;

+ (instancetype)handlerWithParent:(XTBannerHandler *)parent
							where:(NSInteger)where
							other:(XTBannerHandler *)other
						  wintype:(NSInteger)wintype
							align:(NSInteger)align
							 size:(NSInteger)size
						sizeUnits:(NSInteger)sizeUnits
							style:(NSUInteger)style;

- (void)noteStartedFromHtmlTag;

- (void)traceWithIndentLevel:(NSUInteger)indentLevel;

- (void)setIsForT3:(BOOL)isForT3;

- (void)setHiliteMode:(BOOL)hiliteMode;

- (BOOL)isForMainOutputArea;

- (void)mainThread_createTextViewForMainOutputArea;

- (void)mainThread_createTextViewForBanner;

- (void)mainThread_configureViews;

- (void)captureInitialSizeWhenViewSize:(CGFloat)viewSize;

- (void)resetForNextCommand;

- (void)resetForTradStatusLine;

- (void)mainThread_removeHandler;

- (void)display:(NSString *)string;

- (void)mainThread_flush;

- (void)clear;

- (void)synchClear;

- (void)displayTradStatusLineScoreString:(NSString *)string;

- (void)mainThread_setSize:(NSArray *)args;

- (void)mainThread_sizeToContents;

- (void)setColorsFromPrefs;

- (void)gotoRow:(NSUInteger)row column:(NSUInteger)column;

- (void)processFormattingQueueFromMainOutput:(NSMutableArray *)formattingQueue;

@end
