!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! 2003.02.19 ORMagic	[Z, GLULX]
! The base class for magic spells.
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!--------------------------------------------------------------------------------------
! Created by Jim Fisher
! A more detailed description of this file, what it does, and how to use it goes here.
!
!--------------------------------------------------------------------------------------
! AutoDep:	ORObjectInitialise
!--------------------------------------------------------------------------------------
! To register this module with your library, add the line:
!
!		#ifdef USE_ORMagic; #include "ORMagic"; #endif;
!	
!	to the library header file (OR_Library_Include).  To use in a game, add the line:
!
!		Constant USE_ORMagic; 
!
!	to the game file;
!--------------------------------------------------------------------------------------
! Revision History
! 2002.06.20	Initial Creation
! 2002.07.03	Moved the actual casting code from my WIP to this module.
! 2002.07.05	Made the spells command meta.
! 2002.07.06	Corrected bug with the "spells" verb output formatting and spell 
!				selection.
! 2002.07.07	Added menu documentation
! 2002.08.28	Added code to support casting of spells without the need to specify the 
!				verb 'cast'
! 2002.08.31	Modified to reference the new OREntryPoints module.
! 2002.12.07	Removed references the "description" property in the spell and implemented 
!				a property named "text" to describe what a spell does (as displayed by the
!				"spells" verb)
! 2003.02.02	Modified the menu documentation.
! 2003.02.19	Added better ifdef for self docs
!--------------------------------------------------------------------------------------
#ifdef USE_ORMagic;message "          Processing library extension ORMagic...";
!--------------------------------------------------------------------------------------
! D E P E N D A N C I E S   section   (for bringing in dependant modules)
!--- sample forced include---   #ifndef USE_<REPLACEWITHINCLUDENAME>; Constant USE_<REPLACEWITHINCLUDENAME>; message "          ****Forcing inclusion of <REPLACEWITHINCLUDENAME>****"; #include "<REPLACEWITHINCLUDENAME>"; #endif; 
!--- #ifndef TARGET_GLULX; default WORDSIZE 2; #ifnot;default WORDSIZE 4; #endif; !--for GLULX compatability
!--------------------------------------------------------------------------------------
	#ifndef USE_ORObjectInitialise; Constant USE_ORObjectInitialise; message "          ****Forcing inclusion of ORObjectInitialise****"; #include "ORObjectInitialise"; #endif; 
	#ifndef USE_ORRoutinesList; Constant USE_ORRoutinesList; message "          ****Forcing inclusion of ORRoutinesList****"; #include "ORRoutinesList"; #endif; 
	#ifndef USE_OREntryPoints; Constant USE_OREntryPoints; message "          ****Forcing inclusion of OREntryPoints****"; #include "OREntryPoints"; #endif; 
!--------------------------------------------------------------------------------------
#ifdef REPLACEPOINT; #ifndef ORMagic_DONEREPLACE; constant ORMagic_DONEREPLACE; 
!--------------------------------------------------------------------------------------
! R E P L A C E   section (for code that preceeds the inclusion of PARSER)
!--------------------------------------------------------------------------------------

!--------------------------------------------------------------------------------------
#endif;#endif;#ifdef MESSAGEPOINT; #ifndef ORMagic_DONEMESSAGE; constant ORMagic_DONEMESSAGE; 
!--------------------------------------------------------------------------------------
! M E S S A G E   section (for code that falls between PARSER and VERBLIB )
!--- Uncomment to check for OREnglish--- #ifndef OREnglish; message "ERROR!!!! ORMagic requires the OREnglish file.";#endif; 
!--------------------------------------------------------------------------------------
	class ORMagic 
		with cast[; 
				print (ig)CIVerb(actor,"cast","cast")," ",(the)self," spell with no affect.";
			]
		,	text 0
		,	active false
		,	cast_upon 0
		,	KnownBy 0
		,	IsKnownBy[o; return WordInProperty(o,self,KnownBy);]
		,	heartbeat 0
		,	priority 0
	;

	object with object_initialise[;
			ORUnknownVerb.add_routine(self.one);
		]
	,	one[word obj;
				objectloop (obj ofclass ORMagic){
			#ifdef USE_ORRecogName; 
				if(WordInProperty(word,obj,name)==true || MatchAgainstShortName(obj,verb_wordnum)==true){
			#ifnot;
				if(WordInProperty(word,obj,name)==true){
			#endif; 
						verb_wordnum=0;
						return 'cast';
					}
				}
				rfalse;
			]
	;

!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef CODEPOINT; #ifndef ORMagic_DONECODE;constant ORMagic_DONECODE; 
!--------------------------------------------------------------------------------------
! C O D E   section (for code that falls between VERBLIB and GRAMMAR)
!--------------------------------------------------------------------------------------
	!-----------------------------------------------------------------------------
	!---ORMagicControl  object
	!---This is essentially the same code (with a few modifications) as the 
	!---NPC control object.  It allows all active spells to function each turn
	!-----------------------------------------------------------------------------
	object ORMagicControl
		with pause false !--halt all continuous magic
		,	spells_acting false
		,	magiclist 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
		,	description 0
		,	daemon 
			[spell t lowest_priority highest_priority outcount;
				if(self.pause==true) return;
				self.spells_acting=true;
				self.&magiclist-->0=0;
				objectloop(spell ofclass ORMagic) { 
					self.&magiclist-->0=(self.&magiclist-->0)+1;
					self.&magiclist-->(self.&magiclist-->0)=spell;
					if(spell.priority>highest_priority)highest_priority=spell.priority;
					if(spell.priority<lowest_priority)lowest_priority=spell.priority;
				}
				for(outcount=lowest_priority:outcount<=highest_priority:outcount++){
					for(t=0:t<self.&magiclist-->0:t++){
						spell=self.&magiclist-->(t+1);
						if(spell.priority~=outcount) continue;
						if(parent(spell)~=0)
							actor=spell; !--so that floating objects are in the right place at the right time
						else
							actor=player;
						MoveFloatingObjects();
						if(spell.heartbeat~=0 && spell.active==true) spell.heartbeat();
					}						
				}
				actor=player;		!restore the actor
				MoveFloatingObjects();
				self.spells_acting=false;
			]
		,	object_initialise[; StartDaemon(self);]
	;
!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef GRAMMARPOINT; #ifndef ORMagic_DONEGRAMMAR; constant ORMagic_DONEGRAMMAR; #ifdef ORMagic_DONEGRAMMAR; #endif; !--just to supress warning
!--------------------------------------------------------------------------------------
! G R A M M A R   section (for code that follows the inclusion of GRAMMAR)
!--------------------------------------------------------------------------------------
	!--shows which spells the player knows (isknownby routine)
	Verb meta 'spells'*->ShowSpells;
	[ShowSpellsSub o count;
		objectloop(o ofclass ORMagic && o.IsKnownBy(actor)==true) count++;
		print (CIHave)actor;
		if(count==0) print " no magic";
		else print " the following spell";
		if(count>1)print "s";
		print " at ",(my)actor," disposal";
		if(count==0) ".";
		print":^";
		objectloop(o ofclass ORMagic && o.IsKnownBy(actor)) {
			print "     ",(name)o;
			if(o provides text && o.text~=0){
				print " ("; 
				printorrun(o,text,true);
				print ")"; 
			}
			print "^";
		}
	];
	!--actually cast a spell
	[ActorSpell o; !isolate information known by the actor
		switch(scope_stage){
			1: return false;
			2: 	objectloop(o ofclass ORMagic && o.isknownby(actor)==true) PlaceInScope(o); 
				return true;
			3: 	print_ret (bkt)"I am uncertain what you want to cast.";
		}
	];
	Verb 'cast' 
		* scope=ActorSpell -> CastSpell
		* scope=ActorSpell 'at'/'on' noun -> CastSpell		
		* scope=ActorSpell noun -> CastSpell		
	;
	[CastSpellSub;
		noun.cast();
	];

#ifdef ORMenuCatch;
	!--Commands, document thyself.
	ORMenu ORHelpMagic "Magic" with text "The system used for magic is fairly straightforward. Only two commands are used, ~Spells~ and ~Cast.~"
		,	object_initialise[;	if(ORMenuCatch~=0) move self to ORMenuCatch; ]
	;
		ORMenu -> "Spells" with text "The ~Spells~ command will list all spells that the player character currently knows. Known spells can be cast with the ~Cast~ command.";
		ORMenu -> "Cast" with text[;
									print "~Cast~ is an optional command that is used in conjunction with a known spell. It can be used in two forms:^^";
									font off;
									spaces(4);print">CAST THONTAS^^";
									font on; print"or^^";
									font off;
									spaces(4);print">CAST FRIRQUIN AT SNOWMAN^^";
									font on;
									print"As was stated above, ~Cast~ is optional in that:^^";
									font off; 
									spaces(4);print">THONTAS^^";
									font on; print"or^^";
									font off;
									spaces(4);print">FRIRQUIN SNOWMAN^^";
									font on;
									print "will also work.^^";
									print (italics)"NOTE: These example spells do not necessarily appear in the game.";
		];
#endif;
!--------------------------------------------------------------------------------------
#endif; #endif; #endif;
