#charset "us-ascii"
/* 
 *  Copyright (c) 2005 by Kevin Forchione. All rights reserved.
 *   
 *  This file is part of the TADS 3 Flags Library Extension
 *
 *  flags.h
 *
 *  Flags Header File.
 */
#ifndef FLAGS_H
#define FLAGS_H

#include "tads.h"
#include "t3.h"

/*
 *  A macro for defining BitFlags. The num argument
 *  is the bit number (starting with 0) that is to 
 *  be set to 1 for the bit flag.
 */
#define DefBitFlag(num) \
    BitFlag \
    bitNum = static (num > maxBitNum \
    ? FlagException.throwExc('Invalid bit number') : num) \
    elemNum = static (bitNum / bitsPerElem) \
    elemVal = static (1 << (bitNum % bitsPerElem))

#endif  // FLAGS_H