/*
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
*/


//********************************************************************************
//* Do NOT edit this file directly - generated by build/generate.groovy
//********************************************************************************

package gremlingo

import (
	 "errors"
	 "github.com/apache/tinkerpop/gremlin-go/v3/driver"
	 "github.com/google/uuid"
	 "math"
	 "time"
)

var translationMap = map[string][]func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal{
    "g_V_branchXlabel_isXpersonX_countX_optionX1__ageX_optionX0__langX_optionX0__nameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Branch(gremlingo.T__.Label().Is("person").Count()).Option(p["xx1"], gremlingo.T__.Values("age")).Option(p["xx2"], gremlingo.T__.Values("lang")).Option(p["xx2"], gremlingo.T__.Values("name"))}}, 
    "g_V_branchXlabel_isXpersonX_countX_optionX1__ageX_optionX0__langX_optionX0__nameX_optionXany__labelX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Branch(gremlingo.T__.Label().Is("person").Count()).Option(p["xx1"], gremlingo.T__.Values("age")).Option(p["xx2"], gremlingo.T__.Values("lang")).Option(p["xx2"], gremlingo.T__.Values("name")).Option(gremlingo.Pick.Any, gremlingo.T__.Label())}}, 
    "g_V_branchXageX_optionXltX30X__youngX_optionXgtX30X__oldX_optionXnone__on_the_edgeX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Branch(gremlingo.T__.Values("age")).Option(gremlingo.P.Lt(30), gremlingo.T__.Constant("young")).Option(gremlingo.P.Gt(30), gremlingo.T__.Constant("old")).Option(gremlingo.Pick.None, gremlingo.T__.Constant("on the edge"))}}, 
    "g_V_branchXidentityX_optionXhasLabelXsoftwareX__inXcreatedX_name_order_foldX_optionXhasXname_vadasX__ageX_optionXneqX123X__bothE_countX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Branch(gremlingo.T__.Identity()).Option(gremlingo.T__.HasLabel("software"), gremlingo.T__.In("created").Values("name").Order().Fold()).Option(gremlingo.T__.Has("name", "vadas"), gremlingo.T__.Values("age")).Option(gremlingo.P.Neq(123), gremlingo.T__.BothE().Count())}}, 
    "g_V_chooseXout_countX_optionX2L_nameX_optionX3L_ageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Choose(gremlingo.T__.Out().Count()).Option(p["xx1"], gremlingo.T__.Values("name")).Option(p["xx2"], gremlingo.T__.Values("age"))}}, 
    "g_V_chooseXout_countX_optionX2L_nameX_optionX3L_ageX_optionXnone_discardX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Choose(gremlingo.T__.Out().Count()).Option(p["xx1"], gremlingo.T__.Values("name")).Option(p["xx2"], gremlingo.T__.Values("age")).Option(gremlingo.Pick.None, gremlingo.T__.Discard())}}, 
    "g_V_chooseXhasLabelXpersonX_and_outXcreatedX__outXknowsX_identityX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Choose(gremlingo.T__.HasLabel("person").And().Out("created"), gremlingo.T__.Out("knows"), gremlingo.T__.Identity()).Values("name")}}, 
    "g_V_chooseXhasLabelXpersonX_and_outXcreatedX_outXknowsX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Choose(gremlingo.T__.HasLabel("person").And().Out("created"), gremlingo.T__.Out("knows")).Values("name")}}, 
    "g_V_chooseXlabelX_optionXblah__outXknowsXX_optionXbleep__outXcreatedXX_optionXnone__identityX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Choose(gremlingo.T__.Label()).Option("blah", gremlingo.T__.Out("knows")).Option("bleep", gremlingo.T__.Out("created")).Option(gremlingo.Pick.None, gremlingo.T__.Identity()).Values("name")}}, 
    "g_V_chooseXTlabelX_optionXperson__outXknowsX_nameX_optionXbleep_constantXbleepXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Choose(gremlingo.T.Label).Option("person", gremlingo.T__.Out("knows").Values("name")).Option("bleep", gremlingo.T__.Constant("bleep"))}}, 
    "g_V_chooseXTlabelX_optionXblah__outXknowsXX_optionXbleep__outXcreatedXX_optionXnone__identityX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Choose(gremlingo.T.Label).Option("blah", gremlingo.T__.Out("knows")).Option("bleep", gremlingo.T__.Out("created")).Option(gremlingo.Pick.None, gremlingo.T__.Identity()).Values("name")}}, 
    "g_V_chooseXTlabelX_optionXblah__outXknowsXX_optionXbleep__outXcreatedXX_optionXnone_discardX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Choose(gremlingo.T.Label).Option("blah", gremlingo.T__.Out("knows")).Option("bleep", gremlingo.T__.Out("created")).Option(gremlingo.Pick.None, gremlingo.T__.Discard()).Values("name")}}, 
    "g_V_chooseXoutXknowsX_count_isXgtX0XX__outXknowsXX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Choose(gremlingo.T__.Out("knows").Count().Is(gremlingo.P.Gt(0)), gremlingo.T__.Out("knows")).Values("name")}}, 
    "g_V_hasLabelXpersonX_asXp1X_chooseXoutEXknowsX__outXknowsXX_asXp2X_selectXp1_p2X_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").As("p1").Choose(gremlingo.T__.OutE("knows"), gremlingo.T__.Out("knows")).As("p2").Select("p1", "p2").By("name")}}, 
    "g_V_hasLabelXpersonX_chooseXageX__optionX27L__constantXyoungXX_optionXnone__constantXoldXX_groupCount": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Choose(gremlingo.T__.Values("age")).Option(p["xx1"], gremlingo.T__.Constant("young")).Option(gremlingo.Pick.None, gremlingo.T__.Constant("old")).GroupCount()}}, 
    "g_injectX1X_chooseXisX1X__constantX10Xfold__foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(int32(1)).Choose(gremlingo.T__.Is(p["xx1"]), gremlingo.T__.Constant(int32(10)).Fold(), gremlingo.T__.Fold())}}, 
    "g_injectX2X_chooseXisX1X__constantX10Xfold__foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(int32(2)).Choose(gremlingo.T__.Is(p["xx1"]), gremlingo.T__.Constant(int32(10)).Fold(), gremlingo.T__.Fold())}}, 
    "g_V_chooseXhasLabelXpersonX_chooseXageX_optionXbetweenX26_30X_constantXxXX_optionXbetweenX20_30X_constantXyXX_optionXnone_constantXzXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Choose(gremlingo.T__.Values("age")).Option(gremlingo.P.Between(26, 30), gremlingo.T__.Constant("x")).Option(gremlingo.P.Between(20, 30), gremlingo.T__.Constant("y")).Option(gremlingo.Pick.None, gremlingo.T__.Constant("z"))}}, 
    "g_V_chooseXhasLabelXpersonX_chooseXageX_optionXbetweenX26_30X_orXgtX34XX_constantXxXX_optionXgtX34X_constantXyXX_optionXnone_constantXzXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Choose(gremlingo.T__.Values("age")).Option(gremlingo.P.Between(26, 30).Or(gremlingo.P.Gt(34)), gremlingo.T__.Constant("x")).Option(gremlingo.P.Gt(34), gremlingo.T__.Constant("y")).Option(gremlingo.Pick.None, gremlingo.T__.Constant("z"))}}, 
    "g_V_hasLabelXpersonX_chooseXageX_optionXbetweenX26_30X_nameX_optionXnone_nameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Choose(gremlingo.T__.Values("age")).Option(gremlingo.P.Between(26, 30), gremlingo.T__.Values("name")).Option(gremlingo.Pick.None, gremlingo.T__.Values("name"))}}, 
    "g_V_chooseXhasLabelXpersonX_localXchooseXageX_optionXbetweenX26_30X_name_foldX_optionXnone_name_foldXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Local(gremlingo.T__.Choose(gremlingo.T__.Values("age")).Option(gremlingo.P.Between(26, 30), gremlingo.T__.Values("name").Fold()).Option(gremlingo.Pick.None, gremlingo.T__.Values("name").Fold()))}}, 
    "g_V_chooseXhasLabelXpersonX_mapXchooseXageX_optionXbetweenX26_30X_name_foldX_optionXnone_name_foldXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Map(gremlingo.T__.Choose(gremlingo.T__.Values("age")).Option(gremlingo.P.Between(26, 30), gremlingo.T__.Values("name").Fold()).Option(gremlingo.Pick.None, gremlingo.T__.Values("name").Fold()))}}, 
    "g_unionXV_VXhasLabelXpersonX_barrier_localXchooseXageX_optionXbetweenX26_30X_name_foldX_optionXnone_name_foldXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Union(gremlingo.T__.V(), gremlingo.T__.V()).HasLabel("person").Barrier().Local(gremlingo.T__.Choose(gremlingo.T__.Values("age")).Option(gremlingo.P.Between(26, 30), gremlingo.T__.Values("name").Fold()).Option(gremlingo.Pick.None, gremlingo.T__.Values("name").Fold()))}}, 
    "g_unionXV_VXhasLabelXpersonX_barrier_mapXchooseXageX_optionXbetweenX26_30X_name_foldX_optionXnone_name_foldXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Union(gremlingo.T__.V(), gremlingo.T__.V()).HasLabel("person").Barrier().Map(gremlingo.T__.Choose(gremlingo.T__.Values("age")).Option(gremlingo.P.Between(26, 30), gremlingo.T__.Values("name").Fold()).Option(gremlingo.Pick.None, gremlingo.T__.Values("name").Fold()))}}, 
    "g_V_chooseXageX_optionXbetweenX26_30X_nameX_optionXnone_nameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Choose(gremlingo.T__.Values("age")).Option(gremlingo.P.Between(26, 30), gremlingo.T__.Values("name")).Option(gremlingo.Pick.None, gremlingo.T__.Values("name"))}}, 
    "g_V_chooseXageX_optionXbetweenX26_30X_nameX_optionXnone_nameX_optionXunproductive_labelX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Choose(gremlingo.T__.Values("age")).Option(gremlingo.P.Between(26, 30), gremlingo.T__.Values("name")).Option(gremlingo.Pick.None, gremlingo.T__.Values("name")).Option(gremlingo.Pick.Unproductive, gremlingo.T__.Label())}}, 
    "g_V_chooseXageX_optionXbetweenX26_30X_nameX_optionXnone_nameX_optionXnone_identityX_optionXnone_failX_optionXunproductive_identityX_optionXunproductive_labelX_optionXnone_failX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Choose(gremlingo.T__.Values("age")).Option(gremlingo.P.Between(26, 30), gremlingo.T__.Values("name")).Option(gremlingo.Pick.None, gremlingo.T__.Values("name")).Option(gremlingo.Pick.None, gremlingo.T__.Identity()).Option(gremlingo.Pick.None, gremlingo.T__.Fail()).Option(gremlingo.Pick.Unproductive, gremlingo.T__.Label()).Option(gremlingo.Pick.Unproductive, gremlingo.T__.Identity()).Option(gremlingo.Pick.Unproductive, gremlingo.T__.Fail())}}, 
    "g_V_chooseXage_nameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Choose(gremlingo.T__.Values("age"), gremlingo.T__.Values("name"))}}, 
    "g_V_chooseXageX_optionXbetweenX26_30X_nameX_optionXnone_discardX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Choose(gremlingo.T__.Values("age")).Option(gremlingo.P.Between(26, 30), gremlingo.T__.Values("name")).Option(gremlingo.Pick.None, gremlingo.T__.Discard())}}, 
    "g_V_chooseXnameX_optionXneqXyX_ageX_optionXnone_constantXxXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Choose(gremlingo.T__.Values("name")).Option(gremlingo.P.Neq("y"), gremlingo.T__.Values("age")).Option(gremlingo.Pick.None, gremlingo.T__.Constant("x"))}}, 
    "g_V_hasLabelXpersonX_chooseXoutXcreatedX_count_isXeqX0XX__constantXdidnt_createX__constantXcreatedXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Choose(gremlingo.T__.Out("created").Count().Is(gremlingo.P.Eq(0)), gremlingo.T__.Constant("didnt_create"), gremlingo.T__.Constant("created"))}}, 
    "g_V_hasLabelXpersonX_chooseXvaluesXageX_isXgtX30XX__valuesXageX__constantX30XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Choose(gremlingo.T__.Values("age").Is(gremlingo.P.Gt(30)), gremlingo.T__.Values("age"), gremlingo.T__.Constant(30))}}, 
    "g_V_hasLabelXpersonX_chooseXvaluesXageX_isXgtX29XX_and_valuesXageX_isXltX35XX__valuesXnameX__constantXotherXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Choose(gremlingo.T__.Values("age").Is(gremlingo.P.Gt(29)).And().Values("age").Is(gremlingo.P.Lt(35)), gremlingo.T__.Values("name"), gremlingo.T__.Constant("other"))}}, 
    "g_V_chooseXhasXname_vadasX__valuesXnameX__valuesXageXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Choose(gremlingo.T__.Has("name", "vadas"), gremlingo.T__.Values("name"), gremlingo.T__.Values("age"))}}, 
    "g_V_hasLabelXpersonX_chooseXoutXcreatedX_countX_optionX0__constantXnoneXX_optionX1__constantXoneXX_optionX2__constantXmanyXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Choose(gremlingo.T__.Out("created").Count()).Option(p["xx0"], gremlingo.T__.Constant("none")).Option(p["xx1"], gremlingo.T__.Constant("one")).Option(p["xx2"], gremlingo.T__.Constant("many"))}}, 
    "g_V_hasLabelXpersonX_chooseXlocalXoutXknowsX_countX__optionX0__constantXnoFriendsXX__optionXnone__constantXhasFriendsXXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Choose(gremlingo.T__.Local(gremlingo.T__.Out("knows").Count())).Option(p["xx0"], gremlingo.T__.Constant("noFriends")).Option(gremlingo.Pick.None, gremlingo.T__.Constant("hasFriends"))}}, 
    "g_V_chooseXoutE_countX_optionX0__constantXnoneXX_optionXnone__constantXsomeXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Choose(gremlingo.T__.OutE().Count()).Option(p["xx0"], gremlingo.T__.Constant("none")).Option(gremlingo.Pick.None, gremlingo.T__.Constant("some"))}}, 
    "g_V_chooseXlabelX_optionXperson__chooseXageX_optionXP_lt_30__constantXyoungXX_optionXP_gte_30__constantXoldXXX_optionXsoftware__constantXprogramXX_optionXnone__constantXunknownXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Choose(gremlingo.T__.Label()).Option("person", gremlingo.T__.Choose(gremlingo.T__.Values("age")).Option(gremlingo.P.Lt(30), gremlingo.T__.Constant("young")).Option(gremlingo.P.Gte(30), gremlingo.T__.Constant("old"))).Option("software", gremlingo.T__.Constant("program")).Option(gremlingo.Pick.None, gremlingo.T__.Constant("unknown"))}}, 
    "g_V_chooseXhasXname_vadasX__valuesXnameXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Choose(gremlingo.T__.Has("name", "vadas"), gremlingo.T__.Values("name"))}}, 
    "g_V_hasLabelXpersonX_age_chooseXP_eqX29X_constantXmatchedX_constantXotherXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Values("age").Choose(gremlingo.P.Eq(29), gremlingo.T__.Constant("matched"), gremlingo.T__.Constant("other"))}}, 
    "g_V_hasLabelXpersonX_age_chooseXP_eqX29X_constantXmatchedX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Values("age").Choose(gremlingo.P.Eq(29), gremlingo.T__.Constant("matched"))}}, 
    "g_V_hasLabelXpersonX_chooseX_valuesXnameX_option1X_isXmarkoX_valuesXageXX_option2Xnone_valuesXnameXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Choose(gremlingo.T__.Values("name")).Option(gremlingo.T__.Is("marko"), gremlingo.T__.Values("age")).Option(gremlingo.Pick.None, gremlingo.T__.Values("name"))}}, 
    "g_V_hasLabelXpersonX_chooseX_valuesXnameX_option1X_PeqXmarkoX_valuesXageXX_option2Xnone_valuesXnameXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Choose(gremlingo.T__.Values("name")).Option(gremlingo.P.Eq("marko"), gremlingo.T__.Values("age")).Option(gremlingo.Pick.None, gremlingo.T__.Values("name"))}}, 
    "g_V_localXpropertiesXlocationX_order_byXvalueX_limitX2XX_value": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Local(gremlingo.T__.Properties("location").Order().By(gremlingo.T.Value, gremlingo.Order.Asc).Range(0, 2)).Value()}}, 
    "g_V_hasXlabel_personX_asXaX_localXoutXcreatedX_asXbXX_selectXa_bX_byXnameX_byXidX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has(gremlingo.T.Label, "person").As("a").Local(gremlingo.T__.Out("created").As("b")).Select("a", "b").By("name").By(gremlingo.T.Id)}}, 
    "g_V_localXoutE_countX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Local(gremlingo.T__.OutE().Count())}}, 
    "g_VX1X_localXoutEXknowsX_limitX1XX_inV_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Local(gremlingo.T__.OutE("knows").Limit(1)).InV().Values("name")}}, 
    "g_V_localXbothEXcreatedX_limitX1XX_otherV_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Local(gremlingo.T__.BothE("created").Limit(1)).OtherV().Values("name")}}, 
    "g_VX4X_localXbothEX1_createdX_limitX1XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).Local(gremlingo.T__.BothE("created").Limit(1))}}, 
    "g_VX4X_localXbothEXknows_createdX_limitX1XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).Local(gremlingo.T__.BothE("knows", "created").Limit(1))}}, 
    "g_VX4X_localXbothE_limitX1XX_otherV_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).Local(gremlingo.T__.BothE().Limit(1)).OtherV().Values("name")}}, 
    "g_VX4X_localXbothE_limitX2XX_otherV_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).Local(gremlingo.T__.BothE().Limit(2)).OtherV().Values("name")}}, 
    "g_V_localXinEXknowsX_limitX2XX_outV_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Local(gremlingo.T__.InE("knows").Limit(2)).OutV().Values("name")}}, 
    "g_V_localXmatchXproject__created_person__person_name_nameX_selectXname_projectX_by_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Local(gremlingo.T__.Match(gremlingo.T__.As("project").In("created").As("person"), gremlingo.T__.As("person").Values("name").As("name"))).Select("name", "project").By().By("name")}}, 
    "g_V_in_barrier_localXcountX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().In().Barrier().Local(gremlingo.T__.Count())}}, 
    "g_V_localXout_in_simplePathX_path": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Local(gremlingo.T__.Out().In().SimplePath()).Path()}}, 
    "g_withSackX0LX_V_in_barrier_localXsackXsumX_byXageXX_sack": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSack(int64(0)).V().In().Barrier().Local(gremlingo.T__.Sack(gremlingo.Operator.Sum).By("age")).Sack()}}, 
    "g_V_localXout_localXcountXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Local(gremlingo.T__.Out().Local(gremlingo.T__.Count()))}}, 
    "g_V_unionXoutE_count_localXinE_countXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Union(gremlingo.T__.OutE().Count(), gremlingo.T__.Local(gremlingo.T__.InE().Count()))}}, 
    "g_VX2X_optionalXoutXknowsXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid2"]).Optional(gremlingo.T__.Out("knows"))}}, 
    "g_VX2X_optionalXinXknowsXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid2"]).Optional(gremlingo.T__.In("knows"))}}, 
    "g_V_hasLabelXpersonX_optionalXoutXknowsX_optionalXoutXcreatedXXX_path": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Optional(gremlingo.T__.Out("knows").Optional(gremlingo.T__.Out("created"))).Path()}}, 
    "g_V_optionalXout_optionalXoutXX_path": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Optional(gremlingo.T__.Out().Optional(gremlingo.T__.Out())).Path()}}, 
    "g_VX1X_optionalXaddVXdogXX_label": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Optional(gremlingo.T__.AddV("dog")).Label()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_V_repeatXoutX_timesX2X_emit_path": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Out()).Times(2).Emit().Path()}}, 
    "g_V_repeatXoutX_timesX2X_repeatXinX_timesX2X_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Out()).Times(2).Repeat(gremlingo.T__.In()).Times(2).Values("name")}}, 
    "g_V_repeatXoutE_inVX_timesX2X_path_by_name_by_label": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.OutE().InV()).Times(2).Path().By("name").By(gremlingo.T.Label)}}, 
    "g_V_repeatXoutX_timesX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Out()).Times(2)}}, 
    "g_V_repeatXoutX_timesX2X_emit": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Out()).Times(2).Emit()}}, 
    "g_VX1X_timesX2X_repeatXoutX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Times(2).Repeat(gremlingo.T__.Out()).Values("name")}}, 
    "g_V_emit_timesX2X_repeatXoutX_path": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Emit().Times(2).Repeat(gremlingo.T__.Out()).Path()}}, 
    "g_V_emit_repeatXoutX_timesX2X_path": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Emit().Repeat(gremlingo.T__.Out()).Times(2).Path()}}, 
    "g_VX1X_emitXhasXlabel_personXX_repeatXoutX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Emit(gremlingo.T__.Has(gremlingo.T.Label, "person")).Repeat(gremlingo.T__.Out()).Values("name")}}, 
    "g_V_repeatXgroupCountXmX_byXnameX_outX_timesX2X_capXmX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.GroupCount("m").By("name").Out()).Times(2).Cap("m")}}, 
    "g_VX1X_repeatXgroupCountXmX_byXloopsX_outX_timesX3X_capXmX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Repeat(gremlingo.T__.GroupCount("m").By(gremlingo.T__.Loops()).Out()).Times(3).Cap("m")}}, 
    "g_V_repeatXbothX_timesX10X_asXaX_out_asXbX_selectXa_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Both()).Times(10).As("a").Out().As("b").Select("a", "b").Count()}}, 
    "g_VX1X_repeatXoutX_untilXoutE_count_isX0XX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Repeat(gremlingo.T__.Out()).Until(gremlingo.T__.OutE().Count().Is(0)).Values("name")}}, 
    "g_V_hasXname_markoX_repeatXoutE_inV_simplePathX_untilXhasXname_rippleXX_path_byXnameX_byXlabelX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "marko").Repeat(gremlingo.T__.OutE().InV().SimplePath()).Until(gremlingo.T__.Has("name", "ripple")).Path().By("name").By(gremlingo.T.Label)}}, 
    "g_V_hasXloop_name_loopX_repeatXinX_timesX5X_path_by_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("loops", "name", "loop").Repeat(gremlingo.T__.In()).Times(5).Path().By("name")}}, 
    "g_V_repeatXout_repeatXout_order_byXname_descXX_timesX1XX_timesX1X_limitX1X_path_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Out().Repeat(gremlingo.T__.Out().Order().By("name", gremlingo.Order.Desc)).Times(1)).Times(1).Limit(1).Path().By("name")}}, 
    "g_V_repeatXoutXknowsXX_untilXrepeatXoutXcreatedXX_emitXhasXname_lopXXX_path_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Out("knows")).Until(gremlingo.T__.Repeat(gremlingo.T__.Out("created")).Emit(gremlingo.T__.Has("name", "lop"))).Path().By("name")}}, 
    "g_V_repeatXrepeatXout_createdXX_untilXhasXname_rippleXXXemit_lang": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Repeat(gremlingo.T__.Out("created")).Until(gremlingo.T__.Has("name", "ripple"))).Emit().Values("lang")}}, 
    "g_V_untilXconstantXtrueXX_repeatXrepeatXout_createdXX_untilXhasXname_rippleXXXemit_lang": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Until(gremlingo.T__.Constant(true)).Repeat(gremlingo.T__.Repeat(gremlingo.T__.Out("created")).Until(gremlingo.T__.Has("name", "ripple"))).Emit().Values("lang")}}, 
    "g_V_emit_repeatXa_outXknows_filterXloops_isX0XX_lang": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Emit().Repeat("a", gremlingo.T__.Out("knows").Filter(gremlingo.T__.Loops("a").Is(0))).Values("lang")}}, 
    "g_VX3X_repeatXbothX_createdXX_untilXloops_is_40XXemit_repeatXin_knowsXX_emit_loopsXisX1Xdedup_values": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid3"]).Repeat(gremlingo.T__.Both("created")).Until(gremlingo.T__.Loops().Is(40)).Emit(gremlingo.T__.Repeat(gremlingo.T__.In("knows")).Emit(gremlingo.T__.Loops().Is(1))).Dedup().Values("name")}}, 
    "g_VX1X_repeatXrepeatXunionXout_uses_out_traversesXX_whereXloops_isX0X_timesX1X_timeX2X_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Repeat(gremlingo.T__.Repeat(gremlingo.T__.Union(gremlingo.T__.Out("uses"), gremlingo.T__.Out("traverses")).Where(gremlingo.T__.Loops().Is(0))).Times(1)).Times(2).Values("name")}}, 
    "g_V_repeatXa_outXknows_repeatXb_outXcreatedX_filterXloops_isX0XX_emit_lang": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat("a", gremlingo.T__.Out("knows").Repeat("b", gremlingo.T__.Out("created").Filter(gremlingo.T__.Loops("a").Is(0))).Emit()).Emit().Values("lang")}}, 
    "g_VX6X_repeatXa_bothXcreatedX_simplePathX_emitXrepeatXb_bothXknowsXX_untilXloopsXbX_asXb_whereXloopsXaX_asXbX_hasXname_vadasXX_dedup_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid6"]).Repeat("a", gremlingo.T__.Both("created").SimplePath()).Emit(gremlingo.T__.Repeat("b", gremlingo.T__.Both("knows")).Until(gremlingo.T__.Loops("b").As("b").Where(gremlingo.T__.Loops("a").As("b"))).Has("name", "vadas")).Dedup().Values("name")}}, 
    "g_V_emit": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Emit()}}, 
    "g_V_untilXidentityX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Until(gremlingo.T__.Identity())}}, 
    "g_V_timesX5X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Times(5)}}, 
    "g_V_hasXperson_name_markoX_repeatXoutXcreatedXX_timesX1X_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Repeat(gremlingo.T__.Out("created")).Times(1).Values("name")}}, 
    "g_V_hasXperson_name_markoX_repeatXoutXcreatedXX_timesX0X_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Repeat(gremlingo.T__.Out("created")).Times(0).Values("name")}}, 
    "g_V_hasXperson_name_markoX_timesX1X_repeatXoutXcreatedXX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Times(1).Repeat(gremlingo.T__.Out("created")).Values("name")}}, 
    "g_V_hasXperson_name_markoX_timesX0X_repeatXoutXcreatedXX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Times(0).Repeat(gremlingo.T__.Out("created")).Values("name")}}, 
    "g_V_repeatXboth_hasXnot_productiveXX_timesX3X_constantX1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Both().Has("not", "productive")).Times(3).Constant(1)}}, 
    "g_V_hasXnot_productiveX_repeatXbothX_timesX3X_constantX1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("not", "productive").Repeat(gremlingo.T__.Both()).Times(3).Constant(1)}}, 
    "g_VX1_2_3X_repeatXboth_barrierX_emit_timesX2X_path": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"], p["vid2"], p["vid3"]).Repeat(gremlingo.T__.Both().Barrier()).Emit().Times(2).Path()}}, 
    "g_V_order_byXname_descX_repeatXboth_simplePath_order_byXname_descXX_timesX2X_path": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Order().By("name", gremlingo.Order.Desc).Repeat(gremlingo.T__.Both().SimplePath().Order().By("name", gremlingo.Order.Desc)).Times(2).Path()}}, 
    "g_V_repeatXboth_repeatXorder_byXnameXX_timesX1XX_timesX1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Both().Repeat(gremlingo.T__.Order().By("name")).Times(1)).Times(1)}}, 
    "g_V_order_byXname_descX_repeatXlocalXout_order_byXnameXXX_timesX1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Order().By("name", gremlingo.Order.Desc).Repeat(gremlingo.T__.Local(gremlingo.T__.Out().Order().By("name"))).Times(1)}}, 
    "g_V_order_byXnameX_repeatXlocalXboth_simplePath_order_byXnameXXX_timesX2X_path": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Order().By("name").Repeat(gremlingo.T__.Local(gremlingo.T__.Both().SimplePath().Order().By("name"))).Times(2).Path()}}, 
    "g_V_repeatXunionXoutXknowsX_order_byXnameX_inXcreatedX_order_byXnameXXX_timesX1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Union(gremlingo.T__.Out("knows").Order().By("name"), gremlingo.T__.In("created").Order().By("name"))).Times(1)}}, 
    "g_V_repeatXaddV_propertyXgenerated_trueXX_timesX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV().Property("notGenerated", "true").AddV().Property("notGenerated", "true")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.AddV().Property("generated", "true")).Times(2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("notGenerated")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("generated")}}, 
    "g_V_repeatXdedup_bothX_timesX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Dedup().Both()).Times(2)}}, 
    "g_V_repeatXaggregateXxXX_timesX2X_selectXxX_limitX1X_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Aggregate("x")).Times(2).Select("x").Limit(1).Unfold()}}, 
    "g_V_valuesXstrX_repeatXsplitXabcX_conjoinX_timesX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV().Property("str", "ababcczababcc").AddV().Property("str", "abcyabc")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("str").Repeat(gremlingo.T__.Split("abc").Conjoin("")).Times(2)}}, 
    "g_withSackX0X_V_repeatXsackXsumX_byXageX_whereXsack_isXltX59XXXX_timesX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSack(int64(0)).V().Repeat(gremlingo.T__.Sack(gremlingo.Operator.Sum).By("age").Where(gremlingo.T__.Sack().Is(gremlingo.P.Lt(59)))).Times(2)}}, 
    "g_V_repeatXinjectXyXX_timesX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Inject("y")).Times(2)}}, 
    "g_V_repeatXunionXconstantXyX_limitX1X_identityXX_timesX3X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Union(gremlingo.T__.Constant("y").Limit(1), gremlingo.T__.Identity())).Times(2)}}, 
    "g_VX3X_repeatXout_order_byXperformancesX_tailX2XX_timesX1X_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid3"]).Repeat(gremlingo.T__.Out().Order().By("performances").Tail(2)).Times(1).Values("name")}}, 
    "g_VX3X_repeatXout_order_byXperformancesX_tailX2XX_timesX2X_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid3"]).Repeat(gremlingo.T__.Out().Order().By("performances").Tail(2)).Times(2).Values("name")}}, 
    "g_VX2X_repeatXout_localXorder_byXperformancesX_tailX1XXX_timesX1X_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid2"]).Repeat(gremlingo.T__.Out().Local(gremlingo.T__.Order().By("performances").Tail(1))).Times(1).Values("name")}}, 
    "g_VX250X_repeatXout_localXorder_byXperformancesX_tailX1XXX_timesX2X_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid250"]).Repeat(gremlingo.T__.Out().Local(gremlingo.T__.Order().By("performances").Tail(1))).Times(2).Values("name")}}, 
    "g_VX3X_repeatXout_order_byXperformancesX_tailX3X_limitX1XX_timesX2X_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid3"]).Repeat(gremlingo.T__.Out().Order().By("performances").Tail(3).Limit(1)).Times(2).Values("name")}}, 
    "g_VX3X_repeatXout_order_byXperformances_descX_limitX5X_tailX1XX_timesX2X_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid3"]).Repeat(gremlingo.T__.Out().Order().By("performances", gremlingo.Order.Desc).Limit(5).Tail(1)).Times(2).Values("name")}}, 
    "g_VX3X_repeatXoutE_order_byXweightX_tailX2X_inVX_timesX2X_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid3"]).Repeat(gremlingo.T__.OutE().Order().By("weight").Tail(2).InV()).Times(2).Values("name")}}, 
    "g_VX3X_repeatXoutE_order_byXweight_descX_limitX2X_inVX_timesX2X_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid3"]).Repeat(gremlingo.T__.OutE().Order().By("weight", gremlingo.Order.Desc).Limit(2).InV()).Times(2).Values("name")}}, 
    "g_unionXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Union()}}, 
    "g_unionXV_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Union(gremlingo.T__.V().Values("name"))}}, 
    "g_unionXVXv1X_VX4XX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Union(gremlingo.T__.V(p["vid1"]), gremlingo.T__.V(p["vid4"])).Values("name")}}, 
    "g_unionXV_hasLabelXsoftwareX_V_hasLabelXpersonXX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Union(gremlingo.T__.V().HasLabel("software"), gremlingo.T__.V().HasLabel("person")).Values("name")}}, 
    "g_unionXV_out_out_V_hasLabelXsoftwareXX_path": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Union(gremlingo.T__.V().Out().Out(), gremlingo.T__.V().HasLabel("software")).Path()}}, 
    "g_unionXV_out_out_V_hasLabelXsoftwareXX_path_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Union(gremlingo.T__.V().Out().Out(), gremlingo.T__.V().HasLabel("software")).Path().By("name")}}, 
    "g_unionXunionXV_out_outX_V_hasLabelXsoftwareXX_path_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Union(gremlingo.T__.Union(gremlingo.T__.V().Out().Out()), gremlingo.T__.V().HasLabel("software")).Path().By("name")}}, 
    "g_unionXinjectX1X_injectX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Union(gremlingo.T__.Inject(1), gremlingo.T__.Inject(2))}}, 
    "g_V_unionXconstantX1X_constantX2X_constantX3XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid2"]).Union(gremlingo.T__.Constant(int32(1)), gremlingo.T__.Constant(int32(2)), gremlingo.T__.Constant(int32(3)))}}, 
    "g_V_unionXout__inX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Union(gremlingo.T__.Out(), gremlingo.T__.In()).Values("name")}}, 
    "g_VX1X_unionXrepeatXoutX_timesX2X__outX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Union(gremlingo.T__.Repeat(gremlingo.T__.Out()).Times(2), gremlingo.T__.Out()).Values("name")}}, 
    "g_V_chooseXlabel_is_person__unionX__out_lang__out_nameX__in_labelX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Choose(gremlingo.T__.Label().Is("person"), gremlingo.T__.Union(gremlingo.T__.Out().Values("lang"), gremlingo.T__.Out().Values("name")), gremlingo.T__.In().Label())}}, 
    "g_V_chooseXlabel_is_person__unionX__out_lang__out_nameX__in_labelX_groupCount": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Choose(gremlingo.T__.Label().Is("person"), gremlingo.T__.Union(gremlingo.T__.Out().Values("lang"), gremlingo.T__.Out().Values("name")), gremlingo.T__.In().Label()).GroupCount()}}, 
    "g_V_unionXrepeatXunionXoutXcreatedX__inXcreatedXX_timesX2X__repeatXunionXinXcreatedX__outXcreatedXX_timesX2XX_label_groupCount": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Union(gremlingo.T__.Repeat(gremlingo.T__.Union(gremlingo.T__.Out("created"), gremlingo.T__.In("created"))).Times(2), gremlingo.T__.Repeat(gremlingo.T__.Union(gremlingo.T__.In("created"), gremlingo.T__.Out("created"))).Times(2)).Label().GroupCount()}}, 
    "g_VX1_2X_unionXoutE_count__inE_count__outE_weight_sumX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"], p["vid2"]).Union(gremlingo.T__.OutE().Count(), gremlingo.T__.InE().Count(), gremlingo.T__.OutE().Values("weight").Sum())}}, 
    "g_VX1_2X_localXunionXoutE_count__inE_count__outE_weight_sumXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"], p["vid2"]).Local(gremlingo.T__.Union(gremlingo.T__.OutE().Count(), gremlingo.T__.InE().Count(), gremlingo.T__.OutE().Values("weight").Sum()))}}, 
    "g_VX1_2X_localXunionXcountXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"], p["vid2"]).Local(gremlingo.T__.Union(gremlingo.T__.Count()))}}, 
    "g_unionXaddVXpersonX_propertyXname_aliceX_addVXpersonX_propertyXname_bobX_addVXpersonX_propertyXname_chrisX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Union(gremlingo.T__.AddV("person").Property("name", "alice"), gremlingo.T__.AddV("person").Property("name", "bob"), gremlingo.T__.AddV("person").Property("name", "chris")).Values("name")}}, 
    "g_VX_hasLabelXpersonX_unionX_whereX_out_count_isXgtX2XXX_valuesXageX_notX_whereX_bothE_count_isXgt2XXX_valusXnameXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Union(gremlingo.T__.Where(gremlingo.T__.OutE().Count().Is(gremlingo.P.Gt(2))).Values("age"), gremlingo.T__.Not(gremlingo.T__.Where(gremlingo.T__.OutE().Count().Is(gremlingo.P.Gt(2)))).Values("name"))}}, 
    "g_V_valuesXintX_asNumberXGType_BIGDECIMALX_isXtypeOfXGType_BIGDECIMALXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("int", 123)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("int").AsNumber(gremlingo.GType.BigDecimal).Is(gremlingo.P.TypeOf(gremlingo.GType.BigDecimal))}}, 
    "g_V_valuesXintX_asNumberXGType_BIGDECIMALX_isXtypeOfXGType_BIGDECIMALXX_mathXaddX0_5XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("int", 10)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("int").AsNumber(gremlingo.GType.BigDecimal).Is(gremlingo.P.TypeOf(gremlingo.GType.BigDecimal)).Math("_ + 0.5")}}, 
    "g_V_valuesXintX_asNumberXGType_BIGDECIMALX_isXtypeOfXGType_BIGDECIMALXX_isXgtX0XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("int", 5)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("int").AsNumber(gremlingo.GType.BigDecimal).Is(gremlingo.P.TypeOf(gremlingo.GType.BigDecimal)).Is(gremlingo.P.Gt(0))}}, 
    "g_V_valuesXintX_asNumberXGType_BIGDECIMALX_isXtypeOfXGType_BIGDECIMALXX_sumX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("int", 2).AddV("data").Property("int", 3).AddV("data").Property("int", 4)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("int").AsNumber(gremlingo.GType.BigDecimal).Is(gremlingo.P.TypeOf(gremlingo.GType.BigDecimal)).Sum()}}, 
    "g_V_valuesXintX_asNumberXGType_BIGDECIMALX_isXtypeOfXGType_BIGDECIMALXX_minX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("int", 1).AddV("data").Property("int", 5).AddV("data").Property("int", 10)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("int").AsNumber(gremlingo.GType.BigDecimal).Is(gremlingo.P.TypeOf(gremlingo.GType.BigDecimal)).Min()}}, 
    "g_V_valuesXintX_asNumberXGType_BIGDECIMALX_isXtypeOfXGType_BIGDECIMALXX_maxX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("int", 7).AddV("data").Property("int", 14).AddV("data").Property("int", 21)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("int").AsNumber(gremlingo.GType.BigDecimal).Is(gremlingo.P.TypeOf(gremlingo.GType.BigDecimal)).Max()}}, 
    "g_V_valuesXintX_asNumberXGType_BIGDECIMALX_isXtypeOfXGType_BIGDECIMALXX_project_byXidentityX_byXmathXmulX10XXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("int", 6)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("int").AsNumber(gremlingo.GType.BigDecimal).Is(gremlingo.P.TypeOf(gremlingo.GType.BigDecimal)).Project("original", "multiplied").By(gremlingo.T__.Identity()).By(gremlingo.T__.Math("_ * 10"))}}, 
    "g_injectX99X_asNumberXGType_BIGDECIMALX_isXtypeOfXGType_BIGDECIMALXX_groupCount": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(99).AsNumber(gremlingo.GType.BigDecimal).Is(gremlingo.P.TypeOf(gremlingo.GType.BigDecimal)).GroupCount()}}, 
    "g_V_valuesXageX_isXtypeOfXGType_BIGDECIMALXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Is(gremlingo.P.TypeOf(gremlingo.GType.BigDecimal))}}, 
    "g_V_valuesXintX_asNumberXGType_BIGINTX_isXtypeOfXGType_BIGINTXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("int", 456)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("int").AsNumber(gremlingo.GType.BigInt).Is(gremlingo.P.TypeOf(gremlingo.GType.BigInt))}}, 
    "g_V_valuesXintX_asNumberXGType_BIGINTX_isXtypeOfXGType_BIGINTXX_mathXmulX1000XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("int", 100)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("int").AsNumber(gremlingo.GType.BigInt).Is(gremlingo.P.TypeOf(gremlingo.GType.BigInt)).Math("_ * 1000")}}, 
    "g_V_valuesXintX_asNumberXGType_BIGINTX_isXtypeOfXGType_BIGINTXX_isXeqX42XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("int", 42)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("int").AsNumber(gremlingo.GType.BigInt).Is(gremlingo.P.TypeOf(gremlingo.GType.BigInt)).Is(gremlingo.P.Eq(42))}}, 
    "g_V_valuesXintX_asNumberXGType_BIGINTX_isXtypeOfXGType_BIGINTXX_sumX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("int", 10).AddV("data").Property("int", 20).AddV("data").Property("int", 30)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("int").AsNumber(gremlingo.GType.BigInt).Is(gremlingo.P.TypeOf(gremlingo.GType.BigInt)).Sum()}}, 
    "g_V_valuesXintX_asNumberXGType_BIGINTX_isXtypeOfXGType_BIGINTXX_minX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("int", 5).AddV("data").Property("int", 15).AddV("data").Property("int", 25)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("int").AsNumber(gremlingo.GType.BigInt).Is(gremlingo.P.TypeOf(gremlingo.GType.BigInt)).Min()}}, 
    "g_V_valuesXintX_asNumberXGType_BIGINTX_isXtypeOfXGType_BIGINTXX_maxX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("int", 100).AddV("data").Property("int", 200).AddV("data").Property("int", 300)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("int").AsNumber(gremlingo.GType.BigInt).Is(gremlingo.P.TypeOf(gremlingo.GType.BigInt)).Max()}}, 
    "g_V_valuesXintX_asNumberXGType_BIGINTX_isXtypeOfXGType_BIGINTXX_project_byXidentityX_byXmathXaddX999XXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("int", 50)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("int").AsNumber(gremlingo.GType.BigInt).Is(gremlingo.P.TypeOf(gremlingo.GType.BigInt)).Project("original", "added").By(gremlingo.T__.Identity()).By(gremlingo.T__.Math("_ + 999"))}}, 
    "g_injectX777X_asNumberXGType_BIGINTX_isXtypeOfXGType_BIGINTXX_groupCount": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(777).AsNumber(gremlingo.GType.BigInt).Is(gremlingo.P.TypeOf(gremlingo.GType.BigInt)).GroupCount()}}, 
    "g_V_valuesXageX_isXtypeOfXGType_BIGINTXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Is(gremlingo.P.TypeOf(gremlingo.GType.BigInt))}}, 
    "g_V_valuesXintX_asNumberXGType_BYTEX_isXtypeOfXGType_BYTEXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("int", 5)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("int").AsNumber(gremlingo.GType.Byte).Is(gremlingo.P.TypeOf(gremlingo.GType.Byte))}}, 
    "g_V_valuesXintX_asNumberXGType_BYTEX_isXtypeOfXGType_BYTEXX_mathXaddX20XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("int", 10)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("int").AsNumber(gremlingo.GType.Byte).Is(gremlingo.P.TypeOf(gremlingo.GType.Byte)).Math("_ + 20")}}, 
    "g_V_valuesXintX_asNumberXGType_BYTEX_isXtypeOfXGType_BYTEXX_isXltX10XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("int", 7)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("int").AsNumber(gremlingo.GType.Byte).Is(gremlingo.P.TypeOf(gremlingo.GType.Byte)).Is(gremlingo.P.Lt(10))}}, 
    "g_V_valuesXintX_asNumberXGType_BYTEX_isXtypeOfXGType_BYTEXX_sumX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("int", 1).AddV("data").Property("int", 2).AddV("data").Property("int", 3)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("int").AsNumber(gremlingo.GType.Byte).Is(gremlingo.P.TypeOf(gremlingo.GType.Byte)).Sum()}}, 
    "g_V_valuesXintX_asNumberXGType_BYTEX_isXtypeOfXGType_BYTEXX_project_byXidentityX_byXmathXmulX2XXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("int", 8)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("int").AsNumber(gremlingo.GType.Byte).Is(gremlingo.P.TypeOf(gremlingo.GType.Byte)).Project("original", "doubled").By(gremlingo.T__.Identity()).By(gremlingo.T__.Math("_ * 2"))}}, 
    "g_V_valuesXintX_asNumberXGType_BYTEX_isXtypeOfXGType_BYTEXX_chooseXisXeqX12XX_constantXtwelveX_constantXotherXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("int", 12)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("int").AsNumber(gremlingo.GType.Byte).Is(gremlingo.P.TypeOf(gremlingo.GType.Byte)).Choose(gremlingo.T__.Is(gremlingo.P.Eq(12)), gremlingo.T__.Constant("twelve"), gremlingo.T__.Constant("other"))}}, 
    "g_injectX15X_asNumberXGType_BYTEX_isXtypeOfXGType_BYTEXX_groupCount": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(15).AsNumber(gremlingo.GType.Byte).Is(gremlingo.P.TypeOf(gremlingo.GType.Byte)).GroupCount()}}, 
    "g_V_valuesXageX_isXtypeOfXGType_BYTEXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Is(gremlingo.P.TypeOf(gremlingo.GType.Byte))}}, 
    "g_V_valuesXdatetimeX_isXtypeOfXGType_DATETIMEXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("event").Property("datetime", time.Date(2023, 8, 8, 0, 0, 0, 0, time.FixedZone("UTC+00:00", 0)))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("datetime").Is(gremlingo.P.TypeOf(gremlingo.GType.DateTime))}}, 
    "g_V_valuesXdatetimeX_isXtypeOfXGType_DATETIMEXX_project_byXidentityX_byXdateAddXDT_dayX1XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("event").Property("datetime", time.Date(2023, 8, 8, 0, 0, 0, 0, time.FixedZone("UTC+00:00", 0)))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("datetime").Is(gremlingo.P.TypeOf(gremlingo.GType.DateTime)).Project("original", "nextDay").By(gremlingo.T__.Identity()).By(gremlingo.T__.DateAdd(gremlingo.DT.Day, 1))}}, 
    "g_V_valuesXdatetimeX_isXtypeOfXGType_DATETIMEXX_dateDiffXdatetimeX2023_08_10XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("event").Property("datetime", time.Date(2023, 8, 8, 0, 0, 0, 0, time.FixedZone("UTC+00:00", 0)))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("datetime").Is(gremlingo.P.TypeOf(gremlingo.GType.DateTime)).DateDiff(time.Date(2023, 8, 8, 0, 0, 30, 0, time.FixedZone("UTC+00:00", 0)))}}, 
    "g_V_valuesXdatetimeX_isXtypeOfXGType_DATETIMEXX_whereXisXgtXdatetimeX2020_01_01XXXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("event").Property("datetime", time.Date(2023, 8, 8, 0, 0, 0, 0, time.FixedZone("UTC+00:00", 0)))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("datetime").Is(gremlingo.P.TypeOf(gremlingo.GType.DateTime)).Where(gremlingo.T__.Is(gremlingo.P.Gt(time.Date(2020, 1, 1, 0, 0, 0, 0, time.FixedZone("UTC+00:00", 0)))))}}, 
    "g_V_valuesXdatetimeX_isXtypeOfXGType_DATETIMEXX_chooseXisXeqXdatetimeX2023_08_08XXXX_constantXmatchX_constantXnoMatchXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("event").Property("datetime", time.Date(2023, 8, 8, 0, 0, 0, 0, time.FixedZone("UTC+00:00", 0)))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("datetime").Is(gremlingo.P.TypeOf(gremlingo.GType.DateTime)).Choose(gremlingo.T__.Is(gremlingo.P.Eq(time.Date(2023, 8, 8, 0, 0, 0, 0, time.FixedZone("UTC+00:00", 0)))), gremlingo.T__.Constant("match"), gremlingo.T__.Constant("noMatch"))}}, 
    "g_V_valuesXdatetimeX_isXtypeOfXGType_DATETIMEXX_localXaggregateXaX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("event").Property("datetime", time.Date(2023, 8, 8, 0, 0, 0, 0, time.FixedZone("UTC+00:00", 0)))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("datetime").Is(gremlingo.P.TypeOf(gremlingo.GType.DateTime)).Local(gremlingo.T__.Aggregate("a")).Cap("a")}}, 
    "g_injectXdatetimeX_isXtypeOfXGType_DATETIMEXX_aggregateXaX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(time.Date(2023, 8, 8, 0, 0, 0, 0, time.FixedZone("UTC+00:00", 0))).Is(gremlingo.P.TypeOf(gremlingo.GType.DateTime)).Aggregate("a").Cap("a")}}, 
    "g_injectXdatetimeX_isXtypeOfXGType_DATETIMEXX_groupCount": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(time.Date(2023, 8, 8, 0, 0, 0, 0, time.FixedZone("UTC+00:00", 0))).Is(gremlingo.P.TypeOf(gremlingo.GType.DateTime)).GroupCount()}}, 
    "g_V_valuesXdoubleX_isXtypeOfXGType_DOUBLEXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("double", 1.5)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("double").Is(gremlingo.P.TypeOf(gremlingo.GType.Double))}}, 
    "g_E_valuesXweightX_isXtypeOfXGType_DOUBLEXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Values("weight").Is(gremlingo.P.TypeOf(gremlingo.GType.Double))}}, 
    "g_V_valuesXdoubleX_isXtypeOfXGType_DOUBLEXX_mathXceilX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("double", 2.7)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("double").Is(gremlingo.P.TypeOf(gremlingo.GType.Double)).Math("ceil _")}}, 
    "g_V_valuesXdoubleX_isXtypeOfXGType_DOUBLEXX_isXgtX1_0XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("double", 0.8).AddV("data").Property("double", 1.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("double").Is(gremlingo.P.TypeOf(gremlingo.GType.Double)).Is(gremlingo.P.Gt(1.0))}}, 
    "g_V_valuesXdoubleX_isXtypeOfXGType_DOUBLEXX_sumX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("double", 1.5).AddV("data").Property("double", 2.5).AddV("data").Property("double", 3.5)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("double").Is(gremlingo.P.TypeOf(gremlingo.GType.Double)).Sum()}}, 
    "g_V_valuesXdoubleX_isXtypeOfXGType_DOUBLEXX_minX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("double", 0.1).AddV("data").Property("double", 0.5).AddV("data").Property("double", 0.9)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("double").Is(gremlingo.P.TypeOf(gremlingo.GType.Double)).Min()}}, 
    "g_V_valuesXdoubleX_isXtypeOfXGType_DOUBLEXX_maxX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("double", 2.1).AddV("data").Property("double", 3.7).AddV("data").Property("double", 1.9)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("double").Is(gremlingo.P.TypeOf(gremlingo.GType.Double)).Max()}}, 
    "g_V_valuesXdoubleX_isXtypeOfXGType_DOUBLEXX_meanX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("double", 2.1).AddV("data").Property("double", 4.1).AddV("data").Property("double", 6.1)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("double").Is(gremlingo.P.TypeOf(gremlingo.GType.Double)).Mean()}}, 
    "g_V_valuesXdoubleX_isXtypeOfXGType_DOUBLEXX_order_byXascX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("double", 3.2).AddV("data").Property("double", 1.8).AddV("data").Property("double", 2.5)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("double").Is(gremlingo.P.TypeOf(gremlingo.GType.Double)).Order().By(gremlingo.Order.Asc)}}, 
    "g_injectX5_5dX_isXtypeOfXGType_DOUBLEXX_groupCount": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(5.5).Is(gremlingo.P.TypeOf(gremlingo.GType.Double)).GroupCount()}}, 
    "g_V_valuesXageX_isXtypeOfXGType_DOUBLEXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Is(gremlingo.P.TypeOf(gremlingo.GType.Double))}}, 
    "g_V_valuesXfloatX_isXtypeOfXGType_FLOATXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("float", 2.5)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("float").AsNumber(gremlingo.GType.Float).Is(gremlingo.P.TypeOf(gremlingo.GType.Float))}}, 
    "g_V_valuesXfloatX_isXtypeOfXGType_FLOATXX_mathXmulX2XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("float", 3.0)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("float").AsNumber(gremlingo.GType.Float).Is(gremlingo.P.TypeOf(gremlingo.GType.Float)).Math("_ * 2")}}, 
    "g_V_valuesXfloatX_isXtypeOfXGType_FLOATXX_isXeqX1_5XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("float", 1.5)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("float").AsNumber(gremlingo.GType.Float).Is(gremlingo.P.TypeOf(gremlingo.GType.Float)).Is(gremlingo.P.Eq(1.5))}}, 
    "g_V_valuesXfloatX_isXtypeOfXGType_FLOATXX_sumX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("float", 1.5).AddV("data").Property("float", 2.5).AddV("data").Property("float", 3.0)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("float").AsNumber(gremlingo.GType.Float).Is(gremlingo.P.TypeOf(gremlingo.GType.Float)).Sum()}}, 
    "g_V_valuesXfloatX_isXtypeOfXGType_FLOATXX_project_byXidentityX_byXmathXmulX10XXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("float", 4.5)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("float").AsNumber(gremlingo.GType.Float).Is(gremlingo.P.TypeOf(gremlingo.GType.Float)).Project("original", "multiplied").By(gremlingo.T__.Identity()).By(gremlingo.T__.Math("_ * 10"))}}, 
    "g_V_valuesXfloatX_isXtypeOfXGType_FLOATXX_whereXisXgtX1_0XXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("float", 0.5).AddV("data").Property("float", 1.5)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("float").AsNumber(gremlingo.GType.Float).Is(gremlingo.P.TypeOf(gremlingo.GType.Float)).Where(gremlingo.T__.Is(gremlingo.P.Gt(1.0)))}}, 
    "g_V_valuesXfloatX_isXtypeOfXGType_FLOATXX_chooseXisXeqX3_0XX_constantXthreeX_constantXotherXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("float", 3.0)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("float").AsNumber(gremlingo.GType.Float).Is(gremlingo.P.TypeOf(gremlingo.GType.Float)).Choose(gremlingo.T__.Is(gremlingo.P.Eq(3.0)), gremlingo.T__.Constant("three"), gremlingo.T__.Constant("other"))}}, 
    "g_injectX2_0fX_isXtypeOfXGType_FLOATXX_groupCount": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(2.0).AsNumber(gremlingo.GType.Float).Is(gremlingo.P.TypeOf(gremlingo.GType.Float)).GroupCount()}}, 
    "g_V_valuesXageX_isXtypeOfXGType_FLOATXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Is(gremlingo.P.TypeOf(gremlingo.GType.Float))}}, 
    "g_V_valuesXageX_isXtypeOfXGType_INTXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Is(gremlingo.P.TypeOf(gremlingo.GType.Int))}}, 
    "g_V_hasXage_typeOfXGType_INTXX_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("age", gremlingo.P.TypeOf(gremlingo.GType.Int)).Values("name")}}, 
    "g_V_whereXvaluesXageX_isXtypeOfXGType_INTXXX_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Where(gremlingo.T__.Values("age").Is(gremlingo.P.TypeOf(gremlingo.GType.Int))).Values("name")}}, 
    "g_V_valuesXageX_isXtypeOfXGType_INTXX_mathXincX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name", "age").Is(gremlingo.P.TypeOf(gremlingo.GType.Int)).Math("_ + 1")}}, 
    "g_V_valuesXageX_isXtypeOfXGType_INTXX_sumX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Is(gremlingo.P.TypeOf(gremlingo.GType.Int)).Sum()}}, 
    "g_V_valuesXageX_isXtypeOfXGType_INTXX_minX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Is(gremlingo.P.TypeOf(gremlingo.GType.Int)).Min()}}, 
    "g_V_valuesXageX_isXtypeOfXGType_INTXX_maxX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Is(gremlingo.P.TypeOf(gremlingo.GType.Int)).Max()}}, 
    "g_V_valuesXageX_isXtypeOfXGType_INTXX_meanX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Is(gremlingo.P.TypeOf(gremlingo.GType.Int)).Mean()}}, 
    "g_V_valuesXageX_isXtypeOfXGType_INTXX_order_byXdescX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Is(gremlingo.P.TypeOf(gremlingo.GType.Int)).Order().By(gremlingo.Order.Desc)}}, 
    "g_V_valuesXageX_isXtypeOfXGType_INTXX_groupCount": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Is(gremlingo.P.TypeOf(gremlingo.GType.Int)).GroupCount()}}, 
    "g_V_valuesXnameX_fold_isXtypeOfXGType_LISTXX_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Fold().Is(gremlingo.P.TypeOf(gremlingo.GType.List)).Count()}}, 
    "g_V_valuesXageX_isXtypeOfXGType_LISTXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Is(gremlingo.P.TypeOf(gremlingo.GType.List))}}, 
    "g_V_valuesXlistX_isXtypeOfXGType_LISTXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("list", []interface{}{"a", "b", "c"})}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("list").Is(gremlingo.P.TypeOf(gremlingo.GType.List))}}, 
    "g_V_hasXlist_typeOfXGType_LISTXX_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("name", "test").Property("list", []interface{}{1, 2, 3})}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("list", gremlingo.P.TypeOf(gremlingo.GType.List)).Values("name")}}, 
    "g_V_valuesXlistX_isXtypeOfXGType_LISTXX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("list", []interface{}{"x", "y", "z"})}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("list").Is(gremlingo.P.TypeOf(gremlingo.GType.List)).Unfold()}}, 
    "g_V_valuesXlistX_isXtypeOfXGType_LISTXX_countXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("list", []interface{}{1, 2, 3, 4, 5})}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("list").Is(gremlingo.P.TypeOf(gremlingo.GType.List)).Count(gremlingo.Scope.Local)}}, 
    "g_V_valuesXlistX_isXtypeOfXGType_LISTXX_unfold_rangeX1_3X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("list", []interface{}{"first", "second", "third", "fourth"})}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("list").Is(gremlingo.P.TypeOf(gremlingo.GType.List)).Unfold().Range(1, 3)}}, 
    "g_V_valuesXlistX_isXtypeOfXGType_LISTXX_project_byXidentityX_byXcountXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("list", []interface{}{"apple", "banana"})}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("list").Is(gremlingo.P.TypeOf(gremlingo.GType.List)).Project("original", "size").By(gremlingo.T__.Identity()).By(gremlingo.T__.Count(gremlingo.Scope.Local))}}, 
    "g_V_valuesXlistX_isXtypeOfXGType_LISTXX_whereXcountXlocalX_isXgtX2XXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("list", []interface{}{1}).AddV("data").Property("list", []interface{}{1, 2, 3})}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("list").Is(gremlingo.P.TypeOf(gremlingo.GType.List)).Where(gremlingo.T__.Count(gremlingo.Scope.Local).Is(gremlingo.P.Gt(2)))}}, 
    "g_injectXlistX_isXtypeOfXGType_LISTXX_groupCount": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{"test"}).Is(gremlingo.P.TypeOf(gremlingo.GType.List)).GroupCount()}}, 
    "g_V_valuesXlongX_isXtypeOfXGType_LONGXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("long", int64(1))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("long").Is(gremlingo.P.TypeOf(gremlingo.GType.Long))}}, 
    "g_V_hasXlong_typeOfXGType_LONGXX_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("name", "test").Property("long", int64(1))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("long", gremlingo.P.TypeOf(gremlingo.GType.Long)).Values("name")}}, 
    "g_V_valuesXlongX_isXtypeOfXGType_LONGXX_mathXmulX2XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("long", int64(5))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("long").Is(gremlingo.P.TypeOf(gremlingo.GType.Long)).Math("_ * 2")}}, 
    "g_V_valuesXlongX_isXtypeOfXGType_LONGXX_isXgtX5XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("long", int64(10))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("long").Is(gremlingo.P.TypeOf(gremlingo.GType.Long)).Is(gremlingo.P.Gt(int64(5)))}}, 
    "g_V_valuesXlongX_isXtypeOfXGType_LONGXX_sumX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("long", int64(1)).AddV("data").Property("long", int64(2)).AddV("data").Property("long", int64(3))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("long").Is(gremlingo.P.TypeOf(gremlingo.GType.Long)).Sum()}}, 
    "g_V_valuesXlongX_isXtypeOfXGType_LONGXX_localXaggregateXaXX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("long", int64(100))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("long").Is(gremlingo.P.TypeOf(gremlingo.GType.Long)).Local(gremlingo.T__.Aggregate("a")).Cap("a")}}, 
    "g_V_hasLabelXpersonX_valueMap_isXtypeOfXGType_MAPXX_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").ValueMap().Is(gremlingo.P.TypeOf(gremlingo.GType.Map)).Count()}}, 
    "g_V_groupCount_byXlabelX_isXtypeOfXGType_MAPX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().GroupCount().By(gremlingo.T.Label).Is(gremlingo.P.TypeOf(gremlingo.GType.Map))}}, 
    "g_V_valuesXageX_isXtypeOfXGType_MAPXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Is(gremlingo.P.TypeOf(gremlingo.GType.Map))}}, 
    "g_V_valuesXmapX_isXtypeOfXGType_MAPXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("map", map[interface{}]interface{}{"key1": "1", "key2": "2" })}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("map").Is(gremlingo.P.TypeOf(gremlingo.GType.Map))}}, 
    "g_V_hasXmap_typeOfXGType_MAPXX_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("name", "test").Property("map", map[interface{}]interface{}{"a": 1, "b": 2 })}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("map", gremlingo.P.TypeOf(gremlingo.GType.Map)).Values("name")}}, 
    "g_V_valuesXmapX_isXtypeOfXGType_MAPXX_countXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("map", map[interface{}]interface{}{"a": 1, "b": 2, "c": 3 })}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("map").Is(gremlingo.P.TypeOf(gremlingo.GType.Map)).Count(gremlingo.Scope.Local)}}, 
    "g_V_valuesXmapX_isXtypeOfXGType_MAPXX_selectXvaluesX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("map", map[interface{}]interface{}{"city": "NYC", "country": "USA" })}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("map").Is(gremlingo.P.TypeOf(gremlingo.GType.Map)).Select(gremlingo.Column.Values)}}, 
    "g_V_valuesXmapX_isXtypeOfXGType_MAPXX_whereX_countXlocalX_isXgtX1XXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("map", map[interface{}]interface{}{"single": "value" }).AddV("data").Property("map", map[interface{}]interface{}{"key1": "1", "key2": "2" })}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("map").Is(gremlingo.P.TypeOf(gremlingo.GType.Map)).Where(gremlingo.T__.Count(gremlingo.Scope.Local).Is(gremlingo.P.Gt(1)))}}, 
    "g_V_valuesXmapX_isXtypeOfXGType_MAPXX_foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("map", map[interface{}]interface{}{"a": 1 }).AddV("data").Property("map", map[interface{}]interface{}{"b": 2, "c": 3 })}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("map").Is(gremlingo.P.TypeOf(gremlingo.GType.Map)).Fold()}}, 
    "g_V_valueXnameX_aggregateXxX_capXxX_isXtypeOfXGType_SETX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Aggregate("x").Cap("x").Is(gremlingo.P.TypeOf(gremlingo.GType.Set))}}, 
    "g_V_valuesXageX_isXtypeOfXGType_SETXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Is(gremlingo.P.TypeOf(gremlingo.GType.Set))}}, 
    "g_V_valueMap_selectXkeysX_dedup_isXtypeOfXGType_SETXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap().Select(gremlingo.Column.Keys).Dedup().Is(gremlingo.P.TypeOf(gremlingo.GType.Set))}}, 
    "g_V_valuesXsetX_isXtypeOfXGType_SETXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("set", gremlingo.NewSimpleSet("a", "b", "c"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("set").Is(gremlingo.P.TypeOf(gremlingo.GType.Set))}}, 
    "g_V_hasXset_typeOfXGType_SETXX_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("name", "test").Property("set", gremlingo.NewSimpleSet(1, 2, 3))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("set", gremlingo.P.TypeOf(gremlingo.GType.Set)).Values("name")}}, 
    "g_V_valuesXsetX_isXtypeOfXGType_SETXX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("set", gremlingo.NewSimpleSet("x", "y", "z"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("set").Is(gremlingo.P.TypeOf(gremlingo.GType.Set)).Unfold()}}, 
    "g_V_valuesXsetX_isXtypeOfXGType_SETXX_countXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("set", gremlingo.NewSimpleSet(1, 2, 3, 4, 5))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("set").Is(gremlingo.P.TypeOf(gremlingo.GType.Set)).Count(gremlingo.Scope.Local)}}, 
    "g_V_valuesXsetX_isXtypeOfXGType_SETXX_whereXcountXlocalX_isXeqX3XXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("set", gremlingo.NewSimpleSet(1, 2)).AddV("data").Property("set", gremlingo.NewSimpleSet(1, 2, 3))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("set").Is(gremlingo.P.TypeOf(gremlingo.GType.Set)).Where(gremlingo.T__.Count(gremlingo.Scope.Local).Is(gremlingo.P.Eq(3)))}}, 
    "g_V_valuesXsetX_isXtypeOfXGType_SETXX_unfold_limitX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("set", gremlingo.NewSimpleSet("first", "second", "third", "fourth"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("set").Is(gremlingo.P.TypeOf(gremlingo.GType.Set)).Unfold().Limit(2)}}, 
    "g_injectXsetX_isXtypeOfXGType_SETXX_groupCount": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(gremlingo.NewSimpleSet("test")).Is(gremlingo.P.TypeOf(gremlingo.GType.Set)).GroupCount()}}, 
    "g_V_valuesXintX_asNumberXGType_SHORTX_isXtypeOfXGType_SHORTXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("int", 100)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("int").AsNumber(gremlingo.GType.Short).Is(gremlingo.P.TypeOf(gremlingo.GType.Short))}}, 
    "g_V_valuesXintX_asNumberXGType_SHORTX_isXtypeOfXGType_SHORTXX_mathXmulX10XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("int", 50)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("int").AsNumber(gremlingo.GType.Short).Is(gremlingo.P.TypeOf(gremlingo.GType.Short)).Math("_ * 10")}}, 
    "g_V_valuesXintX_asNumberXGType_SHORTX_isXtypeOfXGType_SHORTXX_isXbetweenX20_30XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("int", 25)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("int").AsNumber(gremlingo.GType.Short).Is(gremlingo.P.TypeOf(gremlingo.GType.Short)).Is(gremlingo.P.Between(20, 30))}}, 
    "g_V_valuesXintX_asNumberXGType_SHORTX_isXtypeOfXGType_SHORTXX_minX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("int", 10).AddV("data").Property("int", 20).AddV("data").Property("int", 30)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("int").AsNumber(gremlingo.GType.Short).Is(gremlingo.P.TypeOf(gremlingo.GType.Short)).Min()}}, 
    "g_V_valuesXintX_asNumberXGType_SHORTX_isXtypeOfXGType_SHORTXX_maxX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("int", 15).AddV("data").Property("int", 25).AddV("data").Property("int", 35)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("int").AsNumber(gremlingo.GType.Short).Is(gremlingo.P.TypeOf(gremlingo.GType.Short)).Max()}}, 
    "g_injectX42X_asNumberXGType_SHORTX_isXtypeOfXGType_SHORTXX_storeXaX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(42).AsNumber(gremlingo.GType.Short).Is(gremlingo.P.TypeOf(gremlingo.GType.Short))}}, 
    "g_V_valuesXageX_isXtypeOfXGType_SHORTXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Is(gremlingo.P.TypeOf(gremlingo.GType.Short))}}, 
    "g_V_valuesXuuidX_isXtypeOfXGType_UUIDXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("uuid", uuid.MustParse("f47af10b-58cc-4372-a567-0f02b2f3d479"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("uuid").Is(gremlingo.P.TypeOf(gremlingo.GType.UUID))}}, 
    "g_V_hasXuuid_typeOfXGType_UUIDXX_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("name", "test").Property("uuid", uuid.MustParse("f47af10b-58cc-4372-a567-0f02b2f3d479"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("uuid", gremlingo.P.TypeOf(gremlingo.GType.UUID)).Values("name")}}, 
    "g_V_valuesXuuidX_isXtypeOfXGType_UUIDXX_project_byXidentityX_byXconstantXuuidXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("uuid", uuid.MustParse("f47af10b-58cc-4372-a567-0f02b2f3d479"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("uuid").Is(gremlingo.P.TypeOf(gremlingo.GType.UUID)).Project("original", "type").By(gremlingo.T__.Identity()).By(gremlingo.T__.Constant("uuid"))}}, 
    "g_V_valuesXuuidX_isXtypeOfXGType_UUIDXX_whereXisXeqXuuidXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("uuid", uuid.MustParse("f47af10b-58cc-4372-a567-0f02b2f3d479"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("uuid").Is(gremlingo.P.TypeOf(gremlingo.GType.UUID)).Where(gremlingo.T__.Is(gremlingo.P.Eq(uuid.MustParse("f47af10b-58cc-4372-a567-0f02b2f3d479"))))}}, 
    "g_V_valuesXuuidX_isXtypeOfXGType_UUIDXX_chooseXisXeqXuuidXX_constantXmatchX_constantXnoMatchXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("uuid", uuid.MustParse("f47af10b-58cc-4372-a567-0f02b2f3d479"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("uuid").Is(gremlingo.P.TypeOf(gremlingo.GType.UUID)).Choose(gremlingo.T__.Is(gremlingo.P.Eq(uuid.MustParse("f47af10b-58cc-4372-a567-0f02b2f3d479"))), gremlingo.T__.Constant("match"), gremlingo.T__.Constant("noMatch"))}}, 
    "g_V_valuesXuuidX_isXtypeOfXGType_UUIDXX_localXaggregateXaXX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("uuid", uuid.MustParse("f47af10b-58cc-4372-a567-0f02b2f3d479"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("uuid").Is(gremlingo.P.TypeOf(gremlingo.GType.UUID)).Local(gremlingo.T__.Aggregate("a")).Cap("a")}}, 
    "g_V_valuesXuuidX_isXtypeOfXGType_UUIDXX_aggregateXaX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("data").Property("uuid", uuid.MustParse("f47af10b-58cc-4372-a567-0f02b2f3d479"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("uuid").Is(gremlingo.P.TypeOf(gremlingo.GType.UUID)).Aggregate("a").Cap("a")}}, 
    "g_injectXuuidX_isXtypeOfXGType_UUIDXX_groupCount": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(uuid.MustParse("f47af10b-58cc-4372-a567-0f02b2f3d479")).Is(gremlingo.P.TypeOf(gremlingo.GType.UUID)).GroupCount()}}, 
    "g_injectXUUIDX47af10b_58cc_4372_a567_0f02b2f3d479XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(uuid.MustParse("f47af10b-58cc-4372-a567-0f02b2f3d479"))}}, 
    "g_injectXUUIDXXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(uuid.New())}}, 
    "g_V_aggregateXxX_byXnameX_byXageX_capXxX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate("x").By("name").By("age").Cap("x")}}, 
    "g_V_localXaggregateXxX_byXnameXX_byXageX_capXxX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Local(gremlingo.T__.Aggregate("x").By("name").By("age")).Cap("x")}}, 
    "g_V_valuesXageX_allXgtX32XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").All(gremlingo.P.Gt(32))}}, 
    "g_V_valuesXageX_whereXisXP_gtX33XXX_fold_allXgtX33XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Where(gremlingo.T__.Is(gremlingo.P.Gt(33))).Fold().All(gremlingo.P.Gt(33))}}, 
    "g_V_valuesXageX_order_byXdescX_fold_allXgtX10XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Order().By(gremlingo.Order.Desc).Fold().All(gremlingo.P.Gt(10))}}, 
    "g_V_valuesXageX_order_byXdescX_fold_allXgtX30XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Order().By(gremlingo.Order.Desc).Fold().All(gremlingo.P.Gt(30))}}, 
    "g_injectXabc_bcdX_allXeqXbcdXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{"abc", "bcd"}).All(gremlingo.P.Eq("bcd"))}}, 
    "g_injectXbcd_bcdX_allXeqXbcdXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{"bcd", "bcd"}).All(gremlingo.P.Eq("bcd"))}}, 
    "g_injectXnull_abcX_allXTextP_startingWithXaXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{nil, "abc"}).All(gremlingo.TextP.StartingWith("a"))}}, 
    "g_injectX5_8_10_10_7X_allXgteX7XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{5, 8, 10}, []interface{}{10, 7}).All(gremlingo.P.Gte(7))}}, 
    "g_injectXnullX_allXeqXnullXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(nil).All(gremlingo.P.Eq(nil))}}, 
    "g_injectX7X_allXeqX7XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(7).All(gremlingo.P.Eq(7))}}, 
    "g_injectXnull_nullX_allXeqXnullXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{nil, nil}).All(gremlingo.P.Eq(nil))}}, 
    "g_injectX3_threeX_allXeqX3XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{3, "three"}).All(gremlingo.P.Eq(3))}}, 
    "g_V_andXhasXage_gt_27X__outE_count_gte_2X_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().And(gremlingo.T__.Has("age", gremlingo.P.Gt(27)), gremlingo.T__.OutE().Count().Is(gremlingo.P.Gte(2))).Values("name")}}, 
    "g_V_andXoutE__hasXlabel_personX_and_hasXage_gte_32XX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().And(gremlingo.T__.OutE(), gremlingo.T__.Has(gremlingo.T.Label, "person").And().Has("age", gremlingo.P.Gte(32))).Values("name")}}, 
    "g_V_asXaX_outXknowsX_and_outXcreatedX_inXcreatedX_asXaX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out("knows").And().Out("created").In("created").As("a").Values("name")}}, 
    "g_V_asXaX_andXselectXaX_selectXaXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").And(gremlingo.T__.Select("a"), gremlingo.T__.Select("a"))}}, 
    "g_V_hasXname_markoX_and_hasXname_markoX_and_hasXname_markoX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "marko").And().Has("name", "marko").And().Has("name", "marko")}}, 
    "g_V_valuesXageX_anyXgtX32XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Any(gremlingo.P.Gt(32))}}, 
    "g_V_valuesXageX_order_byXdescX_fold_anyXeqX29XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Order().By(gremlingo.Order.Desc).Fold().Any(gremlingo.P.Eq(29))}}, 
    "g_V_valuesXageX_order_byXdescX_fold_anyXgtX10XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Order().By(gremlingo.Order.Desc).Fold().Any(gremlingo.P.Gt(10))}}, 
    "g_V_valuesXageX_order_byXdescX_fold_anyXgtX42XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Order().By(gremlingo.Order.Desc).Fold().Any(gremlingo.P.Gt(42))}}, 
    "g_injectXabc_cdeX_anyXeqXbcdXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{"abc", "cde"}).Any(gremlingo.P.Eq("bcd"))}}, 
    "g_injectXabc_bcdX_anyXeqXbcdXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{"abc", "bcd"}).Any(gremlingo.P.Eq("bcd"))}}, 
    "g_injectXnull_abcX_anyXTextP_startingWithXaXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{nil, "abc"}).Any(gremlingo.TextP.StartingWith("a"))}}, 
    "g_injectX5_8_10_10_7X_anyXeqX7XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{5, 8, 10}, []interface{}{10, 7}).Any(gremlingo.P.Eq(7))}}, 
    "g_injectXnullX_anyXeqXnullXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(nil).Any(gremlingo.P.Eq(nil))}}, 
    "g_injectX7X_anyXeqX7XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(7).Any(gremlingo.P.Eq(7))}}, 
    "g_injectXnull_nullX_anyXeqXnullXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{nil, nil}).Any(gremlingo.P.Eq(nil))}}, 
    "g_injectX3_threeX_anyXeqX3XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{3, "three"}).Any(gremlingo.P.Eq(3))}}, 
    "g_V_coinX1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Coin(1.0)}}, 
    "g_V_coinX0X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Coin(0.0)}}, 
    "g_withStrategiesXSeedStrategyX_V_order_byXnameX_coinX50X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SeedStrategy(gremlingo.SeedStrategyConfig{Seed: 999999})).V().Order().By("name").Coin(0.5)}}, 
    "g_VX1X_outXcreatedX_inXcreatedX_cyclicPath": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out("created").In("created").CyclicPath()}}, 
    "g_VX1X_both_both_cyclicPath_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Both().Both().CyclicPath().By("age")}}, 
    "g_VX1X_outXcreatedX_inXcreatedX_cyclicPath_path": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out("created").In("created").CyclicPath().Path()}}, 
    "g_VX1X_asXaX_outXcreatedX_asXbX_inXcreatedX_asXcX_cyclicPath_fromXaX_toXbX_path": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).As("a").Out("created").As("b").In("created").As("c").CyclicPath().From("a").To("b").Path()}}, 
    "g_injectX0X_V_both_coalesceXhasXname_markoX_both_constantX0XX_cyclicPath_path": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(0).V().Both().Coalesce(gremlingo.T__.Has("name", "marko").Both(), gremlingo.T__.Constant(0)).CyclicPath().Path()}}, 
    "g_V_out_in_valuesXnameX_fold_dedupXlocalX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().In().Values("name").Fold().Dedup(gremlingo.Scope.Local).Unfold()}}, 
    "g_V_out_in_valuesXnameX_fold_dedupXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Map(gremlingo.T__.In().Values("name").Fold().Dedup(gremlingo.Scope.Local))}}, 
    "g_V_out_asXxX_in_asXyX_selectXx_yX_byXnameX_fold_dedupXlocal_x_yX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().As("x").In().As("y").Select("x", "y").By("name").Fold().Dedup(gremlingo.Scope.Local, "x", "y").Unfold()}}, 
    "g_V_both_dedup_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Both().Dedup().Values("name")}}, 
    "g_V_both_hasXlabel_softwareX_dedup_byXlangX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Both().Has(gremlingo.T.Label, "software").Dedup().By("lang").Values("name")}}, 
    "g_V_both_both_name_dedup": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Both().Both().Values("name").Dedup()}}, 
    "g_V_both_both_dedup": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Both().Both().Dedup()}}, 
    "g_V_both_both_dedup_byXlabelX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Both().Both().Dedup().By(gremlingo.T.Label)}}, 
    "g_V_group_byXlabelX_byXbothE_weight_dedup_foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group().By(gremlingo.T.Label).By(gremlingo.T__.BothE().Values("weight").Dedup().Order().By(gremlingo.Order.Asc).Fold())}}, 
    "g_V_asXaX_both_asXbX_dedupXa_bX_byXlabelX_selectXa_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Both().As("b").Dedup("a", "b").By(gremlingo.T.Label).Select("a", "b")}}, 
    "g_V_asXaX_out_asXbX_in_asXcX_dedupXa_bX_path_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "alice").As("a").AddV("person").Property("name", "bob").As("b").AddV("person").Property("name", "carol").As("c").AddE("knows").From("a").To("b").AddE("likes").From("a").To("b").AddE("likes").From("a").To("c")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("b").In().As("c").Dedup("a", "b").Path().By("name")}}, 
    "g_V_outE_asXeX_inV_asXvX_selectXeX_order_byXweight_ascX_selectXvX_valuesXnameX_dedup": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().OutE().As("e").InV().As("v").Select("e").Order().By("weight", gremlingo.Order.Asc).Select("v").Values("name").Dedup()}}, 
    "g_V_both_both_dedup_byXoutE_countX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Both().Both().Dedup().By(gremlingo.T__.OutE().Count()).Values("name")}}, 
    "g_V_groupCount_selectXvaluesX_unfold_dedup": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().GroupCount().Select(gremlingo.Column.Values).Unfold().Dedup()}}, 
    "g_V_asXaX_repeatXbothX_timesX3X_emit_name_asXbX_group_byXselectXaXX_byXselectXbX_dedup_order_foldX_selectXvaluesX_unfold_dedup": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Repeat(gremlingo.T__.Both()).Times(3).Emit().Values("name").As("b").Group().By(gremlingo.T__.Select("a")).By(gremlingo.T__.Select("b").Dedup().Order().Fold()).Select(gremlingo.Column.Values).Unfold().Dedup()}}, 
    "g_V_repeatXdedupX_timesX2X_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Dedup()).Times(2).Count()}}, 
    "g_V_both_group_by_byXout_dedup_foldX_unfold_selectXvaluesX_unfold_out_order_byXnameX_limitX1X_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Both().Group().By().By(gremlingo.T__.Out().Dedup().Fold()).Unfold().Select(gremlingo.Column.Values).Unfold().Out().Order().By("name").Limit(1).Values("name")}}, 
    "g_V_bothE_properties_dedup_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().BothE().Properties().Dedup().Count()}}, 
    "g_V_both_properties_dedup_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Both().Properties().Dedup().Count()}}, 
    "g_V_both_properties_properties_dedup_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Both().Properties().Properties().Dedup().Count()}}, 
    "g_V_order_byXname_descX_barrier_dedup_age_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Order().By("name", gremlingo.Order.Desc).Barrier().Dedup().By("age").Values("name")}}, 
    "g_withStrategiesXProductiveByStrategyX_V_order_byXname_descX_barrier_dedup_age_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy()).V().Order().By("name", gremlingo.Order.Desc).Barrier().Dedup().By("age").Values("name")}}, 
    "g_V_both_dedup_age_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Both().Dedup().By("age").Values("name")}}, 
    "g_VX1X_asXaX_both_asXbX_both_asXcX_dedupXa_bX_age_selectXa_b_cX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).As("a").Both().As("b").Both().As("c").Dedup("a", "b").By("age").Select("a", "b", "c").By("name")}}, 
    "g_VX1X_valuesXageX_dedupXlocalX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Values("age").Dedup(gremlingo.Scope.Local).Unfold()}}, 
    "g_V_properties_dedup_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "josh").AddV("person").Property("name", "josh").AddV("person").Property("name", "josh")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties("name").Dedup().Count()}}, 
    "g_V_properties_dedup_byXvalueX_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "josh").AddV("person").Property("name", "josh").AddV("person").Property("name", "josh")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties("name").Dedup().By(gremlingo.T.Value).Count()}}, 
    "g_V_both_hasXlabel_softwareX_dedup_byXlangX_byXnameX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Both().Has(gremlingo.T.Label, "software").Dedup().By("lang").By("name").Values("name")}}, 
    "g_V_count_discard": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Count().Discard()}}, 
    "g_V_hasLabelXpersonX_discard": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Discard()}}, 
    "g_VX1X_outXcreatedX_discard": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out("created").Discard()}}, 
    "g_V_discard": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Discard()}}, 
    "g_V_discard_discard": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Discard().Discard()}}, 
    "g_V_discard_fold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Discard().Fold()}}, 
    "g_V_discard_fold_discard": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Discard().Fold().Discard()}}, 
    "g_V_discard_fold_constantX1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Discard().Fold().Constant(1)}}, 
    "g_V_projectXxX_byXcoalesceXage_isXgtX29XX_discardXX_selectXxX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Project("x").By(gremlingo.T__.Coalesce(gremlingo.T__.Values("age").Is(gremlingo.P.Gt(29)), gremlingo.T__.Discard())).Select("x")}}, 
    "g_V_drop": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV().As("a").AddV().As("b").AddE("knows").To("a")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Drop()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}}, 
    "g_V_outE_drop": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV().As("a").AddV().As("b").AddE("knows").To("a")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().OutE().Drop()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}}, 
    "g_V_properties_drop": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV().Property("name", "bob").AddV().Property("name", "alice")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties().Drop()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties()}}, 
    "g_E_propertiesXweightX_drop": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Properties("weight").Drop()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Properties()}}, 
    "g_V_properties_propertiesXstartTimeX_drop": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV().Property("name", "bob").Property(gremlingo.Cardinality.List, "location", "ny", "startTime", 2014, "endTime", 2016).Property(gremlingo.Cardinality.List, "location", "va", "startTime", 2016).AddV().Property("name", "alice").Property(gremlingo.Cardinality.List, "location", "va", "startTime", 2014, "endTime", 2016).Property(gremlingo.Cardinality.List, "location", "ny", "startTime", 2016)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties().Properties("startTime").Drop()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties().Properties()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties().Properties("startTime")}}, 
    "g_V_filterXisX0XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Filter(gremlingo.T__.Is(0))}}, 
    "g_V_filterXconstantX0XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Filter(gremlingo.T__.Constant(0))}}, 
    "g_V_filterXhasXlang_javaXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Filter(gremlingo.T__.Has("lang", "java"))}}, 
    "g_VX1X_filterXhasXage_gtX30XXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Filter(gremlingo.T__.Has("age", gremlingo.P.Gt(30)))}}, 
    "g_VX2X_filterXhasXage_gtX30XXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid2"]).Filter(gremlingo.T__.Has("age", gremlingo.P.Gt(30)))}}, 
    "g_VX1X_out_filterXhasXage_gtX30XXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out().Filter(gremlingo.T__.Has("age", gremlingo.P.Gt(30)))}}, 
    "g_V_filterXhasXname_startingWithXm_or_pXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Filter(gremlingo.T__.Has("name", gremlingo.TextP.StartingWith("m").Or(gremlingo.TextP.StartingWith("p"))))}}, 
    "g_E_filterXisX0XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Filter(gremlingo.T__.Is(0))}}, 
    "g_E_filterXconstantX0XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Filter(gremlingo.T__.Constant(0))}}, 
    "g_VX1X_hasXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Has("name")}}, 
    "g_VX1X_hasXcircumferenceX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Has("circumference")}}, 
    "g_VX1X_hasXname_markoX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Has("name", "marko")}}, 
    "g_VX1X_hasXname_markovarX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Has("name", p["xx1"])}}, 
    "g_VX2X_hasXname_markoX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Has("name", "marko")}}, 
    "g_V_hasXname_markoX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "marko")}}, 
    "g_V_hasXname_blahX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "blah")}}, 
    "g_V_hasXage_gt_30X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("age", gremlingo.P.Gt(30))}}, 
    "g_VX1X_hasXage_gt_30X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Has("age", gremlingo.P.Gt(30))}}, 
    "g_V_hasXpersonvar_age_gt_30X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has(p["xx1"], "age", gremlingo.P.Gt(30))}}, 
    "g_VX4X_hasXage_gt_30X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).Has("age", gremlingo.P.Gt(30))}}, 
    "g_VXv1X_hasXage_gt_30X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Has("age", gremlingo.P.Gt(30))}}, 
    "g_VXv4X_hasXage_gt_30X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).Has("age", gremlingo.P.Gt(30))}}, 
    "g_VX1X_out_hasXid_2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid2"]).Has("age", gremlingo.P.Gt(30))}}, 
    "g_V_hasXblahX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("blah")}}, 
    "g_V_hasXperson_name_markoX_age": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Values("age")}}, 
    "g_V_hasXperson_name_markovarX_age": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", p["xx1"]).Values("age")}}, 
    "g_V_hasXpersonvar_name_markoX_age": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has(p["xx1"], "name", "marko").Values("age")}}, 
    "g_VX1X_outE_hasXweight_inside_0_06X_inV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE().Has("weight", gremlingo.P.Inside(0.0, 0.6)).InV()}}, 
    "g_EX11X_outV_outE_hasXid_10X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E(p["eid11"]).OutV().OutE().Has(gremlingo.T.Id, p["eid10"])}}, 
    "g_EX11X_outV_outE_hasXid_10AsStringX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E(p["eid11"]).OutV().OutE().Has(gremlingo.T.Id, p["eid10"])}}, 
    "g_V_hasXlocationX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("location")}}, 
    "g_V_hasXage_withinX27X_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("age", gremlingo.P.Within(27)).Count()}}, 
    "g_V_hasXage_withinX27_nullX_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("age", gremlingo.P.Within(27, nil)).Count()}}, 
    "g_V_hasXage_withinX27_29X_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("age", gremlingo.P.Within(27, 29)).Count()}}, 
    "g_V_hasXage_withoutX27X_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("age", gremlingo.P.Without(27)).Count()}}, 
    "g_V_hasXage_withoutX27_29X_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("age", gremlingo.P.Without(27, 29)).Count()}}, 
    "g_V_hasXperson_age_withinX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "age", gremlingo.P.Within())}}, 
    "g_V_hasXperson_age_withoutX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "age", gremlingo.P.Without())}}, 
    "g_V_hasXname_containingXarkXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", gremlingo.TextP.Containing("ark"))}}, 
    "g_V_hasXname_startingWithXmarXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", gremlingo.TextP.StartingWith("mar"))}}, 
    "g_V_hasXname_endingWithXasXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", gremlingo.TextP.EndingWith("as"))}}, 
    "g_V_hasXperson_name_containingXoX_andXltXmXXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", gremlingo.TextP.Containing("o").And(gremlingo.P.Lt("m")))}}, 
    "g_V_hasXname_gtXmX_andXcontainingXoXXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", gremlingo.P.Gt("m").And(gremlingo.TextP.Containing("o")))}}, 
    "g_V_hasXname_not_containingXarkXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", gremlingo.TextP.NotContaining("ark"))}}, 
    "g_V_hasXname_not_startingWithXmarXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", gremlingo.TextP.NotStartingWith("mar"))}}, 
    "g_V_hasXname_not_endingWithXasXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", gremlingo.TextP.NotEndingWith("as"))}}, 
    "g_V_hasXname_regexXrMarXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", gremlingo.TextP.Regex("^mar"))}}, 
    "g_V_hasXname_notRegexXrMarXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", gremlingo.TextP.NotRegex("^mar"))}}, 
    "g_V_hasXname_regexXTinkerXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("software").Property("name", "Apache TinkerPop©")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", gremlingo.TextP.Regex("Tinker")).Values("name")}}, 
    "g_V_hasXname_regexXTinkerUnicodeXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("software").Property("name", "Apache TinkerPop©")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", gremlingo.TextP.Regex("Tinker.*\u00A9")).Values("name")}}, 
    "g_V_hasXp_neqXvXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("p", gremlingo.P.Neq("v"))}}, 
    "g_V_hasXage_gtX18X_andXltX30XXorXgtx35XXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("age", gremlingo.P.Gt(18).And(gremlingo.P.Lt(30)).Or(gremlingo.P.Gt(35)))}}, 
    "g_V_hasXage_gtX18X_andXltX30XXorXltx35XXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("age", gremlingo.P.Gt(18).And(gremlingo.P.Lt(30)).And(gremlingo.P.Lt(35)))}}, 
    "g_V_hasXk_withinXcXX_valuesXkX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV().Property("k", "轉注").AddV().Property("k", "✦").AddV().Property("k", "♠").AddV().Property("k", "A")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("k", gremlingo.P.Within("轉注", "✦", "♠")).Values("k")}}, 
    "g_V_hasXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has(nil)}}, 
    "g_V_hasXnull_testnullkeyX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has(nil, "test-null-key")}}, 
    "g_E_hasXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Has(nil)}}, 
    "g_V_hasXlabel_personX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has(gremlingo.T.Label, "person")}}, 
    "g_V_hasXlabel_eqXpersonXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has(gremlingo.T.Label, gremlingo.P.Eq("person"))}}, 
    "g_V_hasXname_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", nil)}}, 
    "g_V_hasIdXemptyX_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasId(p["xx1"]).Count()}}, 
    "g_V_hasIdXwithinXemptyXX_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasId(gremlingo.P.Within([]interface{}{})).Count()}}, 
    "g_V_hasIdXwithoutXemptyXX_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasId(gremlingo.P.Without([]interface{}{})).Count()}}, 
    "g_V_notXhasIdXwithinXemptyXXX_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Not(gremlingo.T__.HasId(gremlingo.P.Within([]interface{}{}))).Count()}}, 
    "g_V_hasIdXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasId(nil)}}, 
    "g_V_hasIdXeqXnullXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasId(gremlingo.P.Eq(nil))}}, 
    "g_V_hasIdX2_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasId(p["vid2"], nil)}}, 
    "g_V_hasIdXmarkovar_vadasvarX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasId(p["vid1"], p["vid2"])}}, 
    "g_V_hasIdX2AsString_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasId(p["vid2"], nil)}}, 
    "g_V_hasIdX1AsString_2AsString_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasId(p["vid1"], p["vid2"], nil)}}, 
    "g_V_hasIdXnull_2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasId(nil, p["vid2"])}}, 
    "g_V_hasIdX1X_hasIdX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasId(p["vid1"]).HasId(p["vid2"])}}, 
    "g_V_in_hasIdXneqX1XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().In().HasId(gremlingo.P.Neq(p["xx1"]))}}, 
    "g_VX1X_out_hasIdX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out().HasId(p["vid2"])}}, 
    "g_VX1X_out_hasXid_2_3X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out().HasId(p["vid2"], p["vid3"])}}, 
    "g_VX1X_out_hasXid_2AsString_3AsStringX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out().HasId(p["vid2"], p["vid3"])}}, 
    "g_VX1AsStringX_out_hasXid_2AsStringX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out().HasId(p["vid2"])}}, 
    "g_VX1X_out_hasXid_2_3X_inList": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out().HasId(p["xx1"])}}, 
    "g_V_hasXid_1_2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasId(p["vid1"], p["vid2"])}}, 
    "g_V_hasXid_1_2X_inList": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasId(p["xx1"])}}, 
    "g_V_both_dedup_properties_hasKeyXageX_value": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Both().Properties().Dedup().HasKey("age").Value()}}, 
    "g_V_both_properties_dedup_hasKeyXageX_hasValueXgtX30XX_value": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Both().Properties().Dedup().HasKey("age").HasValue(gremlingo.P.Gt(30)).Value()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Both().Properties().Dedup().HasKey("age").HasValue(gremlingo.P.Gt(30)).Value()}}, 
    "g_V_bothE_properties_dedup_hasKeyXweightX_value": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().BothE().Properties().Dedup().HasKey("weight").Value()}}, 
    "g_V_bothE_properties_dedup_hasKeyXweightX_hasValueXltX0d3XX_value": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().BothE().Properties().Dedup().HasKey("weight").HasValue(gremlingo.P.Lt(0.3)).Value()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().BothE().Properties().Dedup().HasKey("weight").HasValue(gremlingo.P.Lt(0.3)).Value()}}, 
    "g_V_properties_hasKeyXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties().HasKey(nil)}}, 
    "g_V_properties_hasKeyXnull_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties().HasKey(nil, nil)}}, 
    "g_V_properties_hasKeyXnull_ageX_value": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties().HasKey(nil, "age").Value()}}, 
    "g_E_properties_hasKeyXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Properties().HasKey(nil)}}, 
    "g_E_properties_hasKeyXnull_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Properties().HasKey(nil, nil)}}, 
    "g_E_properties_hasKeyXnull_weightX_value": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Properties().HasKey(nil, "weight").Value()}}, 
    "g_EX7X_hasLabelXknowsX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E(p["eid7"]).HasLabel("knows")}}, 
    "g_E_hasLabelXknowsX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows")}}, 
    "g_E_hasLabelXuses_traversesX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("uses", "traverses")}}, 
    "g_V_hasLabelXperson_software_blahX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person", "software", "blah")}}, 
    "g_V_hasLabelXperson_softwarevarX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person", p["xx1"])}}, 
    "g_V_hasLabelXpersonX_hasLabelXsoftwareX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").HasLabel("software")}}, 
    "g_V_hasLabelXpersonvarX_hasLabelXsoftwareX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel(p["xx1"]).HasLabel("software")}}, 
    "g_V_hasLabelXpersonvar_softwarevarX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel(p["xx1"], p["xx2"])}}, 
    "g_V_hasLabelXpersonX_hasXage_notXlteX10X_andXnotXbetweenX11_20XXXX_andXltX29X_orXeqX35XXXX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Has("age", gremlingo.P.Not(gremlingo.P.Lte(10).And(gremlingo.P.Not(gremlingo.P.Between(11, 20)))).And(gremlingo.P.Lt(29).Or(gremlingo.P.Eq(35)))).Values("name")}}, 
    "g_V_hasLabelXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel(nil)}}, 
    "g_V_hasXlabel_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has(gremlingo.T.Label, nil)}}, 
    "g_V_hasLabelXnull_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel(nil, nil)}}, 
    "g_V_hasLabelXnull_personX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel(nil, "person")}}, 
    "g_E_hasLabelXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel(nil)}}, 
    "g_E_hasXlabel_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Has(gremlingo.T.Label, nil)}}, 
    "g_V_properties_hasLabelXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties().HasLabel(nil)}}, 
    "g_V_hasNotXageX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasNot("age").Values("name")}}, 
    "g_V_properties_hasValueXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties().HasValue(nil)}}, 
    "g_V_properties_hasValueXnull_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties().HasValue(nil, nil)}}, 
    "g_V_properties_hasValueXnull_joshX_value": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties().HasValue(nil, "josh").Value()}}, 
    "g_V_valuesXageX_isX32X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Is(32)}}, 
    "g_V_valuesXageX_isX32varX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Is(p["xx1"])}}, 
    "g_V_valuesXageX_isXlte_30X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Is(gremlingo.P.Lte(30))}}, 
    "g_V_valuesXageX_isXlte_30varX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Is(gremlingo.P.Lte(p["xx1"]))}}, 
    "g_V_valuesXageX_isXgte_29X_isXlt_34X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Is(gremlingo.P.Gte(29)).Is(gremlingo.P.Lt(34))}}, 
    "g_V_valuesXageX_isXgte_29vaarX_isXlt_34varX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Is(gremlingo.P.Gte(p["xx1"])).Is(gremlingo.P.Lt(p["xx2"]))}}, 
    "g_V_whereXinXcreatedX_count_isX1XX_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Where(gremlingo.T__.In("created").Count().Is(1)).Values("name")}}, 
    "g_V_whereXinXcreatedX_count_isXgte_2XX_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Where(gremlingo.T__.In("created").Count().Is(gremlingo.P.Gte(2))).Values("name")}}, 
    "g_V_valuesXageX_noneXgtX32XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").None(gremlingo.P.Gt(32))}}, 
    "g_V_valuesXageX_whereXisXP_gtX33XXX_fold_noneXlteX33XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Where(gremlingo.T__.Is(gremlingo.P.Gt(33))).Fold().None(gremlingo.P.Lte(33))}}, 
    "g_V_valuesXageX_order_byXdescX_fold_noneXltX10XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Order().By(gremlingo.Order.Desc).Fold().None(gremlingo.P.Lt(10))}}, 
    "g_V_valuesXageX_order_byXdescX_fold_noneXgtX30XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Order().By(gremlingo.Order.Desc).Fold().None(gremlingo.P.Gt(30))}}, 
    "g_injectXabc_bcdX_noneXeqXbcdXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{"abc", "bcd"}).None(gremlingo.P.Eq("bcd"))}}, 
    "g_injectXbcd_bcdX_noneXeqXabcXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{"bcd", "bcd"}).None(gremlingo.P.Eq("abc"))}}, 
    "g_injectXnull_bcdX_noneXP_eqXabcXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{nil, "bcd"}).None(gremlingo.P.Eq("abc"))}}, 
    "g_injectX5_8_10_10_7X_noneXltX7XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{5, 8, 10}, []interface{}{10, 7}).None(gremlingo.P.Lt(7))}}, 
    "g_injectXnullX_noneXeqXnullXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(nil).None(gremlingo.P.Eq(nil))}}, 
    "g_injectX7X_noneXeqX7XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(7).None(gremlingo.P.Eq(7))}}, 
    "g_injectXnull_1_emptyX_noneXeqXnullXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{nil, 1}, []interface{}{}).None(gremlingo.P.Eq(nil))}}, 
    "g_injectXnull_nullX_noneXnotXnullXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{nil, nil}).None(gremlingo.P.Neq(nil))}}, 
    "g_injectX3_threeX_noneXeqX3XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{int32(3), "three"}).None(gremlingo.P.Eq(3))}}, 
    "g_V_notXhasXage_gt_27XX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Not(gremlingo.T__.Has("age", gremlingo.P.Gt(27))).Values("name")}}, 
    "g_V_notXnotXhasXage_gt_27XXX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Not(gremlingo.T__.Not(gremlingo.T__.Has("age", gremlingo.P.Gt(27)))).Values("name")}}, 
    "g_V_notXhasXname_gt_27XX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Not(gremlingo.T__.Has("name", gremlingo.P.Gt(27))).Values("name")}}, 
    "g_V_orXhasXage_gt_27X__outE_count_gte_2X_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Or(gremlingo.T__.Has("age", gremlingo.P.Gt(27)), gremlingo.T__.OutE().Count().Is(gremlingo.P.Gte(2))).Values("name")}}, 
    "g_V_orXoutEXknowsX__hasXlabel_softwareX_or_hasXage_gte_35XX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Or(gremlingo.T__.OutE("knows"), gremlingo.T__.Has(gremlingo.T.Label, "software").Or().Has("age", gremlingo.P.Gte(35))).Values("name")}}, 
    "g_V_asXaX_orXselectXaX_selectXaXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Or(gremlingo.T__.Select("a"), gremlingo.T__.Select("a"))}}, 
    "g_VX1X_out_limitX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out().Limit(2)}}, 
    "g_VX1X_out_limitX2varX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out().Limit(p["xx1"])}}, 
    "g_V_localXoutE_limitX1X_inVX_limitX3X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Local(gremlingo.T__.OutE().Limit(1)).InV().Limit(3)}}, 
    "g_VX1X_outXknowsX_outEXcreatedX_rangeX0_1X_inV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out("knows").OutE("created").Range(0, 1).InV()}}, 
    "g_VX1X_outXknowsX_outXcreatedX_rangeX0_1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out("knows").Out("created").Range(0, 1)}}, 
    "g_VX1X_outXcreatedX_inXcreatedX_rangeX1_3X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out("created").In("created").Range(1, 3)}}, 
    "g_VX1X_outXcreatedX_inXcreatedX_rangeX1var_3varX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out("created").In("created").Range(p["xx1"], p["xx2"])}}, 
    "g_VX1X_outXcreatedX_inEXcreatedX_rangeX1_3X_outV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out("created").InE("created").Range(1, 3).OutV()}}, 
    "g_V_repeatXbothX_timesX3X_rangeX5_11X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Both()).Times(3).Range(5, 11)}}, 
    "g_V_asXaX_in_asXbX_in_asXcX_selectXa_b_cX_byXnameX_limitXlocal_2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").In().As("b").In().As("c").Select("a", "b", "c").By("name").Limit(gremlingo.Scope.Local, 2)}}, 
    "g_V_asXaX_in_asXbX_in_asXcX_selectXa_b_cX_byXnameX_limitXlocal_2varX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").In().As("b").In().As("c").Select("a", "b", "c").By("name").Limit(gremlingo.Scope.Local, p["xx1"])}}, 
    "g_V_asXaX_in_asXbX_in_asXcX_selectXa_b_cX_byXnameX_limitXlocal_1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").In().As("b").In().As("c").Select("a", "b", "c").By("name").Limit(gremlingo.Scope.Local, 1)}}, 
    "g_V_asXaX_out_asXbX_out_asXcX_selectXa_b_cX_byXnameX_rangeXlocal_1_3X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("b").Out().As("c").Select("a", "b", "c").By("name").Range(gremlingo.Scope.Local, 1, 3)}}, 
    "g_V_asXaX_out_asXbX_out_asXcX_selectXa_b_cX_byXnameX_rangeXlocal_1var_3varX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("b").Out().As("c").Select("a", "b", "c").By("name").Range(gremlingo.Scope.Local, p["xx1"], p["xx2"])}}, 
    "g_V_asXaX_out_asXbX_out_asXcX_selectXa_b_cX_byXnameX_rangeXlocal_1_2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("b").Out().As("c").Select("a", "b", "c").By("name").Range(gremlingo.Scope.Local, 1, 2)}}, 
    "g_V_hasLabelXpersonX_order_byXageX_skipX1X_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Order().By("age").Skip(1).Values("name")}}, 
    "g_V_hasLabelXpersonX_order_byXageX_skipX1varX_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Order().By("age").Skip(p["xx1"]).Values("name")}}, 
    "g_V_foldX_rangeXlocal_6_7X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Fold().Range(gremlingo.Scope.Local, 6, 7)}}, 
    "g_V_outE_valuesXweightX_fold_orderXlocalX_skipXlocal_2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().OutE().Values("weight").Fold().Order(gremlingo.Scope.Local).Skip(gremlingo.Scope.Local, 2)}}, 
    "g_V_outE_valuesXweightX_fold_orderXlocalX_skipXlocal_2varX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().OutE().Values("weight").Fold().Order(gremlingo.Scope.Local).Skip(gremlingo.Scope.Local, p["xx1"])}}, 
    "g_V_hasLabelXpersonX_order_byXageX_valuesXnameX_skipX1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Order().By("age").Values("name").Skip(1)}}, 
    "g_VX1X_valuesXageX_rangeXlocal_20_30X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Values("age").Range(gremlingo.Scope.Local, 20, 30)}}, 
    "g_V_mapXin_hasIdX1XX_limitX2X_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Map(gremlingo.T__.In().HasId(p["vid1"])).Limit(2).Values("name")}}, 
    "g_V_rangeX2_1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Range(2, 1)}}, 
    "g_V_rangeX3_2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Range(3, 2)}}, 
    "g_injectXlistX1_2_3XX_rangeXlocal_1_2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{1, 2, 3}).Range(gremlingo.Scope.Local, 1, 2)}}, 
    "g_injectXlistX1_2_3XX_limitXlocal_1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{1, 2, 3}).Limit(gremlingo.Scope.Local, 1)}}, 
    "g_injectXlistX1_2_3X_limitXlocal_1X_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{1, 2, 3}).Limit(gremlingo.Scope.Local, 1).Unfold()}}, 
    "g_injectX1_2_3_4_5X_limitXlocal_1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{1, 2}, []interface{}{3, 4, 5}).Limit(gremlingo.Scope.Local, 1)}}, 
    "g_injectX1_2_3_4_5_6X_rangeXlocal_1_2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{1, 2, 3}, []interface{}{4, 5, 6}).Range(gremlingo.Scope.Local, 1, 2)}}, 
    "g_VX5X_repeatXlimitX1X_inX_timesX2X_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid5"]).Repeat(gremlingo.T__.Limit(1).In()).Times(2).Values("name")}}, 
    "g_VX5X_repeatXlimitX1X_inX_untilXloopsXisX2XXX_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid5"]).Repeat(gremlingo.T__.Limit(1).In()).Until(gremlingo.T__.Loops().Is(2)).Values("name")}}, 
    "g_VX5X_limitX1X_in_limitX1X_in_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid5"]).Limit(1).In().Limit(1).In().Values("name")}}, 
    "g_VX5X_repeatXlimitX1X_inX_timesX1X_repeatXlimitX1X_inX_timesX1X_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid5"]).Repeat(gremlingo.T__.Limit(1).In()).Times(1).Repeat(gremlingo.T__.Limit(1).In()).Times(1).Values("name")}}, 
    "g_VX5X_repeatXlimitX1X_in_aggregateXxXX_timesX2X_capXxX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid5"]).Repeat(gremlingo.T__.Limit(1).In().Aggregate("x")).Times(2).Cap("x")}}, 
    "g_VX5X_repeatXrangeX0_1X_inX_timesX2X_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid5"]).Repeat(gremlingo.T__.Range(0, 1).In()).Times(2).Values("name")}}, 
    "g_VX5X_repeatXrangeX0_1X_inX_untilXloopsXisX2XXX_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid5"]).Repeat(gremlingo.T__.Range(0, 1).In()).Until(gremlingo.T__.Loops().Is(2)).Values("name")}}, 
    "g_VX5X_rangeX0_1X_in_rangeX0_1X_in_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid5"]).Range(0, 1).In().Range(0, 1).In().Values("name")}}, 
    "g_VX5X_repeatXrangeX0_1X_in_repeatXrangeX0_1X_inX_timesX1XX_timesX1X_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid5"]).Repeat(gremlingo.T__.Range(0, 1).In().Repeat(gremlingo.T__.Range(0, 1).In()).Times(1)).Times(1).Values("name")}}, 
    "g_VX5X_repeatXrangeX0_1X_in_aggregateXxXX_timesX2X_capXxX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid5"]).Repeat(gremlingo.T__.Range(0, 1).In().Aggregate("x")).Times(2).Cap("x")}}, 
    "g_withoutStrategiesXEarlyLimitStrategyX_VX5X_repeatXlimitX1X_in_limitX1X_limitX1XX_timesX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithoutStrategies(gremlingo.EarlyLimitStrategy()).V(p["vid5"]).Repeat(gremlingo.T__.Limit(1).In().Limit(1).Limit(1)).Times(2)}}, 
    "g_V_repeatXout_whereXhasXnameX_order_byXnameX_limitX1XXX_timesX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Out().Where(gremlingo.T__.Has("name").Order().By("name").Limit(1))).Times(2)}}, 
    "g_V_out_whereXhasXnameX_order_byXnameX_limitX1XX_out_whereXhasXnameX_order_byXnameX_limitX1XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Where(gremlingo.T__.Has("name").Order().By("name").Limit(1)).Out().Where(gremlingo.T__.Has("name").Order().By("name").Limit(1))}}, 
    "g_V_hasXnameXJAMXX_repeatXoutXfollowedByX_order_byXnameX_limitX2XX_timesX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "JAM").Repeat(gremlingo.T__.Out("followedBy").Order().By("name").Limit(2)).Times(2)}}, 
    "g_V_hasXnameXJAMXX_outXfollowedByX_order_byXnameX_limitX2X_outXfollowedByX_order_byXnameX_limitX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "JAM").Out("followedBy").Order().By("name").Limit(2).Out("followedBy").Order().By("name").Limit(2)}}, 
    "g_V_hasXnameXDRUMSXX_repeatXinXfollowedByX_order_byXnameX_rangeX1_4XX_timesX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "DRUMS").Repeat(gremlingo.T__.In("followedBy").Order().By("name").Range(1, 4)).Times(2)}}, 
    "g_V_hasXnameXDRUMSXX_inXfollowedByX_order_byXnameX_rangeX1_4X_inXfollowedByX_order_byXnameX_rangeX1_4X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "DRUMS").In("followedBy").Order().By("name").Range(1, 4).In("followedBy").Order().By("name").Range(1, 4)}}, 
    "g_V_chooseXvaluesXageX_isXlteX30XX_out_order_byXnameX_limitX1X_out_order_byXnameX_limitX2XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Choose(gremlingo.T__.Values("age").Is(gremlingo.P.Lte(30)), gremlingo.T__.Out().Order().By("name").Limit(1), gremlingo.T__.Out().Order().By("name").Limit(2))}}, 
    "g_V_chooseXvaluesXageX_isXlteX30XX_localXout_order_byXnameX_limitX1XX_localXout_order_byXnameX_limitX2XXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Choose(gremlingo.T__.Values("age").Is(gremlingo.P.Lte(30)), gremlingo.T__.Local(gremlingo.T__.Out().Order().By("name").Limit(1)), gremlingo.T__.Local(gremlingo.T__.Out().Order().By("name").Limit(2)))}}, 
    "g_V_hasXnameXHEY_BO_DIDDLEYXX_unionXoutXfollowedByX_order_byXnameX_limitX2X_outXsungByX_order_byXnameX_byXnameX_limitX1XX_unionXoutXfollowedByX_order_limitX2X_outXsungByX_order_byXnameX_limitX1XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "HEY BO DIDDLEY").Union(gremlingo.T__.Out("followedBy").Order().By("name").Limit(2), gremlingo.T__.Out("sungBy").Order().By("name").Limit(1)).Union(gremlingo.T__.Out("followedBy").Order().By("name").Limit(2), gremlingo.T__.Out("sungBy").Order().By("name").Limit(1))}}, 
    "g_V_hasXnameXHEY_BO_DIDDLEYXX_repeatXunionXoutXfollowedByX_order_byXnameX_limitX2X_outXsungByX_order_byXnameX_limitX1XXX_timesX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "HEY BO DIDDLEY").Repeat(gremlingo.T__.Union(gremlingo.T__.Out("followedBy").Order().By("name").Limit(2), gremlingo.T__.Out("sungBy").Order().By("name").Limit(1))).Times(2)}}, 
    "g_V_sampleX1X_byXageX_byXT_idX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Sample(1).By("age").By(gremlingo.T.Id)}}, 
    "g_E_sampleX1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Sample(1)}}, 
    "g_E_sampleX2X_byXweightX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Sample(2).By("weight")}}, 
    "g_V_localXoutE_sampleX1X_byXweightXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Local(gremlingo.T__.OutE().Sample(1).By("weight"))}}, 
    "g_withStrategiesXSeedStrategyX_V_group_byXlabelX_byXbothE_weight_order_sampleX2X_foldXunfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SeedStrategy(gremlingo.SeedStrategyConfig{Seed: 999999})).V().Group().By(gremlingo.T.Label).By(gremlingo.T__.BothE().Values("weight").Order().Sample(2).Fold()).Unfold()}}, 
    "g_withStrategiesXSeedStrategyX_V_group_byXlabelX_byXbothE_weight_order_fold_sampleXlocal_5XXunfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SeedStrategy(gremlingo.SeedStrategyConfig{Seed: 999999})).V().Group().By(gremlingo.T.Label).By(gremlingo.T__.BothE().Values("weight").Order().Fold().Sample(gremlingo.Scope.Local, 5)).Unfold()}}, 
    "g_withStrategiesXSeedStrategyX_V_order_byXlabel_descX_sampleX1X_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SeedStrategy(gremlingo.SeedStrategyConfig{Seed: 999999})).V().Order().By(gremlingo.T.Label, gremlingo.Order.Desc).Sample(1).By("age")}}, 
    "g_VX1X_valuesXageX_sampleXlocal_5X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Values("age").Sample(gremlingo.Scope.Local, 5)}}, 
    "g_V_repeatXsampleX2XX_timesX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Sample(2)).Times(2)}}, 
    "g_V_sampleX2X_sampleX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Sample(2).Sample(2)}}, 
    "g_V3_repeatXout_order_byXperformancesX_sampleX2X_aggregateXxXX_untilXloops_isX2XX_capXxX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid3"]).Repeat(gremlingo.T__.Out().Order().By("performances").Sample(2).Aggregate("x")).Until(gremlingo.T__.Loops().Is(2)).Cap("x").Unfold()}}, 
    "g_V3_out_order_byXperformancesX_sampleX2X_aggregateXxX_out_order_byXperformancesX_sampleX2X_aggregateXxX_capXxX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid3"]).Out().Order().By("performances").Sample(2).Aggregate("x").Out().Order().By("performances").Sample(2).Aggregate("x").Cap("x").Unfold()}}, 
    "g_VX1X_outXcreatedX_inXcreatedX_simplePath": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out("created").In("created").SimplePath()}}, 
    "g_V_repeatXboth_simplePathX_timesX3X_path": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Both().SimplePath()).Times(3).Path()}}, 
    "g_V_asXaX_out_asXbX_out_asXcX_simplePath_byXlabelX_fromXbX_toXcX_path_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("b").Out().As("c").SimplePath().By(gremlingo.T.Label).From("b").To("c").Path().By("name")}}, 
    "g_injectX0X_V_both_coalesceXhasXname_markoX_both_constantX0XX_simplePath_path": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(0).V().Both().Coalesce(gremlingo.T__.Has("name", "marko").Both(), gremlingo.T__.Constant(0)).SimplePath().Path()}}, 
    "g_V_both_asXaX_both_asXbX_simplePath_path_byXageX__fromXaX_toXbX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Both().As("a").Both().As("b").SimplePath().Path().By("age").From("a").To("b")}}, 
    "g_V_valuesXnameX_order_tailXglobal_2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Order().Tail(gremlingo.Scope.Global, 2)}}, 
    "g_V_valuesXnameX_order_tailX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Order().Tail(2)}}, 
    "g_V_valuesXnameX_order_tailX2varX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Order().Tail(p["xx1"])}}, 
    "g_V_valuesXnameX_order_tail": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Order().Tail()}}, 
    "g_V_valuesXnameX_order_tailX7X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Order().Tail(7)}}, 
    "g_V_repeatXbothX_timesX3X_tailX7X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Both()).Times(3).Tail(7)}}, 
    "g_V_repeatXin_outX_timesX3X_tailX7X_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.In().Out()).Times(3).Tail(7).Count()}}, 
    "g_V_asXaX_out_asXaX_out_asXaX_selectXaX_byXunfold_valuesXnameX_foldX_tailXlocal_1X_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("a").Out().As("a").Select("a").By(gremlingo.T__.Unfold().Values("name").Fold()).Tail(gremlingo.Scope.Local, 1).Unfold()}}, 
    "g_V_asXaX_out_asXaX_out_asXaX_selectXaX_byXunfold_valuesXnameX_foldX_tailXlocalX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("a").Out().As("a").Select("a").By(gremlingo.T__.Unfold().Values("name").Fold()).Tail(gremlingo.Scope.Local).Unfold()}}, 
    "g_V_asXaX_out_asXbX_out_asXcX_selectXa_b_cX_byXnameX_tailXlocal_2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("b").Out().As("c").Select("a", "b", "c").By("name").Tail(gremlingo.Scope.Local, 2)}}, 
    "g_V_asXaX_out_asXbX_out_asXcX_selectXa_b_cX_byXnameX_tailXlocal_2varX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("b").Out().As("c").Select("a", "b", "c").By("name").Tail(gremlingo.Scope.Local, p["xx1"])}}, 
    "g_V_asXaX_out_asXbX_out_asXcX_selectXa_b_cX_byXnameX_tailXlocal_1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("b").Out().As("c").Select("a", "b", "c").By("name").Tail(gremlingo.Scope.Local, 1)}}, 
    "g_V_asXaX_out_asXaX_out_asXaX_selectXmixed_aX_byXunfold_valuesXnameX_foldX_tailXlocal_1X_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("a").Out().As("a").Select(gremlingo.Pop.Mixed, "a").By(gremlingo.T__.Unfold().Values("name").Fold()).Tail(gremlingo.Scope.Local, 1).Unfold()}}, 
    "g_V_asXaX_out_asXaX_out_asXaX_selectXmixed_aX_byXunfold_valuesXnameX_foldX_tailXlocalX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("a").Out().As("a").Select(gremlingo.Pop.Mixed, "a").By(gremlingo.T__.Unfold().Values("name").Fold()).Tail(gremlingo.Scope.Local).Unfold()}}, 
    "g_V_asXaX_out_asXaX_out_asXaX_selectXmixed_aX_byXlimitXlocal_0XX_tailXlocal_1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("a").Out().As("a").Select(gremlingo.Pop.Mixed, "a").By(gremlingo.T__.Limit(gremlingo.Scope.Local, 0)).Tail(gremlingo.Scope.Local, 1)}}, 
    "g_V_asXaX_out_asXaX_out_asXaX_selectXmixed_aX_byXunfold_valuesXnameX_foldX_tailXlocal_2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("a").Out().As("a").Select(gremlingo.Pop.Mixed, "a").By(gremlingo.T__.Unfold().Values("name").Fold()).Tail(gremlingo.Scope.Local, 2)}}, 
    "g_VX1X_valuesXageX_tailXlocal_5X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Values("age").Tail(gremlingo.Scope.Local, 50)}}, 
    "g_injectXlistX1_2_3XX_tailXlocal_1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{1, 2, 3}).Tail(gremlingo.Scope.Local, 1)}}, 
    "g_VX1X_valueMapXnameX_tailXlocal_1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).ValueMap("name").Tail(gremlingo.Scope.Local, 1)}}, 
    "g_injectX1_2_3X_tailXlocal_1X_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{1, 2, 3}).Tail(gremlingo.Scope.Local, 1).Unfold()}}, 
    "g_injectX1_2_3_4_5_6X_tailXlocal_1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{1, 2, 3}, []interface{}{4, 5, 6}).Tail(gremlingo.Scope.Local, 1)}}, 
    "g_injectX1_2_3_4_5X_tailXlocal_2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{1, 2, 3, 4, 5}).Tail(gremlingo.Scope.Local, 2)}}, 
    "g_V_valuesXnameX_isXtypeOfXGType_STRINGXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Is(gremlingo.P.TypeOf(gremlingo.GType.String))}}, 
    "g_V_valuesXnameX_isXtypeOfXjava_lang_StringXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Is(gremlingo.P.TypeOf("String"))}}, 
    "g_V_hasXname_typeOfXGType_STRINGXX_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", gremlingo.P.TypeOf(gremlingo.GType.String)).Values("name")}}, 
    "g_V_orXhasXname_typeOfXGType_STRINGXX__hasXage_typeOfXGType_INTXXX_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Or(gremlingo.T__.Has("name", gremlingo.P.TypeOf(gremlingo.GType.String)), gremlingo.T__.Has("age", gremlingo.P.TypeOf(gremlingo.GType.Int))).Values("name")}}, 
    "g_V_andXhasXname_typeOfXGType_STRINGXX__hasXage_typeOfXGType_INTXXX_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().And(gremlingo.T__.Has("name", gremlingo.P.TypeOf(gremlingo.GType.String)), gremlingo.T__.Has("age", gremlingo.P.TypeOf(gremlingo.GType.Int))).Values("name")}}, 
    "g_V_notXhasXage_typeOfXGType_STRINGXXX_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Not(gremlingo.T__.Has("age", gremlingo.P.TypeOf(gremlingo.GType.String))).Values("name")}}, 
    "g_V_valuesXageX_isXnotXtypeOfXGType_STRINGXXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Is(gremlingo.P.Not(gremlingo.P.TypeOf(gremlingo.GType.String)))}}, 
    "g_V_valuesXnameX_isXtypeOfXstringStringXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Is(gremlingo.P.TypeOf("String"))}}, 
    "g_V_orXvaluesXageX_isXtypeOfXGType_INTXX__valuesXnameX_isXtypeOfXGType_STRINGXXX_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Or(gremlingo.T__.Values("age").Is(gremlingo.P.TypeOf(gremlingo.GType.Int)), gremlingo.T__.Values("name").Is(gremlingo.P.TypeOf(gremlingo.GType.String))).Count()}}, 
    "g_V_whereXvaluesXnameX_isXtypeOfXGType_STRINGXXX_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Where(gremlingo.T__.Values("name").Is(gremlingo.P.TypeOf(gremlingo.GType.String))).Values("name")}}, 
    "g_V_whereXvaluesXageX_isXtypeOfXGType_STRINGXXX_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Where(gremlingo.T__.Values("age").Is(gremlingo.P.TypeOf(gremlingo.GType.String))).Count()}}, 
    "g_V_whereXnotXvaluesXageX_isXtypeOfXGType_STRINGXXXX_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Where(gremlingo.T__.Not(gremlingo.T__.Values("age").Is(gremlingo.P.TypeOf(gremlingo.GType.String)))).Values("name")}}, 
    "g_V_valuesXageX_isXtypeOfXGType_NULLXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Is(gremlingo.P.TypeOf(gremlingo.GType.Null))}}, 
    "g_V_valuesXageX_isXtypeOfXGType_BOOLEANXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Is(gremlingo.P.TypeOf(gremlingo.GType.Boolean))}}, 
    "g_V_valuesXageX_isXtypeOfXGType_CHARXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Is(gremlingo.P.TypeOf(gremlingo.GType.Char))}}, 
    "g_V_valuesXageX_isXtypeOfXGType_BINARYXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Is(gremlingo.P.TypeOf(gremlingo.GType.Binary))}}, 
    "g_V_valuesXageX_isXtypeOfXGType_UUIDXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Is(gremlingo.P.TypeOf(gremlingo.GType.UUID))}}, 
    "g_V_valuesXageX_isXtypeOfXGType_DATETIMEXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Is(gremlingo.P.TypeOf(gremlingo.GType.DateTime))}}, 
    "g_V_valuesXageX_isXtypeOfXGType_DURATIONXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Is(gremlingo.P.TypeOf(gremlingo.GType.Duration))}}, 
    "g_V_valuesXageX_isXtypeOfXnon_registered_NameXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Is(gremlingo.P.TypeOf("non-registered-Name"))}}, 
    "g_injectXtrueX_isXtypeOfXGType_BOOLEANX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(true).Is(gremlingo.P.TypeOf(gremlingo.GType.Boolean))}}, 
    "g_V_path_isXtypeOfXGType_PATHXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Values("name").Path().Is(gremlingo.P.TypeOf(gremlingo.GType.Path))}}, 
    "g_V_out_path_isXtypeOfXGType_PATHXX_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Path().Is(gremlingo.P.TypeOf(gremlingo.GType.Path)).Count()}}, 
    "g_V_hasXname_markoX_out_out_path_isXtypeOfXGType_PATHXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "marko").Out().Out().Path().Is(gremlingo.P.TypeOf(gremlingo.GType.Path))}}, 
    "g_V_out_tree_isXtypeOfXGType_TREEXX_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "marko").Out().Tree().Is(gremlingo.P.TypeOf(gremlingo.GType.Tree)).Count()}}, 
    "g_V_whereXtree_isXtypeOfXGType_TREEXXX_values_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Where(gremlingo.T__.Tree().Is(gremlingo.P.TypeOf(gremlingo.GType.Tree))).Values("name")}}, 
    "g_VX1X_outEXknowsX_subgraphXsgX_name_capXsgX_isXtypeOfXGType_GRAPHXX_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().OutE("knows").Subgraph("sg").Cap("sg").Is(gremlingo.P.TypeOf(gremlingo.GType.Graph)).Count()}}, 
    "g_VX1X_outEXknowsX_subgraphXsgX_name_capXsgX_isX_notXtypeOfXGType_GRAPHXXX_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().OutE("knows").Subgraph("sg").Cap("sg").Is(gremlingo.P.Not(gremlingo.P.TypeOf(gremlingo.GType.Graph))).Count()}}, 
    "g_V_valuesXageX_isXtypeOfXGType_PATHXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Is(gremlingo.P.TypeOf(gremlingo.GType.Path))}}, 
    "g_V_valuesXageX_isXtypeOfXGType_TREEXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Is(gremlingo.P.TypeOf(gremlingo.GType.Tree))}}, 
    "g_V_valuesXageX_isXtypeOfXGType_GRAPHXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Is(gremlingo.P.TypeOf(gremlingo.GType.Graph))}}, 
    "g_V_valuesXageX_isXtypeOfXGType_VPROPERTYXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Is(gremlingo.P.TypeOf(gremlingo.GType.VProperty))}}, 
    "g_V_hasXageX_asXaX_out_in_hasXageX_asXbX_selectXa_bX_whereXa_eqXbXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("age").As("a").Out().In().Has("age").As("b").Select("a", "b").Where("a", gremlingo.P.Eq("b"))}}, 
    "g_V_hasXageX_asXaX_out_in_hasXageX_asXbX_selectXa_bX_whereXa_neqXbXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("age").As("a").Out().In().Has("age").As("b").Select("a", "b").Where("a", gremlingo.P.Neq("b"))}}, 
    "g_V_hasXageX_asXaX_out_in_hasXageX_asXbX_selectXa_bX_whereXb_hasXname_markoXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("age").As("a").Out().In().Has("age").As("b").Select("a", "b").Where(gremlingo.T__.As("b").Has("name", "marko"))}}, 
    "g_V_hasXageX_asXaX_out_in_hasXageX_asXbX_selectXa_bX_whereXa_outXknowsX_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("age").As("a").Out().In().Has("age").As("b").Select("a", "b").Where(gremlingo.T__.As("a").Out("knows").As("b"))}}, 
    "g_V_asXaX_outXcreatedX_whereXasXaX_name_isXjoshXX_inXcreatedX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out("created").Where(gremlingo.T__.As("a").Values("name").Is("josh")).In("created").Values("name")}}, 
    "g_withSideEffectXa_josh_peterX_VX1X_outXcreatedX_inXcreatedX_name_whereXwithinXaXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("a", []interface{}{"josh", "peter"}).V(p["vid1"]).Out("created").In("created").Values("name").Where(gremlingo.P.Within("a"))}}, 
    "g_VX1X_asXaX_outXcreatedX_inXcreatedX_asXbX_whereXa_neqXbXX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).As("a").Out("created").In("created").As("b").Where("a", gremlingo.P.Neq("b")).Values("name")}}, 
    "g_VX1X_asXaX_outXcreatedX_inXcreatedX_asXbX_whereXasXbX_outXcreatedX_hasXname_rippleXX_valuesXage_nameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).As("a").Out("created").In("created").As("b").Where(gremlingo.T__.As("b").Out("created").Has("name", "ripple")).Values("age", "name")}}, 
    "g_VX1X_asXaX_outXcreatedX_inXcreatedX_whereXeqXaXX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).As("a").Out("created").In("created").Where(gremlingo.P.Eq("a")).Values("name")}}, 
    "g_VX1X_asXaX_outXcreatedX_inXcreatedX_whereXneqXaXX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).As("a").Out("created").In("created").Where(gremlingo.P.Neq("a")).Values("name")}}, 
    "g_VX1X_out_aggregateXxX_out_whereXnotXwithinXaXXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out().Aggregate("x").Out().Where(gremlingo.P.Not(gremlingo.P.Within("x")))}}, 
    "g_withSideEffectXa_g_VX2XX_VX1X_out_whereXneqXaXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out().Where(gremlingo.T__.Id().Where(gremlingo.P.Neq("a")))}}, 
    "g_VX1X_repeatXbothEXcreatedX_whereXwithoutXeXX_aggregateXeX_otherVX_emit_path": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Repeat(gremlingo.T__.BothE("created").Where(gremlingo.P.Without("e")).Aggregate("e").OtherV()).Emit().Path()}}, 
    "g_V_whereXnotXoutXcreatedXXX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Where(gremlingo.T__.Not(gremlingo.T__.Out("created"))).Values("name")}}, 
    "g_V_asXaX_out_asXbX_whereXandXasXaX_outXknowsX_asXbX__orXasXbX_outXcreatedX_hasXname_rippleX__asXbX_inXknowsX_count_isXnotXeqX0XXXXX_selectXa_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("b").Where(gremlingo.T__.And(gremlingo.T__.As("a").Out("knows").As("b"), gremlingo.T__.Or(gremlingo.T__.As("b").Out("created").Has("name", "ripple"), gremlingo.T__.As("b").In("knows").Count().Is(gremlingo.P.Not(gremlingo.P.Eq(0)))))).Select("a", "b")}}, 
    "g_V_whereXoutXcreatedX_and_outXknowsX_or_inXknowsXX_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Where(gremlingo.T__.Out("created").And().Out("knows").Or().In("knows")).Values("name")}}, 
    "g_V_asXaX_outXcreatedX_asXbX_whereXandXasXbX_in__notXasXaX_outXcreatedX_hasXname_rippleXXX_selectXa_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out("created").As("b").Where(gremlingo.T__.And(gremlingo.T__.As("b").In(), gremlingo.T__.Not(gremlingo.T__.As("a").Out("created").Has("name", "ripple")))).Select("a", "b")}}, 
    "g_V_asXaX_outXcreatedX_asXbX_inXcreatedX_asXcX_bothXknowsX_bothXknowsX_asXdX_whereXc__notXeqXaX_orXeqXdXXXX_selectXa_b_c_dX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out("created").As("b").In("created").As("c").Both("knows").Both("knows").As("d").Where("c", gremlingo.P.Not(gremlingo.P.Eq("a").Or(gremlingo.P.Eq("d")))).Select("a", "b", "c", "d")}}, 
    "g_V_asXaX_out_asXbX_whereXin_count_isXeqX3XX_or_whereXoutXcreatedX_and_hasXlabel_personXXX_selectXa_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("b").Where(gremlingo.T__.As("b").In().Count().Is(gremlingo.P.Eq(3)).Or().Where(gremlingo.T__.As("b").Out("created").And().As("b").Has(gremlingo.T.Label, "person"))).Select("a", "b")}}, 
    "g_V_asXaX_outXcreatedX_inXcreatedX_asXbX_whereXa_gtXbXX_byXageX_selectXa_bX_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out("created").In("created").As("b").Where("a", gremlingo.P.Gt("b")).By("age").Select("a", "b").By("name")}}, 
    "g_V_asXaX_outEXcreatedX_asXbX_inV_asXcX_whereXa_gtXbX_orXeqXbXXX_byXageX_byXweightX_byXweightX_selectXa_cX_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").OutE("created").As("b").InV().As("c").Where("a", gremlingo.P.Gt("b").Or(gremlingo.P.Eq("b"))).By("age").By("weight").By("weight").Select("a", "c").By("name")}}, 
    "g_V_asXaX_outEXcreatedX_asXbX_inV_asXcX_inXcreatedX_asXdX_whereXa_ltXbX_orXgtXcXX_andXneqXdXXX_byXageX_byXweightX_byXinXcreatedX_valuesXageX_minX_selectXa_c_dX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").OutE("created").As("b").InV().As("c").In("created").As("d").Where("a", gremlingo.P.Lt("b").Or(gremlingo.P.Gt("c")).And(gremlingo.P.Neq("d"))).By("age").By("weight").By(gremlingo.T__.In("created").Values("age").Min()).Select("a", "c", "d").By("name")}}, 
    "g_VX1X_asXaX_out_hasXageX_whereXgtXaXX_byXageX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).As("a").Out().Has("age").Where(gremlingo.P.Gt("a")).By("age").Values("name")}}, 
    "g_VX3X_asXaX_in_out_asXbX_whereXa_eqXbXX_byXageX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid3"]).As("a").In().Out().As("b").Where("a", gremlingo.P.Eq("b")).By("age").Values("name")}}, 
    "g_withStrategiesXProductiveByStrategyX_VX3X_asXaX_in_out_asXbX_whereXa_eqXbXX_byXageX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy()).V(p["vid3"]).As("a").In().Out().As("b").Where("a", gremlingo.P.Eq("b")).By("age").Values("name")}}, 
    "g_V_asXnX_whereXorXhasLabelXsoftwareX_hasLabelXpersonXXX_selectXnX_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("n").Where(gremlingo.T__.Or(gremlingo.T__.HasLabel("software"), gremlingo.T__.HasLabel("person"))).Select("n").By("name")}}, 
    "g_V_asXnX_whereXorXselectXnX_hasLabelXsoftwareX_selectXnX_hasLabelXpersonXXX_selectXnX_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("n").Where(gremlingo.T__.Or(gremlingo.T__.Select("n").HasLabel("software"), gremlingo.T__.Select("n").HasLabel("person"))).Select("n").By("name")}}, 
    "g_V_hasLabelXpersonX_asXxX_whereXinEXknowsX_count_isXgteX1XXX_selectXxX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").As("x").Where(gremlingo.T__.InE("knows").Count().Is(gremlingo.P.Gte(1))).Select("x")}}, 
    "get_g_V_whereXage_isXgt_30XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Where(gremlingo.T__.Values("age").Is(gremlingo.P.Gt(30)))}}, 
    "g_V_whereXlabel_isXsoftwareXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Where(gremlingo.T__.Label().Is("software"))}}, 
    "g_V_whereXlabel_isXpersonXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Where(gremlingo.T__.Label().Is("person"))}}, 
    "g_withStrategiesXAdjacentToIncidentStrategyX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.AdjacentToIncidentStrategy()).V()}}, 
    "g_withoutStrategiesXAdjacentToIncidentStrategyX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithoutStrategies(gremlingo.AdjacentToIncidentStrategy()).V()}}, 
    "g_withStrategiesXAdjacentToIncidentStrategyX_V_out_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.AdjacentToIncidentStrategy()).V().Out().Count()}}, 
    "g_withStrategiesXAdjacentToIncidentStrategyX_V_whereXoutX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.AdjacentToIncidentStrategy()).V().Where(gremlingo.T__.Out())}}, 
    "g_withStrategiesXByModulatorOptimizationStrategyX_V_order_byXvaluesXnameXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ByModulatorOptimizationStrategy()).V().Order().By(gremlingo.T__.Values("name"))}}, 
    "g_withoutStrategiesXByModulatorOptimizationStrategyX_V_order_byXvaluesXnameXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithoutStrategies(gremlingo.ByModulatorOptimizationStrategy()).V().Order().By(gremlingo.T__.Values("name"))}}, 
    "g_withStrategiesXComputerFinalizationStrategyX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ComputerFinalizationStrategy()).V()}}, 
    "g_withoutStrategiesXByModulatorOptimizationStrategyX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithoutStrategies(gremlingo.ComputerFinalizationStrategy()).V()}}, 
    "g_withStrategiesXComputerVerificationStrategyX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ComputerVerificationStrategy()).V()}}, 
    "g_withoutStrategiesXComputerVerificationStrategyX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithoutStrategies(gremlingo.ComputerVerificationStrategy()).V()}}, 
    "g_withStrategiesXConnectiveStrategyStrategyX_V_hasXname_markoX_or_whereXinXknowsX_hasXname_markoXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ConnectiveStrategy()).V().Has("name", "marko").Or().Where(gremlingo.T__.In("knows").Has("name", "marko"))}}, 
    "g_withoutStrategiesXConnectiveStrategyX_V_hasXname_markoX_or_whereXinXknowsX_hasXname_markoXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithoutStrategies(gremlingo.ConnectiveStrategy()).V().Has("name", "marko").Or().Where(gremlingo.T__.In("knows").Has("name", "marko"))}}, 
    "g_withStrategiesXCountStrategyX_V_whereXoutE_count_isX0XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.CountStrategy()).V().Where(gremlingo.T__.OutE().Count().Is(0))}}, 
    "g_withoutStrategiesXCountStrategyX_V_whereXoutE_count_isX0XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithoutStrategies(gremlingo.CountStrategy()).V().Where(gremlingo.T__.OutE().Count().Is(0))}}, 
    "g_withStrategiesXEarlyLimitStrategyX_V_out_order_byXnameX_valueMap_limitX3X_selectXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.EarlyLimitStrategy()).V().Out().Order().By("name").ValueMap().Limit(3).Select("name")}}, 
    "g_withoutStrategiesXEarlyLimitStrategyX_V_out_order_byXnameX_valueMap_limitX3X_selectXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithoutStrategies(gremlingo.EarlyLimitStrategy()).V().Out().Order().By("name").ValueMap().Limit(3).Select("name")}}, 
    "g_withStrategiesXEdgeLabelVerificationStrategyXthrowException_true_logWarning_falseXX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.EdgeLabelVerificationStrategy(gremlingo.EdgeLabelVerificationStrategyConfig{ThrowException: true, LogWarning: false})).V().Out()}}, 
    "g_withStrategiesXEdgeLabelVerificationStrategyXthrowException_false_logWarning_falseXX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.EdgeLabelVerificationStrategy(gremlingo.EdgeLabelVerificationStrategyConfig{ThrowException: false, LogWarning: false})).V().Out()}}, 
    "g_withoutStrategiesXEdgeLabelVerificationStrategyX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithoutStrategies(gremlingo.EdgeLabelVerificationStrategy()).V().Out()}}, 
    "g_withStrategiesXElementIdStrategyX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ElementIdStrategy()).V()}}, 
    "g_withoutStrategiesXElementIdStrategyX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithoutStrategies(gremlingo.ElementIdStrategy()).V()}}, 
    "g_withStrategiesXFilterRankingStrategyX_V_out_order_dedup": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.FilterRankingStrategy()).V().Out().Order().Dedup()}}, 
    "g_withoutStrategiesXFilterRankingStrategyX_V_out_order_dedup": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithoutStrategies(gremlingo.FilterRankingStrategy()).V().Out().Order().Dedup()}}, 
    "g_withStrategiesXGraphFilterStrategyX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.GraphFilterStrategy()).V()}}, 
    "g_withoutStrategiesXGraphFilterStrategyX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithoutStrategies(gremlingo.GraphFilterStrategy()).V()}}, 
    "g_withStrategiesXHaltedTraverserStrategyXDetachedFactoryXX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.HaltedTraverserStrategy(gremlingo.HaltedTraverserStrategyConfig{HaltedTraverserFactory: "org.apache.tinkerpop.gremlin.structure.util.detached.DetachedFactory"})).V()}}, 
    "g_withStrategiesXHaltedTraverserStrategyXReferenceFactoryXX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.HaltedTraverserStrategy(gremlingo.HaltedTraverserStrategyConfig{HaltedTraverserFactory: "org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceFactory"})).V()}}, 
    "g_withoutStrategiesXHaltedTraverserStrategyX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithoutStrategies(gremlingo.HaltedTraverserStrategy()).V()}}, 
    "g_withStrategiesXIdentityRemovalStrategyX_V_identity_out": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.IdentityRemovalStrategy()).V().Identity().Out()}}, 
    "g_withoutStrategiesXIdentityRemovalStrategyX_V_identity_out": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithoutStrategies(gremlingo.IdentityRemovalStrategy()).V().Identity().Out()}}, 
    "g_withStrategiesXIncidentToAdjacentStrategyX_V_outE_inV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.IncidentToAdjacentStrategy()).V().OutE().InV()}}, 
    "g_withoutStrategiesXIncidentToAdjacentStrategyX_V_outE_inV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithoutStrategies(gremlingo.IncidentToAdjacentStrategy()).V().OutE().InV()}}, 
    "g_withStrategiesXInlineFilterStrategyX_V_filterXhasXname_markoXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.InlineFilterStrategy()).V().Filter(gremlingo.T__.Has("name", "marko"))}}, 
    "g_withoutStrategiesXInlineFilterStrategyX_V_filterXhasXname_markoXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithoutStrategies(gremlingo.InlineFilterStrategy()).V().Filter(gremlingo.T__.Has("name", "marko"))}}, 
    "g_withStrategiesXLambdaRestrictionStrategyX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.LambdaRestrictionStrategy()).V()}}, 
    "g_withoutStrategiesXLambdaRestrictionStrategyX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithoutStrategies(gremlingo.LambdaRestrictionStrategy()).V()}}, 
    "g_withStrategiesXLazyBarrierStrategyX_V_out_bothE_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.LazyBarrierStrategy()).V().Out().BothE().Count()}}, 
    "g_withoutStrategiesXLazyBarrierStrategyX_V_out_bothE_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithoutStrategies(gremlingo.LazyBarrierStrategy()).V().Out().BothE().Count()}}, 
    "g_withStrategiesXMatchAlgorithmStrategyXmatchAlgorithm_CountMatchAlgorithmXX_V_matchXa_knows_b__a_created_cX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.MatchAlgorithmStrategy(gremlingo.MatchAlgorithmStrategyConfig{MatchAlgorithm: "org.apache.tinkerpop.gremlin.process.traversal.step.map.MatchStep$CountMatchAlgorithm"})).V().Match(gremlingo.T__.As("a").Out("knows").As("b"), gremlingo.T__.As("a").Out("created").As("c"))}}, 
    "g_withStrategiesXMatchAlgorithmStrategyXmatchAlgorithm_GreedyMatchAlgorithmXX_V_matchXa_knows_b__a_created_cX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.MatchAlgorithmStrategy(gremlingo.MatchAlgorithmStrategyConfig{MatchAlgorithm: "org.apache.tinkerpop.gremlin.process.traversal.step.map.MatchStep$GreedyMatchAlgorithm"})).V().Match(gremlingo.T__.As("a").Out("knows").As("b"), gremlingo.T__.As("a").Out("created").As("c"))}}, 
    "g_withoutStrategiesXMatchAlgorithmStrategyX_V_matchXa_knows_b__a_created_cX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithoutStrategies(gremlingo.MatchAlgorithmStrategy()).V().Match(gremlingo.T__.As("a").Out("knows").As("b"), gremlingo.T__.As("a").Out("created").As("c"))}}, 
    "g_withStrategiesXMatchPredicateStrategyX_V_matchXa_created_lop_b__b_0created_29_cX_whereXc_repeatXoutX_timesX2XX_selectXa_b_cX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.MatchPredicateStrategy()).V().Match(gremlingo.T__.As("a").Out("created").Has("name", "lop").As("b"), gremlingo.T__.As("b").In("created").Has("age", 29).As("c")).Where(gremlingo.T__.As("c").Repeat(gremlingo.T__.Out()).Times(2)).Select("a", "b", "c")}}, 
    "g_withoutStrategiesXMatchPredicateStrategyX_V_matchXa_created_lop_b__b_0created_29_cX_whereXc_repeatXoutX_timesX2XX_selectXa_b_cX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithoutStrategies(gremlingo.MatchPredicateStrategy()).V().Match(gremlingo.T__.As("a").Out("created").Has("name", "lop").As("b"), gremlingo.T__.As("b").In("created").Has("age", 29).As("c")).Where(gremlingo.T__.As("c").Repeat(gremlingo.T__.Out()).Times(2)).Select("a", "b", "c")}}, 
    "g_withStrategiesXMessagePassingReductionStrategyX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.MessagePassingReductionStrategy()).V()}}, 
    "g_withoutStrategiesXMessagePassingReductionStrategyX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithoutStrategies(gremlingo.MessagePassingReductionStrategy()).V()}}, 
    "g_V_coworker": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Filter(gremlingo.T__.OutE("created")).Aggregate("p").As("p1").Values("name").As("p1n").Select("p").Unfold().Where(gremlingo.P.Neq("p1")).As("p2").Values("name").As("p2n").Select("p2").Out("created").Choose(gremlingo.T__.In("created").Where(gremlingo.P.Eq("p1")), gremlingo.T__.Values("name"), gremlingo.T__.Constant([]interface{}{})).Group().By(gremlingo.T__.Select("p1n")).By(gremlingo.T__.Group().By(gremlingo.T__.Select("p2n")).By(gremlingo.T__.Unfold().Fold().Project("numCoCreated", "coCreated").By(gremlingo.T__.Count(gremlingo.Scope.Local)).By())).Unfold()}}, 
    "g_V_coworker_with_midV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Filter(gremlingo.T__.OutE("created")).As("p1").V().HasLabel("person").Where(gremlingo.P.Neq("p1")).Filter(gremlingo.T__.OutE("created")).As("p2").Map(gremlingo.T__.Out("created").Where(gremlingo.T__.In("created").As("p1")).Values("name").Fold()).Group().By(gremlingo.T__.Select("p1").By("name")).By(gremlingo.T__.Group().By(gremlingo.T__.Select("p2").By("name")).By(gremlingo.T__.Project("numCoCreated", "coCreated").By(gremlingo.T__.Count(gremlingo.Scope.Local)).By())).Unfold()}}, 
    "g_withStrategiesXOptionsStrategyX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.OptionsStrategy()).V()}}, 
    "g_withStrategiesXOptionsStrategyXmyVar_myValueXX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.OptionsStrategy(map[string]interface{}{"myVar": "myValue"})).V()}}, 
    "g_withoutStrategiesXOptionsStrategyX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithoutStrategies(gremlingo.OptionsStrategy()).V()}}, 
    "g_withStrategiesXOrderLimitStrategyX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.OrderLimitStrategy()).V()}}, 
    "g_withoutStrategiesXOrderLimitStrategyX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithoutStrategies(gremlingo.OrderLimitStrategy()).V()}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_V_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("_partition", "a").Property("name", "alice").AddV("person").Property("_partition", "b").Property("name", "bob")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{PartitionKey: "_partition", WritePartition: "a", ReadPartitions: gremlingo.NewSimpleSet("a")})).V().Values("name")}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_a_bXX_V_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("_partition", "a").Property("name", "alice").AddV("person").Property("_partition", "b").Property("name", "bob")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{PartitionKey: "_partition", WritePartition: "a", ReadPartitions: gremlingo.NewSimpleSet("a", "b")})).V().Values("name")}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_cXX_V_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("_partition", "a").Property("name", "alice").AddV("person").Property("_partition", "b").Property("name", "bob")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{PartitionKey: "_partition", WritePartition: "a", ReadPartitions: gremlingo.NewSimpleSet("c")})).V().Values("name")}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_V_bothE_weight": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("_partition", "a").Property("name", "alice").As("a").AddV("person").Property("_partition", "b").Property("name", "bob").As("b").AddE("knows").From("a").To("b").Property("_partition", "a").Property("weight", 1.0).AddE("knows").From("b").To("a").Property("_partition", "b").Property("weight", 2.0)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{PartitionKey: "_partition", WritePartition: "a", ReadPartitions: gremlingo.NewSimpleSet("a")})).V().BothE().Values("weight")}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_bXX_V_bothE_weight": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("_partition", "a").Property("name", "alice").As("a").AddV("person").Property("_partition", "b").Property("name", "bob").As("b").AddE("knows").From("a").To("b").Property("_partition", "a").Property("weight", 1.0).AddE("knows").From("b").To("a").Property("_partition", "b").Property("weight", 2.0)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{PartitionKey: "_partition", WritePartition: "a", ReadPartitions: gremlingo.NewSimpleSet("b")})).V().BothE().Values("weight")}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_a_bXX_V_bothE_dedup_weight": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("_partition", "a").Property("name", "alice").As("a").AddV("person").Property("_partition", "b").Property("name", "bob").As("b").AddE("knows").From("a").To("b").Property("_partition", "a").Property("weight", 1.0).AddE("knows").From("b").To("a").Property("_partition", "b").Property("weight", 2.0)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{PartitionKey: "_partition", WritePartition: "a", ReadPartitions: gremlingo.NewSimpleSet("a", "b")})).V().BothE().Dedup().Values("weight")}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_cXX_V_bothE_weight": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("_partition", "a").Property("name", "alice").As("a").AddV("person").Property("_partition", "b").Property("name", "bob").As("b").AddE("knows").From("a").To("b").Property("_partition", "a").Property("weight", 1.0).AddE("knows").From("b").To("a").Property("_partition", "b").Property("weight", 2.0)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{PartitionKey: "_partition", WritePartition: "a", ReadPartitions: gremlingo.NewSimpleSet("c")})).V().BothE().Values("weight")}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_V_both_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("_partition", "a").Property("name", "alice").As("a").AddV("person").Property("_partition", "b").Property("name", "bob").As("b").AddE("knows").From("a").To("b").Property("_partition", "a").Property("weight", 1.0).AddE("knows").From("b").To("a").Property("_partition", "b").Property("weight", 2.0)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{PartitionKey: "_partition", WritePartition: "a", ReadPartitions: gremlingo.NewSimpleSet("a")})).V().Both().Values("name")}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_bXX_V_both_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("_partition", "a").Property("name", "alice").As("a").AddV("person").Property("_partition", "b").Property("name", "bob").As("b").AddE("knows").From("a").To("b").Property("_partition", "a").Property("weight", 1.0).AddE("knows").From("b").To("a").Property("_partition", "b").Property("weight", 2.0)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{PartitionKey: "_partition", WritePartition: "a", ReadPartitions: gremlingo.NewSimpleSet("b")})).V().Both().Values("name")}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_a_bXX_V_both_dedup_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("_partition", "a").Property("name", "alice").As("a").AddV("person").Property("_partition", "b").Property("name", "bob").As("b").AddE("knows").From("a").To("b").Property("_partition", "a").Property("weight", 1.0).AddE("knows").From("b").To("a").Property("_partition", "b").Property("weight", 2.0)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{PartitionKey: "_partition", WritePartition: "a", ReadPartitions: gremlingo.NewSimpleSet("a", "b")})).V().Both().Dedup().Values("name")}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_cXX_V_both_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("_partition", "a").Property("name", "alice").As("a").AddV("person").Property("_partition", "b").Property("name", "bob").As("b").AddE("knows").From("a").To("b").Property("_partition", "a").Property("weight", 1.0).AddE("knows").From("b").To("a").Property("_partition", "b").Property("weight", 2.0)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{PartitionKey: "_partition", WritePartition: "a", ReadPartitions: gremlingo.NewSimpleSet("c")})).V().Both().Values("name")}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_V_out_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("_partition", "a").Property("name", "alice").As("a").AddV("person").Property("_partition", "b").Property("name", "bob").As("b").AddE("knows").From("a").To("b").Property("_partition", "a").Property("weight", 1.0).AddE("knows").From("b").To("a").Property("_partition", "b").Property("weight", 2.0)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{PartitionKey: "_partition", WritePartition: "a", ReadPartitions: gremlingo.NewSimpleSet("a")})).V().Out().Values("name")}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_bXX_V_in_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("_partition", "a").Property("name", "alice").As("a").AddV("person").Property("_partition", "b").Property("name", "bob").As("b").AddE("knows").From("a").To("b").Property("_partition", "a").Property("weight", 1.0).AddE("knows").From("b").To("a").Property("_partition", "b").Property("weight", 2.0)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{PartitionKey: "_partition", WritePartition: "a", ReadPartitions: gremlingo.NewSimpleSet("b")})).V().In().Values("name")}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_a_bXX_V_out_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("_partition", "a").Property("name", "alice").As("a").AddV("person").Property("_partition", "b").Property("name", "bob").As("b").AddE("knows").From("a").To("b").Property("_partition", "a").Property("weight", 1.0).AddE("knows").From("b").To("a").Property("_partition", "b").Property("weight", 2.0)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{PartitionKey: "_partition", WritePartition: "a", ReadPartitions: gremlingo.NewSimpleSet("a", "b")})).V().Out().Values("name")}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_cXX_V_out_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("_partition", "a").Property("name", "alice").As("a").AddV("person").Property("_partition", "b").Property("name", "bob").As("b").AddE("knows").From("a").To("b").Property("_partition", "a").Property("weight", 1.0).AddE("knows").From("b").To("a").Property("_partition", "b").Property("weight", 2.0)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{PartitionKey: "_partition", WritePartition: "a", ReadPartitions: gremlingo.NewSimpleSet("c")})).V().Out().Values("name")}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_addVXpersonX_propertyXname_aliceX_addXselfX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{PartitionKey: "_partition", WritePartition: "a", ReadPartitions: gremlingo.NewSimpleSet("a")})).AddV("person").Property("name", "alice").AddE("self")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "alice").Has("_partition", "a")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Has("_partition", "a")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_injectXzeroX_addVXpersonX_propertyXname_aliceX_addXselfX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{PartitionKey: "_partition", WritePartition: "a", ReadPartitions: gremlingo.NewSimpleSet("a")})).Inject(0).AddV("person").Property("name", "alice").AddE("self")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "alice").Has("_partition", "a")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Has("_partition", "a")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_mergeV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{PartitionKey: "_partition", WritePartition: "a", ReadPartitions: gremlingo.NewSimpleSet("a")})).MergeV(p["xx1"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "alice").Has("_partition", "a")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_injectX0X_mergeV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{PartitionKey: "_partition", WritePartition: "a", ReadPartitions: gremlingo.NewSimpleSet("a")})).Inject(0).MergeV(p["xx1"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "alice").Has("_partition", "a")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_mergeE": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("_partition", "a").Property("name", "alice").AddV("person").Property("_partition", "a").Property("name", "bob")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{PartitionKey: "_partition", WritePartition: "a", ReadPartitions: gremlingo.NewSimpleSet("a")})).MergeE(p["xx1"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Has("knows", "_partition", "a")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_injectX0XmergeE": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("_partition", "a").Property("name", "alice").AddV("person").Property("_partition", "a").Property("name", "bob")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{PartitionKey: "_partition", WritePartition: "a", ReadPartitions: gremlingo.NewSimpleSet("a")})).Inject(0).MergeE(p["xx1"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Has("knows", "_partition", "a")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_mergeVXlabel_person_name_aliceX_optionXonMatch_name_bobX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("_partition", "a").Property("name", "alice").AddV("person").Property("_partition", "b").Property("name", "alice")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{PartitionKey: "_partition", WritePartition: "a", ReadPartitions: gremlingo.NewSimpleSet("a")})).MergeV(p["xx1"]).Option(gremlingo.Merge.OnMatch, p["xx2"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "bob").Has("_partition", "a")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_mergeV_optionXonCreateX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("_partition", "b").Property("name", "alice")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{PartitionKey: "_partition", WritePartition: "a", ReadPartitions: gremlingo.NewSimpleSet("a")})).MergeV(p["xx1"]).Option(gremlingo.Merge.OnCreate, p["xx2"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "alice").Has("age", 35).Has("_partition", "a")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_injectX0X__mergeV_optionXonCreateX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("_partition", "b").Property("name", "alice")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{PartitionKey: "_partition", WritePartition: "a", ReadPartitions: gremlingo.NewSimpleSet("a")})).Inject(0).MergeV(p["xx1"]).Option(gremlingo.Merge.OnCreate, p["xx2"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "alice").Has("age", 35).Has("_partition", "a")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_withStrategiesXPathProcessorStrategyX_V_asXaX_selectXaX_byXvaluesXnameXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PathProcessorStrategy()).V().As("a").Select("a").By(gremlingo.T__.Values("name"))}}, 
    "g_withoutStrategiesXPathProcessorStrategyX_V_asXaX_selectXaX_byXvaluesXnameXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithoutStrategies(gremlingo.PathProcessorStrategy()).V().As("a").Select("a").By(gremlingo.T__.Values("name"))}}, 
    "g_withStrategiesXPathRetractionStrategyX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PathRetractionStrategy()).V()}}, 
    "g_withoutStrategiesXPathRetractionStrategyX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithoutStrategies(gremlingo.PathRetractionStrategy()).V()}}, 
    "g_V_shortestpath": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("v").Both().As("v").Project("src", "tgt", "p").By(gremlingo.T__.Select(gremlingo.Pop.First, "v")).By(gremlingo.T__.Select(gremlingo.Pop.Last, "v")).By(gremlingo.T__.Select(gremlingo.Pop.All, "v")).As("triple").Group("x").By(gremlingo.T__.Select("src", "tgt")).By(gremlingo.T__.Select("p").Fold()).Select("tgt").Barrier().Repeat(gremlingo.T__.Both().As("v").Project("src", "tgt", "p").By(gremlingo.T__.Select(gremlingo.Pop.First, "v")).By(gremlingo.T__.Select(gremlingo.Pop.Last, "v")).By(gremlingo.T__.Select(gremlingo.Pop.All, "v")).As("t").Filter(gremlingo.T__.Select(gremlingo.Pop.All, "p").Count(gremlingo.Scope.Local).As("l").Select(gremlingo.Pop.Last, "t").Select(gremlingo.Pop.All, "p").Dedup(gremlingo.Scope.Local).Count(gremlingo.Scope.Local).Where(gremlingo.P.Eq("l"))).Where("src", gremlingo.P.Neq("tgt")).Select(gremlingo.Pop.Last, "t").Not(gremlingo.T__.Select(gremlingo.Pop.All, "p").As("p").Count(gremlingo.Scope.Local).As("l").Select(gremlingo.Pop.All, "x").Unfold().Filter(gremlingo.T__.Select(gremlingo.Column.Keys).Where(gremlingo.P.Eq("t")).By(gremlingo.T__.Select("src", "tgt"))).Filter(gremlingo.T__.Select(gremlingo.Column.Values).Unfold().Or(gremlingo.T__.Count(gremlingo.Scope.Local).Where(gremlingo.P.Lt("l")), gremlingo.T__.Where(gremlingo.P.Eq("p"))))).Barrier().Group("x").By(gremlingo.T__.Select("src", "tgt")).By(gremlingo.T__.Select(gremlingo.Pop.All, "p").Fold()).Select("tgt").Barrier()).Cap("x").Select(gremlingo.Column.Values).Unfold().Unfold().Map(gremlingo.T__.Unfold().Values("name").Fold())}}, 
    "g_V_playlist_paths": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SeedStrategy(gremlingo.SeedStrategyConfig{Seed: 99999})).V().Has("name", "Bob_Dylan").In("sungBy").As("a").Repeat(gremlingo.T__.Out().Order().By(gremlingo.Order.Shuffle).SimplePath().From("a")).Until(gremlingo.T__.Out("writtenBy").Has("name", "Johnny_Cash")).Limit(1).As("b").Repeat(gremlingo.T__.Out().Order().By(gremlingo.Order.Shuffle).As("c").SimplePath().From("b").To("c")).Until(gremlingo.T__.Out("sungBy").Has("name", "Grateful_Dead")).Limit(1).Path().From("a").Unfold().Project("song", "artists").By("name").By(gremlingo.T__.Coalesce(gremlingo.T__.Out("sungBy", "writtenBy").Dedup().Values("name"), gremlingo.T__.Constant("Unknown")).Fold())}}, 
    "g_withStrategiesXProductiveByStrategyX_V_group_byXageX_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy()).V().Group().By("age").By("name")}}, 
    "g_withoutStrategiesXProductiveByStrategyX_V_group_byXageX_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithoutStrategies(gremlingo.ProductiveByStrategy()).V().Group().By("age").By("name")}}, 
    "g_withStrategiesXProfileStrategyX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProfileStrategy()).V()}}, 
    "g_withoutStrategiesXProfileStrategyX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithoutStrategies(gremlingo.ProfileStrategy()).V()}}, 
    "g_withStrategiesXReadOnlyStrategyX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ReadOnlyStrategy()).V()}}, 
    "g_withStrategiesXReadOnlyStrategyX_V_outXknowsX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ReadOnlyStrategy()).V().Out("knows").Values("name")}}, 
    "g_withStrategiesXReadOnlyStrategyX_addVXpersonX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ReadOnlyStrategy()).AddV("person")}}, 
    "g_withStrategiesXReadOnlyStrategyX_addVXpersonX_fromXVX1XX_toXVX2XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ReadOnlyStrategy()).AddE("link").From(gremlingo.T__.V(p["vid1"])).To(gremlingo.T__.V(p["vid2"]))}}, 
    "g_withStrategiesXReadOnlyStrategyX_V_addVXpersonX_fromXVX1XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ReadOnlyStrategy()).V().AddE("link").From(gremlingo.T__.V(p["vid1"]))}}, 
    "g_withStrategiesXReadOnlyStrategyX_V_propertyXname_joshX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ReadOnlyStrategy()).V().Property("name", "josh")}}, 
    "g_withStrategiesXReadOnlyStrategyX_E_propertyXweight_0X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ReadOnlyStrategy()).E().Property("weight", 0)}}, 
    "g_V_classic_recommendation": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "DARK STAR").As("a").Out("followedBy").Aggregate("stash").In("followedBy").Where(gremlingo.P.Neq("a").And(gremlingo.P.Not(gremlingo.P.Within("stash")))).GroupCount().Unfold().Project("x", "y", "z").By(gremlingo.T__.Select(gremlingo.Column.Keys).Values("name")).By(gremlingo.T__.Select(gremlingo.Column.Keys).Values("performances")).By(gremlingo.T__.Select(gremlingo.Column.Values)).Order().By(gremlingo.T__.Select("z"), gremlingo.Order.Desc).By(gremlingo.T__.Select("y"), gremlingo.Order.Asc).Limit(5).Local(gremlingo.T__.Aggregate("m")).Select("x")}}, 
    "g_V_classic_recommendation_ranked": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "DARK STAR").As("a").Out("followedBy").Aggregate("stash").In("followedBy").Where(gremlingo.P.Neq("a").And(gremlingo.P.Not(gremlingo.P.Within("stash")))).GroupCount().Unfold().Project("x", "y", "z").By(gremlingo.T__.Select(gremlingo.Column.Keys).Values("name")).By(gremlingo.T__.Select(gremlingo.Column.Keys).Values("performances")).By(gremlingo.T__.Select(gremlingo.Column.Values)).Order().By(gremlingo.T__.Select("z"), gremlingo.Order.Desc).By(gremlingo.T__.Select("y"), gremlingo.Order.Asc).Limit(5).Local(gremlingo.T__.Aggregate("m"))}}, 
    "g_withStrategiesXReferenceElementStrategyX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ReferenceElementStrategy()).V()}}, 
    "g_withoutStrategiesXReferenceElementStrategyX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithoutStrategies(gremlingo.ReferenceElementStrategy()).V()}}, 
    "g_withStrategiesXRepeatUnrollStrategyX_V_repeatXoutX_timesX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.RepeatUnrollStrategy()).V().Repeat(gremlingo.T__.Out()).Times(2)}}, 
    "g_withoutStrategiesXRepeatUnrollStrategyX_V_repeatXoutX_timesX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithoutStrategies(gremlingo.RepeatUnrollStrategy()).V().Repeat(gremlingo.T__.Out()).Times(2)}}, 
    "g_withStrategiesXRepeatUnrollStrategyX_V_repeatXinX_timesX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.RepeatUnrollStrategy()).V().Repeat(gremlingo.T__.In()).Times(2)}}, 
    "g_withoutStrategiesXRepeatUnrollStrategyX_V_repeatXinX_timesX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithoutStrategies(gremlingo.RepeatUnrollStrategy()).V().Repeat(gremlingo.T__.In()).Times(2)}}, 
    "g_withStrategiesXRepeatUnrollStrategyX_V_repeatXout_hasXname_notStartingWithXzXXX_timesX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.RepeatUnrollStrategy()).V().Repeat(gremlingo.T__.Out().Has("name", gremlingo.TextP.NotStartingWith("z"))).Times(2)}}, 
    "g_withoutStrategiesXRepeatUnrollStrategyX_V_repeatXout_hasXname_notStartingWithXzXXX_timesX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithoutStrategies(gremlingo.RepeatUnrollStrategy()).V().Repeat(gremlingo.T__.Out().Has("name", gremlingo.TextP.NotStartingWith("z"))).Times(2)}}, 
    "g_withStrategiesXRepeatUnrollStrategyX_V_repeatXin_hasXage_gtX20XXX_timesX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.RepeatUnrollStrategy()).V().Repeat(gremlingo.T__.In().Has("age", gremlingo.P.Gt(20))).Times(2)}}, 
    "g_withoutStrategiesXRepeatUnrollStrategyX_V_repeatXin_hasXage_gtX20XXX_timesX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithoutStrategies(gremlingo.RepeatUnrollStrategy()).V().Repeat(gremlingo.T__.In().Has("age", gremlingo.P.Gt(20))).Times(2)}}, 
    "g_withStrategiesXRepeatUnrollStrategyX_V_repeatXboth_hasXage_ltX30XXX_timesX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.RepeatUnrollStrategy()).V().Repeat(gremlingo.T__.Both().Has("age", gremlingo.P.Lt(30))).Times(2)}}, 
    "g_withoutStrategiesXRepeatUnrollStrategyX_V_repeatXboth_hasXage_ltX30XXX_timesX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithoutStrategies(gremlingo.RepeatUnrollStrategy()).V().Repeat(gremlingo.T__.Both().Has("age", gremlingo.P.Lt(30))).Times(2)}}, 
    "g_withStrategiesXRepeatUnrollStrategyX_V_repeatXbothE_otherV_hasXage_ltX30XXX_timesX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.RepeatUnrollStrategy()).V().Repeat(gremlingo.T__.BothE().OtherV().Has("age", gremlingo.P.Lt(30))).Times(2)}}, 
    "g_withoutStrategiesXRepeatUnrollStrategyX_V_repeatXbothE_otherV_hasXage_ltX30XXX_timesX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithoutStrategies(gremlingo.RepeatUnrollStrategy()).V().Repeat(gremlingo.T__.BothE().OtherV().Has("age", gremlingo.P.Lt(30))).Times(2)}}, 
    "g_withStrategiesXRepeatUnrollStrategyX_V_repeatXboth_limitX1XX_timesX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.RepeatUnrollStrategy()).V().Repeat(gremlingo.T__.Both().Limit(1)).Times(2)}}, 
    "g_withoutStrategiesXRepeatUnrollStrategyX_V_repeatXboth_limitX1XX_timesX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithoutStrategies(gremlingo.RepeatUnrollStrategy()).V().Repeat(gremlingo.T__.Both().Limit(1)).Times(2)}}, 
    "g_withStrategiesXRepeatUnrollStrategyX_V_order_byXnameX_repeatXboth_order_byXnameX_aggregateXxXX_timesX2X_limitX10X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.RepeatUnrollStrategy()).V().Order().By("name").Repeat(gremlingo.T__.Both().Order().By("name").Aggregate("x")).Times(2).Limit(10)}}, 
    "g_withoutStrategiesXRepeatUnrollStrategyX_V_order_byXnameX_repeatXboth_order_byXnameX_aggregateXxXX_timesX2X_limitX10X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithoutStrategies(gremlingo.RepeatUnrollStrategy()).V().Order().By("name").Repeat(gremlingo.T__.Both().Order().By("name").Aggregate("x")).Times(2).Limit(10)}}, 
    "g_withStrategiesXRepeatUnrollStrategyX_V_repeatXboth_sampleX1XX_timesX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.RepeatUnrollStrategy()).V().Repeat(gremlingo.T__.Both().Sample(1)).Times(2)}}, 
    "g_withoutStrategiesXRepeatUnrollStrategyX_V_repeatXboth_sampleX1XX_timesX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithoutStrategies(gremlingo.RepeatUnrollStrategy()).V().Repeat(gremlingo.T__.Both().Sample(1)).Times(2)}}, 
    "g_withStrategiesXReservedKeysVerificationStrategyXthrowException_trueXX_addVXpersonX_propertyXid_123X_propertyXname_markoX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ReservedKeysVerificationStrategy(gremlingo.ReservedKeysVerificationStrategyConfig{ThrowException: true})).AddV("person").Property("id", 123).Property("name", "marko")}}, 
    "g_withStrategiesXReservedKeysVerificationStrategyXthrowException_trueXX_addVXpersonX_propertyXage_29X_propertyXname_markoX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ReservedKeysVerificationStrategy(gremlingo.ReservedKeysVerificationStrategyConfig{ThrowException: true, Keys: gremlingo.NewSimpleSet("age")})).AddV("person").Property("age", 29).Property("name", "marko")}}, 
    "g_withoutStrategiesXReservedKeysVerificationStrategyX_addVXpersonX_propertyXid_123X_propertyXname_markoX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithoutStrategies(gremlingo.ReservedKeysVerificationStrategy()).AddV("person").Property("id", 123).Property("name", "marko").Values()}}, 
    "g_withoutStrategiesXSeedStrategyX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithoutStrategies(gremlingo.SeedStrategy()).V()}}, 
    "g_withStrategiesXStandardVerificationStrategyX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.StandardVerificationStrategy()).V()}}, 
    "g_withoutStrategiesXStandardVerificationStrategyX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithoutStrategies(gremlingo.StandardVerificationStrategy()).V()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphAXX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{Vertices: gremlingo.T__.Has("name", gremlingo.P.Within("josh", "lop", "ripple"))})).V()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphAXX_E": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{Vertices: gremlingo.T__.Has("name", gremlingo.P.Within("josh", "lop", "ripple"))})).E()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphAXX_VX4X_outE": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{Vertices: gremlingo.T__.Has("name", gremlingo.P.Within("josh", "lop", "ripple"))})).V(p["vid4"]).OutE()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphAXX_VX4X_inE": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{Vertices: gremlingo.T__.Has("name", gremlingo.P.Within("josh", "lop", "ripple"))})).V(p["vid4"]).InE()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphAXX_VX4X_out": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{Vertices: gremlingo.T__.Has("name", gremlingo.P.Within("josh", "lop", "ripple"))})).V(p["vid4"]).Out()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphAXX_VX4X_in": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{Vertices: gremlingo.T__.Has("name", gremlingo.P.Within("josh", "lop", "ripple"))})).V(p["vid4"]).In()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphAXX_VX4X_both": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{Vertices: gremlingo.T__.Has("name", gremlingo.P.Within("josh", "lop", "ripple"))})).V(p["vid4"]).Both()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphAXX_VX4X_bothE": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{Vertices: gremlingo.T__.Has("name", gremlingo.P.Within("josh", "lop", "ripple"))})).V(p["vid4"]).BothE()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphAXX_VX4X_localXbothE_limitX1XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{Vertices: gremlingo.T__.Has("name", gremlingo.P.Within("josh", "lop", "ripple"))})).V(p["vid4"]).Local(gremlingo.T__.BothE().Limit(1))}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphAXX_EX11X_bothV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{Vertices: gremlingo.T__.Has("name", gremlingo.P.Within("josh", "lop", "ripple"))})).E(p["eid11"]).BothV()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphAXX_EX12X_bothV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{Vertices: gremlingo.T__.Has("name", gremlingo.P.Within("josh", "lop", "ripple"))})).E(p["eid12"]).BothV()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphBXX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 1.0).HasLabel("knows"), gremlingo.T__.Has("weight", 0.4).HasLabel("created").OutV().Has("name", "marko"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphBXX_E": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 1.0).HasLabel("knows"), gremlingo.T__.Has("weight", 0.4).HasLabel("created").OutV().Has("name", "marko"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).E()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphBXX_VX1X_outE": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 1.0).HasLabel("knows"), gremlingo.T__.Has("weight", 0.4).HasLabel("created").OutV().Has("name", "marko"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V(p["vid1"]).OutE()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphBXX_VX1X_out": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 1.0).HasLabel("knows"), gremlingo.T__.Has("weight", 0.4).HasLabel("created").OutV().Has("name", "marko"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V(p["vid1"]).Out()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphBXX_VX1X_outXcreatedX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 1.0).HasLabel("knows"), gremlingo.T__.Has("weight", 0.4).HasLabel("created").OutV().Has("name", "marko"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V(p["vid1"]).Out("knows")}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphBXX_VX4X_outXcreatedX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 1.0).HasLabel("knows"), gremlingo.T__.Has("weight", 0.4).HasLabel("created").OutV().Has("name", "marko"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V(p["vid4"]).Out("created")}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphBXX_VX4X_outE": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 1.0).HasLabel("knows"), gremlingo.T__.Has("weight", 0.4).HasLabel("created").OutV().Has("name", "marko"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V(p["vid4"]).OutE()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphBXX_VX4X_out": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 1.0).HasLabel("knows"), gremlingo.T__.Has("weight", 0.4).HasLabel("created").OutV().Has("name", "marko"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V(p["vid4"]).Out()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphBXX_VX4X_bothE": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 1.0).HasLabel("knows"), gremlingo.T__.Has("weight", 0.4).HasLabel("created").OutV().Has("name", "marko"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V(p["vid4"]).BothE()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphBXX_VX4X_both": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 1.0).HasLabel("knows"), gremlingo.T__.Has("weight", 0.4).HasLabel("created").OutV().Has("name", "marko"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V(p["vid4"]).Both()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphBXX_VX4X_outV_outE": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 1.0).HasLabel("knows"), gremlingo.T__.Has("weight", 0.4).HasLabel("created").OutV().Has("name", "marko"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).E(p["eid8"]).OutV().OutE()}}, 
    "g_withStrategiesXSubgraphStrategyXvertices_inXknowsX_hasXname_markoXXX_V_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{Vertices: gremlingo.T__.In("knows").Has("name", "marko")})).V().Values("name")}}, 
    "g_withStrategiesXSubgraphStrategyXvertices_in_hasXname_markoXXX_V_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{Vertices: gremlingo.T__.In().Has("name", "marko")})).V().Values("name")}}, 
    "g_withStrategiesXSubgraphStrategyXvertices_inXknowsX_whereXoutXcreatedX_hasXname_lopXXXX_V_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{Vertices: gremlingo.T__.In("knows").Where(gremlingo.T__.Out("created").Has("name", "lop"))})).V().Values("name")}}, 
    "g_withStrategiesXSubgraphStrategyXvertices_in_hasXname_markoX_outXcreatedX_hasXname_lopXXXX_V_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{Vertices: gremlingo.T__.In().Where(gremlingo.T__.Has("name", "marko").Out("created").Has("name", "lop"))})).V().Values("name")}}, 
    "g_withStrategiesXSubgraphStrategyXvertices_orXboth_hasXname_markoX_hasXname_markoXXXX_V_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{Vertices: gremlingo.T__.Or(gremlingo.T__.Both().Has("name", "marko"), gremlingo.T__.Has("name", "marko"))})).V().Where(gremlingo.T__.BothE().Count().Is(gremlingo.P.Neq(0))).Values("name")}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphCXX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{Vertices: gremlingo.T__.Has("name", gremlingo.P.Within("josh", "lop", "ripple")), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphCXX_E": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{Vertices: gremlingo.T__.Has("name", gremlingo.P.Within("josh", "lop", "ripple")), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).E()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphCXX_VX4X_outE": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{Vertices: gremlingo.T__.Has("name", gremlingo.P.Within("josh", "lop", "ripple")), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V(p["vid4"]).OutE()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphCXX_VX4X_inE": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{Vertices: gremlingo.T__.Has("name", gremlingo.P.Within("josh", "lop", "ripple")), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V(p["vid4"]).InE()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphCXX_VX4X_out": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{Vertices: gremlingo.T__.Has("name", gremlingo.P.Within("josh", "lop", "ripple")), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V(p["vid4"]).Out()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphCXX_VX4X_in": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{Vertices: gremlingo.T__.Has("name", gremlingo.P.Within("josh", "lop", "ripple")), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V(p["vid4"]).In()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphCXX_VX4X_both": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{Vertices: gremlingo.T__.Has("name", gremlingo.P.Within("josh", "lop", "ripple")), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V(p["vid4"]).Both()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphCXX_VX4X_bothE": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{Vertices: gremlingo.T__.Has("name", gremlingo.P.Within("josh", "lop", "ripple")), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V(p["vid4"]).BothE()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphCXX_VX4X_localXbothE_limitX1XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{Vertices: gremlingo.T__.Has("name", gremlingo.P.Within("josh", "lop", "ripple")), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V(p["vid4"]).Local(gremlingo.T__.BothE().Limit(1))}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphCXX_EX11X_bothV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{Vertices: gremlingo.T__.Has("name", gremlingo.P.Within("josh", "lop", "ripple")), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).E(p["eid11"]).BothV()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphCXX_EX12X_bothV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{Vertices: gremlingo.T__.Has("name", gremlingo.P.Within("josh", "lop", "ripple")), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).E(p["eid12"]).BothV()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphCXX_EX9X_bothV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{Vertices: gremlingo.T__.Has("name", gremlingo.P.Within("josh", "lop", "ripple")), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).E(p["eid9"]).BothV()}}, 
    "g_withStrategiesXSubgraphStrategyXvertices_hasXname_withinXripple_josh_markoXXX_V_asXaX_out_in_asXbX_dedupXa_bX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{Vertices: gremlingo.T__.Has("name", gremlingo.P.Within("ripple", "josh", "marko"))})).V().As("a").Out().In().As("b").Dedup("a", "b").Values("name")}}, 
    "g_withStrategiesXSubgraphStrategyXvertexProperties_hasXstartTime_gtX2005XXXX_V_propertiesXlocationX_value": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{VertexProperties: gremlingo.T__.Has("startTime", gremlingo.P.Gt(2005))})).V().Properties("location").Value()}}, 
    "g_withStrategiesXSubgraphStrategyXvertexProperties_hasXstartTime_gtX2005XXXX_V_valuesXlocationX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{VertexProperties: gremlingo.T__.Has("startTime", gremlingo.P.Gt(2005))})).V().Values("location")}}, 
    "g_withStrategiesXSubgraphStrategyXvertexProperties_hasXstartTime_gtX2005XXXX_V_asXaX_propertiesXlocationX_asXbX_selectXaX_outE_properties_selectXbX_value_dedup": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{VertexProperties: gremlingo.T__.Has("startTime", gremlingo.P.Gt(2005))})).V().As("a").Properties("location").As("b").Select("a").OutE().Properties().Select("b").Value().Dedup()}}, 
    "g_withStrategiesXSubgraphStrategyXvertexProperties_hasXstartTime_gtX2005XXXX_V_asXaX_valuesXlocationX_asXbX_selectXaX_outE_properties_selectXbX_dedup": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{VertexProperties: gremlingo.T__.Has("startTime", gremlingo.P.Gt(2005))})).V().As("a").Values("location").As("b").Select("a").OutE().Properties().Select("b").Dedup()}}, 
    "g_withStrategiesXSubgraphStrategyXvertices_hasXname_neqXstephenXX_vertexProperties_hasXstartTime_gtX2005XXXX_V_propertiesXlocationX_value": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{VertexProperties: gremlingo.T__.Has("startTime", gremlingo.P.Gt(2005)), Vertices: gremlingo.T__.Has("name", gremlingo.P.Neq("stephen"))})).V().Properties("location").Value()}}, 
    "g_withStrategiesXSubgraphStrategyXvertices_hasXname_neqXstephenXX_vertexProperties_hasXstartTime_gtX2005XXXX_V_valuesXlocationX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{VertexProperties: gremlingo.T__.Has("startTime", gremlingo.P.Gt(2005)), Vertices: gremlingo.T__.Has("name", gremlingo.P.Neq("stephen"))})).V().Values("location")}}, 
    "g_withStrategiesXSubgraphStrategyXedges_hasLabelXusesX_hasXskill_5XXX_V_outE_valueMap_selectXvaluesX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{Edges: gremlingo.T__.HasLabel("uses").Has("skill", 5)})).V().OutE().ValueMap().Select(gremlingo.Column.Values).Unfold()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphDXX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: false, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within("josh", "lop", "ripple")), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphDXX_E": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: false, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within("josh", "lop", "ripple")), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).E()}}, 
    "g_withStrategiesXSubgraphStrategyXcheckAdjacentVertices_subgraphDXX_E": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within("josh", "lop", "ripple")), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).E()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphDXX_VX4X_outE": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: false, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within("josh", "lop", "ripple")), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V(p["vid4"]).OutE()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphDXX_VX4X_inE": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: false, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within("josh", "lop", "ripple")), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V(p["vid4"]).InE()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphDXX_VX4X_out": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: false, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within("josh", "lop", "ripple")), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V(p["vid4"]).Out()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphDXX_VX4X_in": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: false, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within("josh", "lop", "ripple")), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V(p["vid4"]).In()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphDXX_VX4X_both": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: false, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within("josh", "lop", "ripple")), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V(p["vid4"]).Both()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphDXX_VX4X_bothE": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: false, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within("josh", "lop", "ripple")), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V(p["vid4"]).BothE()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphDXX_VX4X_localXbothE_limitX1XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: false, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within("josh", "lop", "ripple")), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V(p["vid4"]).Local(gremlingo.T__.BothE().Limit(1))}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphDXX_EX11X_bothV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: false, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within("josh", "lop", "ripple")), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).E(p["eid11"]).BothV()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphDXX_EX12X_bothV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: false, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within("josh", "lop", "ripple")), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).E(p["eid12"]).BothV()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphDXX_EX9X_bothV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: false, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within("josh", "lop", "ripple")), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).E(p["eid9"]).BothV()}}, 
    "g_withStrategiesXSubgraphStrategyXcheckAdjacentVertices_subgraphDXX_EX9X_bothV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within("josh", "lop", "ripple")), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).E(p["eid9"]).BothV()}}, 
    "g_withStrategiesXVertexProgramRestrictionStrategyX_withoutStrategiesXVertexProgramStrategyX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.VertexProgramRestrictionStrategy()).WithoutStrategies(gremlingo.VertexProgramStrategy()).V()}}, 
    "g_withStrategiesXVertexProgramRestrictionStrategy_VertexProgramStrategyX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.VertexProgramRestrictionStrategy(), gremlingo.VertexProgramStrategy()).V()}}, 
    "g_withoutStrategiesXVertexProgramRestrictionStrategyX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithoutStrategies(gremlingo.VertexProgramRestrictionStrategy()).WithStrategies(gremlingo.VertexProgramStrategy()).V()}}, 
    "g_withStrategiesXVertexProgramStrategyX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.VertexProgramStrategy()).V()}}, 
    "g_withoutStrategiesXVertexProgramStrategyX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithoutStrategies(gremlingo.VertexProgramStrategy()).V()}}, 
    "g_VX1X_asXaX_outXcreatedX_addEXcreatedByX_toXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).As("a").Out("created").AddE("createdBy").To("a")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).InE()}}, 
    "g_VX1X_asXaX_outXcreatedX_addEXcreatedByX_toXaX_propertyXweight_2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).As("a").Out("created").AddE("createdBy").To("a").Property("weight", 2.0)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).BothE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).InE().Has("weight", 2.0)}}, 
    "g_V_outE_propertyXweight_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().OutE().Property("weight", nil)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Properties("weight")}}, 
    "g_V_aggregateXxX_asXaX_selectXxX_unfold_addEXexistsWithX_toXaX_propertyXtime_nowX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate("x").As("a").Select("x").Unfold().AddE("existsWith").To("a").Property("time", "now")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).BothE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).InE("existsWith")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE("existsWith")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).BothE("existsWith").Has("time", "now")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid2"]).BothE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid2"]).InE("existsWith")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid2"]).OutE("existsWith")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid2"]).BothE("existsWith").Has("time", "now")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid3"]).BothE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid3"]).InE("existsWith")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid3"]).OutE("existsWith")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid3"]).BothE("existsWith").Has("time", "now")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).BothE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).InE("existsWith")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).OutE("existsWith")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).BothE("existsWith").Has("time", "now")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid5"]).BothE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid5"]).InE("existsWith")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid5"]).OutE("existsWith")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid5"]).BothE("existsWith").Has("time", "now")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid6"]).BothE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid6"]).InE("existsWith")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid6"]).OutE("existsWith")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid6"]).BothE("existsWith").Has("time", "now")}}, 
    "g_V_asXaX_outXcreatedX_inXcreatedX_whereXneqXaXX_asXbX_addEXcodeveloperX_fromXaX_toXbX_propertyXyear_2009X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out("created").In("created").Where(gremlingo.P.Neq("a")).As("b").AddE("codeveloper").From("a").To("b").Property("year", 2009)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).BothE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).InE("codeveloper")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE("codeveloper")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).BothE("codeveloper").Has("year", 2009)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid2"]).BothE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).BothE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).InE("codeveloper")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).OutE("codeveloper")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).BothE("codeveloper").Has("year", 2009)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid6"]).BothE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid6"]).InE("codeveloper")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid6"]).OutE("codeveloper")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid6"]).BothE("codeveloper").Has("year", 2009)}}, 
    "g_V_asXaX_inXcreatedX_addEXcreatedByX_fromXaX_propertyXyear_2009X_propertyXacl_publicX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").In("created").AddE("createdBy").From("a").Property("year", 2009).Property("acl", "public")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).BothE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).InE("createdBy")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE("createdBy")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).BothE("createdBy").Has("year", 2009).Has("acl", "public")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid2"]).BothE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid3"]).BothE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid3"]).InE("createdBy")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid3"]).OutE("createdBy")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid3"]).BothE("createdBy").Has("year", 2009).Has("acl", "public")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).BothE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).InE("createdBy")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).OutE("createdBy")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).BothE("createdBy").Has("year", 2009).Has("acl", "public")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid5"]).BothE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid5"]).InE("createdBy")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid5"]).OutE("createdBy")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid5"]).BothE("createdBy").Has("year", 2009).Has("acl", "public")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid6"]).BothE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid6"]).InE("createdBy")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid6"]).OutE("createdBy")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid6"]).BothE("createdBy").Has("year", 2009).Has("acl", "public")}}, 
    "g_withSideEffectXb_bX_VXaX_addEXknowsX_toXbX_propertyXweight_0_5X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).AddE("knows").To("b").Property("weight", 0.5)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).BothE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).InE("knows")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE("knows")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).BothE("knows").Has("weight", 0.5)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid6"]).BothE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid6"]).InE("knows")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid6"]).OutE("knows")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid6"]).BothE("knows").Has("weight", 0.5)}}, 
    "g_addV_asXfirstX_repeatXaddEXnextX_toXaddVX_inVX_timesX5X_addEXnextX_toXselectXfirstXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV().As("first").Repeat(gremlingo.T__.AddE("next").To(gremlingo.T__.AddV()).InV()).Times(5).AddE("next").To(gremlingo.T__.Select("first"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("next")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Limit(1).BothE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Limit(1).InE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Limit(1).OutE()}}, 
    "g_V_hasXname_markoX_asXaX_outEXcreatedX_asXbX_inV_addEXselectXbX_labelX_toXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "marko").As("a").OutE("created").As("b").InV().AddE(gremlingo.T__.Select("b").Label()).To("a")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).BothE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).InE("created")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).In("created").Has("name", "lop")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE("created")}}, 
    "g_addEXV_outE_label_groupCount_orderXlocalX_byXvalues_descX_selectXkeysX_unfold_limitX1XX_fromXV_hasXname_vadasXX_toXV_hasXname_lopXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddE(gremlingo.T__.V().OutE().Label().GroupCount().Order(gremlingo.Scope.Local).By(gremlingo.Column.Values, gremlingo.Order.Desc).Select(gremlingo.Column.Keys).Unfold().Limit(1)).From(gremlingo.T__.V().Has("name", "vadas")).To(gremlingo.T__.V().Has("name", "lop"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid2"]).BothE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid2"]).InE("knows")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid2"]).OutE("created")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid2"]).Out("created").Has("name", "lop")}}, 
    "g_addEXknowsX_fromXVXvid1XX_toXVXvid6XX_propertyXweight_0_1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddE("knows").From(gremlingo.T__.V(p["vid1"])).To(gremlingo.T__.V(p["vid6"])).Property("weight", p["xx1"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE("knows")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out("knows").Has("name", "peter")}}, 
    "g_addEXknowsvarX_fromXVXvid1XX_toXVXvid6XX_propertyXweight_0_1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddE(p["xx1"]).From(gremlingo.T__.V(p["vid1"])).To(gremlingo.T__.V(p["vid6"])).Property("weight", p["xx2"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE("knows")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out("knows").Has("name", "peter")}}, 
    "g_VXaX_addEXknowsX_toXbX_propertyXweight_0_1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).AddE("knows").To(gremlingo.T__.V(p["vid6"])).Property("weight", p["xx1"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE("knows")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out("knows").Has("name", "peter")}}, 
    "g_addEXknowsXpropertyXweight_nullXfromXV_hasXname_markoXX_toXV_hasXname_vadasXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).AddV("person").Property("name", "vadas").Property("age", 27)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddE("knows").Property("weight", nil).From(gremlingo.T__.V().Has("name", "marko")).To(gremlingo.T__.V().Has("name", "vadas"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Has("knows", "weight", nil)}}, 
    "g_addEXknowsvarXpropertyXweight_nullXfromXV_hasXname_markoXX_toXV_hasXname_vadasXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).AddV("person").Property("name", "vadas").Property("age", 27)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddE(p["xx1"]).Property("weight", nil).From(gremlingo.T__.V().Has("name", "marko")).To(gremlingo.T__.V().Has("name", "vadas"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Has("knows", "weight", nil)}}, 
    "g_unionXaddEXknowsvarXpropertyXweight_nullXfromXV_hasXname_markoXX_toXV_hasXname_vadasXXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).AddV("person").Property("name", "vadas").Property("age", 27)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Union(gremlingo.T__.AddE(p["xx1"]).Property("weight", 1).From(gremlingo.T__.V().Has("name", "marko")).To(gremlingo.T__.V().Has("name", "vadas")))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Has("knows", "weight", 1)}}, 
    "g_addEXedgeX_fromXV_hasXname_markoXX_toXV_hasXname_vadasXX_propertyXweight_0_5X_withXkey_valueX_valuesXweight_keyX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).AddV("person").Property("name", "vadas").Property("age", 27)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddE("edge").From(gremlingo.T__.V().Has("name", "marko")).To(gremlingo.T__.V().Has("name", "vadas")).Property("weight", 0.5).With("key", "value").Values("weight", "key")}}, 
    "g_VX1X_addVXanimalX_propertyXage_selectXaX_byXageXX_propertyXname_puppyX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).As("a").AddV("animal").Property("age", gremlingo.T__.Select("a").By("age")).Property("name", "puppy")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("animal", "age", 29)}}, 
    "g_V_addVXanimalX_propertyXage_0X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().AddV("animal").Property("age", 0)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("animal", "age", 0)}}, 
    "g_V_addVXanimalvarX_propertyXage_0varX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().AddV(p["xx1"]).Property("age", p["xx2"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("animal", "age", 0)}}, 
    "g_addVXpersonX_propertyXname_stephenX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "stephen")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "stephen")}}, 
    "g_addVXpersonvarX_propertyXname_stephenvarX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV(p["xx1"]).Property("name", p["xx2"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "stephen")}}, 
    "g_V_hasLabelXpersonX_propertyXname_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Property(gremlingo.Cardinality.Single, "name", nil)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties("name")}}, 
    "g_addVXpersonX_propertyXsingle_name_stephenX_propertyXsingle_name_stephenmX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property(gremlingo.Cardinality.Single, "name", "stephen").Property(gremlingo.Cardinality.Single, "name", "stephenm")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "stephen")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "stephenm")}}, 
    "get_g_addVXpersonX_propertyXsingle_name_stephenX_propertyXsingle_name_stephenm_since_2010X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property(gremlingo.Cardinality.Single, "name", "stephen").Property(gremlingo.Cardinality.Single, "name", "stephenm", "since", 2010)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "stephen")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "stephenm")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "stephenm").Properties("name").Has("since", 2010)}}, 
    "g_V_hasXname_markoX_propertyXfriendWeight_outEXknowsX_weight_sum__acl_privateX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "marko").Property("friendWeight", gremlingo.T__.OutE("knows").Values("weight").Sum(), "acl", "private")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Has("friendWeight", 1.5)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Properties("friendWeight").Has("acl", "private")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Properties("friendWeight").Count()}}, 
    "g_addVXanimalX_propertyXname_mateoX_propertyXname_gateoX_propertyXname_cateoX_propertyXage_5X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("animal").Property("name", "mateo").Property("name", "gateo").Property("name", "cateo").Property("age", 5)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("animal").Has("name", "mateo").Has("name", "gateo").Has("name", "cateo").Has("age", 5)}}, 
    "g_withSideEffectXa_markoX_addV_propertyXname_selectXaXX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("a", "marko").AddV().Property("name", gremlingo.T__.Select("a")).Values("name")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "marko")}}, 
    "g_addVXpersonX_propertyXsingle_name_stephenX_propertyXsingle_name_stephenm_since_2010X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property(gremlingo.Cardinality.Single, "name", "stephen").Property(gremlingo.Cardinality.Single, "name", "stephenm", "since", 2010)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "stephen")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "stephenm")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "stephenm").Properties("name").Has("since", 2010)}}, 
    "g_V_addVXanimalX_propertyXname_valuesXnameXX_propertyXname_an_animalX_propertyXvaluesXnameX_labelX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().AddV("animal").Property("name", gremlingo.T__.Values("name")).Property("name", "an animal").Property(gremlingo.T__.Values("name"), gremlingo.T__.Label())}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("animal").Has("name", "marko").Has("name", "an animal").Has("marko", "person")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("animal").Has("name", "vadas").Has("name", "an animal").Has("vadas", "person")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("animal").Has("name", "lop").Has("name", "an animal").Has("lop", "software")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("animal").Has("name", "josh").Has("name", "an animal").Has("josh", "person")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("animal").Has("name", "ripple").Has("name", "an animal").Has("ripple", "software")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("animal").Has("name", "peter").Has("name", "an animal").Has("peter", "person")}}, 
    "g_withSideEffectXa_testX_V_hasLabelXsoftwareX_propertyXtemp_selectXaXX_valueMapXname_tempX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("a", "test").V().HasLabel("software").Property("temp", gremlingo.T__.Select("a")).ValueMap("name", "temp")}}, 
    "g_withSideEffectXa_nameX_addV_propertyXselectXaX_markoX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("a", "name").AddV().Property(gremlingo.T__.Select("a"), "marko").Values("name")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "marko")}}, 
    "g_V_asXaX_hasXname_markoX_outXcreatedX_asXbX_addVXselectXaX_labelX_propertyXtest_selectXbX_labelX_valueMap_withXtokensX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Has("name", "marko").Out("created").As("b").AddV(gremlingo.T__.Select("a").Label()).Property("test", gremlingo.T__.Select("b").Label()).ValueMap().With(gremlingo.WithOptions.Tokens)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "test", "software")}}, 
    "g_addVXV_hasXname_markoX_propertiesXnameX_keyX_label": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV(gremlingo.T__.V().Has("name", "marko").Properties("name").Key()).Label()}}, 
    "g_addV_propertyXlabel_personX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV().Property(gremlingo.T.Label, "person")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person")}}, 
    "g_addV_propertyXlabel_personvarX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV().Property(gremlingo.T.Label, p["xx1"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person")}}, 
    "g_addV_propertyXid_1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV().Property(gremlingo.T.Id, 1)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasId("1")}}, 
    "g_addV_propertyXidvar_1varX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV().Property(gremlingo.T.Id, p["xx1"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasId("1")}}, 
    "g_addV_propertyXmapX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV().Property(map[interface{}]interface{}{"name": "foo", "age": 42 })}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "foo")}}, 
    "g_addV_propertyXsingle_mapX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV().Property(gremlingo.Cardinality.Single, map[interface{}]interface{}{"name": "foo", "age": 42 })}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "foo")}}, 
    "g_V_hasXname_fooX_propertyXname_setXbarX_age_43X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV().Property(gremlingo.Cardinality.Single, "name", "foo").Property("age", 42)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "foo").Property(map[interface{}]interface{}{"name": gremlingo.CardinalityValue.Set("bar"), "age": 43 })}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "foo")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "bar")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("age", 43)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("age", 42)}}, 
    "g_V_hasXname_fooX_propertyXset_name_bar_age_singleX43XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV().Property(gremlingo.Cardinality.Single, "name", "foo").Property("age", 42)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "foo").Property(gremlingo.Cardinality.Set, map[interface{}]interface{}{"name": "bar", "age": gremlingo.CardinalityValue.Single(43) })}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "foo")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "bar")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("age", 43)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("age", 42)}}, 
    "g_addV_propertyXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property(nil)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Values()}}, 
    "g_addV_propertyXemptyX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property(map[interface{}]interface{}{ })}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Values()}}, 
    "g_addV_propertyXset_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("foo").Property(gremlingo.Cardinality.Set, nil)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("foo").Values()}}, 
    "g_addV_propertyXset_emptyX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("foo").Property(gremlingo.Cardinality.Set, map[interface{}]interface{}{ })}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Values()}}, 
    "g_addVXpersonX_propertyXname_joshX_propertyXage_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "josh").Property("age", nil)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "age", nil)}}, 
    "g_addVXpersonX_propertyXname_markoX_propertyXfriendWeight_null_acl_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("friendWeight", nil, "acl", nil)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Has("friendWeight", nil)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Properties("friendWeight").Has("acl", nil)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Properties("friendWeight").Count()}}, 
    "g_V_hasXperson_name_aliceX_propertyXsingle_age_unionXage_constantX1XX_sumX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "alice").Property(gremlingo.Cardinality.Single, "age", 50)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "alice").Property("age", gremlingo.T__.Union(gremlingo.T__.Values("age"), gremlingo.T__.Constant(1)).Sum())}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "age", 50)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "age", 51)}}, 
    "g_V_limitX3X_addVXsoftwareX_aggregateXa1X_byXlabelX_aggregateXa2X_byXlabelX_capXa1_a2X_selectXa_bX_byXunfoldX_foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Limit(3).AddV("software").Aggregate("a1").By(gremlingo.T.Label).Aggregate("a2").By(gremlingo.T.Label).Cap("a1", "a2").Select("a1", "a2").By(gremlingo.T__.Unfold().Fold())}}, 
    "g_addV_propertyXname_markoX_withXkey_valueX_valuesXname_keyX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV().Property("name", "marko").With("key", "value").Values("name", "key")}}, 
    "g_addV_propertyXname_marko_since_2010X_withXkey_valueX_propertiesXnameX_valuesXsince_keyX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV().Property("name", "marko", "since", 2010).With("key", "value").Properties("name").Values("since", "key")}}, 
    "g_injectX1X_asBool": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).AsBool()}}, 
    "g_injectX3_14X_asBool": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(3.14).AsBool()}}, 
    "g_injectXneg_1X_asBool": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(-1).AsBool()}}, 
    "g_injectX0X_asBool": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(0).AsBool()}}, 
    "g_injectXneg_0X_asBool": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(-0.0).AsBool()}}, 
    "g_injectXNaNX_asBool": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(math.NaN()).AsBool()}}, 
    "g_injectXbool_trueX_asBool": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(true).AsBool()}}, 
    "g_injectXfalseX_asBool": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(false).AsBool()}}, 
    "g_injectXtrueX_asBool": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("true").AsBool()}}, 
    "g_injectXmixed_trueX_asBool": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("tRUe").AsBool()}}, 
    "g_injectXnullX_asBool": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(nil).AsBool()}}, 
    "g_injectXhelloX_asBool": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("hello").AsBool()}}, 
    "g_injectX1_2X_asBool": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{1, 2}).AsBool()}}, 
    "g_VXX_localX_outE_countX_asBool": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Local(gremlingo.T__.OutE().Count()).AsBool()}}, 
    "g_V_sackXassignX_byX_hasLabelXpersonX_count_asBoolX_sackXandX_byX_outE_count_asBoolX_sack_path": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Sack(gremlingo.Operator.Assign).By(gremlingo.T__.HasLabel("person").Count().AsBool()).Sack(gremlingo.Operator.And).By(gremlingo.T__.OutE().Count().AsBool()).Sack().Path()}}, 
    "g_injectXstrX_asDate": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("2023-08-02T00:00:00Z").AsDate()}}, 
    "g_injectXstr_offsetX_asDate": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("2023-08-02T00:00:00-07:00").AsDate()}}, 
    "g_injectX1694017707000X_asDate": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1694017707000).AsDate()}}, 
    "g_injectX1694017708000LX_asDate": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(int64(1694017708000)).AsDate()}}, 
    "g_injectX1694017709000dX_asDate": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1694017709000.1).AsDate()}}, 
    "g_injectX1_2X_asDate": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{1, 2}).AsDate()}}, 
    "g_injectXnullX_asDate": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(nil).AsDate()}}, 
    "g_injectXinvalidstrX_asDate": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("This String is not an ISO 8601 Date").AsDate()}}, 
    "g_V_valuesXbirthdayX_asDate_asNumber_asDate": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "alice").Property("birthday", "2020-08-02").AddV("person").Property("name", "john").Property("birthday", "1988-12-10").AddV("person").Property("name", "charlie").Property("birthday", "2002-02-01").AddV("person").Property("name", "suzy").Property("birthday", "1965-10-31")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("birthday").AsDate().AsNumber().AsDate()}}, 
    "g_injectX5bX_asNumber": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(int8(5)).AsNumber()}}, 
    "g_injectX5sX_asNumber": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(int16(5)).AsNumber()}}, 
    "g_injectX5iX_asNumber": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(int32(5)).AsNumber()}}, 
    "g_injectX5lX_asNumber": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(int64(5)).AsNumber()}}, 
    "g_injectX5nX_asNumber": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(gremlingo.ParseBigInt("5")).AsNumber()}}, 
    "g_injectX5_0X_asNumber": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(5.0).AsNumber()}}, 
    "g_injectX5_75fX_asNumber": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(float32(5.75)).AsNumber()}}, 
    "g_injectX5X_asNumber": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("5").AsNumber()}}, 
    "g_injectXtestX_asNumber": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("test").AsNumber()}}, 
    "g_injectX_1_2_3_4X_asNumber": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{1, 2, 3, 4}).AsNumber()}}, 
    "g_injectX1_2_3_4X_unfold_asNumber": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{1, 2, 3, 4}).Unfold().AsNumber()}}, 
    "g_injectX_1__2__3__4_X_asNumberXX_foldXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("1", 2, "3", 4).AsNumber().Fold()}}, 
    "g_injectX5_43X_asNumberXGType_INTX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(5.43).AsNumber(gremlingo.GType.Int)}}, 
    "g_injectX5_67X_asNumberXGType_INTX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(5.67).AsNumber(gremlingo.GType.Int)}}, 
    "g_injectX5X_asNumberXGType_LONGX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(5).AsNumber(gremlingo.GType.Long)}}, 
    "g_injectX12X_asNumberXGType_BYTEX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(12).AsNumber(gremlingo.GType.Byte)}}, 
    "g_injectX32768X_asNumberXGType_SHORTX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(32768).AsNumber(gremlingo.GType.Short)}}, 
    "g_injectX300X_asNumberXGType_BYTEX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(300).AsNumber(gremlingo.GType.Byte)}}, 
    "g_injectX32768X_asNumberXGType_VertexX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(32768).AsNumber(gremlingo.GType.Vertex)}}, 
    "g_injectX5X_asNumberXGType_BYTEX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("5").AsNumber(gremlingo.GType.Byte)}}, 
    "g_injectX1_000X_asNumberXGType_BIGINTX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("1,000").AsNumber(gremlingo.GType.BigInt)}}, 
    "g_injectX1_2_3_4_0x5X_asNumber_sum_asNumberXGType_BYTEX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0, 2, 3, "4", "0x5").AsNumber().Sum().AsNumber(gremlingo.GType.Byte)}}, 
    "g_injectXnullX_asNumberXGType_INTX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(nil).AsNumber(gremlingo.GType.Int)}}, 
    "g_V_asXaX_outXknowsX_asXbX_mathXa_plus_bX_byXageX_asNumberXGType_INTX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out("knows").As("b").Math("a + b").By("age").AsNumber(gremlingo.GType.Int)}}, 
    "g_withSideEffectXx_100X_V_age_mathX__plus_xX_asNumberXGType_LONGX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("x", 100).V().Values("age").Math("_ + x").AsNumber(gremlingo.GType.Long)}}, 
    "g_V_valuesXageX_asString_asNumberXGType_DOUBLEX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").AsString().AsNumber(gremlingo.GType.Double)}}, 
    "g_V_valuesXbirthdayX_asNumber_asDate_asNumber": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "alice").Property("birthday", 1596326400000).AddV("person").Property("name", "john").Property("birthday", 597715200000).AddV("person").Property("name", "charlie").Property("birthday", 1012521600000).AddV("person").Property("name", "suzy").Property("birthday", -131587200000)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("birthday").AsNumber().AsDate().AsNumber()}}, 
    "g_injectX1_2X_asString": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1, 2).AsString()}}, 
    "g_injectX1_2X_asStringXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1, 2).AsString(gremlingo.Scope.Local)}}, 
    "g_injectXlist_1_2X_asStringXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{1, 2}).AsString(gremlingo.Scope.Local)}}, 
    "g_injectX1_nullX_asString": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(nil, 1).AsString()}}, 
    "g_injectX1_nullX_asStringXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{1, nil}).AsString(gremlingo.Scope.Local)}}, 
    "g_V_valueMapXnameX_asString": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap("name").AsString()}}, 
    "g_V_valueMapXnameX_order_fold_asStringXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap("name").Order().Fold().AsString(gremlingo.Scope.Local)}}, 
    "g_V_asString": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().AsString()}}, 
    "g_V_fold_asStringXlocalX_orderXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Fold().AsString(gremlingo.Scope.Local).Order(gremlingo.Scope.Local)}}, 
    "g_E_asString": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().AsString()}}, 
    "g_V_properties": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties().AsString()}}, 
    "g_V_hasLabelXpersonX_valuesXageX_asString": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Values("age").AsString()}}, 
    "g_V_hasLabelXpersonX_valuesXageX_order_fold_asStringXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Values("age").Order().Fold().AsString(gremlingo.Scope.Local)}}, 
    "g_V_hasLabelXpersonX_valuesXageX_asString_concatX_years_oldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Values("age").AsString().Concat(" years old")}}, 
    "g_call": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Call()}}, 
    "g_callXlistX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Call("--list")}}, 
    "g_callXlistX_withXstring_stringX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Call("--list").With("service", "tinker.search")}}, 
    "g_callXlistX_withXstring_traversalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Call("--list").With("service", gremlingo.T__.Constant("tinker.search"))}}, 
    "g_callXlist_mapX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Call("--list", p["xx1"])}}, 
    "g_callXlist_traversalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Call("--list", gremlingo.T__.Project("service").By(gremlingo.T__.Constant("tinker.search")))}}, 
    "g_callXlist_map_traversalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Call("--list", p["xx1"], gremlingo.T__.Project("service").By(gremlingo.T__.Constant("tinker.search")))}}, 
    "g_callXsearch_mapX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Call("tinker.search", p["xx1"]).Element()}}, 
    "g_callXsearch_traversalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Call("tinker.search", gremlingo.T__.Project("search").By(gremlingo.T__.Constant("vada"))).Element()}}, 
    "g_callXsearchX_withXstring_stringX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Call("tinker.search").With("search", "vada").Element()}}, 
    "g_callXsearchX_withXstring_traversalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Call("tinker.search").With("search", gremlingo.T__.Constant("vada")).Element()}}, 
    "g_callXsearch_mapX_withXstring_VertexX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Call("tinker.search", p["xx1"]).With("type", "Vertex").Element()}}, 
    "g_callXsearch_mapX_withXstring_EdgeX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Call("tinker.search", p["xx1"]).With("type", "Edge").Element()}}, 
    "g_callXsearch_mapX_withXstring_VertexPropertyX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Call("tinker.search", p["xx1"]).With("type", "VertexProperty").Element()}}, 
    "g_V_callXdcX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("v").Call("tinker.degree.centrality").Project("vertex", "degree").By(gremlingo.T__.Select("v")).By()}}, 
    "g_V_whereXcallXdcXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Where(gremlingo.T__.Call("tinker.degree.centrality").Is(3))}}, 
    "g_V_callXdcX_withXdirection_OUTX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("v").Call("tinker.degree.centrality").With("direction", gremlingo.Direction.Out).Project("vertex", "degree").By(gremlingo.T__.Select("v")).By()}}, 
    "g_V_callXdc_mapX_withXdirection_OUTX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("v").Call("tinker.degree.centrality", p["xx1"]).With("direction", gremlingo.Direction.Out).Project("vertex", "degree").By(gremlingo.T__.Select("v")).By()}}, 
    "g_V_callXdc_traversalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("v").Call("tinker.degree.centrality", gremlingo.T__.Project("direction").By(gremlingo.T__.Constant(gremlingo.Direction.Out))).Project("vertex", "degree").By(gremlingo.T__.Select("v")).By()}}, 
    "g_V_callXdc_map_traversalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("v").Call("tinker.degree.centrality", p["xx1"], gremlingo.T__.Project("direction").By(gremlingo.T__.Constant(gremlingo.Direction.Out))).Project("vertex", "degree").By(gremlingo.T__.Select("v")).By()}}, 
    "g_V_coalesceXoutXfooX_outXbarXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Coalesce(gremlingo.T__.Out("foo"), gremlingo.T__.Out("bar"))}}, 
    "g_VX1X_coalesceXoutXknowsX_outXcreatedXX_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Coalesce(gremlingo.T__.Out("knows"), gremlingo.T__.Out("created")).Values("name")}}, 
    "g_VX1X_coalesceXoutXcreatedX_outXknowsXX_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Coalesce(gremlingo.T__.Out("created"), gremlingo.T__.Out("knows")).Values("name")}}, 
    "g_V_coalesceXoutXlikesX_outXknowsX_inXcreatedXX_groupCount_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Coalesce(gremlingo.T__.Out("likes"), gremlingo.T__.Out("knows"), gremlingo.T__.Out("created")).GroupCount().By("name")}}, 
    "g_V_coalesceXoutEXknowsX_outEXcreatedXX_otherV_path_byXnameX_byXlabelX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Coalesce(gremlingo.T__.OutE("knows"), gremlingo.T__.OutE("created")).OtherV().Path().By("name").By(gremlingo.T.Label)}}, 
    "g_V_outXcreatedX_order_byXnameX_coalesceXname_constantXxXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out("created").Order().By("name").Coalesce(gremlingo.T__.Values("name"), gremlingo.T__.Constant("x"))}}, 
    "g_injectXnullX_combineXinjectX1XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(nil).Combine(gremlingo.T__.Inject(1))}}, 
    "g_V_valuesXnameX_combineXV_foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Combine(gremlingo.T__.V().Fold())}}, 
    "g_V_fold_combineXconstantXnullXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Fold().Combine(gremlingo.T__.Constant(nil))}}, 
    "g_V_fold_combineXVX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Fold().Combine(gremlingo.T__.V())}}, 
    "g_V_valuesXnameX_fold_combineX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Fold().Combine(2)}}, 
    "g_V_valuesXnameX_fold_combineXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Fold().Combine(nil)}}, 
    "g_V_valuesXnonexistantX_fold_combineXV_valuesXnameX_foldX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("nonexistant").Fold().Combine(gremlingo.T__.V().Values("name").Fold()).Unfold()}}, 
    "g_V_valuesXnameX_fold_combineXV_valuesXnonexistantX_foldX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Fold().Combine(gremlingo.T__.V().Values("nonexistant").Fold()).Unfold()}}, 
    "g_V_valuesXageX_order_byXdescX_fold_combineXV_valuesXageX_order_byXdescX_foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Order().By(gremlingo.Order.Desc).Fold().Combine(gremlingo.T__.V().Values("age").Order().By(gremlingo.Order.Desc).Fold())}}, 
    "g_V_out_path_byXvaluesXnameX_toUpperX_combineXMARKOX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Path().By(gremlingo.T__.Values("name").ToUpper()).Combine([]interface{}{"MARKO"})}}, 
    "g_injectXxx1X_combineXV_valuesXnameX_foldX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{"marko"}).Combine(gremlingo.T__.V().Values("name").Fold()).Unfold()}}, 
    "g_V_valueMapXlocationX_selectXvaluesX_unfold_combineXseattle_vancouverX_orderXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap("location").Select(gremlingo.Column.Values).Unfold().Combine([]interface{}{"seattle", "vancouver"}).Order(gremlingo.Scope.Local)}}, 
    "g_V_out_out_path_byXnameX_combineXempty_listX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Out().Path().By("name").Combine([]interface{}{})}}, 
    "g_V_valuesXageX_order_fold_combineXconstantX27X_foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Order().Fold().Combine(gremlingo.T__.Constant(27).Fold())}}, 
    "g_V_out_out_path_byXnameX_combineXdave_kelvinX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Out().Path().By("name").Combine([]interface{}{"dave", "kelvin"})}}, 
    "g_injectXa_null_bX_combineXa_cX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{"a", nil, "b"}).Combine([]interface{}{"a", "c"})}}, 
    "g_injectXa_null_bX_combineXa_null_cX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{"a", nil, "b"}).Combine([]interface{}{"a", nil, "c"})}}, 
    "g_injectX3_threeX_combineXfive_three_7X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{3, "three"}).Combine([]interface{}{"five", "three", int32(7)})}}, 
    "g_injectXa_bX_concat": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("a", "b").Concat()}}, 
    "g_injectXa_bX_concat_XcX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("a", "b").Concat("c")}}, 
    "g_injectXa_bX_concat_Xc_dX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("a", "b").Concat("c", "d")}}, 
    "g_injectXa_bX_concat_Xinject_c_dX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("a", "b").Concat(gremlingo.T__.Inject("c"))}}, 
    "g_injectXaX_concat_Xinject_List_b_cX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("a").Concat(gremlingo.T__.Inject([]interface{}{"b", "c"}))}}, 
    "g_injectXListXa_bXcX_concat_XdX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{"a", "b"}, "c").Concat("d")}}, 
    "g_injectXnullX_concat_XinjectX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(nil).Concat()}}, 
    "g_injectXnull_aX_concat_Xnull_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(nil, "a").Concat(nil, "b")}}, 
    "g_injectXhello_hiX_concatXV_values_order_byXnameX_valuesXnameXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("hello", "hi").Concat(gremlingo.T__.V().Order().By("name").Values("name"))}}, 
    "g_V_hasLabel_value_concat_X_X_concat_XpersonX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Values("name").Concat(" ").Concat("person")}}, 
    "g_hasLabelXpersonX_valuesXnameX_asXaX_constantXMrX_concatXselectXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Values("name").As("a").Constant("Mr.").Concat(gremlingo.T__.Select("a"))}}, 
    "g_hasLabelXsoftwareX_asXaX_valuesXnameX_concatXunsesX_concatXselectXaXvaluesXlangX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("software").As("a").Values("name").Concat(" uses ").Concat(gremlingo.T__.Select("a").Values("lang"))}}, 
    "g_VX1X_outE_asXaX_VX1X_valuesXnamesX_concatXselectXaX_labelX_concatXselectXaX_inV_valuesXnameXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE().As("a").V(p["vid1"]).Values("name").Concat(gremlingo.T__.Select("a").Label()).Concat(gremlingo.T__.Select("a").InV().Values("name"))}}, 
    "g_VX1X_outE_asXaX_VX1X_valuesXnamesX_concatXselectXaX_label_selectXaX_inV_valuesXnameXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE().As("a").V(p["vid1"]).Values("name").Concat(gremlingo.T__.Select("a").Label(), gremlingo.T__.Select("a").InV().Values("name"))}}, 
    "g_addVXconstantXprefix_X_concatXVX1X_labelX_label": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV(gremlingo.T__.Constant("prefix_").Concat(gremlingo.T__.V(p["vid1"]).Label())).Label()}}, 
    "g_injectXnullX_conjoinX1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(nil).Conjoin("1")}}, 
    "g_V_valuesXnameX_conjoinX1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Conjoin("1")}}, 
    "g_V_valuesXnonexistantX_fold_conjoinX_X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("nonexistant").Fold().Conjoin(";")}}, 
    "g_V_valuesXnameX_order_fold_conjoinX_X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Order().Fold().Conjoin("_")}}, 
    "g_V_valuesXageX_order_fold_conjoinX_X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Order().Fold().Conjoin(";")}}, 
    "g_V_out_path_byXvaluesXnameX_toUpperX_conjoinXMARKOX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Path().By(gremlingo.T__.Values("name").ToUpper()).Conjoin("MARKO")}}, 
    "g_injectXmarkoX_conjoinX_X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{"marko"}).Conjoin("-")}}, 
    "g_V_valueMapXlocationX_selectXvaluesX_unfold_orderXlocalX_conjoinX1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap("location").Select(gremlingo.Column.Values).Unfold().Order(gremlingo.Scope.Local).Conjoin("1")}}, 
    "g_V_out_out_path_byXnameX_conjoinXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Out().Path().By("name").Conjoin("")}}, 
    "g_injectXa_null_bX_conjoinXxyzX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{"a", nil, "b"}).Conjoin("xyz")}}, 
    "g_injectX3_threeX_conjoinX_X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{int32(3), "three"}).Conjoin(";")}}, 
    "g_V_connectedComponent_hasXcomponentX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ConnectedComponent().Has("gremlin.connectedComponentVertexProgram.component")}}, 
    "g_V_dedup_connectedComponent_hasXcomponentX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Dedup().ConnectedComponent().Has("gremlin.connectedComponentVertexProgram.component")}}, 
    "g_V_hasLabelXsoftwareX_connectedComponent_project_byXnameX_byXcomponentX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("software").ConnectedComponent().Project("name", "component").By("name").By("gremlin.connectedComponentVertexProgram.component")}}, 
    "g_V_connectedComponent_withXEDGES_bothEXknowsXX_withXPROPERTY_NAME_clusterX_project_byXnameX_byXclusterX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").ConnectedComponent().With("~tinkerpop.connectedComponent.edges", gremlingo.T__.BothE("knows")).With("~tinkerpop.connectedComponent.propertyName", "cluster").Project("name", "cluster").By("name").By("cluster")}}, 
    "g_V_constantX123X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Constant(123)}}, 
    "g_V_constantXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Constant(nil)}}, 
    "g_V_chooseXhasLabelXpersonX_valuesXnameX_constantXinhumanXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Choose(gremlingo.T__.HasLabel("person"), gremlingo.T__.Values("name"), gremlingo.T__.Constant("inhuman"))}}, 
    "g_V_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Count()}}, 
    "g_V_out_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Count()}}, 
    "g_V_both_both_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Both().Both().Count()}}, 
    "g_V_fold_countXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Fold().Count(gremlingo.Scope.Local)}}, 
    "g_V_hasXnoX_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("no").Count()}}, 
    "g_V_whereXinXkknowsX_outXcreatedX_count_is_0XX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Where(gremlingo.T__.In("knows").Out("created").Count().Is(0)).Values("name")}}, 
    "g_V_repeatXoutX_timesX8X_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Out()).Times(8).Count()}}, 
    "g_V_repeatXoutX_timesX5X_asXaX_outXwrittenByX_asXbX_selectXa_bX_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Out()).Times(5).As("a").Out("writtenBy").As("b").Select("a", "b").Count()}}, 
    "g_V_repeatXoutX_timesX3X_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Out()).Times(3).Count()}}, 
    "g_V_order_byXlangX_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Order().By("lang").Count()}}, 
    "g_E_sampleX1X_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Sample(1).Count()}}, 
    "g_V_sampleX1X_byXageX_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Sample(1).By("age").Count()}}, 
    "g_V_order_byXnoX_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Order().By("no").Count()}}, 
    "g_V_group_byXlabelX_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group().By(gremlingo.T.Label).Count()}}, 
    "g_V_group_byXlabelX_countXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group().By(gremlingo.T.Label).Count(gremlingo.Scope.Local)}}, 
    "g_injectXdatetimeXstrXX_dateAddXDT_hour_2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(time.Date(2023, 8, 2, 0, 0, 0, 0, time.FixedZone("UTC+00:00", 0)), time.Date(2023, 8, 2, 0, 0, 0, 0, time.FixedZone("UTC+00:00", 0))).DateAdd(gremlingo.DT.Hour, 2)}}, 
    "g_injectXdatetimeXstrXX_dateAddXhour_2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(time.Date(2023, 8, 2, 0, 0, 0, 0, time.FixedZone("UTC+00:00", 0)), time.Date(2023, 8, 2, 0, 0, 0, 0, time.FixedZone("UTC+00:00", 0))).DateAdd(gremlingo.DT.Hour, 2)}}, 
    "g_injectXdatetimeXstrXX_dateAddXhour_1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(time.Date(2023, 8, 2, 0, 0, 0, 0, time.FixedZone("UTC+00:00", 0)), time.Date(2023, 8, 2, 0, 0, 0, 0, time.FixedZone("UTC+00:00", 0))).DateAdd(gremlingo.DT.Hour, -1)}}, 
    "g_injectXdatetimeXstrXX_dateAddXminute_10X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(time.Date(2023, 8, 2, 0, 0, 0, 0, time.FixedZone("UTC+00:00", 0)), time.Date(2023, 8, 2, 0, 0, 0, 0, time.FixedZone("UTC+00:00", 0))).DateAdd(gremlingo.DT.Minute, 10)}}, 
    "g_injectXdatetimeXstrXX_dateAddXsecond_20X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(time.Date(2023, 8, 2, 0, 0, 0, 0, time.FixedZone("UTC+00:00", 0)), time.Date(2023, 8, 2, 0, 0, 0, 0, time.FixedZone("UTC+00:00", 0))).DateAdd(gremlingo.DT.Second, 20)}}, 
    "g_injectXdatetimeXstrXX_dateAddXday_11X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(time.Date(2023, 9, 6, 0, 0, 0, 0, time.FixedZone("UTC+00:00", 0)), time.Date(2023, 9, 6, 0, 0, 0, 0, time.FixedZone("UTC+00:00", 0))).DateAdd(gremlingo.DT.Day, 11)}}, 
    "g_injectXdatetimeXstr1XX_dateDiffXdatetimeXstr2XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(time.Date(2023, 8, 2, 0, 0, 0, 0, time.FixedZone("UTC+00:00", 0)), time.Date(2023, 8, 2, 0, 0, 0, 0, time.FixedZone("UTC+00:00", 0))).DateDiff(time.Date(2023, 8, 9, 0, 0, 0, 0, time.FixedZone("UTC+00:00", 0)))}}, 
    "g_injectXdatetimeXstr1XX_dateDiffXconstantXdatetimeXstr2XXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(time.Date(2023, 8, 8, 0, 0, 0, 0, time.FixedZone("UTC+00:00", 0)), time.Date(2023, 8, 8, 0, 0, 0, 0, time.FixedZone("UTC+00:00", 0))).DateDiff(gremlingo.T__.Constant(time.Date(2023, 8, 1, 0, 0, 0, 0, time.FixedZone("UTC+00:00", 0))))}}, 
    "g_injectXdatetimeXstr1XX_dateDiffXinjectXdatetimeXstr2XXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(time.Date(2023, 8, 8, 0, 0, 0, 0, time.FixedZone("UTC+00:00", 0)), time.Date(2023, 8, 8, 0, 0, 0, 0, time.FixedZone("UTC+00:00", 0))).DateDiff(gremlingo.T__.Inject(time.Date(2023, 10, 11, 0, 0, 0, 0, time.FixedZone("UTC+00:00", 0))))}}, 
    "g_V_valuesXbirthdayX_asDate_dateDiffXdatetimeX19700101T0000ZXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "alice").Property("birthday", "1596326400000").AddV("person").Property("name", "john").Property("birthday", "597715200000").AddV("person").Property("name", "charlie").Property("birthday", "1012521600000").AddV("person").Property("name", "suzy").Property("birthday", "-131587200000")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("birthday").AsNumber().AsDate().DateDiff(time.Date(1970, 1, 1, 0, 0, 0, 0, time.FixedZone("UTC+00:00", 0)))}}, 
    "g_V_hasXname_aliceX_valuesXbirthdayX_asDate_dateDiffXconstantXnullXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "alice").Property("birthday", 1596326400000)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "alice").Values("birthday").AsDate().DateDiff(gremlingo.T__.Constant(nil))}}, 
    "g_injectXnullX_differenceXinjectX1XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(nil).Difference(gremlingo.T__.Inject(1))}}, 
    "g_V_valuesXnameX_differenceXV_foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Difference(gremlingo.T__.V().Fold())}}, 
    "g_V_fold_differenceXconstantXnullXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Fold().Difference(gremlingo.T__.Constant(nil))}}, 
    "g_V_fold_differenceXVX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Fold().Difference(gremlingo.T__.V())}}, 
    "g_V_valuesXnameX_fold_differenceX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Fold().Difference(2)}}, 
    "g_V_valuesXnameX_fold_differenceXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Fold().Difference(nil)}}, 
    "g_V_valuesXnonexistantX_fold_differenceXV_valuesXnameX_foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("nonexistant").Fold().Difference(gremlingo.T__.V().Values("name").Fold())}}, 
    "g_V_valuesXnameX_fold_differenceXV_valuesXnonexistantX_foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Fold().Difference(gremlingo.T__.V().Values("nonexistant").Fold())}}, 
    "g_V_valuesXageX_fold_differenceXV_valuesXageX_foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Fold().Difference(gremlingo.T__.V().Values("age").Fold())}}, 
    "g_V_out_path_byXvaluesXnameX_toUpperX_differenceXMARKOX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Path().By(gremlingo.T__.Values("name").ToUpper()).Difference([]interface{}{"MARKO"})}}, 
    "g_injectXmarkoX_differenceXV_valuesXnameX_foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{"marko"}).Difference(gremlingo.T__.V().Values("name").Fold())}}, 
    "g_V_valueMapXlocationX_selectXvaluesX_unfold_differenceXseattle_vancouverX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap("location").Select(gremlingo.Column.Values).Unfold().Difference([]interface{}{"seattle", "vancouver"})}}, 
    "g_V_out_out_path_byXnameX_differenceXrippleX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Out().Path().By("name").Difference([]interface{}{"ripple"})}}, 
    "g_V_out_out_path_byXnameX_differenceXempty_listX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Out().Path().By("name").Difference([]interface{}{})}}, 
    "g_V_valuesXageX_fold_differenceXconstantX27X_foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Fold().Difference(gremlingo.T__.Constant(27).Fold())}}, 
    "g_V_out_out_path_byXnameX_differenceXdave_kelvinX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Out().Path().By("name").Difference([]interface{}{"dave", "kelvin"})}}, 
    "g_injectXa_null_bX_differenceXa_cX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{"a", nil, "b"}).Difference([]interface{}{"a", "c"})}}, 
    "g_injectXa_null_bX_differenceXa_null_cX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{"a", nil, "b"}).Difference([]interface{}{"a", nil, "c"})}}, 
    "g_injectX3_threeX_differenceXfive_three_7X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{3, "three"}).Difference([]interface{}{"five", "three", int32(7)})}}, 
    "g_injectXnullX_disjunctXinjectX1XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(nil).Disjunct(gremlingo.T__.Inject(1))}}, 
    "g_V_valuesXnameX_disjunctXV_foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Disjunct(gremlingo.T__.V().Fold())}}, 
    "g_V_fold_disjunctXconstantXnullXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Fold().Disjunct(gremlingo.T__.Constant(nil))}}, 
    "g_V_fold_disjunctXVX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Fold().Disjunct(gremlingo.T__.V())}}, 
    "g_V_valuesXnameX_fold_disjunctX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Fold().Disjunct(2)}}, 
    "g_V_valuesXnameX_fold_disjunctXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Fold().Disjunct(nil)}}, 
    "g_V_valuesXnonexistantX_fold_disjunctXV_valuesXnameX_foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("nonexistant").Fold().Disjunct(gremlingo.T__.V().Values("name").Fold())}}, 
    "g_V_valuesXnameX_fold_disjunctXV_valuesXnonexistantX_foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Fold().Disjunct(gremlingo.T__.V().Values("nonexistant").Fold())}}, 
    "g_V_valuesXageX_fold_disjunctXV_valuesXageX_foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Fold().Disjunct(gremlingo.T__.V().Values("age").Fold())}}, 
    "g_V_out_path_byXvaluesXnameX_toUpperX_disjunctXMARKOX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Path().By(gremlingo.T__.Values("name").ToUpper()).Disjunct([]interface{}{"MARKO"})}}, 
    "g_V_valueMapXlocationX_selectXvaluesX_unfold_disjunctXseattle_vancouverX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap("location").Select(gremlingo.Column.Values).Unfold().Disjunct([]interface{}{"seattle", "vancouver"})}}, 
    "g_V_out_out_path_byXnameX_disjunctXmarkoX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Out().Path().By("name").Disjunct([]interface{}{"marko"})}}, 
    "g_V_out_out_path_byXnameX_disjunctXstephen_markoX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Out().Path().By("name").Disjunct([]interface{}{"stephen", "marko"})}}, 
    "g_V_out_out_path_byXnameX_disjunctXdave_kelvinX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Out().Path().By("name").Disjunct([]interface{}{"dave", "kelvin"})}}, 
    "g_injectXa_null_bX_disjunctXa_cX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{"a", nil, "b"}).Disjunct([]interface{}{"a", "c"})}}, 
    "g_injectXa_null_bX_disjunctXa_null_cX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{"a", nil, "b"}).Disjunct([]interface{}{"a", nil, "c"})}}, 
    "g_injectX3_threeX_disjunctXfive_three_7X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{int32(3), "three"}).Disjunct([]interface{}{"five", "three", int32(7)})}}, 
    "g_E": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}}, 
    "g_EX11X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E(p["eid11"])}}, 
    "g_EX11AsStringX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E(p["eid11"])}}, 
    "g_EXe11X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E(p["e11"])}}, 
    "g_EXe7_e11X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E(p["e7"], p["e11"])}}, 
    "g_EXlistXe7_e11XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E(p["xx1"])}}, 
    "g_EXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E(nil)}}, 
    "g_EXlistXnullXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E(p["xx1"])}}, 
    "g_EX11_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E(p["eid11"], nil)}}, 
    "g_V_EX11X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().E(p["eid11"])}}, 
    "g_EX11X_E": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E(p["eid11"]).E()}}, 
    "g_V_EXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().E(nil)}}, 
    "g_V_EXlistXnullXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().E(p["xx1"])}}, 
    "g_injectX1X_EX11_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).E(p["eid11"], nil)}}, 
    "g_injectX1X_coalesceXEX_hasLabelXtestsX_addEXtestsX_from_V_hasXnameX_XjoshXX_toXV_hasXnameX_XvadasXXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "josh").AddV("person").Property("name", "vadas")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).Coalesce(gremlingo.T__.E().HasLabel("tests"), gremlingo.T__.AddE("tests").From(gremlingo.T__.V().Has("name", "josh")).To(gremlingo.T__.V().Has("name", "vadas")))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("tests")}}, 
    "g_VX1X_outE_inV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE().InV()}}, 
    "g_VX2X_inE_outV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid2"]).InE().OutV()}}, 
    "g_V_outE_hasXweight_1X_outV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().OutE().Has("weight", 1.0).OutV()}}, 
    "g_VX1X_outE_otherV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE().OtherV()}}, 
    "g_VX4X_bothE_otherV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).BothE().OtherV()}}, 
    "g_VX4X_bothE_hasXweight_lt_1X_otherV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).BothE().Has("weight", gremlingo.P.Lt(1.0)).OtherV()}}, 
    "get_g_VX1X_outE_otherV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE().OtherV()}}, 
    "g_VX1X_outEXknowsX_inV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE("knows").InV()}}, 
    "g_VX1X_outEXknows_createdX_inV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE("knows", "created").InV()}}, 
    "g_VX1X_outEXknowsX_bothV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE("knows").BothV()}}, 
    "g_VX1X_outEXknowsX_bothV_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE("knows").BothV().Values("name")}}, 
    "g_VX1X_properties_element": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid2"]).Properties().Element().Limit(1)}}, 
    "g_V_properties_element": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties().Element()}}, 
    "g_V_propertiesXageX_element": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties("age").Element()}}, 
    "g_EX_properties_element": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E(p["eid11"]).Properties().Element().Limit(1)}}, 
    "g_E_properties_element": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Properties().Element()}}, 
    "g_VXv7_properties_properties_element_element": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid7"]).Properties().Properties().Element().Element().Limit(1)}}, 
    "g_V_properties_properties_element_element": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid7"]).Properties().Properties().Element().Element()}}, 
    "g_V_elementMap": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ElementMap()}}, 
    "g_V_elementMapXname_ageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ElementMap("name", "age")}}, 
    "g_EX11X_elementMap": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E(p["eid11"]).ElementMap()}}, 
    "g_V_elementMapXname_age_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ElementMap("name", "age", nil)}}, 
    "g_V_asXaX_flatMapXselectXaXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").FlatMap(gremlingo.T__.Select("a"))}}, 
    "g_V_valuesXnameX_flatMapXsplitXaX_unfoldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").FlatMap(gremlingo.T__.Split("a").Unfold())}}, 
    "g_V_flatMapXout_outX_path": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().FlatMap(gremlingo.T__.Out().Out()).Path()}}, 
    "g_V_fold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Fold()}}, 
    "g_V_fold_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Fold().Unfold()}}, 
    "g_V_age_foldX0_plusX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Fold(0, gremlingo.Operator.Sum)}}, 
    "g_injectXa1_b2X_foldXm_addAllX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(map[interface{}]interface{}{"a": 1 }, map[interface{}]interface{}{"b": 2 }).Fold(map[interface{}]interface{}{ }, gremlingo.Operator.AddAll)}}, 
    "g_injectXa1_b2_b4X_foldXm_addAllX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(map[interface{}]interface{}{"a": 1 }, map[interface{}]interface{}{"b": 2 }, map[interface{}]interface{}{"b": 4 }).Fold(map[interface{}]interface{}{ }, gremlingo.Operator.AddAll)}}, 
    "g_VX1X_formatXstrX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "marko").Format("Hello world")}}, 
    "g_V_formatXstrX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Format("%{name} is %{age} years old")}}, 
    "g_injectX1X_asXageX_V_formatXstrX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).As("age").V().Format("%{name} is %{age} years old")}}, 
    "g_V_formatXstrX_byXvaluesXnameXX_byXvaluesXageXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Format("%{_} is %{_} years old").By(gremlingo.T__.Values("name")).By(gremlingo.T__.Values("age"))}}, 
    "g_V_hasLabelXpersonX_formatXstrX_byXconstantXhelloXX_byXvaluesXnameXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Format("%{_} %{_} %{_}").By(gremlingo.T__.Constant("hello")).By(gremlingo.T__.Values("name"))}}, 
    "g_VX1X_formatXstrX_byXconstantXhelloXX_byXvaluesXnameXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Format("%{_}").By(gremlingo.T__.Constant("hello")).By(gremlingo.T__.Values("name"))}}, 
    "g_V_formatXstrX_byXbothE_countX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Format("%{name} has %{_} connections").By(gremlingo.T__.BothE().Count())}}, 
    "g_V_projectXname_countX_byXvaluesXnameXX_byXbothE_countX_formatXstrX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Project("name", "count").By(gremlingo.T__.Values("name")).By(gremlingo.T__.BothE().Count()).Format("%{name} has %{count} connections")}}, 
    "g_V_elementMap_formatXstrX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ElementMap().Format("%{name} is %{age} years old")}}, 
    "g_V_hasLabelXpersonX_asXaX_valuesXnameX_asXp1X_selectXaX_inXknowsX_formatXstrX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").As("a").Values("name").As("p1").Select("a").In("knows").Format("%{p1} knows %{name}")}}, 
    "g_V_asXsX_label_asXsubjectX_selectXsX_outE_asXpX_label_asXpredicateX_selectXpX_inV_label_asXobjectX_formatXstrX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("s").Label().As("subject").Select("s").OutE().As("p").Label().As("predicate").Select("p").InV().Label().As("object").Format("%{subject} %{predicate} %{object}")}}, 
    "g_V_hasLabelXsoftwareX_index_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("software").Index().Unfold()}}, 
    "g_V_hasLabelXsoftwareX_order_byXnameX_index_withXmapX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("software").Order().By("name").Index().With(gremlingo.WithOptions.Indexer, gremlingo.WithOptions.Map)}}, 
    "g_V_hasLabelXsoftwareX_name_fold_orderXlocalX_index_unfold_order_byXtailXlocal_1XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("software").Values("name").Fold().Order(gremlingo.Scope.Local).Index().Unfold().Order().By(gremlingo.T__.Tail(gremlingo.Scope.Local, 1))}}, 
    "g_V_hasLabelXpersonX_name_fold_orderXlocalX_index_withXmapX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Values("name").Fold().Order(gremlingo.Scope.Local).Index().With(gremlingo.WithOptions.Indexer, gremlingo.WithOptions.Map)}}, 
    "g_VX1X_valuesXageX_index_unfold_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Values("age").Index().Unfold().Unfold()}}, 
    "g_injectXnullX_intersectXinjectX1XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(nil).Intersect(gremlingo.T__.Inject(1))}}, 
    "g_V_valuesXnameX_intersectXV_foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Intersect(gremlingo.T__.V().Fold())}}, 
    "g_V_fold_intersectXconstantXnullXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Fold().Intersect(gremlingo.T__.Constant(nil))}}, 
    "g_V_fold_intersectXVX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Fold().Intersect(gremlingo.T__.V())}}, 
    "g_V_valuesXnameX_fold_intersectX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Fold().Intersect(2)}}, 
    "g_V_valuesXnameX_fold_intersectXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Fold().Intersect(nil)}}, 
    "g_V_valuesXnonexistantX_fold_intersectXV_valuesXnameX_foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("nonexistant").Fold().Intersect(gremlingo.T__.V().Values("name").Fold())}}, 
    "g_V_valuesXnameX_fold_intersectXV_valuesXnonexistantX_foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Fold().Intersect(gremlingo.T__.V().Values("nonexistant").Fold())}}, 
    "g_V_valuesXageX_fold_intersectXV_valuesXageX_foldX_order_local": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Fold().Intersect(gremlingo.T__.V().Values("age").Fold()).Order(gremlingo.Scope.Local)}}, 
    "g_V_out_path_byXvaluesXnameX_toUpperX_intersectXMARKOX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Path().By(gremlingo.T__.Values("name").ToUpper()).Intersect([]interface{}{"MARKO"})}}, 
    "g_injectXmarkoX_intersectX___V_valuesXnameX_foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{"marko"}).Intersect(gremlingo.T__.V().Values("name").Fold())}}, 
    "g_V_valueMapXlocationX_selectXvaluesX_unfold_intersectXseattle_vancouverX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap("location").Select(gremlingo.Column.Values).Unfold().Intersect([]interface{}{"seattle", "vancouver"})}}, 
    "g_V_valuesXageX_fold_intersectX___constantX27X_foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Fold().Intersect(gremlingo.T__.Constant(27).Fold())}}, 
    "g_V_out_out_path_byXnameX_intersectXdave_kelvinX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Out().Path().By("name").Intersect([]interface{}{"dave", "kelvin"})}}, 
    "g_injectXa_null_bX_intersectXa_cX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{"a", nil, "b"}).Intersect([]interface{}{"a", "c"})}}, 
    "g_injectXa_null_bX_intersectXa_null_cX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{"a", nil, "b"}).Intersect([]interface{}{"a", nil, "c"})}}, 
    "g_injectX3_threeX_intersectXfive_three_7X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{3, "three"}).Intersect([]interface{}{"five", "three", int32(7)})}}, 
    "g_injectX__feature___test__nullX_lTrim": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("  feature", " one test", nil, "", " ", "　abc", "abc　", "　abc　", "　　").LTrim()}}, 
    "g_injectX__feature___test__nullX_lTrimXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{"  feature  ", " one test ", nil, "", " ", "　abc", "abc　", "　abc　", "　　"}).LTrim(gremlingo.Scope.Local)}}, 
    "g_injectX__feature__X_lTrim": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("  feature  ").LTrim()}}, 
    "g_injectXListXa_bXX_lTrim": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{"a", "b"}).LTrim()}}, 
    "g_injectXListX1_2XX_lTrimXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{1, 2}).LTrim(gremlingo.Scope.Local)}}, 
    "g_V_valuesXnameX_lTrim": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", " marko ").Property("age", 29).As("marko").AddV("person").Property("name", "  vadas  ").Property("age", 27).As("vadas").AddV("software").Property("name", "  lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh  ").Property("age", 32).As("josh").AddV("software").Property("name", "   ripple   ").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").LTrim()}}, 
    "g_V_valuesXnameX_order_fold_lTrimXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", " marko ").Property("age", 29).As("marko").AddV("person").Property("name", "  vadas  ").Property("age", 27).As("vadas").AddV("software").Property("name", "  lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh  ").Property("age", 32).As("josh").AddV("software").Property("name", "   ripple   ").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Order().Fold().LTrim(gremlingo.Scope.Local)}}, 
    "g_injectXfeature_test_nullX_length": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("feature", "test", nil).Length()}}, 
    "g_injectXfeature_test_nullX_lengthXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("feature", "test", nil).Length(gremlingo.Scope.Local)}}, 
    "g_injectXListXa_bXX_length": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{"a", "b"}).Length()}}, 
    "g_V_valuesXnameX_length": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Length()}}, 
    "g_V_valuesXnameX_order_fold_lengthXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Order().Fold().Length(gremlingo.Scope.Local)}}, 
    "g_VX1X_repeatXboth_simplePathX_untilXhasXname_peterX_or_loops_isX3XX_hasXname_peterX_path_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Repeat(gremlingo.T__.Both().SimplePath()).Until(gremlingo.T__.Has("name", "peter").Or().Loops().Is(3)).Has("name", "peter").Path().By("name")}}, 
    "g_VX1X_repeatXboth_simplePathX_untilXhasXname_peterX_or_loops_isX2XX_hasXname_peterX_path_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Repeat(gremlingo.T__.Both().SimplePath()).Until(gremlingo.T__.Has("name", "peter").Or().Loops().Is(2)).Has("name", "peter").Path().By("name")}}, 
    "g_VX1X_repeatXboth_simplePathX_untilXhasXname_peterX_and_loops_isX3XX_hasXname_peterX_path_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Repeat(gremlingo.T__.Both().SimplePath()).Until(gremlingo.T__.Has("name", "peter").And().Loops().Is(3)).Has("name", "peter").Path().By("name")}}, 
    "g_V_emitXhasXname_markoX_or_loops_isX2XX_repeatXoutX_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Emit(gremlingo.T__.Has("name", "marko").Or().Loops().Is(2)).Repeat(gremlingo.T__.Out()).Values("name")}}, 
    "g_VX1X_mapXvaluesXnameXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Map(gremlingo.T__.Values("name"))}}, 
    "g_VX1X_outE_label_mapXlengthX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE().Label().Map(gremlingo.T__.Length())}}, 
    "g_VX1X_out_mapXvaluesXnameXX_mapXlengthX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out().Map(gremlingo.T__.Values("name")).Map(gremlingo.T__.Length())}}, 
    "g_withPath_V_asXaX_out_mapXselectXaX_valuesXnameXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithPath().V().As("a").Out().Map(gremlingo.T__.Select("a").Values("name"))}}, 
    "g_withPath_V_asXaX_out_out_asXbX_mapXselectXaX_valuesXnameX_concatXselectXbX_valuesXnameXXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithPath().V().As("a").Out().Out().As("b").Map(gremlingo.T__.Select("a").Values("name").Concat(gremlingo.T__.Select("b").Values("name")))}}, 
    "g_V_mapXselectXaXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Map(gremlingo.T__.Select("a"))}}, 
    "g_V_mapXconstantXnullXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Map(gremlingo.T__.Constant(nil))}}, 
    "g_V_valueMap_matchXa_selectXnameX_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap().Match(gremlingo.T__.As("a").Select("name").As("b"))}}, 
    "g_V_matchXa_out_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").Out().As("b"))}}, 
    "g_V_matchXa_out_bX_selectXb_idX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").Out().As("b")).Select("b").By(gremlingo.T.Id)}}, 
    "g_V_matchXa_knows_b__b_created_cX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").Out("knows").As("b"), gremlingo.T__.As("b").Out("created").As("c"))}}, 
    "g_V_matchXb_created_c__a_knows_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("b").Out("created").As("c"), gremlingo.T__.As("a").Out("knows").As("b"))}}, 
    "g_V_matchXa_created_b__b_0created_cX_whereXa_neq_cX_selectXa_cX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").Out("created").As("b"), gremlingo.T__.As("b").In("created").As("c")).Where("a", gremlingo.P.Neq("c")).Select("a", "c")}}, 
    "g_V_matchXd_0knows_a__d_hasXname_vadasX__a_knows_b__b_created_cX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("d").In("knows").As("a"), gremlingo.T__.As("d").Has("name", "vadas"), gremlingo.T__.As("a").Out("knows").As("b"), gremlingo.T__.As("b").Out("created").As("c"))}}, 
    "g_V_matchXa_created_lop_b__b_0created_29_c__c_whereXrepeatXoutX_timesX2XXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").Out("created").Has("name", "lop").As("b"), gremlingo.T__.As("b").In("created").Has("age", 29).As("c"), gremlingo.T__.As("c").Where(gremlingo.T__.Repeat(gremlingo.T__.Out()).Times(2)))}}, 
    "g_V_asXaX_out_asXbX_matchXa_out_count_c__b_in_count_cX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("b").Match(gremlingo.T__.As("a").Out().Count().As("c"), gremlingo.T__.As("b").In().Count().As("c"))}}, 
    "g_V_matchXa__a_out_b__notXa_created_bXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").Out().As("b"), gremlingo.T__.Not(gremlingo.T__.As("a").Out("created").As("b")))}}, 
    "g_V_matchXa_created_lop_b__b_0created_29_cX_whereXc_repeatXoutX_timesX2XX_selectXa_b_cX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").Out("created").Has("name", "lop").As("b"), gremlingo.T__.As("b").In("created").Has("age", 29).As("c")).Where(gremlingo.T__.As("c").Repeat(gremlingo.T__.Out()).Times(2)).Select("a", "b", "c")}}, 
    "g_V_out_out_matchXa_0created_b__b_0knows_cX_selectXcX_outXcreatedX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Out().Match(gremlingo.T__.As("a").In("created").As("b"), gremlingo.T__.As("b").In("knows").As("c")).Select("c").Out("created").Values("name")}}, 
    "g_V_matchXa_knows_b__b_created_c__a_created_cX_dedupXa_b_cX_selectXaX_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").Out("knows").As("b"), gremlingo.T__.As("b").Out("created").As("c"), gremlingo.T__.As("a").Out("created").As("c")).Dedup("a", "b", "c").Select("a").By("name")}}, 
    "g_V_matchXa_created_b__a_repeatXoutX_timesX2XX_selectXa_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").Out("created").As("b"), gremlingo.T__.As("a").Repeat(gremlingo.T__.Out()).Times(2).As("b")).Select("a", "b")}}, 
    "g_V_notXmatchXa_age_b__a_name_cX_whereXb_eqXcXX_selectXaXX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Not(gremlingo.T__.Match(gremlingo.T__.As("a").Values("age").As("b"), gremlingo.T__.As("a").Values("name").As("c")).Where("b", gremlingo.P.Eq("c")).Select("a")).Values("name")}}, 
    "g_V_matchXa_knows_b__andXa_created_c__b_created_c__andXb_created_count_d__a_knows_count_dXXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").Out("knows").As("b"), gremlingo.T__.And(gremlingo.T__.As("a").Out("created").As("c"), gremlingo.T__.As("b").Out("created").As("c"), gremlingo.T__.And(gremlingo.T__.As("b").Out("created").Count().As("d"), gremlingo.T__.As("a").Out("knows").Count().As("d"))))}}, 
    "g_V_matchXa_whereXa_neqXcXX__a_created_b__orXa_knows_vadas__a_0knows_and_a_hasXlabel_personXX__b_0created_c__b_0created_count_isXgtX1XXX_selectXa_b_cX_byXidX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.Where("a", gremlingo.P.Neq("c")), gremlingo.T__.As("a").Out("created").As("b"), gremlingo.T__.Or(gremlingo.T__.As("a").Out("knows").Has("name", "vadas"), gremlingo.T__.As("a").In("knows").And().As("a").Has(gremlingo.T.Label, "person")), gremlingo.T__.As("b").In("created").As("c"), gremlingo.T__.As("b").In("created").Count().Is(gremlingo.P.Gt(1))).Select("a", "b", "c").By(gremlingo.T.Id)}}, 
    "g_V_matchXa__a_both_b__b_both_cX_dedupXa_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").Both().As("b"), gremlingo.T__.As("b").Both().As("c")).Dedup("a", "b")}}, 
    "g_V_matchXa_knows_b__b_created_lop__b_matchXb_created_d__d_0created_cX_selectXcX_cX_selectXa_b_cX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").Out("knows").As("b"), gremlingo.T__.As("b").Out("created").Has("name", "lop"), gremlingo.T__.As("b").Match(gremlingo.T__.As("b").Out("created").As("d"), gremlingo.T__.As("d").In("created").As("c")).Select("c").As("c")).Select("a", "b", "c")}}, 
    "g_V_matchXa_knows_b__a_created_cX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").Out("knows").As("b"), gremlingo.T__.As("a").Out("created").As("c"))}}, 
    "g_V_matchXwhereXandXa_created_b__b_0created_count_isXeqX3XXXX__a_both_b__whereXb_inXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.Where(gremlingo.T__.And(gremlingo.T__.As("a").Out("created").As("b"), gremlingo.T__.As("b").In("created").Count().Is(gremlingo.P.Eq(3)))), gremlingo.T__.As("a").Both().As("b"), gremlingo.T__.Where(gremlingo.T__.As("b").In()))}}, 
    "g_V_matchXa_outEXcreatedX_order_byXweight_descX_limitX1X_inV_b__b_hasXlang_javaXX_selectXa_bX_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").OutE("created").Order().By("weight", gremlingo.Order.Desc).Limit(1).InV().As("b"), gremlingo.T__.As("b").Has("lang", "java")).Select("a", "b").By("name")}}, 
    "g_V_matchXa_both_b__b_both_cX_dedupXa_bX_byXlabelX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").Both().As("b"), gremlingo.T__.As("b").Both().As("c")).Dedup("a", "b").By(gremlingo.T.Label)}}, 
    "g_V_matchXa_created_b__b_0created_aX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").Out("created").As("b"), gremlingo.T__.As("b").In("created").As("a"))}}, 
    "g_V_asXaX_out_asXbX_matchXa_out_count_c__orXa_knows_b__b_in_count_c__and__c_isXgtX2XXXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("b").Match(gremlingo.T__.As("a").Out().Count().As("c"), gremlingo.T__.Or(gremlingo.T__.As("a").Out("knows").As("b"), gremlingo.T__.As("b").In().Count().As("c").And().As("c").Is(gremlingo.P.Gt(2))))}}, 
    "g_V_matchXa_knows_count_bX_selectXbX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").Out("knows").Count().As("b")).Select("b")}}, 
    "g_V_matchXa_0sungBy_b__a_0writtenBy_c__b_writtenBy_d__c_sungBy_d__d_hasXname_GarciaXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").In("sungBy").As("b"), gremlingo.T__.As("a").In("writtenBy").As("c"), gremlingo.T__.As("b").Out("writtenBy").As("d"), gremlingo.T__.As("c").Out("sungBy").As("d"), gremlingo.T__.As("d").Has("name", "Garcia"))}}, 
    "g_V_matchXa_hasXsong_name_sunshineX__a_mapX0followedBy_weight_meanX_b__a_0followedBy_c__c_filterXweight_whereXgteXbXXX_outV_dX_selectXdX_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").Has("song", "name", "HERE COMES SUNSHINE"), gremlingo.T__.As("a").Map(gremlingo.T__.InE("followedBy").Values("weight").Mean()).As("b"), gremlingo.T__.As("a").InE("followedBy").As("c"), gremlingo.T__.As("c").Filter(gremlingo.T__.Values("weight").Where(gremlingo.P.Gte("b"))).OutV().As("d")).Select("d").By("name")}}, 
    "g_V_matchXa_0sungBy_b__a_0sungBy_c__b_writtenBy_d__c_writtenBy_e__d_hasXname_George_HarisonX__e_hasXname_Bob_MarleyXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").In("sungBy").As("b"), gremlingo.T__.As("a").In("sungBy").As("c"), gremlingo.T__.As("b").Out("writtenBy").As("d"), gremlingo.T__.As("c").Out("writtenBy").As("e"), gremlingo.T__.As("d").Has("name", "George_Harrison"), gremlingo.T__.As("e").Has("name", "Bob_Marley"))}}, 
    "g_V_matchXa_hasXname_GarciaX__a_0writtenBy_b__a_0sungBy_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").Has("name", "Garcia"), gremlingo.T__.As("a").In("writtenBy").As("b"), gremlingo.T__.As("a").In("sungBy").As("b"))}}, 
    "g_V_hasLabelXsongsX_matchXa_name_b__a_performances_cX_selectXb_cX_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("song").Match(gremlingo.T__.As("a").Values("name").As("b"), gremlingo.T__.As("a").Values("performances").As("c")).Select("b", "c").Count()}}, 
    "g_V_matchXa_followedBy_count_isXgtX10XX_b__a_0followedBy_count_isXgtX10XX_bX_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").Out("followedBy").Count().Is(gremlingo.P.Gt(10)).As("b"), gremlingo.T__.As("a").In("followedBy").Count().Is(gremlingo.P.Gt(10)).As("b")).Count()}}, 
    "g_V_matchXa_0sungBy_b__a_0writtenBy_c__b_writtenBy_dX_whereXc_sungBy_dX_whereXd_hasXname_GarciaXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").In("sungBy").As("b"), gremlingo.T__.As("a").In("writtenBy").As("c"), gremlingo.T__.As("b").Out("writtenBy").As("d")).Where(gremlingo.T__.As("c").Out("sungBy").As("d")).Where(gremlingo.T__.As("d").Has("name", "Garcia"))}}, 
    "g_V_matchXa_hasXname_GarciaX__a_0writtenBy_b__b_followedBy_c__c_writtenBy_d__whereXd_neqXaXXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").Has("name", "Garcia"), gremlingo.T__.As("a").In("writtenBy").As("b"), gremlingo.T__.As("b").Out("followedBy").As("c"), gremlingo.T__.As("c").Out("writtenBy").As("d"), gremlingo.T__.Where("d", gremlingo.P.Neq("a")))}}, 
    "g_V_matchXa_outXknowsX_name_bX_identity": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").Out("knows").Values("name").As("b")).Identity()}}, 
    "g_V_outE_mathX0_minus_itX_byXweightX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().OutE().Math("0-_").By("weight")}}, 
    "g_V_hasXageX_valueMap_mathXit_plus_itXbyXselectXageX_unfoldXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("age").ValueMap().Math("_+_").By(gremlingo.T__.Select("age").Unfold())}}, 
    "g_V_asXaX_outXknowsX_asXbX_mathXa_plus_bX_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out("knows").As("b").Math("a + b").By("age")}}, 
    "g_withSideEffectXx_100X_V_age_mathX__plus_xX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("x", int32(100)).V().Values("age").Math("_ + x")}}, 
    "g_V_asXaX_outXcreatedX_asXbX_mathXb_plus_aX_byXinXcreatedX_countX_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out("created").As("b").Math("b + a").By(gremlingo.T__.In("created").Count()).By("age")}}, 
    "g_withSackX1X_injectX1X_repeatXsackXsumX_byXconstantX1XXX_timesX5X_emit_mathXsin__X_byXsackX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSack(1).Inject(1).Repeat(gremlingo.T__.Sack(gremlingo.Operator.Sum).By(gremlingo.T__.Constant(1))).Times(5).Emit().Math("sin _").By(gremlingo.T__.Sack())}}, 
    "g_V_projectXa_b_cX_byXbothE_weight_sumX_byXbothE_countX_byXnameX_order_byXmathXa_div_bX_descX_selectXcX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Project("a", "b", "c").By(gremlingo.T__.BothE().Values("weight").Sum()).By(gremlingo.T__.BothE().Count()).By("name").Order().By(gremlingo.T__.Math("a / b"), gremlingo.Order.Desc).Select("c")}}, 
    "g_V_mathXit_plus_itXbyXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Math("_+_").By("age")}}, 
    "g_V_valueMap_mathXit_plus_itXbyXselectXageX_unfoldXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap().Math("_+_").By(gremlingo.T__.Select("age").Unfold())}}, 
    "g_VX1X_outE_asXexpectedWeightX_mathXexpectedWeightPlusOneXbyXweightX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE().As("expectedWeight").Math("expectedWeight + 1").By("weight")}}, 
    "g_V_age_max": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Max()}}, 
    "g_V_foo_max": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("foo").Max()}}, 
    "g_V_name_max": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Max()}}, 
    "g_V_age_fold_maxXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Fold().Max(gremlingo.Scope.Local)}}, 
    "g_V_aggregateXaX_byXageX_capXaX_maxXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate("a").By("age").Cap("a").Max(gremlingo.Scope.Local)}}, 
    "g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXageX_capXaX_maxXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy()).V().Aggregate("a").By("age").Cap("a").Max(gremlingo.Scope.Local)}}, 
    "g_V_aggregateXaX_byXageX_capXaX_unfold_max": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate("a").By("age").Cap("a").Unfold().Max()}}, 
    "g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXageX_capXaX_unfold_max": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy()).V().Aggregate("a").By("age").Cap("a").Unfold().Max()}}, 
    "g_V_aggregateXaX_byXfooX_capXaX_maxXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate("a").By("foo").Cap("a").Max(gremlingo.Scope.Local)}}, 
    "g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXfooX_capXaX_maxXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy()).V().Aggregate("a").By("foo").Cap("a").Max(gremlingo.Scope.Local)}}, 
    "g_V_aggregateXaX_byXfooX_capXaX_unfold_max": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate("a").By("foo").Cap("a").Unfold().Max()}}, 
    "g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXfooX_capXaX_unfold_max": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy()).V().Aggregate("a").By("foo").Cap("a").Unfold().Max()}}, 
    "g_V_foo_fold_maxXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("foo").Fold().Max(gremlingo.Scope.Local)}}, 
    "g_V_name_fold_maxXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Fold().Max(gremlingo.Scope.Local)}}, 
    "g_V_repeatXbothX_timesX5X_age_max": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Both()).Times(5).Values("age").Max()}}, 
    "g_V_hasLabelXsoftwareX_group_byXnameX_byXbothE_weight_maxX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("software").Group().By("name").By(gremlingo.T__.BothE().Values("weight").Max())}}, 
    "g_VX1X_valuesXageX_maxXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Values("age").Max(gremlingo.Scope.Local)}}, 
    "g_V_localXunionXvaluesXageX_outE_valuesXweightXX_foldX_maxXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Local(gremlingo.T__.Union(gremlingo.T__.Values("age"), gremlingo.T__.OutE().Values("weight")).Fold()).Max(gremlingo.Scope.Local)}}, 
    "g_V_age_mean": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Mean()}}, 
    "g_V_foo_mean": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("foo").Mean()}}, 
    "g_V_age_fold_meanXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Fold().Mean(gremlingo.Scope.Local)}}, 
    "g_V_foo_fold_meanXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("foo").Fold().Mean(gremlingo.Scope.Local)}}, 
    "g_V_hasLabelXsoftwareX_group_byXnameX_byXbothE_weight_meanX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("software").Group().By("name").By(gremlingo.T__.BothE().Values("weight").Mean())}}, 
    "g_V_aggregateXaX_byXageX_meanXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate("a").By("age").Cap("a").Mean(gremlingo.Scope.Local)}}, 
    "g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXageX_meanXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy()).V().Aggregate("a").By("age").Cap("a").Mean(gremlingo.Scope.Local)}}, 
    "g_V_aggregateXaX_byXageX_capXaX_unfold_mean": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate("a").By("age").Cap("a").Unfold().Mean()}}, 
    "g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXageX_capXaX_unfold_mean": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy()).V().Aggregate("a").By("age").Cap("a").Unfold().Mean()}}, 
    "g_V_aggregateXaX_byXfooX_meanXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate("a").By("foo").Cap("a").Mean(gremlingo.Scope.Local)}}, 
    "g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXfooX_meanXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy()).V().Aggregate("a").By("foo").Cap("a").Mean(gremlingo.Scope.Local)}}, 
    "g_V_aggregateXaX_byXfooX_capXaX_unfold_mean": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate("a").By("foo").Cap("a").Unfold().Mean()}}, 
    "g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXfooX_capXaX_unfold_mean": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy()).V().Aggregate("a").By("foo").Cap("a").Unfold().Mean()}}, 
    "g_injectXnull_10_20_nullX_mean": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(nil, 10, 20, nil).Mean()}}, 
    "g_injectXlistXnull_10_20_nullXX_meanXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{nil, 10, 20, nil}).Mean(gremlingo.Scope.Local)}}, 
    "g_VX1X_valuesXageX_meanXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Values("age").Mean(gremlingo.Scope.Local)}}, 
    "g_V_localXunionXvaluesXageX_outE_valuesXweightXX_foldX_meanXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Local(gremlingo.T__.Union(gremlingo.T__.Values("age"), gremlingo.T__.OutE().Values("weight")).Fold()).Mean(gremlingo.Scope.Local)}}, 
    "g_injectXnullX_mergeXinjectX1XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(nil).Merge(gremlingo.T__.Inject(1))}}, 
    "g_V_valuesXnameX_mergeXV_foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Merge(gremlingo.T__.V().Fold())}}, 
    "g_V_fold_mergeXconstantXnullXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Fold().Merge(gremlingo.T__.Constant(nil))}}, 
    "g_V_fold_mergeXVX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Fold().Merge(gremlingo.T__.V())}}, 
    "g_V_elementMap_mergeXconstantXaXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ElementMap().Merge(gremlingo.T__.Constant("a"))}}, 
    "g_V_fold_mergeXV_asXaX_projectXaX_byXnameXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Fold().Merge(gremlingo.T__.V().As("a").Project("a").By("name"))}}, 
    "g_V_fold_mergeXk_vX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Fold().Merge(map[interface{}]interface{}{"k": "v" })}}, 
    "g_V_valuesXnameX_fold_mergeX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Fold().Merge(2)}}, 
    "g_V_valuesXnameX_fold_mergeXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Fold().Merge(nil)}}, 
    "g_V_valuesXnonexistantX_fold_mergeXV_valuesXnameX_foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("nonexistant").Fold().Merge(gremlingo.T__.V().Values("name").Fold())}}, 
    "g_V_valuesXnameX_fold_mergeXV_valuesXnonexistantX_foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Fold().Merge(gremlingo.T__.V().Values("nonexistant").Fold())}}, 
    "g_V_valuesXageX_fold_mergeXV_valuesXageX_foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Fold().Merge(gremlingo.T__.V().Values("age").Fold())}}, 
    "g_V_out_path_byXvaluesXnameX_toUpperX_mergeXMARKOX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Path().By(gremlingo.T__.Values("name").ToUpper()).Merge([]interface{}{"MARKO"})}}, 
    "g_injectXmarkoX_mergeXV_valuesXnameX_foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{"marko"}).Merge(gremlingo.T__.V().Values("name").Fold())}}, 
    "g_V_valueMapXlocationX_selectXvaluesX_unfold_mergeXseattle_vancouverX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap("location").Select(gremlingo.Column.Values).Unfold().Merge([]interface{}{"seattle", "vancouver"})}}, 
    "g_V_out_out_path_byXnameX_mergeXempty_listX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Out().Path().By("name").Merge([]interface{}{})}}, 
    "g_V_valuesXageX_fold_mergeXconstantX27X_foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Fold().Merge(gremlingo.T__.Constant(27).Fold())}}, 
    "g_V_out_out_path_byXnameX_mergeXdave_kelvinX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Out().Path().By("name").Merge([]interface{}{"dave", "kelvin"})}}, 
    "g_injectXa_null_bX_mergeXa_cX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{"a", nil, "b"}).Merge([]interface{}{"a", "c"})}}, 
    "g_injectXa_null_bX_mergeXa_null_cX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{"a", nil, "b"}).Merge([]interface{}{"a", nil, "c"})}}, 
    "g_injectX3_threeX_mergeXfive_three_7X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{3, "three"}).Merge([]interface{}{"five", "three", int32(7)})}}, 
    "g_V_asXnameX_projectXnameX_byXnameX_mergeXother_blueprintX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("name").Project("name").By("name").Merge(map[interface{}]interface{}{"other": "blueprint" })}}, 
    "g_V_hasXname_markoX_elementMap_mergeXV_hasXname_lopX_elementMapX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "marko").ElementMap().Merge(gremlingo.T__.V().Has("name", "lop").ElementMap())}}, 
    "g_V_mergeEXlabel_selfX_optionXonMatch_emptyX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).AddE("self")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().MergeE(p["xx1"]).Option(gremlingo.Merge.OnMatch, map[interface{}]interface{}{ })}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Properties()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_V_mergeEXlabel_selfX_optionXonMatch_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).AddE("self")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().MergeE(p["xx1"]).Option(gremlingo.Merge.OnMatch, nil)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Properties()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_V_mergeEXemptyX_optionXonCreate_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("v").MergeE(p["xx1"]).Option(gremlingo.Merge.OnCreate, nil).Option(gremlingo.Merge.OutV, gremlingo.T__.Select("v")).Option(gremlingo.Merge.InV, gremlingo.T__.Select("v"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_V_mergeE_inlineXemptyX_optionXonCreate_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("v").MergeE(map[interface{}]interface{}{gremlingo.T.Label: "self", gremlingo.Direction.Out: gremlingo.Merge.OutV, gremlingo.Direction.In: gremlingo.Merge.InV }).Option(gremlingo.Merge.OnCreate, nil).Option(gremlingo.Merge.OutV, gremlingo.T__.Select("v")).Option(gremlingo.Merge.InV, gremlingo.T__.Select("v"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_mergeEXemptyX_exists": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).AddE("self")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(map[interface{}]interface{}{ })}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_mergeEXemptyX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(map[interface{}]interface{}{ })}}, 
    "g_V_mergeEXemptyX_two_exist": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).AddV("person").Property("name", "vadas").Property("age", 27)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("v").MergeE(p["xx1"]).Option(gremlingo.Merge.OutV, gremlingo.T__.Select("v")).Option(gremlingo.Merge.InV, gremlingo.T__.Select("v"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_V_mergeE_inlineXemptyX_two_exist": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).AddV("person").Property("name", "vadas").Property("age", 27)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("v").MergeE(map[interface{}]interface{}{gremlingo.T.Label: "self", gremlingo.Direction.Out: gremlingo.Merge.OutV, gremlingo.Direction.In: gremlingo.Merge.InV }).Option(gremlingo.Merge.OutV, gremlingo.T__.Select("v")).Option(gremlingo.Merge.InV, gremlingo.T__.Select("v"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_mergeEXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(nil)}}, 
    "g_mergeEXnullvarX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"])}}, 
    "g_V_limitX1X_mergeEXnullvarX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Limit(1).MergeE(p["xx1"])}}, 
    "g_V_mergeEXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().MergeE(nil)}}, 
    "g_mergeEXlabel_knows_out_marko_in_vadasX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Out("knows").Has("person", "name", "vadas")}}, 
    "g_withSideEffectXa_label_knows_out_marko_in_vadasX_mergeEXselectXaXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(gremlingo.T__.Select("a"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Out("knows").Has("person", "name", "vadas")}}, 
    "g_mergeEXlabel_knows_out_marko1_in_vadas1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Out("knows").Has("person", "name", "vadas")}}, 
    "g_mergeEXlabel_knows_out_marko_in_vadas_weight_05X_exists": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").As("a").AddV("person").Property("name", "vadas").As("b").AddE("knows").From("a").To("b")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").OutE("knows").Has("weight", 0.5).InV().Has("person", "name", "vadas")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Out("knows").Has("person", "name", "vadas")}}, 
    "g_mergeEXlabel_knows_out_marko_in_vadas_weight_05X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"])}}, 
    "g_mergeEXlabel_knows_out_marko_in_vadasX_optionXonCreate_created_YX_optionXonMatch_created_NX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"]).Option(gremlingo.Merge.OnCreate, p["xx2"]).Option(gremlingo.Merge.OnMatch, p["xx3"])}}, 
    "g_mergeEXlabel_knows_out_marko_in_vadasX_optionXonCreate_created_YX_optionXonMatch_created_NX_exists": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").As("a").AddV("person").Property("name", "vadas").As("b").AddE("knows").From("a").To("b")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"]).Option(gremlingo.Merge.OnCreate, p["xx2"]).Option(gremlingo.Merge.OnMatch, p["xx3"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("created", "Y")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("created", "N")}}, 
    "g_mergeEXlabel_knows_out_marko_in_vadasX_optionXonCreate_created_YX_optionXonMatch_created_NX_exists_updated": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").As("a").AddV("person").Property("name", "vadas").As("b").AddE("knows").From("a").To("b").Property("created", "Y")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"]).Option(gremlingo.Merge.OnCreate, p["xx2"]).Option(gremlingo.Merge.OnMatch, p["xx3"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("created", "Y")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("created", "N")}}, 
    "g_V_hasXperson_name_marko_X_mergeEXlabel_knowsX_optionXonCreate_created_YX_optionXonMatch_created_NX_exists_updated": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").As("a").AddV("person").Property("name", "vadas").As("b").AddE("knows").From("a").To("b").Property("created", "Y").AddE("knows").From("a").To("b")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").MergeE(p["xx1"]).Option(gremlingo.Merge.OnCreate, p["xx2"]).Option(gremlingo.Merge.OnMatch, p["xx3"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("created", "Y")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("created", "N")}}, 
    "g_withSideEffectXlabel_knows_out_marko_in_vadasX_injectX1X_selectXmX_mergeE": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).Select("m").MergeE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Out("knows").Has("person", "name", "vadas")}}, 
    "g_mergeEXlabel_knows_in_vadasX_optionXonCreate_created_YX_optionXonMatch_created_NX_exists_updated": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").As("a").AddV("person").Property("name", "vadas").As("b").AddE("knows").From("a").To("b").Property("created", "Y").AddE("knows").From("b").To("a").Property("created", "Y")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"]).Option(gremlingo.Merge.OnCreate, p["xx2"]).Option(gremlingo.Merge.OnMatch, p["xx3"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("created", "Y")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("created", "N").InV().Has("name", "vadas")}}, 
    "g_mergeEXlabel_knows_out_vadasX_optionXonCreate_created_YX_optionXonMatch_created_NX_exists_updated": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").As("a").AddV("person").Property("name", "vadas").As("b").AddE("knows").From("a").To("b").Property("created", "Y").AddE("knows").From("b").To("a").Property("created", "Y")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"]).Option(gremlingo.Merge.OnCreate, p["xx2"]).Option(gremlingo.Merge.OnMatch, p["xx3"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("created", "Y")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("created", "N").OutV().Has("name", "vadas")}}, 
    "g_mergeEXout_vadasX_optionXonCreate_created_YX_optionXonMatch_created_NX_exists_updated": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").As("a").AddV("person").Property("name", "vadas").As("b").AddE("knows").From("a").To("b").Property("created", "Y").AddE("knows").From("b").To("a").Property("created", "Y")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"]).Option(gremlingo.Merge.OnCreate, p["xx2"]).Option(gremlingo.Merge.OnMatch, p["xx3"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("created", "Y")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("created", "N").OutV().Has("name", "vadas")}}, 
    "g_V_hasXperson_name_marko_X_mergeEXlabel_self_out_vadas1_in_vadas1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").MergeE(p["xx1"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("self").BothV().Has("name", "vadas")}}, 
    "g_withSideEffectXc_created_YX_withSideEffectXm_matchedX_mergeEXlabel_knows_out_marko_in_vadasX_optionXonCreate_selectXcXX_optionXonMatch_selectXmXX_exists": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").As("a").AddV("person").Property("name", "vadas").As("b").AddE("knows").From("a").To("b")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"]).Option(gremlingo.Merge.OnCreate, gremlingo.T__.Select("c")).Option(gremlingo.Merge.OnMatch, gremlingo.T__.Select("m"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("created", "Y")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("created", "N")}}, 
    "g_withSideEffectXc_created_YX_withSideEffectXm_matchedX_mergeEXlabel_knows_out_marko_in_vadasX_optionXonCreate_selectXcXX_optionXonMatch_selectXmXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").As("a").AddV("person").Property("name", "vadas").As("b")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"]).Option(gremlingo.Merge.OnCreate, gremlingo.T__.Select("c")).Option(gremlingo.Merge.OnMatch, gremlingo.T__.Select("m"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("created", "Y")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("created", "N")}}, 
    "g_withSideEffectXc_created_YX_withSideEffectXm_matchedX_mergeEXlabel_knows_out_marko1_in_vadas1X_optionXonCreate_selectXcXX_optionXonMatch_selectXmXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").As("a").AddV("person").Property("name", "vadas").As("b")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"]).Option(gremlingo.Merge.OnCreate, gremlingo.T__.Select("c")).Option(gremlingo.Merge.OnMatch, gremlingo.T__.Select("m"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("created", "Y")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("created", "N")}}, 
    "g_mergeEXlabel_knows_out_marko_in_vadasX_aliased_direction": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Out("knows").Has("person", "name", "vadas")}}, 
    "g_withSideEffectXm1_label_knows_out_marko_in_vadas_m2_label_self_out_vadas_in_vadasX_unionXselectXm1X_selectXm2XX_mergeE": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Union(gremlingo.T__.Select("m1"), gremlingo.T__.Select("m2")).MergeE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Out("knows").Has("person", "name", "vadas")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "vadas").Out("self").Has("person", "name", "vadas")}}, 
    "g_withSideEffectXc_created_YX_withSideEffectXm_matchedX_mergeEXlabel_knows_out_marko_in_vadasX_optionXonCreate_selectXcXX_optionXonMatch_sideEffectXpropertiesXweightX_dropX_selectXmXX_exists": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").As("a").AddV("person").Property("name", "vadas").As("b").AddE("knows").Property("weight", 1.0).From("a").To("b")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"]).Option(gremlingo.Merge.OnCreate, gremlingo.T__.Select("c")).Option(gremlingo.Merge.OnMatch, gremlingo.T__.SideEffect(gremlingo.T__.Properties("weight").Drop()).Select("m"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("created", "Y")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("created", "N")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("weight")}}, 
    "g_mergeE_with_outVinV_options_map": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"]).Option(gremlingo.Merge.OutV, p["xx2"]).Option(gremlingo.Merge.InV, p["xx3"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "marko").Out("knows").Has("name", "vadas")}}, 
    "g_mergeE_inline_with_outVinV_options_map": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(map[interface{}]interface{}{gremlingo.Direction.Out: gremlingo.Merge.OutV, gremlingo.Direction.In: gremlingo.Merge.InV, gremlingo.T.Label: "knows" }).Option(gremlingo.Merge.OutV, p["xx1"]).Option(gremlingo.Merge.InV, p["xx2"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "marko").Out("knows").Has("name", "vadas")}}, 
    "g_mergeE_with_outVinV_options_select": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).As("x").V(p["vid2"]).As("y").MergeE(p["xx1"]).Option(gremlingo.Merge.OutV, gremlingo.T__.Select("x")).Option(gremlingo.Merge.InV, gremlingo.T__.Select("y"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "marko").Out("knows").Has("name", "vadas")}}, 
    "g_mergeE_inline_with_outVinV_options_select": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).As("x").V(p["vid2"]).As("y").MergeE(map[interface{}]interface{}{gremlingo.Direction.Out: gremlingo.Merge.OutV, gremlingo.Direction.In: gremlingo.Merge.InV, gremlingo.T.Label: "knows" }).Option(gremlingo.Merge.OutV, gremlingo.T__.Select("x")).Option(gremlingo.Merge.InV, gremlingo.T__.Select("y"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "marko").Out("knows").Has("name", "vadas")}}, 
    "g_mergeE_with_eid_specified_and_inheritance_1": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"]).Option(gremlingo.Merge.OnCreate, p["xx2"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E("201")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "marko").Out("knows").Has("name", "vadas")}}, 
    "g_mergeE_with_eid_specified_and_inheritance_2": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"]).Option(gremlingo.Merge.OnCreate, p["xx2"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E("201")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "marko").Out("knows").Has("name", "vadas")}}, 
    "g_mergeE_outV_override_prohibited": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"]).Option(gremlingo.Merge.OnCreate, p["xx2"])}}, 
    "g_mergeE_inV_override_prohibited": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"]).Option(gremlingo.Merge.OnCreate, p["xx2"])}}, 
    "g_mergeE_label_override_prohibited": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"]).Option(gremlingo.Merge.OnCreate, p["xx2"])}}, 
    "g_mergeE_id_override_prohibited": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"]).Option(gremlingo.Merge.OnCreate, p["xx2"])}}, 
    "g_mergeV_mergeE_combination_new_vertices": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(p["xx1"]).As("outV").MergeV(p["xx2"]).As("inV").MergeE(p["xx3"]).Option(gremlingo.Merge.OutV, gremlingo.T__.Select("outV")).Option(gremlingo.Merge.InV, gremlingo.T__.Select("inV"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "marko").Out("knows").Has("name", "vadas")}}, 
    "g_mergeV_mergeE_combination_existing_vertices": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(p["xx1"]).As("outV").MergeV(p["xx2"]).As("inV").MergeE(p["xx3"]).Option(gremlingo.Merge.OutV, gremlingo.T__.Select("outV")).Option(gremlingo.Merge.InV, gremlingo.T__.Select("inV"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "marko").Out("knows").Has("name", "vadas")}}, 
    "g_V_asXvX_mergeEXxx1X_optionXMerge_onMatch_xx2X_optionXMerge_outV_selectXvXX_optionXMerge_inV_selectXvXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("v").MergeE(p["xx1"]).Option(gremlingo.Merge.OnMatch, p["xx2"]).Option(gremlingo.Merge.OutV, gremlingo.T__.Select("v")).Option(gremlingo.Merge.InV, gremlingo.T__.Select("v"))}}, 
    "g_V_mergeEXlabel_knows_out_marko_in_vadasX_optionXonMatch_sideEffectXpropertyXweight_0XX_constantXemptyXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").As("a").AddV("person").Property("name", "vadas").As("b").AddE("knows").Property("weight", 1).From("a").To("b")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().MergeE(p["xx1"]).Option(gremlingo.Merge.OnMatch, gremlingo.T__.SideEffect(gremlingo.T__.Property("weight", 0)).Constant(map[interface{}]interface{}{ }))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("weight", 0)}}, 
    "g_mergeEXlabel_knows_out_marko_in_vadasX_optionXonMatch_sideEffectXpropertyXweight_0XX_constantXemptyXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").As("a").AddV("person").Property("name", "vadas").As("b").AddE("knows").Property("weight", 1).From("a").To("b")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"]).Option(gremlingo.Merge.OnMatch, gremlingo.T__.SideEffect(gremlingo.T__.Property("weight", 0)).Constant(map[interface{}]interface{}{ }))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("weight", 1)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("weight", 0)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("weight")}}, 
    "g_unionXselectXmapX_selectXmapX_constantXcreated_NXX_fold_asXmX_mergeEXselectXmX_limitXlocal_1X_unfoldX_optionXonCreate_selectXmX_rangeXlocal_1_2X_unfoldX_optionXonMatch_selectXmX_tailXlocalX_unfoldX_to_match": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Union(gremlingo.T__.Select("map"), gremlingo.T__.Select("map"), gremlingo.T__.Constant(map[interface{}]interface{}{"created": "N" })).Fold().As("m").MergeE(gremlingo.T__.Select("m").Limit(gremlingo.Scope.Local, 1).Unfold()).Option(gremlingo.Merge.OnCreate, gremlingo.T__.Select("m").Range(gremlingo.Scope.Local, 1, 2).Unfold()).Option(gremlingo.Merge.OnMatch, gremlingo.T__.Select("m").Tail(gremlingo.Scope.Local).Unfold())}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Has("created", "N")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").OutE("knows").Has("created", "N").InV().Has("person", "name", "vadas")}}, 
    "g_unionXselectXmapX_selectXmapX_constantXcreated_NXX_fold_asXmX_mergeEXselectXmX_limitXlocal_1X_unfoldX_optionXonCreate_selectXmX_rangeXlocal_1_2X_unfoldX_optionXonMatch_selectXmX_tailXlocalX_unfoldX_to_create": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Union(gremlingo.T__.Select("map"), gremlingo.T__.Select("map"), gremlingo.T__.Constant(map[interface{}]interface{}{"created": "N" })).Fold().As("m").MergeE(gremlingo.T__.Select("m").Limit(gremlingo.Scope.Local, 1).Unfold()).Option(gremlingo.Merge.OnCreate, gremlingo.T__.Select("m").Range(gremlingo.Scope.Local, 1, 2).Unfold()).Option(gremlingo.Merge.OnMatch, gremlingo.T__.Select("m").Tail(gremlingo.Scope.Local).Unfold())}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasNot("created")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").OutE("knows").HasNot("created").InV().Has("person", "name", "vadas")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "vadas").OutE("self").HasNot("weight").InV().Has("person", "name", "vadas")}}, 
    "g_mergeEXlabel_knows_out_marko_in_vadasX_optionXonMatch_weight_nullX_allowed": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").As("a").AddV("person").Property("name", "vadas").As("b").AddE("knows").From("a").To("b").Property("weight", 1.0)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"]).Option(gremlingo.Merge.OnMatch, p["xx2"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("weight", nil)}}, 
    "g_mergeEXlabel_knows_out_marko_in_vadasX_optionXonMatch_weight_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").As("a").AddV("person").Property("name", "vadas").As("b").AddE("knows").From("a").To("b").Property("weight", 1.0)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"]).Option(gremlingo.Merge.OnMatch, p["xx2"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("weight")}}, 
    "g_mergeVXemptyX_optionXonMatch_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(map[interface{}]interface{}{ }).Option(gremlingo.Merge.OnMatch, nil)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Has("age", 29)}}, 
    "g_V_mergeVXemptyX_optionXonMatch_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().MergeV(map[interface{}]interface{}{ }).Option(gremlingo.Merge.OnMatch, nil)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Has("age", 29)}}, 
    "g_mergeVXnullX_optionXonCreate_label_null_name_markoX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(p["xx1"])}}, 
    "g_V_mergeVXnullX_optionXonCreate_label_null_name_markoX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().MergeV(p["xx1"])}}, 
    "g_mergeVXlabel_person_name_stephenX_optionXonCreate_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(p["xx1"]).Option(gremlingo.Merge.OnCreate, nil)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "stephen")}}, 
    "g_V_mergeVXlabel_person_name_stephenX_optionXonCreate_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().MergeV(p["xx1"]).Option(gremlingo.Merge.OnCreate, nil)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "stephen")}}, 
    "g_mergeVXnullX_optionXonCreate_emptyX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(nil).Option(gremlingo.Merge.OnCreate, map[interface{}]interface{}{ })}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_V_mergeVXnullX_optionXonCreate_emptyX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().MergeV(nil).Option(gremlingo.Merge.OnCreate, map[interface{}]interface{}{ })}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_mergeVXemptyX_no_existing": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(map[interface{}]interface{}{ })}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_injectX0X_mergeVXemptyX_no_existing": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(0).MergeV(map[interface{}]interface{}{ })}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_mergeVXemptyX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(map[interface{}]interface{}{ })}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Has("age", 29)}}, 
    "g_V_mergeVXemptyX_two_exist": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).AddV("person").Property("name", "vadas").Property("age", 27)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().MergeV(map[interface{}]interface{}{ })}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Has("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "vadas").Has("age", 27)}}, 
    "g_mergeVXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(nil)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_mergeVXnullvarX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(p["xx1"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_V_mergeVXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().MergeV(nil)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_mergeVXlabel_person_name_stephenX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(p["xx1"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "stephen")}}, 
    "g_mergeVXlabel_person_name_markoX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(p["xx1"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko")}}, 
    "g_mergeVXlabel_person_name_stephenX_optionXonCreate_label_person_name_stephen_age_19X_option": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(p["xx1"]).Option(gremlingo.Merge.OnCreate, p["xx2"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "stephen").Has("age", 19)}}, 
    "g_mergeVXlabel_person_name_markoX_optionXonMatch_age_19X_option": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(p["xx1"]).Option(gremlingo.Merge.OnMatch, p["xx2"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Has("age", 19)}}, 
    "g_withSideEffectXc_label_person_name_stephenX_withSideEffectXm_label_person_name_stephen_age_19X_mergeVXselectXcXX_optionXonCreate_selectXmXX_option": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(gremlingo.T__.Select("c")).Option(gremlingo.Merge.OnCreate, gremlingo.T__.Select("m"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "stephen").Has("age", 19)}}, 
    "g_withSideEffectXc_label_person_name_markoX_withSideEffectXm_age_19X_mergeVXselectXcXX_optionXonMatch_selectXmXX_option": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(gremlingo.T__.Select("c")).Option(gremlingo.Merge.OnMatch, gremlingo.T__.Select("m"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Has("age", 19)}}, 
    "g_mergeVXlabel_person_name_markoX_propertyXname_vadas_acl_publicX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(p["xx1"]).Property("name", "vadas", "acl", "public")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties("name").HasValue("vadas").Has("acl", "public")}}, 
    "g_injectX0X_mergeVXlabel_person_name_stephenX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(0).MergeV(p["xx1"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "stephen")}}, 
    "g_injectX0X_mergeVXlabel_person_name_markoX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(0).MergeV(p["xx1"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko")}}, 
    "g_injectX0X_mergeVXlabel_person_name_stephenX_optionXonCreate_label_person_name_stephen_age_19X_option": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(0).MergeV(p["xx1"]).Option(gremlingo.Merge.OnCreate, p["xx2"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "stephen").Has("age", 19)}}, 
    "g_injectX0X_mergeVXlabel_person_name_markoX_optionXonMatch_age_19X_option": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(0).MergeV(p["xx1"]).Option(gremlingo.Merge.OnMatch, p["xx2"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Has("age", 19)}}, 
    "g_withSideEffectXc_label_person_name_stephenX_withSideEffectXm_label_person_name_stephen_age_19X_injectX0X_mergeVXselectXcXX_optionXonCreate_selectXmXX_option": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(0).MergeV(gremlingo.T__.Select("c")).Option(gremlingo.Merge.OnCreate, gremlingo.T__.Select("m"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "stephen").Has("age", 19)}}, 
    "g_withSideEffectXc_label_person_name_markoX_withSideEffectXm_age_19X_injectX0X_mergeVXselectXcXX_optionXonMatch_selectXmXX_option": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(0).MergeV(gremlingo.T__.Select("c")).Option(gremlingo.Merge.OnMatch, gremlingo.T__.Select("m"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Has("age", 19)}}, 
    "g_injectX0X_mergeVXlabel_person_name_markoX_propertyXname_vadas_acl_publicX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(0).MergeV(p["xx1"]).Property("name", "vadas", "acl", "public")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties("name").HasValue("vadas").Has("acl", "public")}}, 
    "g_injectXlabel_person_name_marko_label_person_name_stephenX_mergeVXidentityX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(map[interface{}]interface{}{gremlingo.T.Label: "person", "name": "marko" }, map[interface{}]interface{}{gremlingo.T.Label: "person", "name": "stephen" }).MergeV(gremlingo.T__.Identity())}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "stephen")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_injectXlabel_person_name_marko_label_person_name_stephenX_mergeV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(map[interface{}]interface{}{gremlingo.T.Label: "person", "name": "marko" }, map[interface{}]interface{}{gremlingo.T.Label: "person", "name": "stephen" }).MergeV()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "stephen")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_mergeVXlabel_person_name_stephenX_propertyXlist_name_steveX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property(gremlingo.Cardinality.List, "name", "stephen")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(p["xx1"]).Property(gremlingo.Cardinality.List, "name", "steve")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties("name").HasValue("steve")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties("name").HasValue("stephen")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties("name")}}, 
    "g_mergeXlabel_person_name_vadasX_optionXonMatch_age_35X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "vadas").Property("age", 29).AddV("person").Property("name", "vadas").Property("age", 27)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(p["xx1"]).Option(gremlingo.Merge.OnMatch, p["xx2"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("age", 35)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_V_mapXmergeXlabel_person_name_joshXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "vadas").Property("age", 29).AddV("person").Property("name", "stephen").Property("age", 27)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Map(gremlingo.T__.MergeV(p["xx1"]))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "josh")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_withSideEffectXc_label_person_name_markoX_withSideEffectXm_age_19X_mergeVXselectXcXX_optionXonMatch_sideEffectXpropertiesXageX_dropX_selectXmXX_option": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property(gremlingo.Cardinality.List, "age", 29).Property(gremlingo.Cardinality.List, "age", 31).Property(gremlingo.Cardinality.List, "age", 32)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(gremlingo.T__.Select("c")).Option(gremlingo.Merge.OnMatch, gremlingo.T__.SideEffect(gremlingo.T__.Properties("age").Drop()).Select("m"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Has("age", 19)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Has("age")}}, 
    "g_withSideEffectXm_age_19X_V_hasXperson_name_markoX_mergeVXselectXcXX_optionXonMatch_sideEffectXpropertiesXageX_dropX_selectXmXX_option": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property(gremlingo.Cardinality.List, "age", 29).Property(gremlingo.Cardinality.List, "age", 31).Property(gremlingo.Cardinality.List, "age", 32)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").MergeV(map[interface{}]interface{}{ }).Option(gremlingo.Merge.OnMatch, gremlingo.T__.SideEffect(gremlingo.T__.Properties("age").Drop()).Select("m"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Has("age", 19)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Properties("age")}}, 
    "g_mergeV_onCreate_inheritance_existing": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "mike").Property(gremlingo.T.Id, "1")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(p["xx1"]).Option(gremlingo.Merge.OnCreate, p["xx2"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V("1").Has("person", "name", "mike")}}, 
    "g_mergeV_onCreate_inheritance_new_1": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(p["xx1"]).Option(gremlingo.Merge.OnCreate, p["xx2"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V("1").Has("person", "name", "mike")}}, 
    "g_mergeV_onCreate_inheritance_new_2": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(p["xx1"]).Option(gremlingo.Merge.OnCreate, p["xx2"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V("1").Has("person", "name", "mike")}}, 
    "g_mergeV_label_override_prohibited": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(p["xx1"]).Option(gremlingo.Merge.OnCreate, p["xx2"])}}, 
    "g_mergeV_id_override_prohibited": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(p["xx1"]).Option(gremlingo.Merge.OnCreate, p["xx2"])}}, 
    "g_mergeV_hidden_id_key_prohibited": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(p["xx1"])}}, 
    "g_mergeV_hidden_label_key_prohibited": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(p["xx1"])}}, 
    "g_mergeV_hidden_label_value_prohibited": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(p["xx1"])}}, 
    "g_mergeV_hidden_id_key_onCreate_prohibited": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(map[interface{}]interface{}{ }).Option(gremlingo.Merge.OnCreate, p["xx1"])}}, 
    "g_mergeV_hidden_label_key_onCreate_prohibited": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(map[interface{}]interface{}{ }).Option(gremlingo.Merge.OnCreate, p["xx1"])}}, 
    "g_mergeV_hidden_label_value_onCreate_prohibited": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(map[interface{}]interface{}{ }).Option(gremlingo.Merge.OnCreate, p["xx1"])}}, 
    "g_mergeV_hidden_id_key_onMatch_matched_prohibited": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("vertex")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(map[interface{}]interface{}{ }).Option(gremlingo.Merge.OnMatch, p["xx1"])}}, 
    "g_mergeV_hidden_label_key_matched_onMatch_matched_prohibited": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("vertex")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(map[interface{}]interface{}{ }).Option(gremlingo.Merge.OnMatch, p["xx1"])}}, 
    "g_mergeVXname_markoX_optionXonMatch_age_listX33XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property(gremlingo.Cardinality.List, "age", 29).Property(gremlingo.Cardinality.List, "age", 31).Property(gremlingo.Cardinality.List, "age", 32)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(map[interface{}]interface{}{"name": "marko" }).Option(gremlingo.Merge.OnMatch, map[interface{}]interface{}{"age": gremlingo.CardinalityValue.List(33) })}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Has("age", 33)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Has("age")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Properties("age")}}, 
    "g_mergeVXname_markoX_optionXonMatch_age_setX33XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property(gremlingo.Cardinality.List, "age", 29).Property(gremlingo.Cardinality.List, "age", 31).Property(gremlingo.Cardinality.List, "age", 32)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(map[interface{}]interface{}{"name": "marko" }).Option(gremlingo.Merge.OnMatch, map[interface{}]interface{}{"age": gremlingo.CardinalityValue.Set(33) })}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Has("age", 33)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Has("age")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Properties("age")}}, 
    "g_mergeVXname_markoX_optionXonMatch_age_setX31XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property(gremlingo.Cardinality.List, "age", 29).Property(gremlingo.Cardinality.List, "age", 31).Property(gremlingo.Cardinality.List, "age", 32)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(map[interface{}]interface{}{"name": "marko" }).Option(gremlingo.Merge.OnMatch, map[interface{}]interface{}{"age": gremlingo.CardinalityValue.Set(31) })}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Has("age", 31)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Has("age")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Properties("age")}}, 
    "g_mergeVXname_markoX_optionXonMatch_age_singleX33XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property(gremlingo.Cardinality.List, "age", 29).Property(gremlingo.Cardinality.List, "age", 31).Property(gremlingo.Cardinality.List, "age", 32)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(map[interface{}]interface{}{"name": "marko" }).Option(gremlingo.Merge.OnMatch, map[interface{}]interface{}{"age": gremlingo.CardinalityValue.Single(33) })}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Has("age", 33)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Has("age")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Properties("age")}}, 
    "g_mergeVXname_markoX_optionXonMatch_age_33_singleX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property(gremlingo.Cardinality.List, "age", 29).Property(gremlingo.Cardinality.List, "age", 31).Property(gremlingo.Cardinality.List, "age", 32)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(map[interface{}]interface{}{"name": "marko" }).Option(gremlingo.Merge.OnMatch, map[interface{}]interface{}{"age": 33 }, gremlingo.Cardinality.Single)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Has("age", 33)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Has("age")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Properties("age")}}, 
    "g_mergeVXname_markoX_optionXonMatch_name_allen_age_setX31X_singleX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property(gremlingo.Cardinality.List, "age", 29).Property(gremlingo.Cardinality.List, "age", 31).Property(gremlingo.Cardinality.List, "age", 32)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(map[interface{}]interface{}{"name": "marko" }).Option(gremlingo.Merge.OnMatch, map[interface{}]interface{}{"name": "allen", "age": gremlingo.CardinalityValue.Set(31) }, gremlingo.Cardinality.Single)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "allen").Has("age", 31)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "allen").Has("age")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "allen").Properties("age")}}, 
    "g_mergeVXname_markoX_optionXonMatch_name_allen_age_singleX31X_singleX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property(gremlingo.Cardinality.List, "age", 29).Property(gremlingo.Cardinality.List, "age", 31).Property(gremlingo.Cardinality.List, "age", 32)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(map[interface{}]interface{}{"name": "marko" }).Option(gremlingo.Merge.OnMatch, map[interface{}]interface{}{"name": "allen", "age": gremlingo.CardinalityValue.Single(31) }, gremlingo.Cardinality.Single)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "allen").Has("age", 33)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "allen").Has("age", 31)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "allen").Has("age")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "allen").Properties("age")}}, 
    "g_mergeVXname_aliceX_optionXonCreate_age_singleX81XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(map[interface{}]interface{}{"name": "alice", gremlingo.T.Label: "person" }).Option(gremlingo.Merge.OnCreate, map[interface{}]interface{}{"age": gremlingo.CardinalityValue.Single(81) })}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "alice").Has("age", 81)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "alice").Has("age")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "alice").Properties("age")}}, 
    "g_mergeVXname_aliceX_optionXonCreate_age_setX81XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(map[interface{}]interface{}{"name": "alice", gremlingo.T.Label: "person" }).Option(gremlingo.Merge.OnCreate, map[interface{}]interface{}{"age": gremlingo.CardinalityValue.Set(81) })}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "alice").Has("age", 81)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "alice").Has("age")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "alice").Properties("age")}}, 
    "g_mergeVXname_aliceX_optionXonCreate_age_81_setX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(map[interface{}]interface{}{"name": "alice", gremlingo.T.Label: "person" }).Option(gremlingo.Merge.OnCreate, map[interface{}]interface{}{"age": 81 }, gremlingo.Cardinality.Set)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "alice").Has("age", 81)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "alice").Has("age")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "alice").Properties("age")}}, 
    "g_mergeVXname_aliceX_optionXonCreate_age_81_label_person_setX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(map[interface{}]interface{}{"name": "alice" }).Option(gremlingo.Merge.OnCreate, map[interface{}]interface{}{"age": 81, gremlingo.T.Label: "person" }, gremlingo.Cardinality.Set)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "alice").Has("age", 81)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "alice").Has("age")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "alice").Properties("age")}}, 
    "g_mergeV_hidden_label_key_onMatch_matched_prohibited": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(map[interface{}]interface{}{ }).Option(gremlingo.Merge.OnMatch, p["xx1"])}}, 
    "g_injectXlist1_list2_list3X_fold_asXmX_mergeVXselectXmX_limitXlocal_1X_unfoldX_optionXonCreate_selectXmX_rangeXlocal_1_2X_unfoldX_optionXonMatch_selectXmX_tailXlocalX_unfoldX_to_match": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(map[interface{}]interface{}{gremlingo.T.Label: "person", "name": "marko" }, map[interface{}]interface{}{gremlingo.T.Label: "person", "name": "marko" }, map[interface{}]interface{}{"created": "N" }).Fold().As("m").MergeV(gremlingo.T__.Select("m").Limit(gremlingo.Scope.Local, 1).Unfold()).Option(gremlingo.Merge.OnCreate, gremlingo.T__.Select("m").Range(gremlingo.Scope.Local, 1, 2).Unfold()).Option(gremlingo.Merge.OnMatch, gremlingo.T__.Select("m").Tail(gremlingo.Scope.Local).Unfold())}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Has("created", "N")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_injectXlist1_list2_list3X_fold_asXmX_mergeVXselectXmX_limitXlocal_1X_unfoldX_optionXonCreate_selectXmX_rangeXlocal_1_2X_unfoldX_optionXonMatch_selectXmX_tailXlocalX_unfoldX_to_create": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(map[interface{}]interface{}{gremlingo.T.Label: "person", "name": "stephen" }, map[interface{}]interface{}{gremlingo.T.Label: "person", "name": "stephen" }, map[interface{}]interface{}{"created": "N" }).Fold().As("m").MergeV(gremlingo.T__.Select("m").Limit(gremlingo.Scope.Local, 1).Unfold()).Option(gremlingo.Merge.OnCreate, gremlingo.T__.Select("m").Range(gremlingo.Scope.Local, 1, 2).Unfold()).Option(gremlingo.Merge.OnMatch, gremlingo.T__.Select("m").Tail(gremlingo.Scope.Local).Unfold())}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "stephen").HasNot("created")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_V_age_min": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Min()}}, 
    "g_V_foo_min": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("foo").Min()}}, 
    "g_V_name_min": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Min()}}, 
    "g_V_age_fold_minXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Fold().Min(gremlingo.Scope.Local)}}, 
    "g_V_aggregateXaX_byXageX_capXaX_minXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate("a").By("age").Cap("a").Min(gremlingo.Scope.Local)}}, 
    "g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXageX_capXaX_minXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy()).V().Aggregate("a").By("age").Cap("a").Min(gremlingo.Scope.Local)}}, 
    "g_V_aggregateXaX_byXageX_capXaX_unfold_min": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate("a").By("age").Cap("a").Unfold().Min()}}, 
    "g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXageX_capXaX_unfold_min": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy()).V().Aggregate("a").By("age").Cap("a").Unfold().Min()}}, 
    "g_V_aggregateXaX_byXfooX_capXaX_minXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate("a").By("foo").Cap("a").Min(gremlingo.Scope.Local)}}, 
    "g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXfooX_capXaX_minXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy()).V().Aggregate("a").By("foo").Cap("a").Min(gremlingo.Scope.Local)}}, 
    "g_V_aggregateXaX_byXfooX_capXaX_unfold_min": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate("a").By("foo").Cap("a").Unfold().Min()}}, 
    "g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXfooX_capXaX_unfold_min": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy()).V().Aggregate("a").By("foo").Cap("a").Unfold().Min()}}, 
    "g_V_foo_fold_minXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("foo").Fold().Min(gremlingo.Scope.Local)}}, 
    "g_V_name_fold_minXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Fold().Min(gremlingo.Scope.Local)}}, 
    "g_V_repeatXbothX_timesX5X_age_min": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Both()).Times(5).Values("age").Min()}}, 
    "g_V_hasLabelXsoftwareX_group_byXnameX_byXbothE_weight_minX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("software").Group().By("name").By(gremlingo.T__.BothE().Values("weight").Min())}}, 
    "g_V_foo_injectX9999999999X_min": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("foo").Inject(int64(9999999999)).Min()}}, 
    "g_VX1X_valuesXageX_minXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Values("age").Min(gremlingo.Scope.Local)}}, 
    "g_V_localXunionXvaluesXageX_outE_valuesXweightXX_foldX_minXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Local(gremlingo.T__.Union(gremlingo.T__.Values("age"), gremlingo.T__.OutE().Values("weight")).Fold()).Min(gremlingo.Scope.Local)}}, 
    "g_V_name_order": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Order()}}, 
    "g_V_order_byXname_ascX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Order().By("name", gremlingo.Order.Asc).Values("name")}}, 
    "g_V_order_byXnameX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Order().By("name").Values("name")}}, 
    "g_V_outE_order_byXweight_descX_weight": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().OutE().Order().By("weight", gremlingo.Order.Desc).Values("weight")}}, 
    "g_V_asXaX_outXcreatedX_asXbX_order_byXshuffleX_selectXa_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out("created").As("b").Order().By(gremlingo.Order.Shuffle).Select("a", "b")}}, 
    "g_V_both_hasLabelXpersonX_order_byXage_descX_limitX5X_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Both().HasLabel("person").Order().By("age", gremlingo.Order.Desc).Limit(5).Values("name")}}, 
    "g_V_properties_order_byXkey_descX_key": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties().Order().By(gremlingo.T.Key, gremlingo.Order.Desc).Key()}}, 
    "g_V_hasLabelXpersonX_group_byXnameX_byXoutE_weight_sumX_orderXlocalX_byXvaluesX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Group().By("name").By(gremlingo.T__.OutE().Values("weight").Sum()).Order(gremlingo.Scope.Local).By(gremlingo.Column.Values)}}, 
    "g_V_mapXbothE_weight_foldX_order_byXsumXlocalX_descX_byXcountXlocalX_descX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Map(gremlingo.T__.BothE().Values("weight").Order().By(gremlingo.Order.Asc).Fold()).Order().By(gremlingo.T__.Sum(gremlingo.Scope.Local), gremlingo.Order.Desc).By(gremlingo.T__.Count(gremlingo.Scope.Local), gremlingo.Order.Desc)}}, 
    "g_V_group_byXlabelX_byXname_order_byXdescX_foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group().By(gremlingo.T.Label).By(gremlingo.T__.Values("name").Order().By(gremlingo.Order.Desc).Fold())}}, 
    "g_V_hasLabelXpersonX_group_byXnameX_byXoutE_weight_sumX_unfold_order_byXvalues_descX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Group().By("name").By(gremlingo.T__.OutE().Values("weight").Sum()).Unfold().Order().By(gremlingo.Column.Values, gremlingo.Order.Desc)}}, 
    "g_V_asXvX_mapXbothE_weight_foldX_sumXlocalX_asXsX_selectXv_sX_order_byXselectXsX_descX_byXselectXvX_nameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("v").Map(gremlingo.T__.BothE().Values("weight").Fold()).Sum(gremlingo.Scope.Local).As("s").Select("v", "s").Order().By(gremlingo.T__.Select("s"), gremlingo.Order.Desc).By(gremlingo.T__.Select("v").Values("name"))}}, 
    "g_V_hasLabelXpersonX_fold_orderXlocalX_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Fold().Order(gremlingo.Scope.Local).By("age")}}, 
    "g_V_both_hasLabelXpersonX_order_byXage_descX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Both().HasLabel("person").Order().By("age", gremlingo.Order.Desc).Values("name")}}, 
    "g_V_order_byXoutE_count_descX_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Order().By(gremlingo.T__.OutE().Count(), gremlingo.Order.Desc).By("name")}}, 
    "g_V_hasLabelXpersonX_order_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Order().By("age")}}, 
    "g_V_order_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Order().By("age")}}, 
    "g_V_fold_orderXlocalX_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Fold().Order(gremlingo.Scope.Local).By("age")}}, 
    "g_V_fold_orderXlocalX_byXage_descX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Fold().Order(gremlingo.Scope.Local).By("age", gremlingo.Order.Desc)}}, 
    "g_V_orXhasLabelXpersonX_hasXsoftware_name_lopXX_order_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Or(gremlingo.T__.HasLabel("person"), gremlingo.T__.Has("software", "name", "lop")).Order().By("age")}}, 
    "g_withStrategiesXProductiveByStrategyX_V_orXhasLabelXpersonX_hasXsoftware_name_lopXX_order_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy()).V().Or(gremlingo.T__.HasLabel("person"), gremlingo.T__.Has("software", "name", "lop")).Order().By("age")}}, 
    "g_V_hasXsong_name_OHBOYX_outXfollowedByX_outXfollowedByX_order_byXperformancesX_byXsongType_descX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("song", "name", "OH BOY").Out("followedBy").Out("followedBy").Order().By("performances").By("songType", gremlingo.Order.Desc).By("name")}}, 
    "g_V_hasLabelXsongX_order_byXperformances_descX_byXnameX_rangeX110_120X_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("song").Order().By("performances", gremlingo.Order.Desc).By("name").Range(110, 120).Values("name")}}, 
    "g_VX1X_elementMap_orderXlocalX_byXkeys_descXunfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).ElementMap().Order(gremlingo.Scope.Local).By(gremlingo.Column.Keys, gremlingo.Order.Desc).Unfold()}}, 
    "g_VX1X_elementMap_orderXlocalX_byXkeys_ascXunfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).ElementMap().Order(gremlingo.Scope.Local).By(gremlingo.Column.Keys, gremlingo.Order.Asc).Unfold()}}, 
    "g_VX1X_valuesXageX_orderXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Values("age").Order(gremlingo.Scope.Local)}}, 
    "g_V_pageRank_hasXpageRankX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().PageRank().Has("gremlin.pageRankVertexProgram.pageRank")}}, 
    "g_V_outXcreatedX_pageRank_withXedges_bothEX_withXpropertyName_projectRankX_withXtimes_0X_valueMapXname_projectRankX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out("created").PageRank().With("~tinkerpop.pageRank.edges", gremlingo.T__.BothE()).With("~tinkerpop.pageRank.propertyName", "projectRank").With("~tinkerpop.pageRank.times", 0).ValueMap("name", "projectRank")}}, 
    "g_V_pageRank_order_byXpageRank_descX_byXnameX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().PageRank().Order().By("gremlin.pageRankVertexProgram.pageRank", gremlingo.Order.Desc).By("name").Values("name")}}, 
    "g_V_pageRank_order_byXpageRank_descX_name_limitX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().PageRank().Order().By("gremlin.pageRankVertexProgram.pageRank", gremlingo.Order.Desc).Values("name").Limit(2)}}, 
    "g_V_pageRank_withXedges_outEXknowsXX_withXpropertyName_friendRankX_project_byXnameX_byXvaluesXfriendRankX_mathX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().PageRank().With("~tinkerpop.pageRank.edges", gremlingo.T__.OutE("knows")).With("~tinkerpop.pageRank.propertyName", "friendRank").Project("name", "friendRank").By("name").By(gremlingo.T__.Values("friendRank").Math("ceil(_ * 100)"))}}, 
    "g_V_hasLabelXpersonX_pageRank_withXpropertyName_kpageRankX_project_byXnameX_byXvaluesXpageRankX_mathX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").PageRank().With("~tinkerpop.pageRank.propertyName", "pageRank").Project("name", "pageRank").By("name").By(gremlingo.T__.Values("pageRank").Math("ceil(_ * 100)"))}}, 
    "g_V_pageRank_withXpropertyName_pageRankX_asXaX_outXknowsX_pageRank_asXbX_selectXa_bX_by_byXmathX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().PageRank().With("~tinkerpop.pageRank.propertyName", "pageRank").As("a").Out("knows").Values("pageRank").As("b").Select("a", "b").By().By(gremlingo.T__.Math("ceil(_ * 100)"))}}, 
    "g_V_hasLabelXsoftwareX_hasXname_rippleX_pageRankX1X_withXedges_inEXcreatedX_withXtimes_1X_withXpropertyName_priorsX_inXcreatedX_unionXboth__identityX_valueMapXname_priorsX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("software").Has("name", "ripple").PageRank(1.0).With("~tinkerpop.pageRank.edges", gremlingo.T__.InE("created")).With("~tinkerpop.pageRank.times", 1).With("~tinkerpop.pageRank.propertyName", "priors").In("created").Union(gremlingo.T__.Both(), gremlingo.T__.Identity()).ValueMap("name", "priors")}}, 
    "g_V_outXcreatedX_groupXmX_byXlabelX_pageRankX1X_withXpropertyName_pageRankX_withXedges_inEX_withXtimes_1X_inXcreatedX_groupXmX_byXpageRankX_capXmX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out("created").Group("m").By(gremlingo.T.Label).PageRank(1.0).With("~tinkerpop.pageRank.propertyName", "pageRank").With("~tinkerpop.pageRank.edges", gremlingo.T__.InE()).With("~tinkerpop.pageRank.times", 1).In("created").Group("m").By("pageRank").Cap("m")}}, 
    "g_VX1X_name_path": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Values("name").Path()}}, 
    "g_VX1X_out_path_byXageX_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out().Path().By("age").By("name")}}, 
    "g_V_repeatXoutX_timesX2X_path_byXitX_byXnameX_byXlangX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Out()).Times(2).Path().By().By("name").By("lang")}}, 
    "g_V_out_out_path_byXnameX_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Out().Path().By("name").By("age")}}, 
    "g_V_asXaX_hasXname_markoX_asXbX_hasXage_29X_asXcX_path": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Has("name", "marko").As("b").Has("age", 29).As("c").Path()}}, 
    "g_VX1X_outEXcreatedX_inV_inE_outV_path": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE("created").InV().InE().OutV().Path()}}, 
    "g_V_asXaX_out_asXbX_out_asXcX_path_fromXbX_toXcX_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("b").Out().As("c").Path().From("b").To("c").By("name")}}, 
    "g_VX1X_out_path_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out().Path().By("age")}}, 
    "g_withStrategiesXProductiveByStrategyX_VX1X_out_path_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy()).V(p["vid1"]).Out().Path().By("age")}}, 
    "g_injectX1_null_nullX_path": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1, nil, nil).Path()}}, 
    "g_injectX1_null_nullX_path_dedup": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1, nil, nil).Path().Dedup()}}, 
    "g_V_peerPressure_hasXclusterX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().PeerPressure().Has("gremlin.peerPressureVertexProgram.cluster")}}, 
    "g_V_peerPressure_withXpropertyName_clusterX_withXedges_outEXknowsXX_pageRankX1X_byXrankX_withXedges_outEXknowsX_withXtimes_2X_group_byXclusterX_byXrank_sumX_limitX100X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().PeerPressure().With("~tinkerpop.peerPressure.propertyName", "cluster").With("~tinkerpop.peerPressure.edges", gremlingo.T__.OutE("knows")).PageRank(1.0).With("~tinkerpop.pageRank.propertyName", "rank").With("~tinkerpop.pageRank.edges", gremlingo.T__.OutE("knows")).With("~tinkerpop.pageRank.times", 1).Group().By("cluster").By(gremlingo.T__.Values("rank").Sum()).Limit(100)}}, 
    "g_V_hasXname_rippleX_inXcreatedX_peerPressure_withXedges_outEX_withyXpropertyName_clusterX_repeatXunionXidentity__bothX_timesX2X_dedup_valueMapXname_clusterX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "ripple").In("created").PeerPressure().With("~tinkerpop.peerPressure.edges", gremlingo.T__.OutE()).With("~tinkerpop.peerPressure.propertyName", "cluster").Repeat(gremlingo.T__.Union(gremlingo.T__.Identity(), gremlingo.T__.Both())).Times(2).Dedup().ValueMap("name", "cluster")}}, 
    "g_injectXnullX_productXinjectX1XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(nil).Product(gremlingo.T__.Inject(1))}}, 
    "g_V_valuesXnameX_productXV_foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Product(gremlingo.T__.V().Fold())}}, 
    "g_V_fold_productXconstantXnullXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Fold().Product(gremlingo.T__.Constant(nil))}}, 
    "g_V_fold_productXVX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Fold().Product(gremlingo.T__.V())}}, 
    "g_V_valuesXnameX_fold_productX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Fold().Product(2)}}, 
    "g_V_valuesXnameX_fold_productXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Fold().Product(nil)}}, 
    "g_V_valuesXnonexistantX_fold_productXV_valuesXnameX_foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("nonexistant").Fold().Product(gremlingo.T__.V().Values("name").Fold())}}, 
    "g_V_valuesXnameX_fold_productXV_valuesXnonexistantX_foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Fold().Product(gremlingo.T__.V().Values("nonexistant").Fold())}}, 
    "g_V_valuesXageX_order_byXdescX_limitX3X_fold_productXV_valuesXageX_order_byXascX_limitX2X_foldX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Order().By(gremlingo.Order.Desc).Limit(3).Fold().Product(gremlingo.T__.V().Values("age").Order().By(gremlingo.Order.Asc).Limit(2).Fold()).Unfold()}}, 
    "g_V_out_path_byXvaluesXnameX_toUpperX_productXMARKOX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Path().By(gremlingo.T__.Values("name").ToUpper()).Product([]interface{}{"MARKO"}).Unfold()}}, 
    "g_injectXmarkoX_productXV_valuesXnameX_order_foldX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{"marko"}).Product(gremlingo.T__.V().Values("name").Order().Fold()).Unfold()}}, 
    "g_V_valueMapXlocationX_selectXvaluesX_unfold_productXdulles_seattle_vancouverX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap("location").Select(gremlingo.Column.Values).Unfold().Product([]interface{}{"dulles", "seattle", "vancouver"}).Unfold()}}, 
    "g_V_valuesXageX_order_byXascX_fold_productXconstantX27X_foldX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Order().By(gremlingo.Order.Asc).Fold().Product(gremlingo.T__.Constant(27).Fold()).Unfold()}}, 
    "g_V_out_out_path_byXnameX_productXdave_kelvinX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Out().Path().By("name").Product([]interface{}{"dave", "kelvin"}).Unfold()}}, 
    "g_injectXa_null_bX_productXa_cX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{"a", nil, "b"}).Product([]interface{}{"a", "c"}).Unfold()}}, 
    "g_injectXa_null_bX_productXa_null_cX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{"a", nil, "b"}).Product([]interface{}{"a", nil, "c"}).Unfold()}}, 
    "g_injectX3_threeX_productXfive_three_7X_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{int32(3), "three"}).Product([]interface{}{"five", "three", int32(7)}).Unfold()}}, 
    "g_V_hasLabelXpersonX_projectXa_bX_byXoutE_countX_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Project("a", "b").By(gremlingo.T__.OutE().Count()).By("age")}}, 
    "g_V_outXcreatedX_projectXa_bX_byXnameX_byXinXcreatedX_countX_order_byXselectXbX__descX_selectXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out("created").Project("a", "b").By("name").By(gremlingo.T__.In("created").Count()).Order().By(gremlingo.T__.Select("b"), gremlingo.Order.Desc).Select("a")}}, 
    "g_V_valueMap_projectXxX_byXselectXnameXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap().Project("x").By(gremlingo.T__.Select("name"))}}, 
    "g_V_projectXa_bX_byXinE_countX_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Project("a", "b").By(gremlingo.T__.InE().Count()).By("age")}}, 
    "g_withStrategiesXProductiveByStrategyX_V_projectXa_bX_byXinE_countX_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy()).V().Project("a", "b").By(gremlingo.T__.InE().Count()).By("age")}}, 
    "g_V_hasXageX_propertiesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("age").Properties("name").Value()}}, 
    "g_V_hasXageX_propertiesXname_ageX_value": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("age").Properties("name", "age").Value()}}, 
    "g_V_hasXageX_propertiesXage_nameX_value": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("age").Properties("age", "name").Value()}}, 
    "g_V_propertiesXname_age_nullX_value": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties("name", "age", nil).Value()}}, 
    "g_V_valuesXname_age_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name", "age", nil)}}, 
    "g_injectX__feature___test__nullX_rTrim": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("feature  ", "one test ", nil, "", " ", "　abc", "abc　", "　abc　", "　　").RTrim()}}, 
    "g_injectX__feature___test__nullX_rTrimXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{"  feature  ", " one test ", nil, "", " ", "　abc", "abc　", "　abc　", "　　"}).RTrim(gremlingo.Scope.Local)}}, 
    "g_injectX__feature__X_rTrim": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("  feature  ").RTrim()}}, 
    "g_injectXListXa_bXX_rTrim": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{"a", "b"}).RTrim()}}, 
    "g_injectXListX1_2XX_rTrimXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{1, 2}).RTrim(gremlingo.Scope.Local)}}, 
    "g_V_valuesXnameX_rTrim": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", " marko ").Property("age", 29).As("marko").AddV("person").Property("name", "  vadas  ").Property("age", 27).As("vadas").AddV("software").Property("name", "  lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh  ").Property("age", 32).As("josh").AddV("software").Property("name", "   ripple   ").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").RTrim()}}, 
    "g_V_valuesXnameX_order_fold_rTrimXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", " marko ").Property("age", 29).As("marko").AddV("person").Property("name", "  vadas  ").Property("age", 27).As("vadas").AddV("software").Property("name", "  lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh  ").Property("age", 32).As("josh").AddV("software").Property("name", "   ripple   ").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Order().Fold().RTrim(gremlingo.Scope.Local)}}, 
    "g_injectXthat_this_test_nullX_replaceXh_jX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("that", "this", "test", nil).Replace("h", "j")}}, 
    "g_injectXthat_this_test_nullX_fold_replaceXlocal_h_jX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("that", "this", "test", nil).Fold().Replace(gremlingo.Scope.Local, "h", "j")}}, 
    "g_injectXListXa_bXcX_replaceXa_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{"a", "b"}).Replace("a", "b")}}, 
    "g_V_hasLabelXsoftwareX_valueXnameX_replaceXnull_iX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("software").Values("name").Replace(nil, "g")}}, 
    "g_V_hasLabelXsoftwareX_valueXnameX_replaceXa_iX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("software").Values("name").Replace("p", "g")}}, 
    "g_V_hasLabelXsoftwareX_valueXnameX_order_fold_replaceXloacl_a_iX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("software").Values("name").Order().Fold().Replace(gremlingo.Scope.Local, "p", "g")}}, 
    "g_injectXfeature_test_nullX_reverse": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("feature", "test one", nil).Reverse()}}, 
    "g_V_valuesXnameX_reverse": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Reverse()}}, 
    "g_V_valuesXageX_reverse": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Reverse()}}, 
    "g_V_out_path_byXnameX_reverse": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Path().By("name").Reverse()}}, 
    "g_V_out_out_path_byXnameX_reverse": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Out().Path().By("name").Reverse()}}, 
    "g_V_valuesXageX_fold_orderXlocalX_byXdescX_reverse": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Fold().Order(gremlingo.Scope.Local).By(gremlingo.Order.Desc).Reverse()}}, 
    "g_V_valuesXnameX_fold_orderXlocalX_by_reverse": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Fold().Order(gremlingo.Scope.Local).By().Reverse()}}, 
    "g_injectXnullX_reverse": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(nil).Reverse()}}, 
    "g_injectXbX_reverse": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("b").Reverse()}}, 
    "g_injectX3_threeX_reverse": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{3, "three"}).Reverse()}}, 
    "g_VX1X_asXaX_outXknowsX_asXbX_selectXa_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).As("a").Out("knows").As("b").Select("a", "b")}}, 
    "g_VX1X_asXaX_outXknowsX_asXbX_selectXa_bX_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).As("a").Out("knows").As("b").Select("a", "b").By("name")}}, 
    "g_VX1X_asXaX_outXknowsX_asXbX_selectXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).As("a").Out("knows").As("b").Select("a")}}, 
    "g_VX1X_asXaX_outXknowsX_asXbX_selectXaX_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).As("a").Out("knows").As("b").Select("a").By("name")}}, 
    "g_V_asXaX_out_asXbX_selectXa_bX_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("b").Select("a", "b").By("name")}}, 
    "g_V_asXaX_out_aggregateXxX_asXbX_selectXa_bX_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().Aggregate("x").As("b").Select("a", "b").By("name")}}, 
    "g_V_asXaX_name_order_asXbX_selectXa_bX_byXnameX_by_XitX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Values("name").Order().As("b").Select("a", "b").By("name").By()}}, 
    "g_V_hasXname_gremlinX_inEXusesX_order_byXskill_ascX_asXaX_outV_asXbX_selectXa_bX_byXskillX_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "gremlin").InE("uses").Order().By("skill", gremlingo.Order.Asc).As("a").OutV().As("b").Select("a", "b").By("skill").By("name")}}, 
    "g_V_whereX_valueXnameX_isXmarkoXX_asXaX_selectXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Where(gremlingo.T__.Values("name").Is("marko")).As("a").Select("a")}}, 
    "g_V_label_groupCount_asXxX_selectXxX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Label().GroupCount().As("x").Select("x")}}, 
    "g_V_hasLabelXpersonX_asXpX_mapXbothE_label_groupCountX_asXrX_selectXp_rX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").As("p").Map(gremlingo.T__.BothE().Label().GroupCount()).As("r").Select("p", "r")}}, 
    "g_V_chooseXoutE_count_isX0X__asXaX__asXbXX_chooseXselectXaX__selectXaX__selectXbXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Choose(gremlingo.T__.OutE().Count().Is(p["xx1"]), gremlingo.T__.As("a"), gremlingo.T__.As("b")).Choose(gremlingo.T__.Select("a"), gremlingo.T__.Select("a"), gremlingo.T__.Select("b"))}}, 
    "g_VX1X_groupXaX_byXconstantXaXX_byXnameX_selectXaX_selectXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Group("a").By(gremlingo.T__.Constant("a")).By(gremlingo.T__.Values("name")).Barrier().Select("a").Select("a")}}, 
    "g_VX1X_asXhereX_out_selectXhereX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).As("here").Out().Select("here")}}, 
    "g_VX4X_out_asXhereX_hasXlang_javaX_selectXhereX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).As("here").Out().Select("here")}}, 
    "g_VX4X_out_asXhereX_hasXlang_javaX_selectXhereX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).Out().As("here").Has("lang", "java").Select("here").Values("name")}}, 
    "g_VX1X_outE_asXhereX_inV_hasXname_vadasX_selectXhereX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE().As("here").InV().Has("name", "vadas").Select("here")}}, 
    "g_VX1X_outEXknowsX_hasXweight_1X_asXhereX_inV_hasXname_joshX_selectXhereX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE("knows").Has("weight", 1.0).As("here").InV().Has("name", "josh").Select("here")}}, 
    "g_VX1X_outEXknowsX_asXhereX_hasXweight_1X_asXfakeX_inV_hasXname_joshX_selectXhereX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE("knows").As("here").Has("weight", 1.0).As("fake").InV().Has("name", "josh").Select("here")}}, 
    "g_V_asXhereXout_name_selectXhereX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("here").Out().Values("name").Select("here")}}, 
    "g_V_outXcreatedX_unionXasXprojectX_inXcreatedX_hasXname_markoX_selectXprojectX__asXprojectX_inXcreatedX_inXknowsX_hasXname_markoX_selectXprojectXX_groupCount_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out("created").Union(gremlingo.T__.As("project").In("created").Has("name", "marko").Select("project"), gremlingo.T__.As("project").In("created").In("knows").Has("name", "marko").Select("project")).GroupCount().By("name")}}, 
    "g_V_untilXout_outX_repeatXin_asXaXX_selectXaX_byXtailXlocalX_nameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Until(gremlingo.T__.Out().Out()).Repeat(gremlingo.T__.In().As("a")).Select("a").By(gremlingo.T__.Tail(gremlingo.Scope.Local).Values("name"))}}, 
    "g_V_outE_weight_groupCount_selectXkeysX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().OutE().Values("weight").GroupCount().Select(gremlingo.Column.Keys).Unfold()}}, 
    "g_V_hasLabelXsoftwareX_asXnameX_asXlanguageX_asXcreatorsX_selectXname_language_creatorsX_byXnameX_byXlangX_byXinXcreatedX_name_fold_orderXlocalXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("software").As("name").As("language").As("creators").Select("name", "language", "creators").By("name").By("lang").By(gremlingo.T__.In("created").Values("name").Fold().Order(gremlingo.Scope.Local))}}, 
    "g_V_outE_weight_groupCount_unfold_selectXkeysX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().OutE().Values("weight").GroupCount().Unfold().Select(gremlingo.Column.Keys).Unfold()}}, 
    "g_V_outE_weight_groupCount_unfold_selectXvaluesX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().OutE().Values("weight").GroupCount().Unfold().Select(gremlingo.Column.Values).Unfold()}}, 
    "g_V_untilXout_outX_repeatXin_asXaX_in_asXbXX_selectXa_bX_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Until(gremlingo.T__.Out().Out()).Repeat(gremlingo.T__.In().As("a").In().As("b")).Select("a", "b").By("name")}}, 
    "g_V_outE_weight_groupCount_selectXvaluesX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().OutE().Values("weight").GroupCount().Select(gremlingo.Column.Values).Unfold()}}, 
    "g_V_asXaX_whereXoutXknowsXX_selectXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Where(gremlingo.T__.Out("knows")).Select("a")}}, 
    "g_VX1X_asXaX_repeatXout_asXaXX_timesX2X_selectXfirst_aX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).As("a").Repeat(gremlingo.T__.Out().As("a")).Times(2).Select(gremlingo.Pop.First, "a")}}, 
    "g_V_asXaX_outXknowsX_asXbX_localXselectXa_bX_byXnameXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out("knows").As("b").Local(gremlingo.T__.Select("a", "b").By("name"))}}, 
    "g_VX1X_asXaX_repeatXout_asXaXX_timesX2X_selectXlast_aX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).As("a").Repeat(gremlingo.T__.Out().As("a")).Times(2).Select(gremlingo.Pop.Last, "a")}}, 
    "g_VX1X_outEXknowsX_asXhereX_hasXweight_1X_inV_hasXname_joshX_selectXhereX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE("knows").As("here").Has("weight", 1.0).InV().Has("name", "josh").Select("here")}}, 
    "g_V_asXaX_hasXname_markoX_asXbX_asXcX_selectXa_b_cX_by_byXnameX_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Has("name", "marko").As("b").As("c").Select("a", "b", "c").By().By("name").By("age")}}, 
    "g_V_outE_weight_groupCount_selectXvaluesX_unfold_groupCount_selectXvaluesX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().OutE().Values("weight").GroupCount().Select(gremlingo.Column.Values).Unfold().GroupCount().Select(gremlingo.Column.Values).Unfold()}}, 
    "g_V_asXaX_groupXmX_by_byXbothE_countX_barrier_selectXmX_selectXselectXaXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Group("m").By().By(gremlingo.T__.BothE().Count()).Barrier().Select("m").Select(gremlingo.T__.Select("a"))}}, 
    "g_V_asXaX_groupXmX_by_byXbothE_countX_barrier_selectXmX_selectXselectXaXX_byXmathX_plus_XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Group("m").By().By(gremlingo.T__.BothE().Count()).Barrier().Select("m").Select(gremlingo.T__.Select("a")).By(gremlingo.T__.Math("_+_"))}}, 
    "g_V_asXaX_outXknowsX_asXaX_selectXall_constantXaXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out("knows").As("a").Select(gremlingo.Pop.All, gremlingo.T__.Constant("a"))}}, 
    "g_V_selectXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Select("a")}}, 
    "g_V_selectXaX_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Select("a").Count()}}, 
    "g_V_selectXa_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Select("a", "b")}}, 
    "g_V_valueMap_selectXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap().Select("a")}}, 
    "g_V_valueMap_selectXa_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap().Select("a", "b")}}, 
    "g_V_selectXfirst_aX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Select(gremlingo.Pop.First, "a")}}, 
    "g_V_selectXfirst_a_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Select(gremlingo.Pop.First, "a", "b")}}, 
    "g_V_valueMap_selectXfirst_aX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap().Select(gremlingo.Pop.First, "a")}}, 
    "g_V_valueMap_selectXfirst_a_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap().Select(gremlingo.Pop.First, "a", "b")}}, 
    "g_V_selectXlast_aX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Select(gremlingo.Pop.Last, "a")}}, 
    "g_V_selectXlast_a_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Select(gremlingo.Pop.Last, "a", "b")}}, 
    "g_V_valueMap_selectXlast_aX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap().Select(gremlingo.Pop.Last, "a")}}, 
    "g_V_valueMap_selectXlast_a_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap().Select(gremlingo.Pop.Last, "a", "b")}}, 
    "g_V_selectXall_aX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Select(gremlingo.Pop.All, "a")}}, 
    "g_V_selectXall_a_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Select(gremlingo.Pop.All, "a", "b")}}, 
    "g_V_valueMap_selectXall_aX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap().Select(gremlingo.Pop.All, "a")}}, 
    "g_V_valueMap_selectXall_a_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap().Select(gremlingo.Pop.All, "a", "b")}}, 
    "g_V_asXa_bX_out_asXcX_path_selectXkeysX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a", "b").Out().As("c").Path().Select(gremlingo.Column.Keys)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a", "b").Out().As("c").Path().Select(gremlingo.Column.Keys)}}, 
    "g_V_hasXperson_name_markoX_barrier_asXaX_outXknows_selectXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Barrier().As("a").Out("knows").Select("a")}}, 
    "g_V_hasXperson_name_markoX_elementMapXnameX_asXaX_unionXidentity_identityX_selectXaX_selectXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").ElementMap("name").As("a").Union(gremlingo.T__.Identity(), gremlingo.T__.Identity()).Select("a").Select("name")}}, 
    "g_V_hasXperson_name_markoX_count_asXaX_unionXidentity_identityX_selectXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Count().As("a").Union(gremlingo.T__.Identity(), gremlingo.T__.Identity()).Select("a")}}, 
    "g_V_hasXperson_name_markoX_path_asXaX_unionXidentity_identityX_selectXaX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Path().As("a").Union(gremlingo.T__.Identity(), gremlingo.T__.Identity()).Select("a").Unfold()}}, 
    "g_EX11X_propertiesXweightX_asXaX_selectXaX_byXkeyX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E(p["eid11"]).Properties("weight").As("a").Select("a").By(gremlingo.T.Key)}}, 
    "g_EX11X_propertiesXweightX_asXaX_selectXaX_byXvalueX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E(p["eid11"]).Properties("weight").As("a").Select("a").By(gremlingo.T.Value)}}, 
    "g_V_asXaX_selectXaX_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Select("a").By("age")}}, 
    "g_V_asXa_nX_selectXa_nX_byXageX_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a", "n").Select("a", "n").By("age").By("name")}}, 
    "g_withStrategiesXProductiveByStrategyX_V_asXaX_selectXaX_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy()).V().As("a").Select("a").By("age")}}, 
    "g_withSideEffectXk_nullX_injectXxX_selectXkX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("k", nil).Inject("x").Select("k")}}, 
    "g_V_out_in_selectXall_a_a_aX_byXunfold_name_foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("A").Property("name", "a1").As("a1").AddV("B").Property("name", "b1").As("b1").AddE("ab").From("a1").To("b1")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("a").In().As("a").Select(gremlingo.Pop.All, "a", "a", "a").By(gremlingo.T__.Unfold().Values("name").Fold())}}, 
    "g_V_asXlabelX_localXaggregateXxX_selectXxX_selectXlabelX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("label").Local(gremlingo.T__.Aggregate("x")).Barrier().Select("x").Select("label")}}, 
    "g_V_name_asXaX_selectXfirst_aX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").As("a").Select(gremlingo.Pop.First, "a")}}, 
    "g_V_name_asXaX_selectXlast_aX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").As("a").Select(gremlingo.Pop.Last, "a")}}, 
    "g_V_name_asXaX_selectXmixed_aX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").As("a").Select(gremlingo.Pop.Mixed, "a")}}, 
    "g_V_name_asXaX_selectXall_aX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").As("a").Select(gremlingo.Pop.All, "a")}}, 
    "g_V_hasLabelXpersonX_name_asXaX_concatXXX_asXaX_length_asXaX_selectXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Values("name").As("a").Concat("X").As("a").Length().As("a").Select("a")}}, 
    "g_V_hasLabelXpersonX_name_asXaX_concatXXX_asXaX_length_asXaX_selectXfirst_aX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Values("name").As("a").Concat("X").As("a").Length().As("a").Select(gremlingo.Pop.First, "a")}}, 
    "g_V_hasLabelXpersonX_name_asXaX_concatXXX_asXaX_length_asXaX_selectXlast_aX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Values("name").As("a").Concat("X").As("a").Length().As("a").Select(gremlingo.Pop.Last, "a")}}, 
    "g_V_hasLabelXpersonX_name_asXaX_concatXXX_asXaX_concatXYZX_asXaX_selectXmixed_aX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Values("name").As("a").Concat("X").As("a").Concat("YZ").As("a").Select(gremlingo.Pop.Mixed, "a")}}, 
    "g_V_hasLabelXpersonX_name_asXaX_concatXXX_asXaX_concatXYZX_asXaX_selectXall_aX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Values("name").As("a").Concat("X").As("a").Concat("YZ").As("a").Select(gremlingo.Pop.All, "a")}}, 
    "g_V_asXaX_out_asXaX_out_asXaX_selectXmixed_aX_byXunfold_valuesXnameX_foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("a").Out().As("a").Select(gremlingo.Pop.Mixed, "a").By(gremlingo.T__.Unfold().Values("name").Fold())}}, 
    "g_V_asXaX_out_asXaX_out_asXaX_selectXall_aX_byXunfold_valuesXnameX_foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("a").Out().As("a").Select(gremlingo.Pop.All, "a").By(gremlingo.T__.Unfold().Values("name").Fold())}}, 
    "g_V_shortestPath": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ShortestPath()}}, 
    "g_V_both_dedup_shortestPath": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Both().Dedup().ShortestPath()}}, 
    "g_V_shortestPath_edgesIncluded": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ShortestPath().With("~tinkerpop.shortestPath.includeEdges")}}, 
    "g_V_shortestPath_directionXINX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ShortestPath().With("~tinkerpop.shortestPath.edges", gremlingo.Direction.In)}}, 
    "g_V_shortestPath_edgesXoutEX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ShortestPath().With("~tinkerpop.shortestPath.edges", gremlingo.T__.OutE())}}, 
    "g_V_shortestPath_edgesIncluded_edgesXoutEX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ShortestPath().With("~tinkerpop.shortestPath.includeEdges").With("~tinkerpop.shortestPath.edges", gremlingo.T__.OutE())}}, 
    "g_V_hasXname_markoX_shortestPath": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "marko").ShortestPath()}}, 
    "g_V_shortestPath_targetXhasXname_markoXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ShortestPath().With("~tinkerpop.shortestPath.target", gremlingo.T__.Has("name", "marko"))}}, 
    "g_V_shortestPath_targetXvaluesXnameX_isXmarkoXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ShortestPath().With("~tinkerpop.shortestPath.target", gremlingo.T__.Values("name").Is("marko"))}}, 
    "g_V_hasXname_markoX_shortestPath_targetXhasLabelXsoftwareXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "marko").ShortestPath().With("~tinkerpop.shortestPath.target", gremlingo.T__.HasLabel("software"))}}, 
    "g_V_hasXname_markoX_shortestPath_targetXhasXname_joshXX_distanceXweightX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "marko").ShortestPath().With("~tinkerpop.shortestPath.target", gremlingo.T__.Has("name", "josh")).With("~tinkerpop.shortestPath.distance", "weight")}}, 
    "g_V_hasXname_danielX_shortestPath_targetXhasXname_stephenXX_edgesXbothEXusesXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "daniel").ShortestPath().With("~tinkerpop.shortestPath.target", gremlingo.T__.Has("name", "stephen")).With("~tinkerpop.shortestPath.edges", gremlingo.T__.BothE("uses"))}}, 
    "g_V_hasXsong_name_MIGHT_AS_WELLX_shortestPath_targetXhasXsong_name_MAYBE_YOU_KNOW_HOW_I_FEELXX_edgesXoutEXfollowedByXX_distanceXweightX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("song", "name", "MIGHT AS WELL").ShortestPath().With("~tinkerpop.shortestPath.target", gremlingo.T__.Has("song", "name", "MAYBE YOU KNOW HOW I FEEL")).With("~tinkerpop.shortestPath.edges", gremlingo.T__.OutE("followedBy")).With("~tinkerpop.shortestPath.distance", "weight")}}, 
    "g_V_hasXname_markoX_shortestPath_maxDistanceX1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "marko").ShortestPath().With("~tinkerpop.shortestPath.maxDistance", 1)}}, 
    "g_V_hasXname_vadasX_shortestPath_distanceXweightX_maxDistanceX1_3X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "vadas").ShortestPath().With("~tinkerpop.shortestPath.distance", "weight").With("~tinkerpop.shortestPath.maxDistance", 1.3)}}, 
    "g_injectXthat_this_testX_spiltXhX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("that", "this", "test", nil).Split("h")}}, 
    "g_injectXhello_worldX_spiltXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("hello world").Split(nil)}}, 
    "g_injectXthat_this_test_nullX_splitXemptyX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("that", "this", "test", nil).Split("")}}, 
    "g_injectXListXa_bXcX_splitXa_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{"a", "b"}).Split("a")}}, 
    "g_V_hasLabelXpersonX_valueXnameX_splitXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Values("name").Split(nil)}}, 
    "g_V_hasLabelXpersonX_valueXnameX_order_fold_splitXlocal_aX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Values("name").Order().Fold().Split(gremlingo.Scope.Local, "a").Unfold()}}, 
    "g_V_hasLabelXpersonX_valueXnameX_order_fold_splitXlocal_emptyX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Values("name").Order().Fold().Split(gremlingo.Scope.Local, "").Unfold()}}, 
    "g_injectXthat_this_testX_substringX1_8X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("test", "hello world", nil).Substring(1, 8)}}, 
    "g_injectXListXa_bXcX_substringX1_2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{"aa", "bb"}).Substring(1, 2)}}, 
    "g_V_hasLabelXpersonX_valueXnameX_substringX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("software").Values("name").Substring(2)}}, 
    "g_V_hasLabelXsoftwareX_valueXnameX_substringX1_4X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("software").Values("name").Substring(1, 4)}}, 
    "g_V_hasLabelXpersonX_valueXnameX_order_fold_substringXlocal_2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("software").Values("name").Order().Fold().Substring(gremlingo.Scope.Local, 2)}}, 
    "g_V_hasLabelXsoftwareX_valueXnameX_order_fold_substringXlocal_1_4X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("software").Values("name").Order().Fold().Substring(gremlingo.Scope.Local, 1, 4)}}, 
    "g_V_hasLabelXsoftwareX_valueXnameX_substringX1_0X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("software").Values("name").Substring(1, 0)}}, 
    "g_V_hasLabelXpersonX_valueXnameX_substringXneg3X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Values("name").Substring(-3)}}, 
    "g_V_hasLabelXsoftwareX_valueXnameX_substringX1_neg1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("software").Values("name").Substring(1, -1)}}, 
    "g_V_hasLabelXsoftwareX_valueXnameX_substringXneg4_2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("software").Values("name").Substring(-4, 2)}}, 
    "g_V_hasLabelXsoftwareX_valueXnameX_substringXneg3_neg1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("software").Values("name").Substring(-3, -1)}}, 
    "g_V_injectX127b_1bX_sumXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(int8(127), int8(1)).Sum()}}, 
    "g_V_injectX_128b__1bX_sumXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(int8(-128), int8(-1)).Sum()}}, 
    "g_V_injectX32767s_1sX_sumXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(int16(32767), int16(1)).Sum()}}, 
    "g_V_injectX_32768s__1sX_sumXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(int16(-32768), int16(-1)).Sum()}}, 
    "g_V_injectX2147483647i_1iX_sumXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(int32(2147483647), int32(1)).Sum()}}, 
    "g_V_injectX_2147483648i__1iX_sumXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(int32(-2147483648), int32(-1)).Sum()}}, 
    "g_V_age_sum": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Sum()}}, 
    "g_V_foo_sum": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("foo").Sum()}}, 
    "g_V_age_fold_sumXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Fold().Sum(gremlingo.Scope.Local)}}, 
    "g_V_foo_fold_sumXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("foo").Fold().Sum(gremlingo.Scope.Local)}}, 
    "g_V_hasLabelXsoftwareX_group_byXnameX_byXbothE_weight_sumX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("software").Group().By("name").By(gremlingo.T__.BothE().Values("weight").Sum())}}, 
    "g_V_aggregateXaX_byXageX_sumXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate("a").By("age").Cap("a").Sum(gremlingo.Scope.Local)}}, 
    "g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXageX_sumXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy()).V().Aggregate("a").By("age").Cap("a").Sum(gremlingo.Scope.Local)}}, 
    "g_V_aggregateXaX_byXageX_capXaX_unfold_sum": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate("a").By("age").Cap("a").Unfold().Sum()}}, 
    "g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXageX_capXaX_unfold_sum": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy()).V().Aggregate("a").By("age").Cap("a").Unfold().Sum()}}, 
    "g_V_aggregateXaX_byXfooX_sumXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate("a").By("foo").Cap("a").Sum(gremlingo.Scope.Local)}}, 
    "g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXfooX_sumXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy()).V().Aggregate("a").By("foo").Cap("a").Sum(gremlingo.Scope.Local)}}, 
    "g_V_aggregateXaX_byXfooX_capXaX_unfold_sum": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate("a").By("foo").Cap("a").Unfold().Sum()}}, 
    "g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXfooX_capXaX_unfold_sum": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy()).V().Aggregate("a").By("foo").Cap("a").Unfold().Sum()}}, 
    "g_injectXnull_10_5_nullX_sum": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(nil, 10, 5, nil).Sum()}}, 
    "g_injectXlistXnull_10_5_nullXX_sumXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{nil, 10, 5, nil}).Sum(gremlingo.Scope.Local)}}, 
    "g_VX1X_valuesXageX_sumXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Values("age").Sum(gremlingo.Scope.Local)}}, 
    "g_V_localXunionXvaluesXageX_outE_valuesXweightXX_foldX_sumXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Local(gremlingo.T__.Union(gremlingo.T__.Values("age"), gremlingo.T__.OutE().Values("weight")).Fold()).Sum(gremlingo.Scope.Local)}}, 
    "g_V_age_injectX1000nX_sum": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Inject(gremlingo.ParseBigInt("1000")).Sum()}}, 
    "g_injectX1b_2b_3bX_sum": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(int8(1), int8(2), int8(3)).Sum()}}, 
    "g_injectX1b_2b_3sX_sum": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(int8(1), int8(2), int16(3)).Sum()}}, 
    "g_injectX1b_26b_3iX_sum": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(int8(1), int8(2), int32(3)).Sum()}}, 
    "g_injectX1f_26f_3fX_sum": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(float32(1), float32(2), float32(3)).Sum()}}, 
    "g_V_age_injectX1000nX_fold_sumXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Inject(gremlingo.ParseBigInt("1000")).Fold().Sum(gremlingo.Scope.Local)}}, 
    "g_injectX1b_2b_3bX_fold_sumXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(int8(1), int8(2), int8(3)).Fold().Sum(gremlingo.Scope.Local)}}, 
    "g_injectX1b_2b_3sX_fold_sumXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(int8(1), int8(2), int16(3)).Fold().Sum(gremlingo.Scope.Local)}}, 
    "g_injectX1b_26b_3iX_fold_sumXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(int8(1), int8(2), int32(3)).Fold().Sum(gremlingo.Scope.Local)}}, 
    "g_injectX1f_26f_3fX_fold_sumXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(float32(1), float32(2), float32(3)).Fold().Sum(gremlingo.Scope.Local)}}, 
    "g_injectXfeature_test_nullX_toLower": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("FEATURE", "tESt", nil).ToLower()}}, 
    "g_injectXfeature_test_nullX_toLowerXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{"FEATURE", "tESt", nil}).ToLower(gremlingo.Scope.Local)}}, 
    "g_injectXListXa_bXX_toLower": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{"a", "b"}).ToLower()}}, 
    "g_V_valuesXnameX_toLower": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "MARKO").Property("age", 29).As("marko").AddV("person").Property("name", "VADAS").Property("age", 27).As("vadas").AddV("software").Property("name", "LOP").Property("lang", "java").As("lop").AddV("person").Property("name", "JOSH").Property("age", 32).As("josh").AddV("software").Property("name", "RIPPLE").Property("lang", "java").As("ripple").AddV("person").Property("name", "PETER").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").ToLower()}}, 
    "g_V_valuesXnameX_toLowerXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "MARKO").Property("age", 29).As("marko").AddV("person").Property("name", "VADAS").Property("age", 27).As("vadas").AddV("software").Property("name", "LOP").Property("lang", "java").As("lop").AddV("person").Property("name", "JOSH").Property("age", 32).As("josh").AddV("software").Property("name", "RIPPLE").Property("lang", "java").As("ripple").AddV("person").Property("name", "PETER").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").ToLower(gremlingo.Scope.Local)}}, 
    "g_V_valuesXnameX_order_fold_toLowerXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "MARKO").Property("age", 29).As("marko").AddV("person").Property("name", "VADAS").Property("age", 27).As("vadas").AddV("software").Property("name", "LOP").Property("lang", "java").As("lop").AddV("person").Property("name", "JOSH").Property("age", 32).As("josh").AddV("software").Property("name", "RIPPLE").Property("lang", "java").As("ripple").AddV("person").Property("name", "PETER").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Order().Fold().ToLower(gremlingo.Scope.Local)}}, 
    "g_injectXfeature_test_nullX_toUpper": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("feature", "tESt", nil).ToUpper()}}, 
    "g_injectXfeature_test_nullX_toUpperXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{"feature", "tESt", nil}).ToUpper(gremlingo.Scope.Local)}}, 
    "g_injectXListXa_bXX_toUpper": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{"a", "b"}).ToUpper()}}, 
    "g_V_valuesXnameX_toUpper": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").ToUpper()}}, 
    "g_V_valuesXnameX_toUpperXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").ToUpper(gremlingo.Scope.Local)}}, 
    "g_V_valuesXnameX_order_fold_toUpperXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Order().Fold().ToUpper(gremlingo.Scope.Local)}}, 
    "g_injectX__feature___test__nullX_trim": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("  feature  ", " one test ", nil, "", " ", "　abc", "abc　", "　abc　", "　　").Trim()}}, 
    "g_injectX__feature___test__nullX_trimXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{"  feature  ", " one test ", nil, "", " ", "　abc", "abc　", "　abc　", "　　"}).Trim(gremlingo.Scope.Local)}}, 
    "g_injectXListXa_bXX_trim": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{"a", "b"}).Trim()}}, 
    "g_injectXListX1_2XX_trimXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{1, 2}).Trim(gremlingo.Scope.Local)}}, 
    "g_V_valuesXnameX_trim": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", " marko ").Property("age", 29).As("marko").AddV("person").Property("name", "  vadas  ").Property("age", 27).As("vadas").AddV("software").Property("name", "  lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh  ").Property("age", 32).As("josh").AddV("software").Property("name", "   ripple   ").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Trim()}}, 
    "g_V_valuesXnameX_order_fold_trimXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", " marko ").Property("age", 29).As("marko").AddV("person").Property("name", "  vadas  ").Property("age", 27).As("vadas").AddV("software").Property("name", "  lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh  ").Property("age", 32).As("josh").AddV("software").Property("name", "   ripple   ").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Order().Fold().Trim(gremlingo.Scope.Local)}}, 
    "g_V_localXoutE_foldX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Local(gremlingo.T__.OutE().Fold()).Unfold()}}, 
    "g_V_valueMap_unfold_mapXselectXkeysXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap().Unfold().Map(gremlingo.T__.Select(gremlingo.Column.Keys))}}, 
    "g_VX1X_repeatXboth_simplePathX_untilXhasIdX6XX_path_byXnameX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Repeat(gremlingo.T__.Both().SimplePath()).Until(gremlingo.T__.HasId(p["vid6"])).Path().By("name").Unfold()}}, 
    "g_V_valueMap": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap()}}, 
    "g_V_valueMapXtrueX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap(true)}}, 
    "g_V_valueMap_withXtokensX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap().With(gremlingo.WithOptions.Tokens)}}, 
    "g_V_valueMapXname_ageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap("name", "age")}}, 
    "g_V_valueMapXtrue_name_ageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap(true, "name", "age")}}, 
    "g_V_valueMapXname_ageX_withXtokensX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap("name", "age").With(gremlingo.WithOptions.Tokens)}}, 
    "g_V_valueMapXname_ageX_withXtokens_labelsX_byXunfoldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap("name", "age").With(gremlingo.WithOptions.Tokens, gremlingo.WithOptions.Labels).By(gremlingo.T__.Unfold())}}, 
    "g_V_valueMapXname_ageX_withXtokens_idsX_byXunfoldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap("name", "age").With(gremlingo.WithOptions.Tokens, gremlingo.WithOptions.Ids).By(gremlingo.T__.Unfold())}}, 
    "g_VX1X_outXcreatedX_valueMap": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out("created").ValueMap()}}, 
    "g_V_hasLabelXpersonX_filterXoutEXcreatedXX_valueMapXtrueX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Filter(gremlingo.T__.OutE("created")).ValueMap(true)}}, 
    "g_V_hasLabelXpersonX_filterXoutEXcreatedXX_valueMap_withXtokensX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Filter(gremlingo.T__.OutE("created")).ValueMap().With(gremlingo.WithOptions.Tokens)}}, 
    "g_VX1X_valueMapXname_locationX_byXunfoldX_by": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).ValueMap("name", "location").By(gremlingo.T__.Unfold()).By()}}, 
    "g_V_valueMapXname_age_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap("name", "age", nil)}}, 
    "g_V_valueMapXname_ageX_byXisXxXXbyXunfoldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap("name", "age").By(gremlingo.T__.Is("x")).By(gremlingo.T__.Unfold())}}, 
    "g_VXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(nil)}}, 
    "g_VXlistXnullXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["xx1"])}}, 
    "g_VX1_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"], nil)}}, 
    "g_VXlistX1_2_3XX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["xx1"]).Values("name")}}, 
    "g_VXlistXv1_v2_v3XX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["xx1"]).Values("name")}}, 
    "g_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_VXv1X_out": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out()}}, 
    "g_VX1X_out": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out()}}, 
    "g_VX2X_in": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid2"]).In()}}, 
    "g_VX4X_both": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).Both()}}, 
    "g_VX1X_outE": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE()}}, 
    "g_VX2X_outE": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid2"]).InE()}}, 
    "g_VX4X_bothEXcreatedX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).BothE("created")}}, 
    "g_VX4X_bothEXcreatedvarX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).BothE(p["xx1"])}}, 
    "g_VX4X_bothE": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).BothE()}}, 
    "g_V_out_outE_inV_inE_inV_both_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().OutE().InV().InE().InV().Both().Values("name")}}, 
    "g_VX2X_inE": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid2"]).BothE()}}, 
    "g_VX1X_outXknowsX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out("knows")}}, 
    "g_VX1AsStringX_outXknowsX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out("knows")}}, 
    "g_VX1X_outXknows_createdX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out("knows", "created")}}, 
    "g_VX1X_outXknowsvar_createdvarX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out(p["xx2"], p["xx3"])}}, 
    "g_V_out_out": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Out()}}, 
    "g_VX1X_out_out_out": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out().Out().Out()}}, 
    "g_VX1X_out_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out().Values("name")}}, 
    "g_VX1X_to_XOUT_knowsX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).To(gremlingo.Direction.Out, "knows")}}, 
    "g_VX1_2_3_4X_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("software", "name", "lop").Drop()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"], p["vid2"], p["vid3"], p["vid4"])}}, 
    "g_V_hasLabelXpersonX_V_hasLabelXsoftwareX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").V().HasLabel("software").Values("name")}}, 
    "g_V_hasLabelXloopsX_bothEXselfX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("loops").BothE("self")}}, 
    "g_V_hasLabelXloopsX_bothXselfX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("loops").Both("self")}}, 
    "g_injectX1X_VXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).V(nil)}}, 
    "g_injectX1X_VX1_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).V(p["vid1"], nil)}}, 
    "g_VX1X_V_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).V().Values("name")}}, 
    "g_V_outXknowsX_V_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out("knows").V().Values("name")}}, 
    "g_V_hasXname_GarciaX_inXsungByX_asXsongX_V_hasXname_Willie_DixonX_inXwrittenByX_whereXeqXsongXX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("artist", "name", "Garcia").In("sungBy").As("song").V().Has("artist", "name", "Willie_Dixon").In("writtenBy").Where(gremlingo.P.Eq("song")).Values("name")}}, 
    "g_V_hasLabelXpersonX_asXpX_VXsoftwareX_addInEXuses_pX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").As("p").V(p["xx1"]).AddE("uses").From("p")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("uses")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE("uses")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid2"]).OutE("uses")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid3"]).InE("uses")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).OutE("uses")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid5"]).InE("uses")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid6"]).OutE("uses")}}, 
    "InjectXnullX_eqXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(nil).Is(gremlingo.P.Eq(nil))}}, 
    "InjectXnullX_neqXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(nil).Is(gremlingo.P.Neq(nil))}}, 
    "InjectXnullX_ltXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(nil).Is(gremlingo.P.Lt(nil))}}, 
    "InjectXnullX_lteXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(nil).Is(gremlingo.P.Lte(nil))}}, 
    "InjectXnullX_gtXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(nil).Is(gremlingo.P.Gt(nil))}}, 
    "InjectXnullX_gteXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(nil).Is(gremlingo.P.Gte(nil))}}, 
    "InjectXNaNX_eqXNaNX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(math.NaN()).Is(gremlingo.P.Eq(math.NaN()))}}, 
    "InjectXNaNX_neqXNaNX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(math.NaN()).Is(gremlingo.P.Neq(math.NaN()))}}, 
    "InjectXNaNX_ltXNaNX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(math.NaN()).Is(gremlingo.P.Lt(math.NaN()))}}, 
    "InjectXNaNX_lteXNaNX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(math.NaN()).Is(gremlingo.P.Lte(math.NaN()))}}, 
    "InjectXNaNX_gtXNaNX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(math.NaN()).Is(gremlingo.P.Gt(math.NaN()))}}, 
    "InjectXNaNX_gteXNaNX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(math.NaN()).Is(gremlingo.P.Gte(math.NaN()))}}, 
    "InjectX1dX_eqXNaNX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Is(gremlingo.P.Eq(math.NaN()))}}, 
    "InjectX1dX_neqXNaNX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Is(gremlingo.P.Neq(math.NaN()))}}, 
    "InjectX1dX_ltXNaNX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Is(gremlingo.P.Lt(math.NaN()))}}, 
    "InjectX1dX_lteXNaNX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Is(gremlingo.P.Lte(math.NaN()))}}, 
    "InjectX1dX_gtXNaNX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Is(gremlingo.P.Gt(math.NaN()))}}, 
    "InjectX1dX_gteXNaNX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Is(gremlingo.P.Gte(math.NaN()))}}, 
    "InjectXNaNX_eqXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(math.NaN()).Is(gremlingo.P.Eq(nil))}}, 
    "InjectXNaNX_neqXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(math.NaN()).Is(gremlingo.P.Neq(nil))}}, 
    "InjectXNaNX_ltXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(math.NaN()).Is(gremlingo.P.Lt(nil))}}, 
    "InjectXNaNX_lteXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(math.NaN()).Is(gremlingo.P.Lte(nil))}}, 
    "InjectXNaNX_gtXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(math.NaN()).Is(gremlingo.P.Gt(nil))}}, 
    "InjectXNaNX_gteXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(math.NaN()).Is(gremlingo.P.Gte(nil))}}, 
    "InjectXfooX_eqX1dX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("foo").Is(gremlingo.P.Eq(1.0))}}, 
    "InjectXfooX_neqX1dX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("foo").Is(gremlingo.P.Neq(1.0))}}, 
    "InjectXfooX_ltX1dX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("foo").Is(gremlingo.P.Lt(1.0))}}, 
    "InjectXfooX_lteX1dX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("foo").Is(gremlingo.P.Lte(1.0))}}, 
    "InjectXfooX_gtX1dX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("foo").Is(gremlingo.P.Gt(1.0))}}, 
    "InjectXfooX_gteX1dX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("foo").Is(gremlingo.P.Gte(1.0))}}, 
    "InjectX1dX_eqXfooX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Is(gremlingo.P.Eq("foo"))}}, 
    "InjectX1dX_neqXfooX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Is(gremlingo.P.Neq("foo"))}}, 
    "InjectX1dX_ltXfooX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Is(gremlingo.P.Lt("foo"))}}, 
    "InjectX1dX_lteXfooX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Is(gremlingo.P.Lte("foo"))}}, 
    "InjectX1dX_gtXfooX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Is(gremlingo.P.Gt("foo"))}}, 
    "InjectX1dX_gteXfooX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Is(gremlingo.P.Gte("foo"))}}, 
    "InjectX1dX_andXtrue_trueX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).And(gremlingo.T__.Is(gremlingo.P.Eq(1)), gremlingo.T__.Is(gremlingo.P.Gt(0)))}}, 
    "InjectX1dX_isXtrue_trueX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).Is(gremlingo.P.Eq(1).And(gremlingo.P.Gt(0)))}}, 
    "InjectX1dX_andXtrue_falseX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).And(gremlingo.T__.Is(gremlingo.P.Eq(1)), gremlingo.T__.Is(gremlingo.P.Lt(0)))}}, 
    "InjectX1dX_isXtrue_falseX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).Is(gremlingo.P.Eq(1).And(gremlingo.P.Lt(0)))}}, 
    "InjectX1dX_andXtrue_errorX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).And(gremlingo.T__.Is(gremlingo.P.Eq(1)), gremlingo.T__.Is(gremlingo.P.Lt(math.NaN())))}}, 
    "InjectX1dX_isXtrue_errorX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).Is(gremlingo.P.Eq(1).And(gremlingo.P.Lt(math.NaN())))}}, 
    "InjectX1dX_andXfalse_trueX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).And(gremlingo.T__.Is(gremlingo.P.Neq(1)), gremlingo.T__.Is(gremlingo.P.Gt(0)))}}, 
    "InjectX1dX_isXfalse_trueX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).Is(gremlingo.P.Neq(1).And(gremlingo.P.Gt(0)))}}, 
    "InjectX1dX_andXfalse_falseX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).And(gremlingo.T__.Is(gremlingo.P.Neq(1)), gremlingo.T__.Is(gremlingo.P.Lt(0)))}}, 
    "InjectX1dX_isXfalse_falseX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).Is(gremlingo.P.Neq(1).And(gremlingo.P.Lt(0)))}}, 
    "InjectX1dX_andXfalse_errorX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).And(gremlingo.T__.Is(gremlingo.P.Neq(1)), gremlingo.T__.Is(gremlingo.P.Lt(math.NaN())))}}, 
    "InjectX1dX_isXfalse_errorX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).Is(gremlingo.P.Neq(1).And(gremlingo.P.Lt(math.NaN())))}}, 
    "InjectX1dX_andXerror_trueX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).And(gremlingo.T__.Is(gremlingo.P.Lt(math.NaN())), gremlingo.T__.Is(gremlingo.P.Gt(0)))}}, 
    "InjectX1dX_isXerror_trueX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).Is(gremlingo.P.Lt(math.NaN()).And(gremlingo.P.Gt(0)))}}, 
    "InjectX1dX_andXerror_falseX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).And(gremlingo.T__.Is(gremlingo.P.Lt(math.NaN())), gremlingo.T__.Is(gremlingo.P.Gt(2)))}}, 
    "InjectX1dX_isXerror_falseX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).Is(gremlingo.P.Lt(math.NaN()).And(gremlingo.P.Gt(2)))}}, 
    "InjectX1dX_andXerror_errorX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).And(gremlingo.T__.Is(gremlingo.P.Lt(math.NaN())), gremlingo.T__.Is(gremlingo.P.Gt(math.NaN())))}}, 
    "InjectX1dX_isXerror_errorX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).Is(gremlingo.P.Lt(math.NaN()).And(gremlingo.P.Gt(math.NaN())))}}, 
    "InjectX1dX_orXtrue_trueX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).Or(gremlingo.T__.Is(gremlingo.P.Eq(1)), gremlingo.T__.Is(gremlingo.P.Gt(0)))}}, 
    "InjectX1dX_isXtrue_or_trueX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).Is(gremlingo.P.Eq(1).Or(gremlingo.P.Gt(0)))}}, 
    "InjectX1dX_orXtrue_falseX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).Or(gremlingo.T__.Is(gremlingo.P.Eq(1)), gremlingo.T__.Is(gremlingo.P.Lt(0)))}}, 
    "InjectX1dX_isXtrue_or_falseX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).Is(gremlingo.P.Eq(1).Or(gremlingo.P.Lt(0)))}}, 
    "InjectX1dX_orXtrue_errorX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).Or(gremlingo.T__.Is(gremlingo.P.Eq(1)), gremlingo.T__.Is(gremlingo.P.Lt(math.NaN())))}}, 
    "InjectX1dX_isXtrue_or_errorX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).Is(gremlingo.P.Eq(1).Or(gremlingo.P.Lt(math.NaN())))}}, 
    "InjectX1dX_orXfalse_trueX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).Or(gremlingo.T__.Is(gremlingo.P.Neq(1)), gremlingo.T__.Is(gremlingo.P.Gt(0)))}}, 
    "InjectX1dX_isXfalse_or_trueX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).Is(gremlingo.P.Neq(1).Or(gremlingo.P.Gt(0)))}}, 
    "InjectX1dX_orXfalse_falseX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).Or(gremlingo.T__.Is(gremlingo.P.Neq(1)), gremlingo.T__.Is(gremlingo.P.Lt(0)))}}, 
    "InjectX1dX_isXfalse_or_falseX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).Is(gremlingo.P.Neq(1).Or(gremlingo.P.Lt(0)))}}, 
    "InjectX1dX_orXfalse_errorX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).Or(gremlingo.T__.Is(gremlingo.P.Neq(1)), gremlingo.T__.Is(gremlingo.P.Lt(math.NaN())))}}, 
    "InjectX1dX_isXfalse_or_errorX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).Is(gremlingo.P.Neq(1).Or(gremlingo.P.Lt(math.NaN())))}}, 
    "InjectX1dX_orXerror_trueX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).Or(gremlingo.T__.Is(gremlingo.P.Lt(math.NaN())), gremlingo.T__.Is(gremlingo.P.Gt(0)))}}, 
    "InjectX1dX_isXerror_or_trueX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).Is(gremlingo.P.Lt(math.NaN()).Or(gremlingo.P.Gt(0)))}}, 
    "InjectX1dX_orXerror_falseX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).Or(gremlingo.T__.Is(gremlingo.P.Lt(math.NaN())), gremlingo.T__.Is(gremlingo.P.Gt(2)))}}, 
    "InjectX1dX_isXerror_or_falseX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).Is(gremlingo.P.Lt(math.NaN()).Or(gremlingo.P.Gt(2)))}}, 
    "InjectX1dX_orXerror_errorX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).Or(gremlingo.T__.Is(gremlingo.P.Lt(math.NaN())), gremlingo.T__.Is(gremlingo.P.Gt(math.NaN())))}}, 
    "InjectX1dX_isXerror_or_errorX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).Is(gremlingo.P.Lt(math.NaN()).Or(gremlingo.P.Gt(math.NaN())))}}, 
    "InjectX1dX_notXtrueX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).Not(gremlingo.T__.Is(gremlingo.P.Gt(0)))}}, 
    "InjectX1dX_notXfalseX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).Not(gremlingo.T__.Is(gremlingo.P.Lt(0)))}}, 
    "InjectX1dX_notXNaNX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).Not(gremlingo.T__.Is(gremlingo.P.Gt(math.NaN())))}}, 
    "InjectX1dX_notXisXeqXNaNXXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).Not(gremlingo.T__.Is(gremlingo.P.Eq(math.NaN())))}}, 
    "InjectXInfX_eqXInfX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(math.Inf(1)).Is(gremlingo.P.Eq(math.Inf(1)))}}, 
    "InjectXInfX_neqXInfX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(math.Inf(1)).Is(gremlingo.P.Neq(math.Inf(1)))}}, 
    "InjectXNegInfX_eqXNegInfX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(math.Inf(-1)).Is(gremlingo.P.Eq(math.Inf(-1)))}}, 
    "InjectXNegInfX_neqXNegInfX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(math.Inf(-1)).Is(gremlingo.P.Neq(math.Inf(-1)))}}, 
    "InjectXInfX_gtXNegInfX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(math.Inf(1)).Is(gremlingo.P.Gt(math.Inf(-1)))}}, 
    "InjectXInfX_ltXNegInfX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(math.Inf(1)).Is(gremlingo.P.Lt(math.Inf(-1)))}}, 
    "InjectXNegInfX_ltXInfX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(math.Inf(-1)).Is(gremlingo.P.Lt(math.Inf(1)))}}, 
    "InjectXNegInfX_gtXInfX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(math.Inf(-1)).Is(gremlingo.P.Gt(math.Inf(1)))}}, 
    "Primitives_Number_eqXbyteX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{int8(1), int16(1), int32(1), int64(1), float32(1), 1, int32(1000), gremlingo.ParseBigDecimal("1"), gremlingo.ParseBigInt("1")}).Unfold().Where(gremlingo.T__.Is(p["xx1"]))}}, 
    "Primitives_Number_eqXshortX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{int8(1), int16(1), int32(1), int64(1), float32(1), 1, int32(1000), gremlingo.ParseBigDecimal("1"), gremlingo.ParseBigInt("1")}).Unfold().Where(gremlingo.T__.Is(p["xx1"]))}}, 
    "Primitives_Number_eqXintX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{int8(1), int16(1), int32(1), int64(1), float32(1), 1, int32(1000), gremlingo.ParseBigDecimal("1"), gremlingo.ParseBigInt("1")}).Unfold().Where(gremlingo.T__.Is(p["xx1"]))}}, 
    "Primitives_Number_eqXlongX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{int8(1), int16(1), int32(1), int64(1), float32(1), 1, int32(1000), gremlingo.ParseBigDecimal("1"), gremlingo.ParseBigInt("1")}).Unfold().Where(gremlingo.T__.Is(p["xx1"]))}}, 
    "Primitives_Number_eqXbigintX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{int8(1), int16(1), int32(1), int64(1), float32(1), 1, int32(1000), gremlingo.ParseBigDecimal("1"), gremlingo.ParseBigInt("1")}).Unfold().Where(gremlingo.T__.Is(p["xx1"]))}}, 
    "Primitives_Number_eqXfloatX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{int8(1), int16(1), int32(1), int64(1), float32(1), 1, int32(1000), gremlingo.ParseBigDecimal("1"), gremlingo.ParseBigInt("1")}).Unfold().Where(gremlingo.T__.Is(p["xx1"]))}}, 
    "Primitives_Number_eqXdoubleX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{int8(1), int16(1), int32(1), int64(1), float32(1), 1, int32(1000), gremlingo.ParseBigDecimal("1"), gremlingo.ParseBigInt("1")}).Unfold().Where(gremlingo.T__.Is(p["xx1"]))}}, 
    "Primitives_Number_eqXbigdecimalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{int8(1), int16(1), int32(1), int64(1), float32(1), 1, int32(1000), gremlingo.ParseBigDecimal("1"), gremlingo.ParseBigInt("1")}).Unfold().Where(gremlingo.T__.Is(p["xx1"]))}}, 
    "g_V_values_order": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values().Order()}}, 
    "g_V_properties_order": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties().Order()}}, 
    "g_V_properties_order_id": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties().Order().Id()}}, 
    "g_E_properties_order_value": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "alice").As("a").AddE("self").From("a").To("a").Property("weight", 0.5).Property("a", int32(10)).AddE("self").From("a").To("a").Property("weight", 1.0).Property("a", int32(11)).AddE("self").From("a").To("a").Property("weight", 0.4).Property("a", int32(12)).AddE("self").From("a").To("a").Property("weight", 1.0).Property("a", int32(13)).AddE("self").From("a").To("a").Property("weight", 0.4).Property("a", int32(14)).AddE("self").From("a").To("a").Property("weight", 0.2).Property("a", int32(15))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Properties().Order().Value()}}, 
    "g_E_properties_order_byXdescX_value": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "alice").As("a").AddE("self").From("a").To("a").Property("weight", 0.5).Property("a", int32(10)).AddE("self").From("a").To("a").Property("weight", 1.0).Property("a", int32(11)).AddE("self").From("a").To("a").Property("weight", 0.4).Property("a", int32(12)).AddE("self").From("a").To("a").Property("weight", 1.0).Property("a", int32(13)).AddE("self").From("a").To("a").Property("weight", 0.4).Property("a", int32(14)).AddE("self").From("a").To("a").Property("weight", 0.2).Property("a", int32(15))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Properties().Order().By(gremlingo.Order.Desc).Value()}}, 
    "g_inject_order": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("zzz", "foo", []interface{}{"a", "b", "c", "d"}, 1, []interface{}{"a", "b", "c"}, map[interface{}]interface{}{"a": "a", "b": "b" }, nil, 2.0, map[interface{}]interface{}{"a": "a", "b": false, "c": "c" }, "bar", true, false, math.Inf(1), math.NaN(), math.Inf(-1)).Order()}}, 
    "g_inject_order_byXdescX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("zzz", "foo", []interface{}{"a", "b", "c", "d"}, 1, []interface{}{"a", "b", "c"}, map[interface{}]interface{}{"a": "a", "b": "b" }, nil, 2.0, map[interface{}]interface{}{"a": "a", "b": false, "c": "c" }, "bar", true, false, math.Inf(1), math.NaN(), math.Inf(-1)).Order().By(gremlingo.Order.Desc)}}, 
    "g_V_out_out_order_byXascX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Out().Order().By(gremlingo.Order.Asc)}}, 
    "g_V_out_out_order_byXdescX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Out().Order().By(gremlingo.Order.Desc)}}, 
    "g_V_out_out_asXheadX_path_order_byXascX_selectXheadX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Out().As("head").Path().Order().By(gremlingo.Order.Asc).Select("head")}}, 
    "g_V_out_out_asXheadX_path_order_byXdescX_selectXheadX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Out().As("head").Path().Order().By(gremlingo.Order.Desc).Select("head")}}, 
    "g_V_out_outE_order_byXascX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().OutE().Order().By(gremlingo.Order.Asc)}}, 
    "g_V_out_outE_order_byXdescX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().OutE().Order().By(gremlingo.Order.Desc)}}, 
    "g_V_out_outE_asXheadX_path_order_byXascX_selectXheadX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().OutE().As("head").Path().Order().By(gremlingo.Order.Asc).Select("head")}}, 
    "g_V_out_outE_asXheadX_path_order_byXdescX_selectXheadX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().OutE().As("head").Path().Order().By(gremlingo.Order.Desc).Select("head")}}, 
    "g_V_out_out_properties_asXheadX_path_order_byXascX_selectXheadX_value": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Out().Properties().As("head").Path().Order().By(gremlingo.Order.Asc).Select("head").Value()}}, 
    "g_V_out_out_properties_asXheadX_path_order_byXdescX_selectXheadX_value": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Out().Properties().As("head").Path().Order().By(gremlingo.Order.Desc).Select("head").Value()}}, 
    "g_V_out_out_values_asXheadX_path_order_byXascX_selectXheadX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Out().Values().As("head").Path().Order().By(gremlingo.Order.Asc).Select("head")}}, 
    "g_V_out_out_values_asXheadX_path_order_byXdescX_selectXheadX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Out().Values().As("head").Path().Order().By(gremlingo.Order.Desc).Select("head")}}, 
    "g_V_valueXnameX_aggregateXxX_capXxX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Aggregate("x").Cap("x")}}, 
    "g_V_aggregateXxX_byXnameX_capXxX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate("x").By("name").Cap("x")}}, 
    "g_V_out_aggregateXaX_path": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Aggregate("a").Path()}}, 
    "g_V_hasLabelXpersonX_aggregateXxX_byXageX_capXxX_asXyX_selectXyX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Aggregate("x").By("age").Cap("x").As("y").Select("y")}}, 
    "g_V_aggregateXxX_byXageX_capXxX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate("x").By("age").Cap("x")}}, 
    "g_V_localXaggregateXxX_byXageXX_capXxX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Local(gremlingo.T__.Aggregate("x").By("age")).Cap("x")}}, 
    "g_withStrategiesXProductiveByStrategyX_V_localXaggregateXxX_byXageXX_capXxX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy()).V().Local(gremlingo.T__.Aggregate("x").By("age")).Cap("x")}}, 
    "g_V_localX_aggregateXa_byXnameXX_out_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Local(gremlingo.T__.Aggregate("a").By("name")).Out().Cap("a")}}, 
    "g_VX1X_localXaggregateXaX_byXnameXX_out_localXaggregateXaX_byXnameXX_name_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Local(gremlingo.T__.Aggregate("a").By("name")).Out().Local(gremlingo.T__.Aggregate("a").By("name")).Values("name").Cap("a")}}, 
    "g_withSideEffectXa_setX_V_both_name_localXaggregateX_aXX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Both().Values("name").Local(gremlingo.T__.Aggregate("a")).Cap("a")}}, 
    "g_withSideEffectXa_set_inlineX_V_both_name_localXaggregateXaXX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("a", gremlingo.NewSimpleSet("alice")).V().Both().Values("name").Local(gremlingo.T__.Aggregate("a")).Cap("a")}}, 
    "g_V_localXaggregateXaX_byXoutEXcreatedX_countXX_out_out_localXaggregateXaX_byXinEXcreatedX_weight_sumXX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Local(gremlingo.T__.Aggregate("a").By(gremlingo.T__.OutE("created").Count())).Out().Out().Local(gremlingo.T__.Aggregate("a").By(gremlingo.T__.InE("created").Values("weight").Sum())).Cap("a")}}, 
    "g_V_aggregateXxX_byXvaluesXageX_isXgtX29XXX_capXxX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate("x").By(gremlingo.T__.Values("age").Is(gremlingo.P.Gt(29))).Cap("x")}}, 
    "g_withStrategiesXProductiveByStrategyX_V_aggregateXxX_byXvaluesXageX_isXgtX29XXX_capXxX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy()).V().Aggregate("x").By(gremlingo.T__.Values("age").Is(gremlingo.P.Gt(29))).Cap("x")}}, 
    "g_V_aggregateXxX_byXout_order_byXnameXX_capXxX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate("x").By(gremlingo.T__.Out().Order().By("name")).Cap("x")}}, 
    "g_withStrategiesXProductiveByStrategyX_V_aggregateXxX_byXout_order_byXnameXX_capXxX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy()).V().Aggregate("x").By(gremlingo.T__.Out().Order().By("name")).Cap("x")}}, 
    "g_V_aggregateXaX_hasXperson_age_gteX30XXX_capXaX_unfold_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate("a").Has("person", "age", gremlingo.P.Gte(30)).Cap("a").Unfold().Values("name")}}, 
    "g_withSideEffectXa_1_sumX_V_aggregateXaX_byXageX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("a", 1, gremlingo.Operator.Sum).V().Aggregate("a").By("age").Cap("a")}}, 
    "g_withSideEffectXa_1_sumX_V_localXaggregateX_aX_byXageXX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("a", 1, gremlingo.Operator.Sum).V().Local(gremlingo.T__.Aggregate("a").By("age")).Cap("a")}}, 
    "g_withSideEffectXa_123_minusX_V_aggregateXaX_byXageX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("a", 123, gremlingo.Operator.Minus).V().Aggregate("a").By("age").Cap("a")}}, 
    "g_withSideEffectXa_123_minusX_V_localXaggregateX_aX_byXageXX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("a", 123, gremlingo.Operator.Minus).V().Local(gremlingo.T__.Aggregate("a").By("age")).Cap("a")}}, 
    "g_withSideEffectXa_2_multX_V_aggregateXaX_byXageX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("a", 2, gremlingo.Operator.Mult).V().Aggregate("a").By("age").Cap("a")}}, 
    "g_withSideEffectXa_2_multX_V_localXaggregateX_aX_byXageXX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("a", 2, gremlingo.Operator.Mult).V().Local(gremlingo.T__.Aggregate("a").By("age")).Cap("a")}}, 
    "g_withSideEffectXa_876960_divX_V_aggregateXaX_byXageX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("a", 876960, gremlingo.Operator.Div).V().Aggregate("a").By("age").Cap("a")}}, 
    "g_withSideEffectXa_876960_divX_V_localXaggregateX_aX_byXageXX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("a", 876960, gremlingo.Operator.Div).V().Local(gremlingo.T__.Aggregate("a").By("age")).Cap("a")}}, 
    "g_withSideEffectXa_1_minX_V_aggregateXaX_byXageX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("a", 1, gremlingo.Operator.Min).V().Aggregate("a").By("age").Cap("a")}}, 
    "g_withSideEffectXa_1_minX_V_localXaggregateX_aX_byXageXX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("a", 1, gremlingo.Operator.Min).V().Local(gremlingo.T__.Aggregate("a").By("age")).Cap("a")}}, 
    "g_withSideEffectXa_100_minX_V_aggregateXaX_byXageX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("a", 100, gremlingo.Operator.Min).V().Aggregate("a").By("age").Cap("a")}}, 
    "g_withSideEffectXa_100_minX_V_localXaggregateX_aX_byXageXX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("a", 100, gremlingo.Operator.Min).V().Local(gremlingo.T__.Aggregate("a").By("age")).Cap("a")}}, 
    "g_withSideEffectXa_1_maxX_V_aggregateXaX_byXageX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("a", 1, gremlingo.Operator.Max).V().Aggregate("a").By("age").Cap("a")}}, 
    "g_withSideEffectXa_1_maxX_V_localXaggregateX_aX_byXageXX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("a", 1, gremlingo.Operator.Max).V().Local(gremlingo.T__.Aggregate("a").By("age")).Cap("a")}}, 
    "g_withSideEffectXa_100_maxX_V_aggregateXaX_byXageX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("a", 100, gremlingo.Operator.Max).V().Aggregate("a").By("age").Cap("a")}}, 
    "g_withSideEffectXa_100_maxX_V_localXaggregateX_aX_byXageX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("a", 100, gremlingo.Operator.Max).V().Local(gremlingo.T__.Aggregate("a").By("age")).Cap("a")}}, 
    "g_withSideEffectXa_true_andX_V_constantXfalseX_aggregateXaX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("a", true, gremlingo.Operator.And).V().Constant(false).Aggregate("a").Cap("a")}}, 
    "g_withSideEffectXa_true_andX_V_constantXfalseX_localXaggregateX_aXX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("a", true, gremlingo.Operator.And).V().Constant(false).Local(gremlingo.T__.Aggregate("a")).Cap("a")}}, 
    "g_withSideEffectXa_true_orX_V_constantXfalseX_aggregateXaX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("a", true, gremlingo.Operator.Or).V().Constant(false).Aggregate("a").Cap("a")}}, 
    "g_withSideEffectXa_true_orX_V_constantXfalseX_localXaggregateX_aXX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("a", true, gremlingo.Operator.Or).V().Constant(false).Local(gremlingo.T__.Aggregate("a")).Cap("a")}}, 
    "g_withSideEffectXa_1_2_3_addAllX_V_aggregateXaX_byXageX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("a", []interface{}{int32(1), int32(2), int32(3)}, gremlingo.Operator.AddAll).V().Aggregate("a").By("age").Cap("a")}}, 
    "g_withSideEffectXa_1_2_3_addAllX_V_localXaggregateX_aX_byXageXX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("a", []interface{}{int32(1), int32(2), int32(3)}, gremlingo.Operator.AddAll).V().Local(gremlingo.T__.Aggregate("a").By("age")).Cap("a")}}, 
    "g_withSideEffectXa_1_2_3_assignX_V_aggregateXaX_byXageX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("a", []interface{}{int32(1), int32(2), int32(3)}, gremlingo.Operator.Assign).V().Aggregate("a").By("age").Cap("a")}}, 
    "g_withSideEffectXa_1_2_3_assignX_V_order_byXageX_localXaggregateX_aX_byXageXX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("a", []interface{}{int32(1), int32(2), int32(3)}, gremlingo.Operator.Assign).V().Order().By("age").Local(gremlingo.T__.Aggregate("a").By("age")).Cap("a")}}, 
    "g_V_localXaggregateXa_nameXX_out_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Local(gremlingo.T__.Aggregate("a").By("name")).Out().Cap("a")}}, 
    "g_withSideEffectXa_setX_V_both_name_localXaggregateXaXX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Both().Values("name").Local(gremlingo.T__.Aggregate("a")).Cap("a")}}, 
    "g_V_localXaggregateXaXX_outE_inV_localXaggregateXaXX_capXaX_unfold_dedup": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Local(gremlingo.T__.Aggregate("a")).OutE().InV().Local(gremlingo.T__.Aggregate("a")).Cap("a").Unfold().Dedup()}}, 
    "g_V_hasLabelXpersonX_localXaggregateXaXX_outXcreatedX_localXaggregateXaXX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Local(gremlingo.T__.Aggregate("a")).Out("created").Local(gremlingo.T__.Aggregate("a")).Cap("a")}}, 
    "g_V_localXaggregateXaXX_repeatXout_localXaggregateXaXXX_timesX2X_capXaX_unfold_groupCount": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Local(gremlingo.T__.Aggregate("a")).Repeat(gremlingo.T__.Out().Local(gremlingo.T__.Aggregate("a"))).Times(2).Cap("a").Unfold().Values("name").GroupCount()}}, 
    "g_V_hasXname_markoX_localXaggregateXaXX_outXknowsX_localXaggregateXaXX_outXcreatedX_localXaggregateXaXX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "marko").Local(gremlingo.T__.Aggregate("a")).Out("knows").Local(gremlingo.T__.Aggregate("a")).Out("created").Local(gremlingo.T__.Aggregate("a")).Cap("a")}}, 
    "g_V_hasLabelXsoftwareX_localXaggregateXaXX_inXcreatedX_localXaggregateXaXX_outXknowsX_localXaggregateXaXX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("software").Local(gremlingo.T__.Aggregate("a")).In("created").Local(gremlingo.T__.Aggregate("a")).Out("knows").Local(gremlingo.T__.Aggregate("a")).Cap("a")}}, 
    "g_V_localXaggregateXaXX_outE_hasXweight_lgtX0_5XX_inV_localXaggregateXaXX_capXaX_unfold_path": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Local(gremlingo.T__.Aggregate("a")).OutE().Has("weight", gremlingo.P.Gt(0.5)).InV().Local(gremlingo.T__.Aggregate("a")).Cap("a").Unfold().Path()}}, 
    "g_V_localXaggregateXaXX_bothE_sampleX1X_otherV_localXaggregateXaXX_capXaX_unfold_groupCount_byXlabelX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Local(gremlingo.T__.Aggregate("a")).BothE().Sample(1).OtherV().Local(gremlingo.T__.Aggregate("a")).Cap("a").Unfold().GroupCount().By(gremlingo.T.Label)}}, 
    "g_V_hasLabelXpersonX_localXaggregateXaXX_outE_inV_simplePath_localXaggregateXaXX_capXaX_unfold_hasLabelXsoftwareX_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Local(gremlingo.T__.Aggregate("a")).OutE().InV().SimplePath().Local(gremlingo.T__.Aggregate("a")).Cap("a").Unfold().HasLabel("software").Count()}}, 
    "g_V_localXaggregateXaXX_unionXout_inX_localXaggregateXaXX_capXaX_unfold_dedup_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Local(gremlingo.T__.Aggregate("a")).Union(gremlingo.T__.Out(), gremlingo.T__.In()).Local(gremlingo.T__.Aggregate("a")).Cap("a").Unfold().Dedup().Values("name")}}, 
    "g_V_hasXname_joshX_localXaggregateXaXX_outE_hasXweight_ltX1_0XX_inV_localXaggregateXaXX_outE_inV_localXaggregateXaXX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "josh").Local(gremlingo.T__.Aggregate("a")).OutE().Has("weight", gremlingo.P.Lt(1.0)).InV().Local(gremlingo.T__.Aggregate("a")).OutE().InV().Local(gremlingo.T__.Aggregate("a")).Cap("a")}}, 
    "g_V_hasLabelXpersonX_localXaggregateXaXX_outE_order_byXweightX_limitX1X_inV_localXaggregateXaXX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Local(gremlingo.T__.Aggregate("a")).OutE().Order().By("weight").Limit(1).InV().Local(gremlingo.T__.Aggregate("a")).Cap("a")}}, 
    "g_V_fail": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Fail()}}, 
    "g_V_failXmsgX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Fail("msg")}}, 
    "g_V_unionXout_failX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Union(gremlingo.T__.Out(), gremlingo.T__.Fail())}}, 
    "g_V_group_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group().By("name")}}, 
    "g_V_group_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group().By("age")}}, 
    "g_withStrategiesXProductiveByStrategyX_V_group_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy()).V().Group().By("age")}}, 
    "g_V_group_byXnameX_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group().By("name").By("age")}}, 
    "g_V_group_byXnameX_by": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group().By("name").By()}}, 
    "g_V_hasXlangX_group_byXlangX_byXcountX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("lang").Group().By("lang").By(gremlingo.T__.Count())}}, 
    "g_V_group_byXoutE_countX_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Order().By("name").Group().By(gremlingo.T__.OutE().Count()).By("name")}}, 
    "g_V_repeatXbothXfollowedByXX_timesX2X_group_byXsongTypeX_byXcountX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Both("followedBy")).Times(2).Group().By("songType").By(gremlingo.T__.Count())}}, 
    "g_V_group_byXvaluesXnameX_substringX1XX_byXconstantX1XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group().By(gremlingo.T__.Values("name").Substring(0, 1)).By(gremlingo.T__.Constant(1))}}, 
    "g_V_out_group_byXlabelX_selectXpersonX_unfold_outXcreatedX_name_limitX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Group().By(gremlingo.T.Label).Select("person").Unfold().Out("created").Values("name").Limit(2)}}, 
    "g_V_hasLabelXsongX_group_byXnameX_byXproperties_groupCount_byXlabelXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("song").Group().By("name").By(gremlingo.T__.Properties().GroupCount().By(gremlingo.T.Label))}}, 
    "g_V_outXfollowedByX_group_byXsongTypeX_byXbothE_group_byXlabelX_byXweight_sumXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out("followedBy").Group().By("songType").By(gremlingo.T__.BothE().Group().By(gremlingo.T.Label).By(gremlingo.T__.Values("weight").Sum()))}}, 
    "g_V_group_byXlabelX_byXbothE_groupXaX_byXlabelX_byXweight_sumX_weight_sumX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group().By(gremlingo.T.Label).By(gremlingo.T__.BothE().Group("a").By(gremlingo.T.Label).By(gremlingo.T__.Values("weight").Sum()).Values("weight").Sum())}}, 
    "g_V_hasLabelXpersonX_asXpX_outXcreatedX_group_byXnameX_byXselectXpX_valuesXageX_sumX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").As("p").Out("created").Group().By("name").By(gremlingo.T__.Select("p").Values("age").Sum())}}, 
    "g_V_group_byXlabelX_byXlabel_countX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group().By(gremlingo.T__.Label()).By(gremlingo.T__.Label().Count())}}, 
    "g_V_hasXperson_name_withinXvadas_peterXX_group_by_byXout_order_foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", gremlingo.P.Within("vadas", "peter")).Group().By().By(gremlingo.T__.Out().Order().Fold())}}, 
    "g_V_hasXperson_name_withinXvadas_peterXX_group_by_byXout_foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", gremlingo.P.Within("vadas", "peter")).Group().By().By(gremlingo.T__.Out().Fold())}}, 
    "g_V_hasXperson_name_withinXvadas_peterXX_group_by_byXout_orderX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", gremlingo.P.Within("vadas", "peter")).Group().By().By(gremlingo.T__.Out().Order())}}, 
    "g_V_hasXperson_name_withinXvadas_peterXX_group_by_byXout_order_countX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", gremlingo.P.Within("vadas", "peter")).Group().By().By(gremlingo.T__.Out().Order().Count())}}, 
    "g_V_hasXperson_name_withinXvadas_peterXX_group_by_byXout_order_fold_countXlocalXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", gremlingo.P.Within("vadas", "peter")).Group().By().By(gremlingo.T__.Out().Order().Fold().Count(gremlingo.Scope.Local))}}, 
    "g_V_group_by_byXout_label_foldX_selectXvaluesX_unfold_orderXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group().By().By(gremlingo.T__.Out().Label().Fold()).Select(gremlingo.Column.Values).Unfold().Order(gremlingo.Scope.Local)}}, 
    "g_V_group_by_byXout_label_dedup_foldX_selectXvaluesX_unfold_orderXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group().By().By(gremlingo.T__.Out().Label().Dedup().Fold()).Select(gremlingo.Column.Values).Unfold().Order(gremlingo.Scope.Local)}}, 
    "g_V_group_by_byXout_label_limitX0X_foldX_selectXvaluesX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group().By().By(gremlingo.T__.Out().Label().Limit(0).Fold()).Select(gremlingo.Column.Values).Unfold()}}, 
    "g_V_group_by_byXout_label_limitX10X_foldX_selectXvaluesX_unfold_orderXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group().By().By(gremlingo.T__.Out().Label().Limit(10).Fold()).Select(gremlingo.Column.Values).Unfold().Order(gremlingo.Scope.Local)}}, 
    "g_V_group_by_byXout_label_tailX10X_foldX_selectXvaluesX_unfold_orderXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group().By().By(gremlingo.T__.Out().Label().Tail(10).Fold()).Select(gremlingo.Column.Values).Unfold().Order(gremlingo.Scope.Local)}}, 
    "g_V_groupXaX_byXnameX_by_selectXaX_countXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group("a").By("name").By().Select("a").Count(gremlingo.Scope.Local)}}, 
    "g_V_localXgroupXaX_byXnameX_by_selectXaX_countXlocalXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Local(gremlingo.T__.Group("a").By("name").By().Select("a").Count(gremlingo.Scope.Local))}}, 
    "g_V_group_byXvaluesXnameXX_byXboth_countX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group().By(gremlingo.T__.Values("name")).By(gremlingo.T__.Both().Count())}}, 
    "g_V_outXcreatedX_groupCount_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out("created").GroupCount().By("name")}}, 
    "g_V_groupCount_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().GroupCount().By("age")}}, 
    "g_withStrategiesXProductiveByStrategyX_V_groupCount_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy()).V().GroupCount().By("age")}}, 
    "g_V_outXcreatedX_name_groupCount": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out("created").Values("name").GroupCount()}}, 
    "g_V_outXcreatedX_groupCountXaX_byXnameX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out("created").GroupCount("a").By("name").Cap("a")}}, 
    "g_V_outXcreatedX_name_groupCountXaX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out("created").Values("name").GroupCount("a").Cap("a")}}, 
    "g_V_repeatXout_groupCountXaX_byXnameXX_timesX2X_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Out().GroupCount("a").By("name")).Times(2).Cap("a")}}, 
    "g_V_both_groupCountXaX_byXlabelX_asXbX_barrier_whereXselectXaX_selectXsoftwareX_isXgtX2XXX_selectXbX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Both().GroupCount("a").By(gremlingo.T.Label).As("b").Barrier().Where(gremlingo.T__.Select("a").Select("software").Is(gremlingo.P.Gt(2))).Select("b").Values("name")}}, 
    "g_V_unionXoutXknowsX__outXcreatedX_inXcreatedXX_groupCount_selectXvaluesX_unfold_sum": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Union(gremlingo.T__.Out("knows"), gremlingo.T__.Out("created").In("created")).GroupCount().Select(gremlingo.Column.Values).Unfold().Sum()}}, 
    "g_V_hasXnoX_groupCount": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("no").GroupCount()}}, 
    "g_V_hasXnoX_groupCountXaX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("no").GroupCount("a").Cap("a")}}, 
    "g_V_unionXrepeatXoutX_timesX2X_groupCountXmX_byXlangXX__repeatXinX_timesX2X_groupCountXmX_byXnameXX_capXmX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Union(gremlingo.T__.Repeat(gremlingo.T__.Out()).Times(2).GroupCount("m").By("lang"), gremlingo.T__.Repeat(gremlingo.T__.In()).Times(2).GroupCount("m").By("name")).Cap("m")}}, 
    "g_V_outXcreatedX_groupCountXxX_capXxX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out("created").GroupCount("x").Cap("x")}}, 
    "g_V_groupCount_byXbothE_countX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().GroupCount().By(gremlingo.T__.BothE().Count())}}, 
    "g_V_both_localXgroupCountXaXX_out_capXaX_selectXkeysX_unfold_both_localXgroupCountXaXX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Both().Local(gremlingo.T__.GroupCount("a")).Out().Cap("a").Select(gremlingo.Column.Keys).Unfold().Both().Local(gremlingo.T__.GroupCount("a")).Cap("a")}}, 
    "g_V_hasXperson_name_markoX_bothXknowsX_groupCount_byXvaluesXnameX_foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Both("knows").GroupCount().By(gremlingo.T__.Values("name").Fold())}}, 
    "g_V_outXcreatedX_groupCount_byXnameX_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out("created").GroupCount().By("name").By("age")}}, 
    "g_V_outXcreatedX_groupCountXxX_byXnameX_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out("created").GroupCount("x").By("name").By("age")}}, 
    "g_V_groupCountXaX_selectXaX_countXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().GroupCount("a").Select("a").Count(gremlingo.Scope.Local)}}, 
    "g_V_localXgroupCountXaX_selectXaX_countXlocalXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Local(gremlingo.T__.GroupCount("a").Select("a").Count(gremlingo.Scope.Local))}}, 
    "g_VX1X_out_name_injectXdanielX_asXaX_mapXlengthX_path": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out().Values("name").Inject("daniel").As("a").Map(gremlingo.T__.Length()).Path()}}, 
    "g_injectXnull_1_3_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(nil, 1, 3, nil)}}, 
    "g_injectX10_20_null_20_10_10X_groupCountXxX_dedup_asXyX_projectXa_bX_by_byXselectXxX_selectXselectXyXXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(10, 20, nil, 20, 10, 10).GroupCount("x").Dedup().As("y").Project("a", "b").By().By(gremlingo.T__.Select("x").Select(gremlingo.T__.Select("y")))}}, 
    "g_injectXname_marko_age_nullX_selectXname_ageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(map[interface{}]interface{}{"name": "marko", "age": nil }).Select("name", "age")}}, 
    "g_injectXnull_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(nil, nil)}}, 
    "g_injectXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(nil)}}, 
    "g_inject": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject()}}, 
    "g_VX1X_valuesXageX_injectXnull_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["xx1"]).Values("age").Inject(nil, nil)}}, 
    "g_VX1X_valuesXageX_injectXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["xx1"]).Values("age").Inject(nil)}}, 
    "g_VX1X_valuesXageX_inject": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["xx1"]).Values("age").Inject()}}, 
    "g_injectXnull_1_3_nullX_asXaX_selectXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(nil, 1, 3, nil).As("a").Select("a")}}, 
    "g_injectX1_3X_injectX100_300X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1, 3).Inject(100, 300)}}, 
    "g_injectX1_3_100_300X_list": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject([]interface{}{1, 3, 100, 300})}}, 
    "g_injectX1_3_100_300X_set": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(gremlingo.NewSimpleSet(1, 3, 100, 300))}}, 
    "g_injectX1_1X_set": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(gremlingo.NewSimpleSet(1, 1))}}, 
    "g_io_readXkryoX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Io("data/tinkerpop-modern.kryo").Read()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}}, 
    "g_io_read_withXreader_gryoX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Io("data/tinkerpop-modern.kryo").With(gremlingo.IO.Reader, gremlingo.IO.Gryo).Read()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}}, 
    "g_io_readXgraphsonX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Io("data/tinkerpop-modern.json").Read()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}}, 
    "g_io_read_withXreader_graphsonX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Io("data/tinkerpop-modern.json").With(gremlingo.IO.Reader, gremlingo.IO.Graphson).Read()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}}, 
    "g_io_readXgraphmlX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Io("data/tinkerpop-modern.xml").Read()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}}, 
    "g_io_read_withXreader_graphmlX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Io("data/tinkerpop-modern.xml").With(gremlingo.IO.Reader, gremlingo.IO.Graphml).Read()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}}, 
    "g_withSackX127bX_injectX1bX_sackXsumX_sack": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSack(int8(127)).Inject(int8(1)).Sack(gremlingo.Operator.Sum).Sack()}}, 
    "g_withSackX32767sX_injectX1sX_sackXsumX_sack": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSack(int16(32767)).Inject(int16(1)).Sack(gremlingo.Operator.Sum).Sack()}}, 
    "g_withSackX2147483647iX_injectX1iX_sackXsumX_sack": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSack(int32(2147483647)).Inject(int32(1)).Sack(gremlingo.Operator.Sum).Sack()}}, 
    "g_withSackX1_7976931348623157E_308dX_injectX1_7976931348623157E_308dX_sackXsumX_sack": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSack(1.7976931348623157e+308).Inject(1.7976931348623157e+308).Sack(gremlingo.Operator.Sum).Sack()}}, 
    "g_withSackX_128bX_injectX1bX_sackXminusX_sack": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSack(int8(-128)).Inject(int8(1)).Sack(gremlingo.Operator.Minus).Sack()}}, 
    "g_withSackX_32768sX_injectX1sX_sackXminusX_sack": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSack(int16(-32768)).Inject(int16(1)).Sack(gremlingo.Operator.Minus).Sack()}}, 
    "g_withSackX_2147483648iX_injectX1iX_sackXminusX_sack": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSack(int32(-2147483648)).Inject(int32(1)).Sack(gremlingo.Operator.Minus).Sack()}}, 
    "g_withSackX_1_7976931348623157E_308dX_injectX1_7976931348623157E_308dX_sackXminusX_sack": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSack(-1.7976931348623157e+308).Inject(1.7976931348623157e+308).Sack(gremlingo.Operator.Minus).Sack()}}, 
    "g_withSackX127bX_injectX2bX_sackXmultX_sack": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSack(int8(127)).Inject(int8(2)).Sack(gremlingo.Operator.Mult).Sack()}}, 
    "g_withSackX32767sX_injectX2sX_sackXmultX_sack": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSack(int16(32767)).Inject(int16(2)).Sack(gremlingo.Operator.Mult).Sack()}}, 
    "g_withSackX2147483647iX_injectX2iX_sackXmultX_sack": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSack(int32(2147483647)).Inject(int32(2)).Sack(gremlingo.Operator.Mult).Sack()}}, 
    "g_withSackX1_7976931348623157E_308dX_injectX2dX_sackXmultX_sack": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSack(1.7976931348623157e+308).Inject(2).Sack(gremlingo.Operator.Mult).Sack()}}, 
    "g_withSackX127bX_injectX0_5fX_sackXdivX_sack": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSack(int8(127)).Inject(float32(0.5)).Sack(gremlingo.Operator.Div).Sack()}}, 
    "g_withSackX32767sX_injectX0_5fX_sackXdivX_sack": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSack(int16(32767)).Inject(float32(0.5)).Sack(gremlingo.Operator.Div).Sack()}}, 
    "g_withSackX2147483647iX_injectX0_5fX_sackXdivX_sack": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSack(int32(2147483647)).Inject(0.5).Sack(gremlingo.Operator.Div).Sack()}}, 
    "g_withSackX1_7976931348623157E_308dX_injectX0_5dX_sackXdivX_sack": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSack(1.7976931348623157e+308).Inject(0.5).Sack(gremlingo.Operator.Div).Sack()}}, 
    "g_withSackX_128bX_injectX_1bX_sackXdivX_sack": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSack(int8(-128)).Inject(int8(-1)).Sack(gremlingo.Operator.Div).Sack()}}, 
    "g_withSackX_32768sX_injectX_1sX_sackXdivX_sack": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSack(int16(-32768)).Inject(int16(-1)).Sack(gremlingo.Operator.Div).Sack()}}, 
    "g_withSackX_2147483648iX_injectX_1iX_sackXdivX_sack": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSack(int32(-2147483648)).Inject(int32(-1)).Sack(gremlingo.Operator.Div).Sack()}}, 
    "g_withSackXhelloX_V_outE_sackXassignX_byXlabelX_inV_sack": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSack("hello").V().OutE().Sack(gremlingo.Operator.Assign).By(gremlingo.T.Label).InV().Sack()}}, 
    "g_withSackX0X_V_outE_sackXsumX_byXweightX_inV_sack_sum": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSack(0.0).V().OutE().Sack(gremlingo.Operator.Sum).By("weight").InV().Sack().Sum()}}, 
    "g_withSackX0X_V_repeatXoutE_sackXsumX_byXweightX_inVX_timesX2X_sack": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSack(0.0).V().Repeat(gremlingo.T__.OutE().Sack(gremlingo.Operator.Sum).By("weight").InV()).Times(2).Sack()}}, 
    "g_withBulkXfalseX_withSackX1_sumX_VX1X_localXoutEXknowsX_barrierXnormSackX_inVX_inXknowsX_barrier_sack": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithBulk(false).WithSack(1.0, gremlingo.Operator.Sum).V(p["vid1"]).Local(gremlingo.T__.OutE("knows").Barrier(gremlingo.Barrier.NormSack).InV()).In("knows").Barrier().Sack()}}, 
    "g_withBulkXfalseX_withSackX1_sumX_V_out_barrier_sack": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithBulk(false).WithSack(1, gremlingo.Operator.Sum).V().Out().Barrier().Sack()}}, 
    "g_withSackX1_sumX_VX1X_localXoutXknowsX_barrierXnormSackXX_inXknowsX_barrier_sack": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSack(1.0, gremlingo.Operator.Sum).V(p["vid1"]).Local(gremlingo.T__.Out("knows").Barrier(gremlingo.Barrier.NormSack)).In("knows").Barrier().Sack()}}, 
    "g_V_sackXassignX_byXageX_sack": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Sack(gremlingo.Operator.Assign).By("age").Sack()}}, 
    "g_withSackXBigInteger_TEN_powX1000X_assignX_V_localXoutXknowsX_barrierXnormSackXX_inXknowsX_barrier_sack": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSack(gremlingo.ParseBigInt("10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"), gremlingo.Operator.Assign).V().Local(gremlingo.T__.Out("knows").Barrier(gremlingo.Barrier.NormSack)).In("knows").Barrier().Sack()}}, 
    "g_withSackX2X_V_sackXdivX_byXconstantX4_0XX_sack": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSack(2).V().Sack(gremlingo.Operator.Div).By(gremlingo.T__.Constant(4.0)).Sack()}}, 
    "g_V_sackXassignX_byXageX_byXnameX_sack": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Sack(gremlingo.Operator.Assign).By("age").By("name").Sack()}}, 
    "g_V_sideEffectXidentityX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().SideEffect(gremlingo.T__.Identity())}}, 
    "g_V_sideEffectXidentity_valuesXnameXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().SideEffect(gremlingo.T__.Identity().Values("name"))}}, 
    "g_V_sideEffectXpropertyXage_22X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("age", 21)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().SideEffect(gremlingo.T__.Property("age", 22))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("age", 21)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("age", 22)}}, 
    "g_V_group_byXvaluesXnameX_sideEffectXconstantXzyxXX_substringX1XX_byXconstantX1X_sideEffectXconstantXxyzXXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group().By(gremlingo.T__.Values("name").SideEffect(gremlingo.T__.Constant("zyx")).Substring(0, 1)).By(gremlingo.T__.Constant(1).SideEffect(gremlingo.T__.Constant("xyz")))}}, 
    "g_withSideEffectXx_setX_V_both_both_sideEffectXlocalXaggregateXxX_byXnameXX_capXxX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("x", gremlingo.NewSimpleSet()).V().Both().Both().SideEffect(gremlingo.T__.Local(gremlingo.T__.Aggregate("x").By("name"))).Cap("x").Unfold()}}, 
    "g_V_hasXageX_groupCountXaX_byXnameX_out_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("age").GroupCount("a").By("name").Out().Cap("a")}}, 
    "g_V_groupXaX_byXageX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group("a").By("age").Cap("a")}}, 
    "g_V_groupXaX_byXnameX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group("a").By("name").Cap("a")}}, 
    "g_V_hasXlangX_groupXaX_byXlangX_byXnameX_out_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("lang").Group("a").By("lang").By("name").Out().Cap("a")}}, 
    "g_V_repeatXout_groupXaX_byXnameX_byXcountX_timesX2X_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Out().Group("a").By("name").By(gremlingo.T__.Count())).Times(2).Cap("a")}}, 
    "g_V_groupXaX_byXlabelX_byXoutE_weight_sumX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group("a").By(gremlingo.T.Label).By(gremlingo.T__.OutE().Values("weight").Sum()).Cap("a")}}, 
    "g_V_repeatXbothXfollowedByXX_timesX2X_groupXaX_byXsongTypeX_byXcountX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Both("followedBy")).Times(2).Group("a").By("songType").By(gremlingo.T__.Count()).Cap("a")}}, 
    "g_V_groupXaX_byXvaluesXnameX_substringX1XX_byXconstantX1XX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group("a").By(gremlingo.T__.Values("name").Substring(0, 1)).By(gremlingo.T__.Constant(1)).Cap("a")}}, 
    "g_V_hasLabelXsongX_groupXaX_byXnameX_byXproperties_groupCount_byXlabelXX_out_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("song").Group("a").By("name").By(gremlingo.T__.Properties().GroupCount().By(gremlingo.T.Label)).Out().Cap("a")}}, 
    "g_V_hasLabelXpersonX_asXpX_outXcreatedX_groupXaX_byXnameX_byXselectXpX_valuesXageX_sumX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").As("p").Out("created").Group("a").By("name").By(gremlingo.T__.Select("p").Values("age").Sum()).Cap("a")}}, 
    "g_V_groupXmX_byXnameX_byXinXknowsX_nameX_capXmX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group("m").By("name").By(gremlingo.T__.In("knows").Values("name")).Cap("m")}}, 
    "g_V_groupXmX_byXlabelX_byXlabel_countX_capXmX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group("m").By(gremlingo.T__.Label()).By(gremlingo.T__.Label().Count()).Cap("m")}}, 
    "g_V_chooseXlabel_person__age_groupCountXaX__name_groupCountXbXX_capXa_bX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Choose(gremlingo.T__.Has(gremlingo.T.Label, "person"), gremlingo.T__.Values("age").GroupCount("a"), gremlingo.T__.Values("name").GroupCount("b")).Cap("a", "b").Unfold()}}, 
    "g_V_hasXperson_name_withinXvadas_peterXX_groupXaX_by_byXout_orderX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", gremlingo.P.Within("vadas", "peter")).Group("a").By().By(gremlingo.T__.Out().Order()).Cap("a")}}, 
    "g_V_hasXperson_name_withinXvadas_peterXX_groupXaX_by_byXout_order_countX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", gremlingo.P.Within("vadas", "peter")).Group("a").By().By(gremlingo.T__.Out().Order().Count()).Cap("a")}}, 
    "g_V_hasXperson_name_withinXvadas_peterXX_groupXaX_by_byXout_order_fold_countXlocalXX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", gremlingo.P.Within("vadas", "peter")).Group("a").By().By(gremlingo.T__.Out().Order().Fold().Count(gremlingo.Scope.Local)).Cap("a")}}, 
    "g_V_groupXaX_by_byXout_label_foldX_capXaX_selectXvaluesX_unfold_orderXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group("a").By().By(gremlingo.T__.Out().Label().Fold()).Cap("a").Select(gremlingo.Column.Values).Unfold().Order(gremlingo.Scope.Local)}}, 
    "g_V_groupXaX_by_byXout_label_dedup_foldX_capXaX_selectXvaluesX_unfold_orderXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group("a").By().By(gremlingo.T__.Out().Label().Dedup().Fold()).Cap("a").Select(gremlingo.Column.Values).Unfold().Order(gremlingo.Scope.Local)}}, 
    "g_V_groupXaX_by_byXout_label_limitX0X_foldX_capXaX_selectXvaluesX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group("a").By().By(gremlingo.T__.Out().Label().Limit(0).Fold()).Cap("a").Select(gremlingo.Column.Values).Unfold()}}, 
    "g_V_groupXaX_by_byXout_label_limitX10X_foldX_capXaX_selectXvaluesX_unfold_orderXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group("a").By().By(gremlingo.T__.Out().Label().Limit(10).Fold()).Cap("a").Select(gremlingo.Column.Values).Unfold().Order(gremlingo.Scope.Local)}}, 
    "g_V_groupXaX_by_byXout_label_tailX10X_foldX_capXaX_selectXvaluesX_unfold_orderXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group("a").By().By(gremlingo.T__.Out().Label().Tail(10).Fold()).Cap("a").Select(gremlingo.Column.Values).Unfold().Order(gremlingo.Scope.Local)}}, 
    "g_VX1X_outEXknowsX_subgraphXsgX_name_capXsgX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE("knows").Subgraph("sg").Values("name").Cap("sg")}}, 
    "g_V_repeatXbothEXcreatedX_subgraphXsgX_outVX_timesX5X_name_dedup_capXsgX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.BothE("created").Subgraph("sg").OutV()).Times(5).Values("name").Dedup().Cap("sg")}}, 
    "g_V_outEXnoexistX_subgraphXsgXcapXsgX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().OutE("noexist").Subgraph("sg").Cap("sg")}}, 
    "g_E_hasXweight_0_5X_subgraphXaX_selectXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Has("weight", 0.4).Subgraph("a").Select("a")}}, 
    "g_VX1X_out_out_tree_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out().Out().Tree().By("name")}}, 
    "g_VX1X_out_out_tree": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out().Out().Tree()}}, 
    "g_V_out_tree_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Tree().By("age")}}, 
    "g_VX1X_out_out_treeXaX_byXnameX_both_both_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out().Out().Tree("a").By("name").Both().Both().Cap("a")}}, 
    "g_VX1X_out_out_treeXaX_both_both_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out().Out().Tree("a").Both().Both().Cap("a")}}, 
    "g_VX1X_out_out_tree_byXlabelX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out().Out().Tree().By(gremlingo.T.Label)}}, 
    "g_VX1X_out_out_treeXaX_byXlabelX_both_both_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out().Out().Tree("a").By(gremlingo.T.Label).Both().Both().Cap("a")}}, 
    "g_VX1X_out_out_out_tree": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Out().Out().Tree()}}, 
    "g_VX1X_outE_inV_bothE_otherV_tree": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE().InV().BothE().OtherV().Tree()}}, 
    "g_VX1X_outE_inV_bothE_otherV_tree_byXnameX_byXlabelX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE().InV().BothE().OtherV().Tree().By("name").By(gremlingo.T.Label)}}, 
    "g_V_out_treeXaX_selectXaX_countXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Tree("a").Select("a").Count(gremlingo.Scope.Local)}}, 
    "g_V_out_order_byXnameX_localXtreeXaX_selectXaX_countXlocalXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Local(gremlingo.T__.Tree("a").Select("a").Count(gremlingo.Scope.Local))}}, 
}

   func GetTraversal(scenarioName string, g *gremlingo.GraphTraversalSource, parameters map[string]interface{}, sideEffects map[string]interface{}) (*gremlingo.GraphTraversal, error) {
       if traversalFns, ok := translationMap[scenarioName]; ok {
           traversalFn := traversalFns[0]
           translationMap[scenarioName] = traversalFns[1:]
           traversal := traversalFn(g, parameters)
           for key, value := range sideEffects {
               traversal.Bytecode.AddSource("withSideEffect", key, value)
           }
           return traversal, nil
       } else {
           return nil, errors.New("scenario for traversal not recognized")
       }
   }

