/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.MessageDeliveryTimeInfo;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Producer;
import com.sun.messaging.jmq.jmsserver.core.ProducerUID;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.persist.api.PartitionedStore;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQBasicConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.IOException;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class DataHandler
extends PacketHandler {
    private static boolean DEBUG = false;
    private int msgProcessCnt = 0;
    private FaultInjection fi = FaultInjection.getInjection();

    @Override
    public boolean handle(IMQConnection con, Packet msg) throws BrokerException {
        boolean sentReply = false;
        return this.handle(con, msg, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean handle(IMQConnection con, Packet msg, boolean isadmin) throws BrokerException {
        props = null;
        if (!isadmin && this.fi.FAULT_INJECTION) {
            ++this.msgProcessCnt;
            try {
                props = msg.getProperties();
            }
            catch (Exception ex) {
                props = new Properties();
            }
        } else {
            this.msgProcessCnt = 0;
        }
        ack = msg.getSendAcknowledge();
        cid = msg.getConsumerID();
        (IMQBasicConnection)con;
        if (IMQBasicConnection.getDumpPacket()) ** GOTO lbl-1000
        (IMQBasicConnection)con;
        if (IMQBasicConnection.getDumpOutPacket()) lbl-1000:
        // 2 sources

        {
            v0 = msg.getSysMessageID().toString();
        } else {
            v0 = "";
        }
        refid = v0;
        isIndemp = msg.getIndempotent();
        reason = null;
        failedrefs = null;
        status = 200;
        removeMsg = false;
        routedSet = null;
        deliveryDelayReadyList = new ArrayList<MessageDeliveryTimeInfo>();
        route = false;
        pausedProducer = null;
        transacted = false;
        try {
            pausedProducer = this.checkFlow(msg, con);
            v1 = transacted = msg.getTransactionID() != 0L;
            if (!isadmin && this.fi.FAULT_INJECTION) {
                m = new HashMap<String, Constable>();
                if (props != null) {
                    m.putAll(props);
                }
                m.put("mqMsgCount", Integer.valueOf(this.msgProcessCnt));
                m.put("mqIsTransacted", Boolean.valueOf(transacted));
                this.fi.checkFaultAndExit("msg.send.1", m, 2, false);
                if (this.fi.checkFault("msg.send.1.exception", m)) {
                    this.fi.unsetFault("msg.send.1.exception");
                    throw new BrokerException("FAULT INJECTION: msg.send.1.exception");
                }
                if (this.fi.checkFaultAndSleep("msg.send.1.sleep", m, true)) {
                    this.fi.unsetFault("msg.send.1.sleep");
                }
                if (this.fi.checkFaultAndSleep("msg.send.1.sleep.exception", m, true)) {
                    this.fi.unsetFault("msg.send.1.sleep.exception");
                    throw new BrokerException("FAULT INJECTION: msg.send.1.sleep.exception");
                }
            }
            realduid = DestinationUID.getUID(msg.getDestination(), msg.getIsQueue());
            if (DataHandler.DEBUG) {
                this.logger.log(8, "DataHandler:Received JMS Message[" + msg.toString() + " : " + realduid + "]TID=" + msg.getTransactionID() + " on connection " + con + ", isadmin=" + isadmin);
            }
            dds = DestinationList.findMatchingIDs(con.getPartitionedStore(), realduid);
            duids = dds[0];
            packetUsed = false;
            if (duids.size() == 0) {
                route = false;
            } else {
                itr = duids.iterator();
                while (itr.hasNext()) {
                    ref = null;
                    lastthr = null;
                    isLast = false;
                    duid = (DestinationUID)itr.next();
                    isLast = itr.hasNext() == false;
                    ds = DestinationList.getDestination(con.getPartitionedStore(), duid);
                    d = ds[0];
                    try {
                        if (d == null) {
                            throw new BrokerException("Unknown Destination:" + msg.getDestination());
                        }
                        if (realduid.isWildcard() && d.isTemporary()) {
                            this.logger.log(4, "L10N-XXX: Wildcard production with destination name of " + realduid + " to temporary destination " + d.getUniqueName() + " is not supported, ignoring");
                            continue;
                        }
                        if (realduid.isWildcard() && d.isInternal()) {
                            this.logger.log(4, "L10N-XXX: Wildcard production with destination name of " + realduid + " to internal destination " + d.getUniqueName() + " is not supported, ignoring");
                            continue;
                        }
                        if (realduid.isWildcard() && d.isDMQ()) {
                            this.logger.log(4, "L10N-XXX: Wildcard production with destination name of " + realduid + " to the DeadMessageQueue" + d.getUniqueName() + " is not supported, ignoring");
                            continue;
                        }
                        if (pausedProducer != null) {
                            this.pauseProducer(d, duid, pausedProducer, con);
                            pausedProducer = null;
                        }
                        if (packetUsed) {
                            newp = new Packet();
                            newp.fill(msg);
                            newp.generateSequenceNumber(true);
                            newp.generateTimestamp(true);
                            newp.prepareToSend();
                            newp.generateSequenceNumber(false);
                            newp.generateTimestamp(false);
                            msg = newp;
                        }
                        packetUsed = true;
                        ref = this.createReference(msg, duid, con, isadmin);
                        if (isLast && (route |= this.queueMessage(d, ref, transacted)) && ack && !ref.isPersistent()) {
                            this.sendAcknowledge(refid, cid, status, con, reason, props, transacted);
                            ack = false;
                        }
                        if ((s = this.routeMessage(con.getPartitionedStore(), transacted, ref, route, d, deliveryDelayReadyList)) != null && !s.isEmpty()) {
                            if (routedSet == null) {
                                routedSet = new HashMap<PacketReference, Set>();
                            }
                            routedSet.put(ref, s);
                        }
                        this.pauseProducer(d, duid, pausedProducer, con);
                    }
                    catch (Exception ex) {
                        if (ref != null) {
                            if (failedrefs == null) {
                                failedrefs = new ArrayList<PacketReference>();
                            }
                            failedrefs.add(ref);
                        }
                        lastthr = ex;
                        this.logger.log(4, "B2011", (Object)con.toString(), (Throwable)ex);
                    }
                    finally {
                        if (pausedProducer != null) {
                            this.pauseProducer(d, duid, pausedProducer, con);
                            pausedProducer = null;
                        }
                        if (!isLast || lastthr == null) continue;
                        throw lastthr;
                    }
                }
            }
        }
        catch (BrokerException ex) {
            loglevel = isIndemp != false && ex.getStatusCode() == 304 ? 4 : 16;
            this.logger.log(loglevel, "B2011", (Object)con.toString(), (Throwable)ex);
            reason = ex.getMessage();
            status = ex.getStatusCode();
        }
        catch (IOException ex) {
            this.logger.log(16, "B2011", (Object)con.toString(), (Throwable)ex);
            reason = ex.getMessage();
            status = 500;
        }
        catch (SecurityException ex) {
            this.logger.log(16, "B2011", (Object)con.toString(), (Throwable)ex);
            reason = ex.getMessage();
            status = 403;
        }
        catch (OutOfMemoryError err) {
            this.logger.logStack(16, "B2011", con.toString() + ":" + msg.getPacketSize(), (Throwable)err);
            reason = err.getMessage();
            status = 500;
        }
        catch (Exception ex) {
            this.logger.logStack(16, "B2011", con.toString(), (Throwable)ex);
            reason = ex.getMessage();
            status = 500;
        }
        if (status == 500 && failedrefs != null) {
            for (PacketReference ref : failedrefs) {
                ds = DestinationList.getDestination(con.getPartitionedStore(), ref.getDestinationUID());
                d = ds[0];
                if (d == null) continue;
                this.cleanupOnError(d, ref);
            }
        }
        if (ack) {
            this.sendAcknowledge(refid, cid, status, con, reason, props, transacted);
        }
        if (route && routedSet != null) {
            itr = routedSet.entrySet().iterator();
            pair = null;
            while (itr.hasNext()) {
                pair = (Map.Entry)itr.next();
                pktref = (PacketReference)pair.getKey();
                duid = pktref.getDestinationUID();
                s = (Set)pair.getValue();
                ds = DestinationList.getDestination(con.getPartitionedStore(), duid);
                dest = ds[0];
                if (dest == null) {
                    emsg = new Object[]{pktref, s, duid};
                    this.logger.log(16, this.br.getKString("B2265", emsg));
                    continue;
                }
                try {
                    this.forwardMessage(dest, pktref, s);
                }
                catch (Exception e) {
                    emsg = new Object[]{pktref, duid, s};
                    this.logger.logStack(16, this.br.getKString("B4404", emsg), e);
                }
            }
        }
        if (deliveryDelayReadyList.size() > 0) {
            di = null;
            for (MessageDeliveryTimeInfo di : deliveryDelayReadyList) {
                di.setDeliveryReady();
            }
        }
        return isadmin;
    }

    public void sendAcknowledge(String refid, long cid, int status, IMQConnection con, String reason, Hashtable props, boolean transacted) {
        Hashtable<String, Object> hash;
        Packet pkt;
        block9: {
            block8: {
                if (!con.isAdminConnection() && this.fi.FAULT_INJECTION) {
                    HashMap<String, Constable> m = new HashMap<String, Constable>();
                    if (props != null) {
                        m.putAll(props);
                    }
                    m.put("mqMsgCount", Integer.valueOf(this.msgProcessCnt));
                    m.put("mqIsTransacted", Boolean.valueOf(transacted));
                    this.fi.checkFaultAndExit("msg.send.2", m, 2, false);
                }
                pkt = new Packet(con.useDirectBuffers());
                pkt.setPacketType(9);
                pkt.setConsumerID(cid);
                hash = new Hashtable<String, Object>();
                hash.put("JMQStatus", status);
                if (reason != null) {
                    hash.put("JMQReason", reason);
                }
                IMQBasicConnection cfr_ignored_0 = (IMQBasicConnection)con;
                if (IMQBasicConnection.getDumpPacket()) break block8;
                IMQBasicConnection cfr_ignored_1 = (IMQBasicConnection)con;
                if (!IMQBasicConnection.getDumpOutPacket()) break block9;
            }
            hash.put("JMQReqID", refid);
        }
        pkt.setProperties(hash);
        con.sendControlMessage(pkt);
        if (!con.isAdminConnection() && this.fi.FAULT_INJECTION) {
            HashMap<String, Constable> m = new HashMap<String, Constable>();
            if (props != null) {
                m.putAll(props);
            }
            m.put("mqMsgCount", Integer.valueOf(this.msgProcessCnt));
            m.put("mqIsTransacted", Boolean.valueOf(transacted));
            this.fi.checkFaultAndExit("msg.send.3", m, 2, false);
        }
    }

    public Producer checkFlow(Packet msg, IMQConnection con) {
        long pid;
        ProducerUID puid;
        Producer p;
        Producer pausedProducer = null;
        if (msg.getFlowPaused()) {
            con.flowPaused(0L);
            msg.setFlowPaused(false);
        }
        if ((p = (Producer)Producer.getProducer(puid = new ProducerUID(pid = msg.getProducerID()))) != null) {
            p.addMsg();
        }
        if (msg.getConsumerFlow()) {
            pausedProducer = p;
            if (pausedProducer == null) {
                this.logger.log(16, "Unknown ProducerUID " + puid);
            } else if (pausedProducer.getConnectionUID() != con.getConnectionUID()) {
                this.logger.log(16, "Producer " + pausedProducer + " not on this connection " + con.getConnectionUID());
            }
            msg.setConsumerFlow(false);
        }
        return pausedProducer;
    }

    public PacketReference createReference(Packet msg, DestinationUID duid, IMQConnection con, boolean isadmin) throws BrokerException {
        PacketReference ref = PacketReference.createReference(con.getPartitionedStore(), msg, duid, con);
        if (isadmin) {
            ref.overridePersistence(false);
        }
        return ref;
    }

    public boolean queueMessage(Destination d, PacketReference ref, boolean transacted) throws BrokerException {
        return d.queueMessage(ref, transacted);
    }

    public Set routeMessage(PartitionedStore storep, boolean transacted, PacketReference ref, boolean route, Destination d, List<MessageDeliveryTimeInfo> readylist) throws BrokerException, SelectorFormatException {
        String reason = null;
        int status = 200;
        Set s = null;
        MessageDeliveryTimeInfo di = ref.getDeliveryTimeInfo();
        if (transacted) {
            try {
                TransactionList[] tls = DestinationList.getTransactionList(storep);
                TransactionList tl = tls[0];
                tl.addMessage(ref);
            }
            catch (Exception ex) {
                String emsg = this.br.getKString("B4403", ref + "[TID=" + ref.getTransactionID() + ", " + di + "]", ex.getMessage());
                ref.destroy();
                this.logger.logStack(BrokerStateHandler.isShuttingDown() ? 4 : 16, emsg, ex);
                reason = emsg;
                status = 500;
                throw new BrokerException(reason, status);
            }
        } else if (route) {
            if (di != null && di.getOnTimerState() != null) {
                d.routeNewMessageWithDeliveryDelay(ref);
                readylist.add(di);
            } else {
                s = d.routeNewMessage(ref);
            }
        }
        return s;
    }

    public void cleanupOnError(Destination d, PacketReference ref) {
        try {
            d.removeMessage(ref.getSysMessageID(), null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void forwardMessage(Destination d, PacketReference ref, Set s) throws BrokerException {
        d.forwardMessage(s, ref);
    }

    public void pauseProducer(Destination d, Producer pausedProducer, IMQConnection con) {
        this.pauseProducer(d, d.getDestinationUID(), pausedProducer, con);
    }

    public void pauseProducer(Destination d, DestinationUID duid, Producer pausedProducer, IMQConnection con) {
        if (pausedProducer != null) {
            if (d != null) {
                d.producerFlow(con, pausedProducer);
            } else if (duid != null) {
                pausedProducer.sendResumeFlow(duid, DestinationList.MAX_PRODUCER_BATCH);
            }
        }
    }
}

