/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.jwtauth.cdi;

import fish.payara.microprofile.jwtauth.cdi.InjectionPointGenerator;
import fish.payara.microprofile.jwtauth.cdi.ParameterizedTypeImpl;
import fish.payara.microprofile.jwtauth.eesecurity.JWTAuthenticationMechanism;
import fish.payara.microprofile.jwtauth.eesecurity.SignedJWTIdentityStore;
import fish.payara.microprofile.jwtauth.jwt.ClaimAnnotationLiteral;
import fish.payara.microprofile.jwtauth.jwt.ClaimValueImpl;
import fish.payara.microprofile.jwtauth.jwt.JWTInjectableType;
import fish.payara.microprofile.jwtauth.jwt.JsonWebTokenImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.security.enterprise.SecurityContext;
import javax.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import javax.security.enterprise.identitystore.IdentityStore;
import org.eclipse.microprofile.auth.LoginConfig;
import org.eclipse.microprofile.jwt.Claim;
import org.eclipse.microprofile.jwt.ClaimValue;
import org.eclipse.microprofile.jwt.JsonWebToken;
import org.glassfish.soteria.cdi.CdiProducer;
import org.glassfish.soteria.cdi.CdiUtils;

public class CdiInitEventHandler {
    private static final JsonWebTokenImpl emptyJsonWebToken = new JsonWebTokenImpl(null, Collections.emptyMap());

    public static void installAuthenticationMechanism(AfterBeanDiscovery afterBeanDiscovery) {
        afterBeanDiscovery.addBean((Bean)new CdiProducer().scope(ApplicationScoped.class).beanClass(IdentityStore.class).types(new Type[]{Object.class, IdentityStore.class, SignedJWTIdentityStore.class}).addToId((Object)("store " + LoginConfig.class)).create(e -> new SignedJWTIdentityStore()));
        afterBeanDiscovery.addBean((Bean)new CdiProducer().scope(ApplicationScoped.class).beanClass(HttpAuthenticationMechanism.class).types(new Type[]{Object.class, HttpAuthenticationMechanism.class, JWTAuthenticationMechanism.class}).addToId((Object)("mechanism " + LoginConfig.class)).create(e -> new JWTAuthenticationMechanism()));
        afterBeanDiscovery.addBean((Bean)new CdiProducer().scope(RequestScoped.class).beanClass(JsonWebToken.class).types(new Type[]{Object.class, JsonWebToken.class}).addToId((Object)("token " + LoginConfig.class)).create(e -> CdiInitEventHandler.getJsonWebToken()));
        for (JWTInjectableType injectableType : CdiInitEventHandler.computeTypes()) {
            afterBeanDiscovery.addBean((Bean)new CdiProducer().scope(Dependent.class).beanClass(CdiInitEventHandler.class).types(new Type[]{injectableType.getFullType()}).qualifiers(new Annotation[]{new ClaimAnnotationLiteral()}).addToId((Object)("claim for " + injectableType.getFullType())).create(creationalContext -> {
                Claim claim = CdiInitEventHandler.getQualifier(CdiInitEventHandler.getCurrentInjectionPoint(CdiUtils.getBeanManager(), creationalContext), Claim.class);
                String claimName = CdiInitEventHandler.getClaimName(claim);
                Object claimObj = injectableType.convert(CdiInitEventHandler.getJsonWebToken().getClaims().get(claimName));
                if (injectableType.isOptional()) {
                    claimObj = Optional.ofNullable(claimObj);
                }
                if (injectableType.isClaimValue()) {
                    claimObj = new ClaimValueImpl<Optional<Object>>(claimName, (Optional<Object>)claimObj);
                }
                return claimObj;
            }));
        }
    }

    private static Set<JWTInjectableType> computeTypes() {
        HashSet<JWTInjectableType> baseTypes = new HashSet<JWTInjectableType>(Arrays.asList(new JWTInjectableType((Type)((Object)String.class)), new JWTInjectableType((Type)new ParameterizedTypeImpl((Type)((Object)Set.class), new Type[]{String.class}), Set.class), new JWTInjectableType((Type)((Object)Long.class)), new JWTInjectableType((Type)((Object)Boolean.class)), new JWTInjectableType((Type)((Object)JsonString.class)), new JWTInjectableType((Type)((Object)JsonNumber.class)), new JWTInjectableType((Type)((Object)JsonStructure.class)), new JWTInjectableType((Type)((Object)JsonArray.class)), new JWTInjectableType((Type)((Object)JsonObject.class))));
        HashSet<JWTInjectableType> optionalTypes = new HashSet<JWTInjectableType>(baseTypes);
        optionalTypes.addAll(baseTypes.stream().map(t -> new JWTInjectableType((Type)new ParameterizedTypeImpl((Type)((Object)Optional.class), t.getFullType()), (JWTInjectableType)t)).collect(Collectors.toSet()));
        HashSet<JWTInjectableType> claimValueTypes = new HashSet<JWTInjectableType>(optionalTypes);
        claimValueTypes.addAll(optionalTypes.stream().map(t -> new JWTInjectableType((Type)new ParameterizedTypeImpl((Type)((Object)ClaimValue.class), t.getFullType()), (JWTInjectableType)t)).collect(Collectors.toSet()));
        return claimValueTypes;
    }

    public static InjectionPoint getCurrentInjectionPoint(BeanManager beanManager, CreationalContext<?> creationalContext) {
        Bean<InjectionPointGenerator> bean = CdiInitEventHandler.resolve(beanManager, InjectionPointGenerator.class, new Annotation[0]);
        return bean != null ? (InjectionPoint)beanManager.getInjectableReference((InjectionPoint)bean.getInjectionPoints().iterator().next(), creationalContext) : null;
    }

    public static <T> Bean<T> resolve(BeanManager beanManager, Class<T> beanClass, Annotation ... qualifiers) {
        Set beans = beanManager.getBeans(beanClass, qualifiers);
        for (Bean bean : beans) {
            if (bean.getBeanClass() != beanClass) continue;
            return beanManager.resolve(Collections.singleton(bean));
        }
        Bean bean = beanManager.resolve(beans);
        if (bean == null && beanClass.getSuperclass() != Object.class) {
            return CdiInitEventHandler.resolve(beanManager, beanClass.getSuperclass(), qualifiers);
        }
        return bean;
    }

    public static <A extends Annotation> A getQualifier(InjectionPoint injectionPoint, Class<A> qualifierClass) {
        for (Annotation annotation : injectionPoint.getQualifiers()) {
            if (!qualifierClass.isAssignableFrom(annotation.getClass())) continue;
            return (A)((Annotation)qualifierClass.cast(annotation));
        }
        return null;
    }

    public static JsonWebTokenImpl getJsonWebToken() {
        JsonWebTokenImpl jsonWebToken = (JsonWebTokenImpl)((SecurityContext)CdiUtils.getBeanReference(SecurityContext.class, (Annotation[])new Annotation[0])).getCallerPrincipal();
        if (jsonWebToken == null) {
            jsonWebToken = emptyJsonWebToken;
        }
        return jsonWebToken;
    }

    public static String getClaimName(Claim claim) {
        if (claim.value().equals("")) {
            return claim.standard().name();
        }
        return claim.value();
    }
}

