/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.jwtauth.eesecurity;

import fish.payara.microprofile.jwtauth.eesecurity.SignedJWTCredential;
import fish.payara.microprofile.jwtauth.jwt.JsonWebTokenImpl;
import fish.payara.microprofile.jwtauth.jwt.JwtTokenParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.DeploymentException;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import javax.security.enterprise.CallerPrincipal;
import javax.security.enterprise.identitystore.CredentialValidationResult;
import javax.security.enterprise.identitystore.IdentityStore;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class SignedJWTIdentityStore
implements IdentityStore {
    private static final Logger LOGGER = Logger.getLogger(SignedJWTIdentityStore.class.getName());
    private static final String RSA_ALGORITHM = "RSA";
    private final String acceptedIssuer;
    private final Optional<Boolean> enabledNamespace;
    private final Optional<String> customNamespace;
    private final Config config = ConfigProvider.getConfig();

    public SignedJWTIdentityStore() {
        Optional<Properties> properties = this.readVendorProperties();
        this.acceptedIssuer = this.readVendorIssuer(properties).orElseGet(() -> (String)this.config.getOptionalValue("mp.jwt.verify.issuer", String.class).orElseThrow(() -> new IllegalStateException("No issuer found")));
        this.enabledNamespace = this.readEnabledNamespace(properties);
        this.customNamespace = this.readCustomNamespace(properties);
    }

    public CredentialValidationResult validate(SignedJWTCredential signedJWTCredential) {
        JwtTokenParser jwtTokenParser = new JwtTokenParser(this.enabledNamespace, this.customNamespace);
        try {
            jwtTokenParser.parse(signedJWTCredential.getSignedJWT());
            String keyID = jwtTokenParser.getKeyID();
            Optional<PublicKey> publicKey = this.readDefaultPublicKey();
            if (!publicKey.isPresent()) {
                publicKey = this.readMPEmbeddedPublicKey(keyID);
            }
            if (!publicKey.isPresent()) {
                publicKey = this.readMPPublicKeyFromLocation(keyID);
            }
            if (!publicKey.isPresent()) {
                throw new IllegalStateException("No PublicKey found");
            }
            JsonWebTokenImpl jsonWebToken = jwtTokenParser.verify(this.acceptedIssuer, publicKey.get());
            ArrayList groups = new ArrayList((Collection)jsonWebToken.getClaim("groups"));
            return new CredentialValidationResult((CallerPrincipal)jsonWebToken, new HashSet(groups));
        }
        catch (Exception e) {
            LOGGER.log(Level.FINEST, "Exception trying to parse JWT token.", e);
            return CredentialValidationResult.INVALID_RESULT;
        }
    }

    private Optional<Properties> readVendorProperties() {
        URL mpJwtResource = Thread.currentThread().getContextClassLoader().getResource("/payara-mp-jwt.properties");
        Properties properties = null;
        if (mpJwtResource != null) {
            try {
                properties = new Properties();
                properties.load(mpJwtResource.openStream());
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to load Vendor properties from resource file", e);
            }
        }
        return Optional.ofNullable(properties);
    }

    private Optional<String> readVendorIssuer(Optional<Properties> properties) {
        return properties.isPresent() ? Optional.ofNullable(properties.get().getProperty("accepted.issuer")) : Optional.empty();
    }

    private Optional<Boolean> readEnabledNamespace(Optional<Properties> properties) {
        return properties.isPresent() ? Optional.ofNullable(Boolean.valueOf(properties.get().getProperty("enable.namespace", "false"))) : Optional.empty();
    }

    private Optional<String> readCustomNamespace(Optional<Properties> properties) {
        return properties.isPresent() ? Optional.ofNullable(properties.get().getProperty("custom.namespace", null)) : Optional.empty();
    }

    private Optional<PublicKey> readDefaultPublicKey() throws Exception {
        return this.readPublicKeyFromLocation("/publicKey.pem", null);
    }

    private Optional<PublicKey> readMPEmbeddedPublicKey(String keyID) throws Exception {
        Optional key = this.config.getOptionalValue("mp.jwt.verify.publickey", String.class);
        if (!key.isPresent()) {
            return Optional.empty();
        }
        return this.createPublicKey((String)key.get(), keyID);
    }

    private Optional<PublicKey> readMPPublicKeyFromLocation(String keyID) throws Exception {
        Optional locationOpt = this.config.getOptionalValue("mp.jwt.verify.publickey.location", String.class);
        if (!locationOpt.isPresent()) {
            return Optional.empty();
        }
        String publicKeyLocation = (String)locationOpt.get();
        return this.readPublicKeyFromLocation(publicKeyLocation, keyID);
    }

    private Optional<PublicKey> readPublicKeyFromLocation(String publicKeyLocation, String keyID) throws Exception {
        URL publicKeyURL = Thread.currentThread().getContextClassLoader().getResource(publicKeyLocation);
        if (publicKeyURL == null) {
            try {
                publicKeyURL = new URL(publicKeyLocation);
            }
            catch (MalformedURLException ex) {
                publicKeyURL = null;
            }
        }
        if (publicKeyURL == null) {
            return Optional.empty();
        }
        byte[] byteBuffer = new byte[16384];
        try (InputStream inputStream = publicKeyURL.openStream();){
            String key = new String(byteBuffer, 0, inputStream.read(byteBuffer));
            Optional<PublicKey> optional = this.createPublicKey(key, keyID);
            return optional;
        }
    }

    private Optional<PublicKey> createPublicKey(String key, String keyID) throws Exception {
        try {
            return Optional.of(this.createPublicKeyFromPem(key));
        }
        catch (Exception pemEx) {
            try {
                return Optional.of(this.createPublicKeyFromJWKS(key, keyID));
            }
            catch (Exception jwksEx) {
                throw new DeploymentException((Throwable)jwksEx);
            }
        }
    }

    private PublicKey createPublicKeyFromPem(String key) throws Exception {
        key = key.replaceAll("-----BEGIN (.*)-----", "").replaceAll("-----END (.*)----", "").replaceAll("\r\n", "").replaceAll("\n", "").trim();
        byte[] keyBytes = Base64.getDecoder().decode(key);
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(keyBytes);
        return KeyFactory.getInstance(RSA_ALGORITHM).generatePublic(publicKeySpec);
    }

    private PublicKey createPublicKeyFromJWKS(String jwksValue, String keyID) throws Exception {
        JsonObject jwks = this.parseJwks(jwksValue);
        JsonArray keys = jwks.getJsonArray("keys");
        JsonObject jwk = keys != null ? this.findJwk(keys, keyID) : jwks;
        byte[] exponentBytes = Base64.getUrlDecoder().decode(jwk.getString("e"));
        BigInteger exponent = new BigInteger(1, exponentBytes);
        byte[] modulusBytes = Base64.getUrlDecoder().decode(jwk.getString("n"));
        BigInteger modulus = new BigInteger(1, modulusBytes);
        RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(modulus, exponent);
        return KeyFactory.getInstance(RSA_ALGORITHM).generatePublic(publicKeySpec);
    }

    private JsonObject parseJwks(String jwksValue) throws Exception {
        JsonObject jwks;
        try (JsonReader reader = Json.createReader((Reader)new StringReader(jwksValue));){
            jwks = reader.readObject();
        }
        catch (Exception ex) {
            byte[] jwksDecodedValue = Base64.getDecoder().decode(jwksValue);
            try (ByteArrayInputStream jwksStream = new ByteArrayInputStream(jwksDecodedValue);
                 JsonReader reader2 = Json.createReader((InputStream)jwksStream);){
                jwks = reader2.readObject();
            }
        }
        return jwks;
    }

    private JsonObject findJwk(JsonArray keys, String keyID) {
        if (Objects.isNull(keyID) && keys.size() > 0) {
            return keys.getJsonObject(0);
        }
        for (JsonValue value : keys) {
            JsonObject jwk = value.asJsonObject();
            if (!Objects.equals(keyID, jwk.getString("kid"))) continue;
            return jwk;
        }
        throw new IllegalStateException("No matching JWK for KeyID.");
    }
}

