/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.jwtauth.jwt;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.security.enterprise.CallerPrincipal;
import org.eclipse.microprofile.jwt.Claims;
import org.eclipse.microprofile.jwt.JsonWebToken;

public class JsonWebTokenImpl
extends CallerPrincipal
implements JsonWebToken {
    private final Map<String, JsonValue> claims;

    public JsonWebTokenImpl(String callerName, Map<String, JsonValue> claims) {
        super(callerName);
        this.claims = claims;
    }

    public Map<String, JsonValue> getClaims() {
        return this.claims;
    }

    @Override
    public <T> T getClaim(String claimName) {
        JsonValue claimValue = this.getClaims().get(claimName);
        if (claimValue == null) {
            return null;
        }
        try {
            Claims claim = Claims.valueOf(claimName);
            if (claim.getType().equals(Long.class)) {
                return (T)Long.valueOf(((JsonNumber)claimValue).longValue());
            }
            if (claim.getType().equals(Set.class)) {
                if (claimValue instanceof JsonString) {
                    return (T)Collections.singleton(((JsonString)claimValue).getString());
                }
                return (T)JsonWebTokenImpl.asStringSet((JsonArray)claimValue);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (claimValue instanceof JsonString) {
            return (T)((JsonString)claimValue).getString();
        }
        return (T)this.getClaims().get(claimName);
    }

    @Override
    public Set<String> getClaimNames() {
        return this.getClaims().keySet();
    }

    private static Set<String> asStringSet(JsonArray jsonArray) {
        return new HashSet(jsonArray.getValuesAs(JsonString.class)).stream().map(t -> t.getString()).collect(Collectors.toSet());
    }
}

