/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.jwtauth.jwt;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jwt.SignedJWT;
import fish.payara.microprofile.jwtauth.jwt.JsonWebTokenImpl;
import java.io.Reader;
import java.io.StringReader;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.json.Json;
import javax.json.JsonNumber;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.eclipse.microprofile.jwt.Claims;

public class JwtTokenParser {
    private static final String DEFAULT_NAMESPACE = "https://payara.fish/mp-jwt/";
    private final List<Claims> requiredClaims = Arrays.asList(Claims.iss, Claims.sub, Claims.exp, Claims.iat, Claims.jti, Claims.groups);
    private final boolean enableNamespacedClaims;
    private final Optional<String> customNamespace;
    private String rawToken;
    private SignedJWT signedJWT;

    public JwtTokenParser(Optional<Boolean> enableNamespacedClaims, Optional<String> customNamespace) {
        this.enableNamespacedClaims = enableNamespacedClaims.orElse(false);
        this.customNamespace = customNamespace;
    }

    public JwtTokenParser() {
        this(Optional.empty(), Optional.empty());
    }

    public void parse(String bearerToken) throws Exception {
        this.rawToken = bearerToken;
        this.signedJWT = SignedJWT.parse((String)this.rawToken);
        if (!this.checkIsJWT(this.signedJWT.getHeader())) {
            throw new IllegalStateException("Not JWT");
        }
    }

    public JsonWebTokenImpl verify(String issuer, PublicKey publicKey) throws Exception {
        if (this.signedJWT == null) {
            throw new IllegalStateException("No parsed SignedJWT.");
        }
        if (!this.signedJWT.getHeader().getAlgorithm().equals((Object)JWSAlgorithm.RS256)) {
            throw new IllegalStateException("Not RS256");
        }
        try (JsonReader reader = Json.createReader((Reader)new StringReader(this.signedJWT.getPayload().toString()));){
            Map<String, JsonValue> rawClaims = new HashMap<String, JsonValue>((Map<String, JsonValue>)reader.readObject());
            rawClaims = this.handleNamespacedClaims(rawClaims);
            if (!this.checkRequiredClaimsPresent(rawClaims)) {
                throw new IllegalStateException("Not all required claims present");
            }
            String callerPrincipalName = this.getCallerPrincipalName(rawClaims);
            if (callerPrincipalName == null) {
                throw new IllegalStateException("One of upn, preferred_username or sub is required to be non null");
            }
            if (!this.checkIssuer(rawClaims, issuer)) {
                throw new IllegalStateException("Bad issuer");
            }
            if (!this.checkNotExpired(rawClaims)) {
                throw new IllegalStateException("Expired");
            }
            if (!this.signedJWT.verify((JWSVerifier)new RSASSAVerifier((RSAPublicKey)publicKey))) {
                throw new IllegalStateException("Signature invalid");
            }
            rawClaims.put(Claims.raw_token.name(), (JsonValue)Json.createObjectBuilder().add("token", this.rawToken).build().get((Object)"token"));
            JsonWebTokenImpl jsonWebTokenImpl = new JsonWebTokenImpl(callerPrincipalName, rawClaims);
            return jsonWebTokenImpl;
        }
    }

    public String getKeyID() {
        if (this.signedJWT == null) {
            throw new IllegalStateException("No parsed SignedJWT.");
        }
        return this.signedJWT.getHeader().getKeyID();
    }

    private Map<String, JsonValue> handleNamespacedClaims(Map<String, JsonValue> currentClaims) {
        if (this.enableNamespacedClaims) {
            String namespace = this.customNamespace.orElse(DEFAULT_NAMESPACE);
            HashMap<String, JsonValue> processedClaims = new HashMap<String, JsonValue>(currentClaims.size());
            for (Map.Entry<String, JsonValue> entry : currentClaims.entrySet()) {
                String claimName = entry.getKey();
                JsonValue value = entry.getValue();
                if (claimName.startsWith(namespace)) {
                    claimName = claimName.substring(namespace.length());
                }
                processedClaims.put(claimName, value);
            }
            return processedClaims;
        }
        return currentClaims;
    }

    private boolean checkRequiredClaimsPresent(Map<String, JsonValue> presentedClaims) {
        for (Claims requiredClaim : this.requiredClaims) {
            if (presentedClaims.get(requiredClaim.name()) != null) continue;
            return false;
        }
        return true;
    }

    private boolean checkNotExpired(Map<String, JsonValue> presentedClaims) {
        int expiredTime;
        int currentTime = (int)(System.currentTimeMillis() / 1000L);
        return currentTime < (expiredTime = ((JsonNumber)presentedClaims.get(Claims.exp.name())).intValue());
    }

    private boolean checkIssuer(Map<String, JsonValue> presentedClaims, String acceptedIssuer) {
        if (!(presentedClaims.get(Claims.iss.name()) instanceof JsonString)) {
            return false;
        }
        String issuer = ((JsonString)presentedClaims.get(Claims.iss.name())).getString();
        return acceptedIssuer.equals(issuer);
    }

    private boolean checkIsJWT(JWSHeader header) {
        return header.getType().toString().equals("JWT");
    }

    private String getCallerPrincipalName(Map<String, JsonValue> rawClaims) {
        JsonString callerPrincipalClaim = (JsonString)rawClaims.get(Claims.upn.name());
        if (callerPrincipalClaim == null) {
            callerPrincipalClaim = (JsonString)rawClaims.get(Claims.preferred_username.name());
        }
        if (callerPrincipalClaim == null) {
            callerPrincipalClaim = (JsonString)rawClaims.get(Claims.sub.name());
        }
        if (callerPrincipalClaim == null) {
            return null;
        }
        return callerPrincipalClaim.getString();
    }
}

