/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.jwtauth.servlet;

import fish.payara.microprofile.jwtauth.cdi.CdiExtension;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.CDI;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

public class RolesDeclarationInitializer
implements ServletContainerInitializer {
    private static final Logger logger = Logger.getLogger(RolesDeclarationInitializer.class.getName());

    public void onStartup(Set<Class<?>> c, ServletContext ctx) throws ServletException {
        Set<String> roles = null;
        boolean addJWTAuthenticationMechanism = false;
        try {
            CdiExtension cdiExtension;
            Instance extensionInstance;
            CDI cdi = CDI.current();
            if (cdi != null && (extensionInstance = cdi.select(CdiExtension.class, new Annotation[0])) != null && !extensionInstance.isUnsatisfied() && !extensionInstance.isAmbiguous() && (cdiExtension = (CdiExtension)extensionInstance.get()) != null) {
                roles = cdiExtension.getRoles();
                addJWTAuthenticationMechanism = cdiExtension.isAddJWTAuthenticationMechanism();
            }
        }
        catch (Exception e) {
            logger.log(Level.FINEST, "Exception trying to use CDI:", e);
        }
        if (roles == null) {
            logger.log(Level.FINEST, "CDI not available for context " + ctx.getContextPath());
            return;
        }
        if (!addJWTAuthenticationMechanism) {
            return;
        }
        if (logger.isLoggable(Level.INFO)) {
            String version = this.getClass().getPackage().getImplementationVersion();
            logger.log(Level.INFO, "Initializing MP-JWT {0} for context ''{1}''", new Object[]{version, ctx.getContextPath()});
        }
        ctx.declareRoles(roles.toArray(new String[0]));
    }
}

