/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.requesttracing.store;

import fish.payara.nucleus.requesttracing.store.ClusteredRequestTraceStore;
import fish.payara.nucleus.requesttracing.store.LocalRequestTraceStore;
import fish.payara.nucleus.requesttracing.store.RequestTraceStoreInterface;
import fish.payara.nucleus.requesttracing.store.strategy.LongestTraceStorageStrategy;
import fish.payara.nucleus.requesttracing.store.strategy.ReservoirTraceStorageStrategy;
import fish.payara.nucleus.requesttracing.store.strategy.TraceStorageStrategy;
import fish.payara.nucleus.store.ClusteredStore;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.glassfish.api.event.Events;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.internal.api.Globals;

public class RequestTraceStoreFactory {
    private static final String REQUEST_TRACE_STORE = "REQUEST_TRACE_STORE";
    private static final String HISTORIC_REQUEST_TRACE_STORE = "HISTORIC_REQUEST_TRACE_STORE";

    public static RequestTraceStoreInterface getStore(Events events, boolean reservoirSamplingEnabled, boolean historic) {
        String storeName = historic ? HISTORIC_REQUEST_TRACE_STORE : REQUEST_TRACE_STORE;
        TraceStorageStrategy strategy = reservoirSamplingEnabled ? new ReservoirTraceStorageStrategy() : new LongestTraceStorageStrategy();
        ClusteredStore clusteredStore = null;
        ServiceHandle serviceHandle = Globals.getDefaultHabitat().getServiceHandle(ClusteredStore.class, new Annotation[0]);
        if (serviceHandle != null && serviceHandle.isActive()) {
            clusteredStore = (ClusteredStore)serviceHandle.getService();
        }
        if (clusteredStore != null && clusteredStore.isEnabled()) {
            Map<Serializable, Serializable> store = clusteredStore.getMap(storeName);
            return new ClusteredRequestTraceStore(store, strategy);
        }
        return new LocalRequestTraceStore(strategy);
    }
}

