/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.appserver.zendesk.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.util.ColumnFormatter;
import fish.payara.appserver.zendesk.config.ZendeskSupportConfiguration;
import java.util.HashMap;
import java.util.Properties;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@Service(name="get-zendesk-support-configuration")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=ZendeskSupportConfiguration.class, opType=RestEndpoint.OpType.GET, path="get-zendesk-support-configuration", description="Gets the Zendesk Support Configuration")})
public class GetZendeskSupportConfigurationCommand
implements AdminCommand {
    @Inject
    private Target targetUtil;
    private final String config = "server-config";

    public void execute(AdminCommandContext acc) {
        Config configNode = this.targetUtil.getConfig("server-config");
        ZendeskSupportConfiguration zendeskSupportConfiguration = (ZendeskSupportConfiguration)configNode.getExtensionByType(ZendeskSupportConfiguration.class);
        ActionReport actionReport = acc.getActionReport();
        String[] outputHeaders = new String[]{"Enabled", "Email Address"};
        ColumnFormatter columnFormatter = new ColumnFormatter(outputHeaders);
        Object[] outputValues = new Object[]{zendeskSupportConfiguration.getEnabled(), zendeskSupportConfiguration.getEmailAddress()};
        columnFormatter.addRow(outputValues);
        actionReport.appendMessage(columnFormatter.toString());
        HashMap<String, String> extraPropsMap = new HashMap<String, String>();
        extraPropsMap.put("enabled", zendeskSupportConfiguration.getEnabled());
        extraPropsMap.put("emailAddress", zendeskSupportConfiguration.getEmailAddress());
        Properties extraProps = new Properties();
        extraProps.put("zendeskSupportConfiguration", extraPropsMap);
        actionReport.setExtraProperties(extraProps);
    }
}

