/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop.security;

import com.sun.corba.ee.spi.legacy.interceptor.ORBInitInfoExt;
import com.sun.enterprise.iiop.security.AlternateSecurityInterceptorFactory;
import com.sun.enterprise.iiop.security.SecClientRequestInterceptor;
import com.sun.enterprise.iiop.security.SecIORInterceptor;
import com.sun.enterprise.iiop.security.SecServerRequestInterceptor;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.enterprise.iiop.api.IIOPInterceptorFactory;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.jvnet.hk2.annotations.Service;
import org.omg.CORBA.ORB;
import org.omg.IOP.Codec;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

@Service(name="ServerSecurityInterceptorFactory")
@Singleton
public class SecurityIIOPInterceptorFactory
implements IIOPInterceptorFactory {
    private static Logger _logger = null;
    final String interceptorFactory = System.getProperty("com.sun.enterprise.iiop.security.interceptorFactory");
    private ClientRequestInterceptor creq;
    private ServerRequestInterceptor sreq;
    private SecIORInterceptor sior;
    @Inject
    private ProcessEnvironment penv;
    private AlternateSecurityInterceptorFactory altSecFactory;
    @Inject
    private ClassLoaderHierarchy clh;

    public ClientRequestInterceptor createClientRequestInterceptor(ORBInitInfo info, Codec codec) {
        if (!this.penv.getProcessType().isServer()) {
            return null;
        }
        if (this.altSecFactory != null || this.interceptorFactory != null && this.createAlternateSecurityInterceptorFactory()) {
            return this.altSecFactory.getClientRequestInterceptor(codec);
        }
        ClientRequestInterceptor ret = this.getClientInterceptorInstance(codec);
        return ret;
    }

    public ServerRequestInterceptor createServerRequestInterceptor(ORBInitInfo info, Codec codec) {
        ServerRequestInterceptor ret = null;
        try {
            if (!this.penv.getProcessType().isServer()) {
                return null;
            }
            ret = this.altSecFactory != null || this.interceptorFactory != null && this.createAlternateSecurityInterceptorFactory() ? this.altSecFactory.getServerRequestInterceptor(codec) : this.getServerInterceptorInstance(codec);
            if (info instanceof ORBInitInfoExt) {
                ORBInitInfoExt infoExt = (ORBInitInfoExt)info;
                IORInterceptor secIOR = this.getSecIORInterceptorInstance(codec, (ORB)infoExt.getORB());
                info.add_ior_interceptor(secIOR);
            }
        }
        catch (DuplicateName ex) {
            _logger.log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
        return ret;
    }

    private synchronized boolean createAlternateSecurityInterceptorFactory() {
        try {
            Class<?> clazz;
            try {
                clazz = Thread.currentThread().getContextClassLoader().loadClass(this.interceptorFactory);
            }
            catch (ClassNotFoundException cnfe) {
                clazz = this.clh.getCommonClassLoader().loadClass(this.interceptorFactory);
            }
            if (AlternateSecurityInterceptorFactory.class.isAssignableFrom(clazz) && !clazz.isInterface()) {
                this.altSecFactory = (AlternateSecurityInterceptorFactory)clazz.newInstance();
                return true;
            }
            _logger.log(Level.INFO, "Not a valid factory class: " + this.interceptorFactory + ". Must implement " + AlternateSecurityInterceptorFactory.class.getName());
        }
        catch (ClassNotFoundException ex) {
            _logger.log(Level.INFO, "Interceptor Factory class " + this.interceptorFactory + " not loaded: ", ex);
        }
        catch (InstantiationException ex) {
            _logger.log(Level.INFO, "Interceptor Factory class " + this.interceptorFactory + " not loaded: ", ex);
        }
        catch (IllegalAccessException ex) {
            _logger.log(Level.INFO, "Interceptor Factory class " + this.interceptorFactory + " not loaded: ", ex);
        }
        return false;
    }

    private synchronized ClientRequestInterceptor getClientInterceptorInstance(Codec codec) {
        if (this.creq == null) {
            this.creq = new SecClientRequestInterceptor("SecClientRequestInterceptor", codec);
        }
        return this.creq;
    }

    private synchronized ServerRequestInterceptor getServerInterceptorInstance(Codec codec) {
        if (this.sreq == null) {
            this.sreq = new SecServerRequestInterceptor("SecServerRequestInterceptor", codec);
        }
        return this.sreq;
    }

    private synchronized IORInterceptor getSecIORInterceptorInstance(Codec codec, ORB orb) {
        if (this.sior == null) {
            this.sior = new SecIORInterceptor(codec, orb);
        }
        return this.sior;
    }

    static {
        _logger = LogDomains.getLogger(SecurityIIOPInterceptorFactory.class, (String)"javax.enterprise.system.core.security");
    }
}

