/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.faulttolerance;

import java.util.function.LongSupplier;

public interface FaultToleranceMetrics {
    public static final FaultToleranceMetrics DISABLED = new FaultToleranceMetrics(){};

    default public void incrementCounter(String metric) {
    }

    default public void addToHistogram(String metric, long nanos) {
    }

    default public void linkGauge(String metric, LongSupplier gauge) {
    }

    default public void incrementInvocationsTotal() {
        this.incrementCounter("ft.%s.invocations.total");
    }

    default public void incrementInvocationsFailedTotal() {
        this.incrementCounter("ft.%s.invocations.failed.total");
    }

    default public void incrementRetryCallsSucceededNotRetriedTotal() {
        this.incrementCounter("ft.%s.retry.callsSucceededNotRetried.total");
    }

    default public void incrementRetryCallsSucceededRetriedTotal() {
        this.incrementCounter("ft.%s.retry.callsSucceededRetried.total");
    }

    default public void incrementRetryCallsFailedTotal() {
        this.incrementCounter("ft.%s.retry.callsFailed.total");
    }

    default public void incrementRetryRetriesTotal() {
        this.incrementCounter("ft.%s.retry.retries.total");
    }

    default public void addTimeoutExecutionDuration(long duration) {
        this.addToHistogram("ft.%s.timeout.executionDuration", duration);
    }

    default public void incrementTimeoutCallsTimedOutTotal() {
        this.incrementCounter("ft.%s.timeout.callsTimedOut.total");
    }

    default public void incrementTimeoutCallsNotTimedOutTotal() {
        this.incrementCounter("ft.%s.timeout.callsNotTimedOut.total");
    }

    default public void incrementCircuitbreakerCallsSucceededTotal() {
        this.incrementCounter("ft.%s.circuitbreaker.callsSucceeded.total");
    }

    default public void incrementCircuitbreakerCallsFailedTotal() {
        this.incrementCounter("ft.%s.circuitbreaker.callsFailed.total");
    }

    default public void incrementCircuitbreakerCallsPreventedTotal() {
        this.incrementCounter("ft.%s.circuitbreaker.callsPrevented.total");
    }

    default public void incrementCircuitbreakerOpenedTotal() {
        this.incrementCounter("ft.%s.circuitbreaker.opened.total");
    }

    default public void linkCircuitbreakerOpenTotal(LongSupplier gauge) {
        this.linkGauge("ft.%s.circuitbreaker.open.total", gauge);
    }

    default public void linkCircuitbreakerHalfOpenTotal(LongSupplier gauge) {
        this.linkGauge("ft.%s.circuitbreaker.halfOpen.total", gauge);
    }

    default public void linkCircuitbreakerClosedTotal(LongSupplier gauge) {
        this.linkGauge("ft.%s.circuitbreaker.closed.total", gauge);
    }

    default public void incrementBulkheadCallsAcceptedTotal() {
        this.incrementCounter("ft.%s.bulkhead.callsAccepted.total");
    }

    default public void incrementBulkheadCallsRejectedTotal() {
        this.incrementCounter("ft.%s.bulkhead.callsRejected.total");
    }

    default public void linkBulkheadConcurrentExecutions(LongSupplier gauge) {
        this.linkGauge("ft.%s.bulkhead.concurrentExecutions", gauge);
    }

    default public void linkBulkheadWaitingQueuePopulation(LongSupplier gauge) {
        this.linkGauge("ft.%s.bulkhead.waitingQueue.population", gauge);
    }

    default public void addBulkheadExecutionDuration(long duration) {
        this.addToHistogram("ft.%s.bulkhead.executionDuration", duration);
    }

    default public void addBulkheadWaitingDuration(long duration) {
        this.addToHistogram("ft.%s.bulkhead.waiting.duration", duration);
    }

    default public void incrementFallbackCallsTotal() {
        this.incrementCounter("ft.%s.fallback.calls.total");
    }
}

