/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.faulttolerance.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.util.ColumnFormatter;
import fish.payara.microprofile.faulttolerance.FaultToleranceServiceConfiguration;
import java.util.HashMap;
import java.util.Properties;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@Service(name="get-fault-tolerance-configuration")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=FaultToleranceServiceConfiguration.class, opType=RestEndpoint.OpType.GET, path="get-fault-tolerance-configuration", description="Gets the Fault Tolerance Configuration")})
public class GetFaultToleranceConfigurationCommand
implements AdminCommand {
    private final String[] OUTPUT_HEADERS = new String[]{"Async Max Pool Size", "Delay Max Pool Size"};
    @Inject
    private Target targetUtil;
    @Param(optional=true, defaultValue="server-config")
    private String target;

    public void execute(AdminCommandContext acc) {
        Config targetConfig = this.targetUtil.getConfig(this.target);
        if (targetConfig == null) {
            acc.getActionReport().setMessage("No such config name: " + this.targetUtil);
            acc.getActionReport().setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        FaultToleranceServiceConfiguration config = (FaultToleranceServiceConfiguration)targetConfig.getExtensionByType(FaultToleranceServiceConfiguration.class);
        ColumnFormatter columnFormatter = new ColumnFormatter(this.OUTPUT_HEADERS);
        Object[] outputValues = new Object[]{config.getAsyncMaxPoolSize(), config.getDelayMaxPoolSize()};
        columnFormatter.addRow(outputValues);
        acc.getActionReport().appendMessage(columnFormatter.toString());
        HashMap<String, String> extraPropertiesMap = new HashMap<String, String>();
        extraPropertiesMap.put("asyncMaxPoolSize", config.getAsyncMaxPoolSize());
        extraPropertiesMap.put("delayMaxPoolSize", config.getDelayMaxPoolSize());
        Properties extraProperties = new Properties();
        extraProperties.put("faultToleranceConfiguration", extraPropertiesMap);
        acc.getActionReport().setExtraProperties(extraProperties);
    }
}

