/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.faulttolerance.admin;

import com.sun.enterprise.config.serverbeans.Config;
import fish.payara.microprofile.faulttolerance.FaultToleranceServiceConfiguration;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="set-fault-tolerance-configuration")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=FaultToleranceServiceConfiguration.class, opType=RestEndpoint.OpType.POST, path="set-fault-tolerance-configuration", description="Sets the Fault Tolerance Configuration")})
public class SetFaultToleranceConfigurationCommand
implements AdminCommand {
    private static final Logger logger = Logger.getLogger(SetFaultToleranceConfigurationCommand.class.getName());
    @Inject
    private Target targetUtil;
    @Param(optional=true, alias="managedexecutorservicename", obsolete=true)
    private String managedExecutorServiceName;
    @Param(optional=true, alias="managedscheduledexecutorservicename", obsolete=true)
    private String managedScheduledExecutorServiceName;
    @Param(optional=true, alias="async-max-pool-size")
    private Integer asyncMaxPoolSize;
    @Param(optional=true, alias="delay-max-pool-size")
    private Integer delayMaxPoolSize;
    @Param(optional=true, alias="async-pool-keep-alive")
    private Integer _asyncPoolKeepAliveInSeconds;
    @Param(optional=true, alias="cleanup-interval")
    private Integer _cleanupIntervalInMinutes;
    @Param(optional=true, defaultValue="server-config")
    private String target;

    public void execute(AdminCommandContext acc) {
        Config targetConfig = this.targetUtil.getConfig(this.target);
        FaultToleranceServiceConfiguration faultToleranceServiceConfiguration = (FaultToleranceServiceConfiguration)targetConfig.getExtensionByType(FaultToleranceServiceConfiguration.class);
        try {
            ConfigSupport.apply(configProxy -> {
                if (this.asyncMaxPoolSize != null) {
                    configProxy.setAsyncMaxPoolSize(this.asyncMaxPoolSize <= 0 ? null : this.asyncMaxPoolSize.toString());
                }
                if (this.delayMaxPoolSize != null) {
                    configProxy.setDelayMaxPoolSize(this.delayMaxPoolSize <= 0 ? null : this.delayMaxPoolSize.toString());
                }
                if (this._asyncPoolKeepAliveInSeconds != null) {
                    configProxy.setAsyncPoolKeepAliveInSeconds(this._asyncPoolKeepAliveInSeconds.toString());
                }
                if (this._cleanupIntervalInMinutes != null) {
                    configProxy.setCleanupIntervalInMinutes(this._cleanupIntervalInMinutes.toString());
                }
                return null;
            }, (ConfigBeanProxy)faultToleranceServiceConfiguration);
        }
        catch (TransactionFailure ex) {
            acc.getActionReport().failure(logger, "Failed to update Fault Tolerance configuration", (Throwable)ex);
        }
    }
}

