/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.faulttolerance.cdi;

import fish.payara.microprofile.faulttolerance.FaultToleranceConfig;
import fish.payara.microprofile.faulttolerance.FaultToleranceService;
import fish.payara.microprofile.faulttolerance.cdi.FaultTolerance;
import fish.payara.microprofile.faulttolerance.policy.FaultTolerancePolicy;
import fish.payara.microprofile.faulttolerance.service.Stereotypes;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.enterprise.context.control.RequestContextController;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;
import org.glassfish.internal.api.Globals;

@Interceptor
@FaultTolerance
@Priority(value=4015)
public class FaultToleranceInterceptor
implements Stereotypes,
Serializable {
    private static final Logger logger = Logger.getLogger(FaultToleranceInterceptor.class.getName());
    @Inject
    private BeanManager beanManager;
    @Inject
    private Instance<RequestContextController> requestContextControllerInstance;

    @AroundInvoke
    public Object intercept(InvocationContext context) throws Exception {
        try {
            FaultToleranceService env = (FaultToleranceService)Globals.getDefaultBaseServiceLocator().getService(FaultToleranceService.class, new Annotation[0]);
            AtomicReference lazyConfig = new AtomicReference();
            Supplier<FaultToleranceConfig> configSupplier = () -> (FaultToleranceConfig)lazyConfig.updateAndGet(value -> value != null ? value : env.getConfig(context, this));
            FaultTolerancePolicy policy = FaultTolerancePolicy.get(context, configSupplier);
            if (policy.isPresent) {
                return policy.proceed(context, () -> env.getMethodContext(context, policy, this.getRequestContextController()));
            }
        }
        catch (FaultToleranceDefinitionException e) {
            logger.log(Level.SEVERE, "Effective FT policy contains illegal values, fault tolerance cannot be applied, falling back to plain method invocation.", e);
        }
        return context.proceed();
    }

    private RequestContextController getRequestContextController() {
        return this.requestContextControllerInstance.isResolvable() ? (RequestContextController)this.requestContextControllerInstance.get() : null;
    }

    @Override
    public boolean isStereotype(Class<? extends Annotation> annotationType) {
        return this.beanManager.isStereotype(annotationType);
    }

    @Override
    public Set<Annotation> getStereotypeDefinition(Class<? extends Annotation> stereotype) {
        return this.beanManager.getStereotypeDefinition(stereotype);
    }
}

