/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.faulttolerance.policy;

import fish.payara.microprofile.faulttolerance.FaultToleranceConfig;
import fish.payara.microprofile.faulttolerance.FaultToleranceMethodContext;
import fish.payara.microprofile.faulttolerance.FaultToleranceMetrics;
import fish.payara.microprofile.faulttolerance.policy.AsynchronousPolicy;
import fish.payara.microprofile.faulttolerance.policy.BulkheadPolicy;
import fish.payara.microprofile.faulttolerance.policy.CircuitBreakerPolicy;
import fish.payara.microprofile.faulttolerance.policy.FallbackPolicy;
import fish.payara.microprofile.faulttolerance.policy.RetryPolicy;
import fish.payara.microprofile.faulttolerance.policy.StaticAnalysisContext;
import fish.payara.microprofile.faulttolerance.policy.TimeoutPolicy;
import fish.payara.microprofile.faulttolerance.state.CircuitBreakerState;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.faulttolerance.exceptions.BulkheadException;
import org.eclipse.microprofile.faulttolerance.exceptions.CircuitBreakerOpenException;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceException;
import org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException;

public final class FaultTolerancePolicy
implements Serializable {
    static final Logger logger = Logger.getLogger(FaultTolerancePolicy.class.getName());
    private static final long TTL = 60000L;
    private static final ConcurrentHashMap<Class<?>, Map<Method, FaultTolerancePolicy>> POLICY_BY_METHOD = new ConcurrentHashMap();
    private final long expiresMillis = System.currentTimeMillis() + 60000L;
    public final boolean isPresent;
    public final boolean isNonFallbackEnabled;
    public final boolean isMetricsEnabled;
    public final AsynchronousPolicy asynchronous;
    public final BulkheadPolicy bulkhead;
    public final CircuitBreakerPolicy circuitBreaker;
    public final FallbackPolicy fallback;
    public final RetryPolicy retry;
    public final TimeoutPolicy timeout;

    public static void clean() {
        long now = System.currentTimeMillis();
        POLICY_BY_METHOD.forEachValue(Long.MAX_VALUE, map -> map.entrySet().removeIf(entry -> now > ((FaultTolerancePolicy)entry.getValue()).expiresMillis));
    }

    public static FaultTolerancePolicy asAnnotated(Class<?> target, Method annotated) {
        return FaultTolerancePolicy.create(new StaticAnalysisContext(target, annotated), FaultToleranceConfig.asAnnotated(target, annotated));
    }

    public static FaultTolerancePolicy get(InvocationContext context, Supplier<FaultToleranceConfig> configSpplier) throws FaultToleranceDefinitionException {
        return POLICY_BY_METHOD.computeIfAbsent(context.getTarget().getClass(), target -> new ConcurrentHashMap()).compute(context.getMethod(), (method, policy) -> policy != null && !policy.isExpired() ? policy : FaultTolerancePolicy.create(context, (FaultToleranceConfig)configSpplier.get()));
    }

    private static FaultTolerancePolicy create(InvocationContext context, FaultToleranceConfig config) {
        return new FaultTolerancePolicy(config.isNonFallbackEnabled(), config.isMetricsEnabled(), AsynchronousPolicy.create(context, config), BulkheadPolicy.create(context, config), CircuitBreakerPolicy.create(context, config), FallbackPolicy.create(context, config), RetryPolicy.create(context, config), TimeoutPolicy.create(context, config));
    }

    public FaultTolerancePolicy(boolean isNonFallbackEnabled, boolean isMetricsEnabled, AsynchronousPolicy asynchronous, BulkheadPolicy bulkhead, CircuitBreakerPolicy circuitBreaker, FallbackPolicy fallback, RetryPolicy retry, TimeoutPolicy timeout) {
        this.isNonFallbackEnabled = isNonFallbackEnabled;
        this.isMetricsEnabled = isMetricsEnabled;
        this.asynchronous = asynchronous;
        this.bulkhead = bulkhead;
        this.circuitBreaker = circuitBreaker;
        this.fallback = fallback;
        this.retry = retry;
        this.timeout = timeout;
        this.isPresent = this.isAsynchronous() || this.isBulkheadPresent() || this.isCircuitBreakerPresent() || this.isFallbackPresent() || this.isRetryPresent() || this.isTimeoutPresent();
    }

    private boolean isExpired() {
        return System.currentTimeMillis() > this.expiresMillis;
    }

    public boolean isAsynchronous() {
        return this.asynchronous != null;
    }

    public boolean isBulkheadPresent() {
        return this.bulkhead != null;
    }

    public boolean isCircuitBreakerPresent() {
        return this.circuitBreaker != null;
    }

    public boolean isFallbackPresent() {
        return this.fallback != null;
    }

    public boolean isRetryPresent() {
        return this.retry != null;
    }

    public boolean isTimeoutPresent() {
        return this.timeout != null;
    }

    public Object proceed(InvocationContext context, Supplier<FaultToleranceMethodContext> ftmContextSupplier) throws Exception {
        if (!this.isPresent) {
            logger.log(Level.FINER, "Fault Tolerance not enabled, proceeding normally.");
            return context.proceed();
        }
        FaultToleranceMethodContext ftmContext = ftmContextSupplier.get();
        FaultToleranceMetrics metrics = ftmContext.getMetrics(this.isMetricsEnabled);
        try {
            metrics.incrementInvocationsTotal();
            return this.processAsynchronousStage(ftmContext, metrics);
        }
        catch (Error | Exception ex) {
            metrics.incrementInvocationsFailedTotal();
            throw ex;
        }
    }

    private Object processAsynchronousStage(FaultToleranceMethodContext context, final FaultToleranceMetrics metrics) throws Exception {
        if (!this.isAsynchronous()) {
            return this.processFallbackStage(new FaultToleranceInvocation(context, metrics, null, null));
        }
        logger.log(Level.FINER, "Proceeding invocation with asynchronous semantics");
        final ConcurrentHashMap.KeySetView workers = ConcurrentHashMap.newKeySet();
        CompletableFuture<Object> asyncResult = new CompletableFuture<Object>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                if (super.cancel(mayInterruptIfRunning)) {
                    logger.log(Level.FINE, "Asynchronous computation was cancelled by caller.");
                    if (mayInterruptIfRunning) {
                        workers.forEach(worker -> worker.interrupt());
                    }
                    return true;
                }
                return false;
            }

            @Override
            public boolean completeExceptionally(Throwable ex) {
                logger.log(Level.FINE, "Asynchronous computation completed with exception", ex);
                if (ex instanceof ExecutionException) {
                    metrics.incrementInvocationsFailedTotal();
                    return super.completeExceptionally(ex.getCause());
                }
                if (ex instanceof FaultToleranceException || !FaultTolerancePolicy.this.asynchronous.isSuccessWhenCompletedExceptionally()) {
                    metrics.incrementInvocationsFailedTotal();
                }
                return super.completeExceptionally(ex);
            }
        };
        FaultToleranceInvocation invocation = new FaultToleranceInvocation(context, metrics, asyncResult, workers);
        context.runAsynchronous(asyncResult, () -> invocation.runStageWithWorker(() -> this.processFallbackStage(invocation)));
        return asyncResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object processFallbackStage(FaultToleranceInvocation invocation) throws Exception {
        if (!this.isFallbackPresent()) {
            return this.processRetryStage(invocation);
        }
        logger.log(Level.FINER, "Proceeding invocation with fallback semantics");
        invocation.trace("executeFallbackMethod");
        try {
            Object object = this.processRetryStage(invocation);
            return object;
        }
        catch (Error | Exception ex) {
            if (!this.fallback.isFallbackApplied(ex)) {
                throw ex;
            }
            invocation.metrics.incrementFallbackCallsTotal();
            if (this.fallback.isHandlerPresent()) {
                logger.log(Level.FINE, "Using fallback class: {0}", this.fallback.value.getName());
                Object object = invocation.context.fallbackHandle(this.fallback.value, ex);
                return object;
            }
            logger.log(Level.FINE, "Using fallback method: {0}", this.fallback.method.getName());
            Object object = invocation.context.fallbackInvoke(this.fallback.method);
            return object;
        }
        finally {
            invocation.endTrace();
        }
    }

    private Object processRetryStage(FaultToleranceInvocation invocation) throws Exception {
        int totalAttempts;
        if (!this.retry.isNone()) {
            logger.log(Level.FINER, "Proceeding invocation with retry semantics");
        }
        int attemptsLeft = totalAttempts = this.retry.totalAttempts();
        Long retryTimeoutTime = this.retry.timeoutTimeNow();
        while (attemptsLeft > 0) {
            --attemptsLeft;
            try {
                Object resultValue;
                boolean firstAttempt;
                boolean bl = firstAttempt = attemptsLeft == totalAttempts - 1;
                if (!firstAttempt) {
                    logger.log(Level.FINER, "Attempting retry.");
                    invocation.metrics.incrementRetryRetriesTotal();
                }
                Object object = resultValue = this.isAsynchronous() ? this.processRetryAsync(invocation) : this.processCircuitBreakerStage(invocation, null);
                if (firstAttempt) {
                    invocation.metrics.incrementRetryCallsSucceededNotRetriedTotal();
                } else {
                    invocation.metrics.incrementRetryCallsSucceededRetriedTotal();
                }
                return resultValue;
            }
            catch (Error | Exception ex) {
                boolean timedOut;
                boolean bl = timedOut = retryTimeoutTime != null && System.currentTimeMillis() >= retryTimeoutTime;
                if (!timedOut && !this.retry.retryOn(ex)) {
                    throw ex;
                }
                if (timedOut || attemptsLeft <= 0) {
                    logger.log(Level.FINE, "Retry attemp failed. Giving up{0}", timedOut ? " due to time-out." : ".");
                    invocation.metrics.incrementRetryCallsFailedTotal();
                    throw ex;
                }
                logger.log(Level.FINE, "Retry attempt failed. {0} attempts left.", attemptsLeft);
                if (!this.retry.isDelayed()) continue;
                invocation.context.delay(this.retry.jitteredDelay());
            }
        }
        throw new FaultToleranceException("Retry failed");
    }

    private CompletableFuture<Object> processRetryAsync(FaultToleranceInvocation invocation) throws Exception {
        CompletableFuture<Object> asyncAttempt = new CompletableFuture<Object>();
        invocation.context.runAsynchronous(asyncAttempt, () -> invocation.runStageWithWorker(() -> this.processCircuitBreakerStage(invocation, asyncAttempt)));
        try {
            asyncAttempt.get();
            invocation.timeoutIfConcludedConcurrently();
            return asyncAttempt;
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof ExecutionException) {
                if (this.asynchronous.isSuccessWhenCompletedExceptionally()) {
                    CompletableFuture<Object> exceptionalResult = new CompletableFuture<Object>();
                    exceptionalResult.completeExceptionally(cause.getCause());
                    return exceptionalResult;
                }
                FaultTolerancePolicy.rethrow(cause.getCause());
            }
            FaultTolerancePolicy.rethrow(cause);
            return null;
        }
    }

    private static void rethrow(Throwable t) throws Exception {
        if (t instanceof Exception) {
            throw (Exception)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new ExecutionException(t);
    }

    private Object processCircuitBreakerStage(FaultToleranceInvocation invocation, CompletableFuture<Object> asyncAttempt) throws Exception {
        if (!this.isCircuitBreakerPresent()) {
            return this.processTimeoutStage(invocation, asyncAttempt);
        }
        logger.log(Level.FINER, "Proceeding invocation with circuitbreaker semantics");
        CircuitBreakerState state = invocation.context.getState(this.circuitBreaker.requestVolumeThreshold);
        if (this.isMetricsEnabled) {
            invocation.metrics.linkCircuitbreakerOpenTotal(state::nanosOpen);
            invocation.metrics.linkCircuitbreakerHalfOpenTotal(state::nanosHalfOpen);
            invocation.metrics.linkCircuitbreakerClosedTotal(state::nanosClosed);
        }
        Object resultValue = null;
        switch (state.getCircuitState()) {
            default: {
                logger.log(Level.FINER, "CircuitBreaker is open, throwing exception");
                invocation.metrics.incrementCircuitbreakerCallsPreventedTotal();
                throw new CircuitBreakerOpenException();
            }
            case HALF_OPEN: {
                logger.log(Level.FINER, "Proceeding half open CircuitBreaker context");
                try {
                    resultValue = this.processTimeoutStage(invocation, asyncAttempt);
                }
                catch (Error | Exception ex) {
                    invocation.metrics.incrementCircuitbreakerCallsFailedTotal();
                    if (this.circuitBreaker.isFailure(ex)) {
                        logger.log(Level.FINE, "Exception causes CircuitBreaker to transit: half-open => open");
                        this.openCircuit(invocation, state);
                    }
                    throw ex;
                }
                if (state.halfOpenSuccessfulClosedCircuit(this.circuitBreaker.successThreshold)) {
                    logger.log(Level.FINE, "Success threshold causes CircuitBreaker to transit: half-open => closed");
                }
                invocation.metrics.incrementCircuitbreakerCallsSucceededTotal();
                return resultValue;
            }
            case CLOSED: 
        }
        logger.log(Level.FINER, "Proceeding closed CircuitBreaker context");
        Throwable failedOn = null;
        try {
            resultValue = this.processTimeoutStage(invocation, asyncAttempt);
            state.recordClosedOutcome(true);
        }
        catch (Error | Exception ex) {
            if (this.circuitBreaker.isFailure(ex)) {
                state.recordClosedOutcome(false);
                invocation.metrics.incrementCircuitbreakerCallsFailedTotal();
            } else {
                state.recordClosedOutcome(true);
                invocation.metrics.incrementCircuitbreakerCallsSucceededTotal();
            }
            failedOn = ex;
        }
        if (state.isOverFailureThreshold(this.circuitBreaker.requestVolumeThreshold, this.circuitBreaker.failureRatio)) {
            logger.log(Level.FINE, "Failure threshold causes CircuitBreaker to transit: closed => open");
            this.openCircuit(invocation, state);
        }
        if (failedOn != null) {
            FaultTolerancePolicy.rethrow(failedOn);
        }
        invocation.metrics.incrementCircuitbreakerCallsSucceededTotal();
        return resultValue;
    }

    private void openCircuit(FaultToleranceInvocation invocation, CircuitBreakerState state) throws Exception {
        invocation.metrics.incrementCircuitbreakerOpenedTotal();
        state.open();
        if (this.circuitBreaker.delay == 0L) {
            state.halfOpen();
        } else {
            invocation.context.runDelayed(this.circuitBreaker.delay, state::halfOpen);
        }
    }

    private Object processTimeoutStage(FaultToleranceInvocation invocation, CompletableFuture<Object> asyncAttempt) throws Exception {
        if (!this.isTimeoutPresent()) {
            return this.processBulkheadStage(invocation);
        }
        logger.log(Level.FINER, "Proceeding invocation with timeout semantics");
        long timeoutDuration = Duration.of(this.timeout.value, this.timeout.unit).toMillis();
        long timeoutTime = System.currentTimeMillis() + timeoutDuration;
        Thread current = Thread.currentThread();
        AtomicBoolean timedOut = new AtomicBoolean(false);
        Future<?> timeout = invocation.context.runDelayed(timeoutDuration, () -> {
            logger.log(Level.FINE, "Interrupting attempt due to timeout.");
            timedOut.set(true);
            current.interrupt();
            invocation.metrics.incrementTimeoutCallsTimedOutTotal();
            if (asyncAttempt != null) {
                asyncAttempt.completeExceptionally(new TimeoutException());
            }
        });
        long executionStartTime = System.nanoTime();
        try {
            Object resultValue = this.processBulkheadStage(invocation);
            if (current.isInterrupted()) {
                Thread.interrupted();
            }
            if (timedOut.get() || System.currentTimeMillis() > timeoutTime) {
                throw new TimeoutException();
            }
            invocation.metrics.incrementTimeoutCallsNotTimedOutTotal();
            Object object = resultValue;
            return object;
        }
        catch (TimeoutException ex) {
            logger.log(Level.FINE, "Execution timed out.");
            throw ex;
        }
        catch (Error | Exception ex) {
            if (timedOut.get() || System.currentTimeMillis() > timeoutTime) {
                logger.log(Level.FINE, "Execution timed out.");
                throw new TimeoutException(ex);
            }
            throw ex;
        }
        finally {
            invocation.metrics.addTimeoutExecutionDuration(System.nanoTime() - executionStartTime);
            timeout.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object processBulkheadStage(FaultToleranceInvocation invocation) throws Exception {
        int currentlyIn;
        if (!this.isBulkheadPresent()) {
            return FaultTolerancePolicy.proceed(invocation);
        }
        logger.log(Level.FINER, "Proceeding invocation with bulkhead semantics");
        boolean async = this.isAsynchronous();
        boolean exitOnCompletion = async && this.bulkhead.exitOnCompletion;
        int runCapacity = this.bulkhead.value;
        int queueCapacity = async ? this.bulkhead.waitingTaskQueue : 0;
        AtomicInteger queuingOrRunning = invocation.context.getQueuingOrRunningPopulation();
        if (this.isMetricsEnabled && async) {
            invocation.metrics.linkBulkheadWaitingQueuePopulation(() -> Math.max(0, queuingOrRunning.get() - runCapacity));
        }
        do {
            if ((currentlyIn = queuingOrRunning.get()) >= runCapacity + queueCapacity) {
                invocation.metrics.incrementBulkheadCallsRejectedTotal();
                throw new BulkheadException("No free work or queue space.");
            }
            if (queueCapacity <= 0) continue;
            logger.log(Level.FINER, "Attempting to enter bulkhead queue.");
        } while (!queuingOrRunning.compareAndSet(currentlyIn, currentlyIn + 1));
        try {
            CompletionStage<Object> completionStage;
            block22: {
                Object res;
                long executionSince;
                Thread currentThread;
                BlockingQueue<Thread> running;
                block20: {
                    Object object;
                    block21: {
                        logger.log(Level.FINE, "Entered bulkhead queue.");
                        running = invocation.context.getConcurrentExecutions(runCapacity);
                        if (this.isMetricsEnabled) {
                            invocation.metrics.incrementBulkheadCallsAcceptedTotal();
                            invocation.metrics.linkBulkheadConcurrentExecutions(running::size);
                        }
                        logger.log(Level.FINER, "Attempting to enter bulkhead execution.");
                        long waitingSince = System.nanoTime();
                        currentThread = Thread.currentThread();
                        try {
                            running.put(currentThread);
                        }
                        finally {
                            if (async) {
                                invocation.metrics.addBulkheadWaitingDuration(Math.max(1L, System.nanoTime() - waitingSince));
                            }
                        }
                        executionSince = System.nanoTime();
                        try {
                            logger.log(Level.FINE, "Entered bulkhead execution.");
                            res = FaultTolerancePolicy.proceed(invocation);
                            if (exitOnCompletion) break block20;
                            object = res;
                            if (exitOnCompletion) break block21;
                            invocation.metrics.addBulkheadExecutionDuration(Math.max(1L, System.nanoTime() - executionSince));
                            running.remove(currentThread);
                        }
                        catch (Throwable throwable) {
                            if (!exitOnCompletion) {
                                invocation.metrics.addBulkheadExecutionDuration(Math.max(1L, System.nanoTime() - executionSince));
                                running.remove(currentThread);
                            }
                            throw throwable;
                        }
                    }
                    return object;
                }
                completionStage = ((CompletionStage)res).whenComplete((value, exception) -> {
                    invocation.metrics.addBulkheadExecutionDuration(Math.max(1L, System.nanoTime() - executionSince));
                    running.remove(currentThread);
                    queuingOrRunning.decrementAndGet();
                });
                if (exitOnCompletion) break block22;
                invocation.metrics.addBulkheadExecutionDuration(Math.max(1L, System.nanoTime() - executionSince));
                running.remove(currentThread);
            }
            return completionStage;
        }
        finally {
            if (!exitOnCompletion) {
                queuingOrRunning.decrementAndGet();
            }
        }
    }

    private static Object proceed(FaultToleranceInvocation invocation) throws Exception {
        invocation.timeoutIfConcludedConcurrently();
        logger.log(Level.FINER, "Proceeding invocation chain");
        return invocation.context.proceed();
    }

    static final class FaultToleranceInvocation {
        final FaultToleranceMethodContext context;
        final FaultToleranceMetrics metrics;
        final CompletableFuture<Object> asyncResult;
        final Set<Thread> asyncWorkers;

        FaultToleranceInvocation(FaultToleranceMethodContext context, FaultToleranceMetrics metrics, CompletableFuture<Object> asyncResult, Set<Thread> asyncWorkers) {
            this.context = context;
            this.metrics = metrics;
            this.asyncResult = asyncResult;
            this.asyncWorkers = asyncWorkers;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object runStageWithWorker(Callable<Object> stage) throws Exception {
            this.timeoutIfConcludedConcurrently();
            Thread current = Thread.currentThread();
            this.asyncWorkers.add(current);
            try {
                Object object = stage.call();
                return object;
            }
            finally {
                this.asyncWorkers.remove(current);
            }
        }

        void timeoutIfConcludedConcurrently() throws TimeoutException {
            if (this.asyncResult != null && this.asyncResult.isDone() || Thread.currentThread().isInterrupted()) {
                throw new TimeoutException("Computation already concluded in a concurrent attempt");
            }
        }

        void trace(String method) {
            this.context.trace(method);
        }

        void endTrace() {
            this.context.endTrace();
        }
    }
}

