/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.faulttolerance.service;

import fish.payara.microprofile.faulttolerance.FaultToleranceMethodContext;
import fish.payara.microprofile.faulttolerance.FaultToleranceMetrics;
import fish.payara.microprofile.faulttolerance.policy.AsynchronousPolicy;
import fish.payara.microprofile.faulttolerance.policy.FaultTolerancePolicy;
import fish.payara.microprofile.faulttolerance.service.FaultToleranceExecutionContext;
import fish.payara.microprofile.faulttolerance.service.FaultToleranceRequestTracing;
import fish.payara.microprofile.faulttolerance.state.CircuitBreakerState;
import fish.payara.notification.requesttracing.RequestTraceSpan;
import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.control.RequestContextController;
import javax.enterprise.inject.spi.CDI;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.faulttolerance.FallbackHandler;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

public final class FaultToleranceMethodContextImpl
implements FaultToleranceMethodContext {
    private static final Logger logger = Logger.getLogger(FaultToleranceMethodContextImpl.class.getName());
    private final FaultToleranceMethodState shared;
    private final InvocationContext context;
    private final FaultTolerancePolicy policy;

    public FaultToleranceMethodContextImpl(RequestContextController requestContext, FaultToleranceRequestTracing requestTracing, FaultToleranceMetrics metrics, ExecutorService asyncExecution, ScheduledExecutorService delayedExecution, Object target) {
        this(new FaultToleranceMethodState(requestContext, requestTracing, metrics, asyncExecution, delayedExecution, new WeakReference<Object>(target)), null, null);
    }

    private FaultToleranceMethodContextImpl(FaultToleranceMethodState shared, InvocationContext context, FaultTolerancePolicy policy) {
        this.shared = shared;
        this.context = context;
        this.policy = policy;
        shared.lastUsed.accumulateAndGet(System.currentTimeMillis(), Long::max);
    }

    public boolean isExpired(long ttl) {
        return this.shared.isExpired(ttl);
    }

    public FaultToleranceMethodContextImpl in(InvocationContext context, FaultTolerancePolicy policy) {
        return new FaultToleranceMethodContextImpl(this.shared, context, policy);
    }

    @Override
    public Object proceed() throws Exception {
        try {
            int in = this.shared.executingThreadCount.incrementAndGet();
            if (this.policy.isBulkheadPresent() && in > this.policy.bulkhead.value) {
                logger.log(Level.WARNING, "Bulkhead appears to have been breached, now executing {0} for method {1}", new Object[]{in, this.context.getMethod()});
            }
            Object object = this.context.proceed();
            return object;
        }
        finally {
            this.shared.executingThreadCount.decrementAndGet();
        }
    }

    @Override
    public FaultToleranceMetrics getMetrics(boolean enabled) {
        return enabled ? this.shared.metrics : FaultToleranceMetrics.DISABLED;
    }

    @Override
    public CircuitBreakerState getState(int requestVolumeThreshold) {
        return requestVolumeThreshold < 0 ? this.shared.circuitBreakerState.get() : this.shared.circuitBreakerState.updateAndGet(value -> value != null ? value : new CircuitBreakerState(requestVolumeThreshold));
    }

    @Override
    public BlockingQueue<Thread> getConcurrentExecutions(int maxConcurrentThreads) {
        return maxConcurrentThreads < 0 ? this.shared.concurrentExecutions.get() : this.shared.concurrentExecutions.updateAndGet(value -> value != null ? value : new ArrayBlockingQueue(maxConcurrentThreads));
    }

    @Override
    public AtomicInteger getQueuingOrRunningPopulation() {
        return this.shared.queuingOrRunningPopulation;
    }

    @Override
    public void delay(long delayMillis) throws InterruptedException {
        if (delayMillis <= 0L) {
            return;
        }
        this.trace("delayRetry");
        try {
            Thread.sleep(delayMillis);
        }
        finally {
            this.endTrace();
        }
    }

    @Override
    public void runAsynchronous(CompletableFuture<Object> asyncResult, Callable<Object> task) throws RejectedExecutionException {
        Runnable completionTask = () -> {
            if (!asyncResult.isCancelled() && !Thread.currentThread().isInterrupted()) {
                try {
                    this.trace("runAsynchronous");
                    if (this.shared.requestContext != null) {
                        this.shared.requestContext.activate();
                    }
                    Future<?> futureResult = AsynchronousPolicy.toFuture(task.call());
                    if (!asyncResult.isCancelled()) {
                        if (!asyncResult.isDone()) {
                            asyncResult.complete(futureResult.get());
                        }
                    } else {
                        futureResult.cancel(true);
                    }
                }
                catch (Error | Exception ex) {
                    asyncResult.completeExceptionally(ex);
                }
                finally {
                    if (this.shared.requestContext != null) {
                        this.shared.requestContext.deactivate();
                    }
                    this.endTrace();
                }
            }
        };
        this.shared.asyncExecution.submit(completionTask);
    }

    @Override
    public Future<?> runDelayed(long delayMillis, Runnable task) throws Exception {
        return this.shared.delayedExecution.schedule(task, delayMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public Object fallbackHandle(Class<? extends FallbackHandler<?>> fallbackClass, Throwable ex) throws Exception {
        return ((FallbackHandler)CDI.current().select(fallbackClass, new Annotation[0]).get()).handle(new FaultToleranceExecutionContext(this.context.getMethod(), this.context.getParameters(), ex));
    }

    @Override
    public Object fallbackInvoke(Method fallbackMethod) throws Exception {
        try {
            fallbackMethod.setAccessible(true);
            return fallbackMethod.invoke(this.context.getTarget(), this.context.getParameters());
        }
        catch (InvocationTargetException e) {
            throw (Exception)e.getTargetException();
        }
        catch (IllegalAccessException e) {
            throw new FaultToleranceDefinitionException(e);
        }
    }

    @Override
    public void trace(String method) {
        this.shared.requestTracing.startSpan(new RequestTraceSpan(method), this.context);
    }

    @Override
    public void endTrace() {
        this.shared.requestTracing.endSpan();
    }

    static final class FaultToleranceMethodState {
        final RequestContextController requestContext;
        final FaultToleranceRequestTracing requestTracing;
        final FaultToleranceMetrics metrics;
        final ExecutorService asyncExecution;
        final ScheduledExecutorService delayedExecution;
        final WeakReference<Object> target;
        final AtomicReference<CircuitBreakerState> circuitBreakerState = new AtomicReference();
        final AtomicReference<BlockingQueue<Thread>> concurrentExecutions = new AtomicReference();
        final AtomicInteger queuingOrRunningPopulation = new AtomicInteger();
        final AtomicInteger executingThreadCount = new AtomicInteger();
        final AtomicLong lastUsed = new AtomicLong(System.currentTimeMillis());

        FaultToleranceMethodState(RequestContextController requestContext, FaultToleranceRequestTracing requestTracing, FaultToleranceMetrics metrics, ExecutorService asyncExecution, ScheduledExecutorService delayedExecution, WeakReference<Object> target) {
            this.requestContext = requestContext;
            this.requestTracing = requestTracing;
            this.metrics = metrics;
            this.asyncExecution = asyncExecution;
            this.delayedExecution = delayedExecution;
            this.target = target;
        }

        public boolean isExpired(long ttl) {
            if (this.target.get() == null) {
                return true;
            }
            return this.executingThreadCount.get() == 0 && this.queuingOrRunningPopulation.get() == 0 && this.lastUsed.get() + ttl < System.currentTimeMillis() && this.isStabilyClosedCuicuit();
        }

        private boolean isStabilyClosedCuicuit() {
            CircuitBreakerState state = this.circuitBreakerState.get();
            return state == null || state.getCircuitState() == CircuitBreakerState.CircuitState.CLOSED && state.isClosedOutcomeSuccessOnly();
        }
    }
}

