/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.faulttolerance.service;

import fish.payara.microprofile.faulttolerance.FaultToleranceConfig;
import fish.payara.microprofile.faulttolerance.FaultToleranceMethodContext;
import fish.payara.microprofile.faulttolerance.FaultToleranceMetrics;
import fish.payara.microprofile.faulttolerance.FaultToleranceService;
import fish.payara.microprofile.faulttolerance.FaultToleranceServiceConfiguration;
import fish.payara.microprofile.faulttolerance.policy.FaultTolerancePolicy;
import fish.payara.microprofile.faulttolerance.service.BindableFaultToleranceConfig;
import fish.payara.microprofile.faulttolerance.service.FaultToleranceMethodContextImpl;
import fish.payara.microprofile.faulttolerance.service.FaultToleranceRequestTracing;
import fish.payara.microprofile.faulttolerance.service.FaultToleranceUtils;
import fish.payara.microprofile.faulttolerance.service.MethodFaultToleranceMetrics;
import fish.payara.microprofile.faulttolerance.service.Stereotypes;
import fish.payara.microprofile.faulttolerance.state.CircuitBreakerState;
import fish.payara.microprofile.metrics.MetricsService;
import fish.payara.monitoring.collect.MonitoringData;
import fish.payara.monitoring.collect.MonitoringDataCollector;
import fish.payara.monitoring.collect.MonitoringDataSource;
import fish.payara.notification.requesttracing.RequestTraceSpan;
import fish.payara.nucleus.requesttracing.RequestTracingService;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.enterprise.context.control.RequestContextController;
import javax.inject.Inject;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.ContractsProvided;
import org.jvnet.hk2.annotations.Service;

@ContractsProvided(value={FaultToleranceService.class})
@Service(name="microprofile-fault-tolerance-service")
@RunLevel(value=10)
public class FaultToleranceServiceImpl
implements EventListener,
FaultToleranceService,
MonitoringDataSource,
FaultToleranceRequestTracing {
    private static final Logger logger = Logger.getLogger(FaultToleranceServiceImpl.class.getName());
    private InvocationManager invocationManager;
    private FaultToleranceServiceConfiguration config;
    @Inject
    private RequestTracingService requestTracingService;
    @Inject
    private ServiceLocator serviceLocator;
    @Inject
    private Events events;
    @Inject
    private MetricsService metricsService;
    private final ConcurrentMap<String, FaultToleranceMethodContextImpl> methodByTargetObjectAndName = new ConcurrentHashMap<String, FaultToleranceMethodContextImpl>();
    private final ConcurrentMap<String, BindableFaultToleranceConfig> configByApplication = new ConcurrentHashMap<String, BindableFaultToleranceConfig>();
    private ThreadPoolExecutor asyncExecutorService;
    private ScheduledExecutorService delayExecutorService;

    @PostConstruct
    public void postConstruct() {
        this.events.register((EventListener)this);
        this.invocationManager = (InvocationManager)this.serviceLocator.getService(InvocationManager.class, new Annotation[0]);
        this.requestTracingService = (RequestTracingService)this.serviceLocator.getService(RequestTracingService.class, new Annotation[0]);
        this.config = (FaultToleranceServiceConfiguration)this.serviceLocator.getService(FaultToleranceServiceConfiguration.class, new Annotation[0]);
        this.delayExecutorService = Executors.newScheduledThreadPool(this.getMaxDelayPoolSize());
        this.asyncExecutorService = new ThreadPoolExecutor(0, this.getMaxAsyncPoolSize(), this.getAsyncPoolKeepAliveInSeconds(), TimeUnit.SECONDS, new SynchronousQueue<Runnable>(true));
        int interval = this.getCleanupIntervalInMinutes();
        this.delayExecutorService.scheduleAtFixedRate(this::cleanMethodContexts, interval, interval, TimeUnit.MINUTES);
        if (this.config != null) {
            if (!"concurrent/__defaultManagedExecutorService".equals(this.config.getManagedExecutorService())) {
                logger.log(Level.WARNING, "Fault tolerance executor service was configured to managed executor service {0}. This option has been replaced by 'async-max-pool-size' to set the maximum size of a fixed Fault Tolerance pool.", this.config.getManagedExecutorService());
            }
            if (!"concurrent/__defaultManagedScheduledExecutorService".equals(this.config.getManagedScheduledExecutorService())) {
                logger.log(Level.WARNING, "Fault tolerance scheduled executor service was configured to managed scheduled executor service {0}. This option has been replaced by 'delay-max-pool-size' to set the maximum size of a fixed Fault Tolerance pool.", this.config.getManagedScheduledExecutorService());
            }
        }
    }

    private void cleanMethodContexts() {
        long ttl = TimeUnit.MINUTES.toMillis(1L);
        int cleaned = 0;
        for (String key : new HashSet(this.methodByTargetObjectAndName.keySet())) {
            try {
                FaultToleranceMethodContextImpl newValue = this.methodByTargetObjectAndName.compute(key, (k, methodContext) -> methodContext.isExpired(ttl) ? null : methodContext);
                if (newValue != null) continue;
                ++cleaned;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to clean FT method context for " + key, e);
            }
        }
        if (cleaned > 0) {
            String allClean = this.methodByTargetObjectAndName.isEmpty() ? ".All clean." : ".";
            logger.log(Level.INFO, "Cleaned {0} expired FT method contexts" + allClean, cleaned);
        }
    }

    private int getMaxDelayPoolSize() {
        return this.config == null ? 20 : Integer.parseInt(this.config.getDelayMaxPoolSize());
    }

    private int getMaxAsyncPoolSize() {
        return this.config == null ? 2000 : Integer.parseInt(this.config.getAsyncMaxPoolSize());
    }

    private int getAsyncPoolKeepAliveInSeconds() {
        return this.config == null ? 60 : Integer.parseInt(this.config.getAsyncPoolKeepAliveInSeconds());
    }

    private int getCleanupIntervalInMinutes() {
        return this.config == null ? 1 : Integer.parseInt(this.config.getCleanupIntervalInMinutes());
    }

    public void event(EventListener.Event<?> event) {
        if (event.is(Deployment.APPLICATION_UNLOADED)) {
            ApplicationInfo info = (ApplicationInfo)event.hook();
            this.deregisterApplication(info.getName());
            FaultTolerancePolicy.clean();
        } else if (event.is(EventTypes.SERVER_SHUTDOWN)) {
            if (this.asyncExecutorService != null) {
                this.asyncExecutorService.shutdownNow();
            }
            if (this.delayExecutorService != null) {
                this.delayExecutorService.shutdownNow();
            }
        }
    }

    @MonitoringData(ns="ft")
    public void collect(MonitoringDataCollector collector) {
        for (Map.Entry methodValue : this.methodByTargetObjectAndName.entrySet()) {
            String group = (String)methodValue.getKey();
            MonitoringDataCollector methodCollector = collector.group((CharSequence)group);
            FaultToleranceMethodContext context = (FaultToleranceMethodContext)methodValue.getValue();
            BlockingQueue<Thread> concurrentExecutions = context.getConcurrentExecutions(-1);
            if (concurrentExecutions != null) {
                FaultToleranceServiceImpl.collectBulkheadSemaphores(methodCollector, concurrentExecutions);
                FaultToleranceServiceImpl.collectBulkheadSemaphores(methodCollector, concurrentExecutions, context.getQueuingOrRunningPopulation());
            }
            FaultToleranceServiceImpl.collectCircuitBreakerState(methodCollector, context.getState(-1));
        }
    }

    private static void collectBulkheadSemaphores(MonitoringDataCollector collector, BlockingQueue<Thread> concurrentExecutions) {
        collector.collect((CharSequence)"RemainingConcurrentExecutionsCapacity", (long)concurrentExecutions.remainingCapacity()).collect((CharSequence)"ConcurrentExecutions", (long)concurrentExecutions.size());
    }

    private static void collectBulkheadSemaphores(MonitoringDataCollector collector, BlockingQueue<Thread> concurrentExecutions, AtomicInteger queuingOrRunningPopulation) {
        collector.collect((CharSequence)"WaitingQueuePopulation", (long)(queuingOrRunningPopulation.get() - concurrentExecutions.size()));
    }

    private static void collectCircuitBreakerState(MonitoringDataCollector collector, CircuitBreakerState state) {
        if (state == null) {
            return;
        }
        collector.collect((CharSequence)"circuitBreakerHalfOpenSuccessful", (long)state.getHalfOpenSuccessfulResultCounter()).collect((CharSequence)"circuitBreakerState", state.getCircuitState().name().charAt(0));
    }

    @Override
    public FaultToleranceConfig getConfig(InvocationContext context, Stereotypes stereotypes) {
        return this.configByApplication.computeIfAbsent(this.getApplicationContext(context), key -> new BindableFaultToleranceConfig(stereotypes)).bindTo(context);
    }

    private MetricRegistry getApplicationMetricRegistry() {
        try {
            return this.metricsService.getApplicationRegistry();
        }
        catch (Exception e) {
            return null;
        }
    }

    private void deregisterApplication(String applicationName) {
        this.configByApplication.remove(applicationName);
    }

    private String getApplicationContext(InvocationContext context) {
        ComponentInvocation currentInvocation = this.invocationManager.getCurrentInvocation();
        String appName = currentInvocation.getAppName();
        return appName != null ? appName : "common";
    }

    @Override
    public void startSpan(RequestTraceSpan span, InvocationContext context) {
        if (this.requestTracingService != null && this.requestTracingService.isRequestTracingEnabled()) {
            this.addGenericFaultToleranceRequestTracingDetails(span, context);
            this.requestTracingService.startTrace(span);
        }
    }

    @Override
    public void endSpan() {
        if (this.requestTracingService != null && this.requestTracingService.isRequestTracingEnabled()) {
            this.requestTracingService.endTrace();
        }
    }

    private void addGenericFaultToleranceRequestTracingDetails(RequestTraceSpan span, InvocationContext context) {
        ComponentInvocation currentInvocation = this.invocationManager.getCurrentInvocation();
        span.addSpanTag("App Name", currentInvocation.getAppName());
        span.addSpanTag("Component ID", currentInvocation.getComponentId());
        span.addSpanTag("Module Name", currentInvocation.getModuleName());
        span.addSpanTag("Class Name", context.getMethod().getDeclaringClass().getName());
        span.addSpanTag("Method Name", context.getMethod().getName());
    }

    @Override
    public FaultToleranceMethodContext getMethodContext(InvocationContext context, FaultTolerancePolicy policy, RequestContextController requestContextController) {
        FaultToleranceMethodContextImpl methodContext = this.methodByTargetObjectAndName.computeIfAbsent(FaultToleranceServiceImpl.getTargetMethodId(context), key -> this.createMethodContext((String)key, context, requestContextController));
        return methodContext.in(context, policy);
    }

    private FaultToleranceMethodContextImpl createMethodContext(String methodId, InvocationContext context, RequestContextController requestContextController) {
        MetricRegistry metricRegistry = this.getApplicationMetricRegistry();
        FaultToleranceMetrics metrics = metricRegistry == null ? FaultToleranceMetrics.DISABLED : new MethodFaultToleranceMetrics(metricRegistry, FaultToleranceUtils.getCanonicalMethodName(context));
        this.asyncExecutorService.setMaximumPoolSize(this.getMaxAsyncPoolSize());
        this.asyncExecutorService.setKeepAliveTime(this.getAsyncPoolKeepAliveInSeconds(), TimeUnit.SECONDS);
        logger.log(Level.INFO, "Creating FT method context for {0}", methodId);
        return new FaultToleranceMethodContextImpl(requestContextController, this, metrics, this.asyncExecutorService, this.delayExecutorService, context.getTarget());
    }

    private static String getTargetMethodId(InvocationContext context) {
        Object target = context.getTarget();
        Method method = context.getMethod();
        StringBuilder methodId = new StringBuilder();
        methodId.append(Integer.toHexString(System.identityHashCode(target))).append('@');
        methodId.append(target.getClass().getName()).append('.').append(method.getName());
        if (method.getParameterCount() > 0) {
            methodId.append('(');
            for (Class<?> param : method.getParameterTypes()) {
                methodId.append(param.getName()).append(' ');
            }
            methodId.append(')');
        }
        return methodId.toString();
    }
}

