/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.faulttolerance.service;

import fish.payara.microprofile.faulttolerance.FaultToleranceMetrics;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.LongSupplier;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;

final class MethodFaultToleranceMetrics
implements FaultToleranceMetrics {
    private final String canonicalMethodName;
    private final MetricRegistry registry;
    private final Map<String, Counter> countersByKeyPattern = new ConcurrentHashMap<String, Counter>();
    private final Map<String, Histogram> histogramsByKeyPattern = new ConcurrentHashMap<String, Histogram>();
    private final Map<String, Gauge<Long>> gaugesByKeyPattern = new ConcurrentHashMap<String, Gauge<Long>>();

    MethodFaultToleranceMetrics(MetricRegistry registry, String canonicalMethodName) {
        this.registry = registry;
        this.canonicalMethodName = canonicalMethodName;
    }

    @Override
    public void incrementCounter(String keyPattern) {
        this.countersByKeyPattern.computeIfAbsent(keyPattern, pattern -> this.registry.counter(this.metricName((String)pattern))).inc();
    }

    @Override
    public void addToHistogram(String keyPattern, long duration) {
        this.histogramsByKeyPattern.computeIfAbsent(keyPattern, pattern -> this.registry.histogram(this.metricName((String)pattern))).update(duration);
    }

    @Override
    public void linkGauge(String keyPattern, LongSupplier gauge) {
        this.gaugesByKeyPattern.computeIfAbsent(keyPattern, pattern -> {
            String metricName = this.metricName(keyPattern);
            Gauge newGauge = gauge::getAsLong;
            try {
                this.registry.register(metricName, (Metric)newGauge);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return newGauge;
        });
    }

    private String metricName(String keyPattern) {
        return String.format(keyPattern, this.canonicalMethodName);
    }
}

