/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.appserver.rest.endpoints;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;

public class RestEndpointModel {
    private String path;
    private String requestMethod;

    private RestEndpointModel(String path, String requestMethod) {
        this.path = path;
        this.requestMethod = requestMethod;
    }

    public static RestEndpointModel generateFromMethod(Method method) {
        String requestMethod = RestEndpointModel.getRequestMethodAnnotation(method);
        if (requestMethod == null) {
            return null;
        }
        Class<?> enclosingClass = method.getDeclaringClass();
        String parentPath = RestEndpointModel.getPathAnnotation(enclosingClass);
        String childPath = RestEndpointModel.getPathAnnotation(method);
        String path = parentPath + childPath;
        if (childPath.equals("/")) {
            path = parentPath;
        }
        return new RestEndpointModel(path, requestMethod);
    }

    private static String getPathAnnotation(AnnotatedElement element) {
        Path annotation = element.getAnnotation(Path.class);
        if (annotation == null || annotation.value().isEmpty()) {
            return "/";
        }
        return "/" + annotation.value().replaceAll("^/", "").replaceAll("/$", "");
    }

    private static String getRequestMethodAnnotation(AnnotatedElement element) {
        GET get = element.getAnnotation(GET.class);
        if (get != null) {
            return "GET";
        }
        POST post = element.getAnnotation(POST.class);
        if (post != null) {
            return "POST";
        }
        PUT put = element.getAnnotation(PUT.class);
        if (put != null) {
            return "PUT";
        }
        DELETE delete = element.getAnnotation(DELETE.class);
        if (delete != null) {
            return "DELETE";
        }
        HEAD head = element.getAnnotation(HEAD.class);
        if (head != null) {
            return "HEAD";
        }
        OPTIONS options = element.getAnnotation(OPTIONS.class);
        if (options != null) {
            return "OPTIONS";
        }
        PATCH patch = element.getAnnotation(PATCH.class);
        if (patch != null) {
            return "PATCH";
        }
        return null;
    }

    public String getPath() {
        return this.path;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }
}

