/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor;

import com.sun.enterprise.config.serverbeans.MonitoringService;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.StringUtils;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Singleton;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import org.glassfish.admin.monitor.FutureStatsProviders;
import org.glassfish.admin.monitor.MLogger;
import org.glassfish.admin.monitor.StatsProviderRegistry;
import org.glassfish.api.monitoring.ContainerMonitoring;
import org.glassfish.external.amx.AMXGlassfish;
import org.glassfish.external.amx.MBeanListener;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderInfo;
import org.glassfish.external.probe.provider.StatsProviderManagerDelegate;
import org.glassfish.external.statistics.Statistic;
import org.glassfish.external.statistics.annotations.Reset;
import org.glassfish.external.statistics.impl.StatisticImpl;
import org.glassfish.external.statistics.impl.StatsImpl;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.flashlight.client.ProbeClientMediator;
import org.glassfish.flashlight.client.ProbeClientMethodHandle;
import org.glassfish.flashlight.datatree.TreeNode;
import org.glassfish.flashlight.datatree.factory.TreeNodeFactory;
import org.glassfish.flashlight.provider.FlashlightProbe;
import org.glassfish.flashlight.provider.ProbeRegistry;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObjectManager;
import org.glassfish.gmbal.ManagedObjectManagerFactory;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Singleton
public class StatsProviderManagerDelegateImpl
extends MBeanListener.CallbackImpl
implements StatsProviderManagerDelegate {
    protected ProbeClientMediator pcm;
    MonitoringService monitoringService;
    private final MonitoringRuntimeDataRegistry mrdr;
    private final ProbeRegistry probeRegistry;
    private final String instanceName;
    private final TreeNode serverNode;
    private ObjectName monitoringServer;
    private final String parentPath;
    private boolean AMXReady = false;
    private final StatsProviderRegistry statsProviderRegistry;
    private static final Logger LOGGER = MLogger.getLogger();
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(StatsProviderManagerDelegateImpl.class);

    StatsProviderManagerDelegateImpl(ProbeClientMediator pcm, ProbeRegistry probeRegistry, MonitoringRuntimeDataRegistry mrdr, String iName, MonitoringService monitoringService) {
        this.pcm = pcm;
        this.mrdr = mrdr;
        this.instanceName = iName;
        this.monitoringService = monitoringService;
        this.probeRegistry = probeRegistry;
        this.serverNode = this.constructServerPP();
        this.statsProviderRegistry = new StatsProviderRegistry(mrdr);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, " In the ctor : instance name {0}", this.instanceName);
            LOGGER.log(Level.FINE, " In the ctor : MONITORING SERVER {0}", this.monitoringServer);
        }
        this.monitoringServer = AMXGlassfish.DEFAULT.serverMon(this.instanceName);
        String pp = this.monitoringServer.getKeyProperty("pp");
        String type = this.monitoringServer.getKeyProperty("type");
        String name = this.monitoringServer.getKeyProperty("name");
        this.parentPath = pp + File.separatorChar + type + "[" + name + "]";
    }

    public void register(String configElement, PluginPoint pp, String subTreePath, Object statsProvider) {
        this.register(configElement, pp, subTreePath, statsProvider, null);
    }

    public void register(String configElement, PluginPoint pp, String subTreePath, Object statsProvider, String invokerId) {
        StatsProviderInfo spInfo = new StatsProviderInfo(configElement, pp, subTreePath, statsProvider, invokerId);
        this.register(spInfo);
    }

    public void register(StatsProviderInfo spInfo) {
        try {
            this.tryToRegister(spInfo);
        }
        catch (RuntimeException rte) {
            LOGGER.log(Level.FINE, "NCLS-MNTG-00201", new Object[]{spInfo.getStatsProvider().getClass().getName()});
            LOGGER.log(Level.FINE, "Listener registration failed", rte);
            FutureStatsProviders.add(spInfo);
        }
    }

    void tryToRegister(StatsProviderInfo spInfo) {
        StatsProviderRegistry.StatsProviderRegistryElement spre;
        String configElement = spInfo.getConfigElement();
        Object statsProvider = spInfo.getStatsProvider();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("registering a statsProvider");
        }
        if (this.monitoringService != null && this.monitoringService.getContainerMonitoring(configElement) == null && this.monitoringService.getMonitoringLevel(configElement) == null) {
            this.createConfigElement(configElement);
        }
        if (this.getMonitoringEnabled() && this.getEnabledValue(configElement)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(" enabled is true ");
            }
            if ((spre = this.statsProviderRegistry.getStatsProviderRegistryElement(statsProvider)) == null) {
                this.statsProviderRegistry.registerStatsProvider(spInfo);
                spre = this.statsProviderRegistry.getStatsProviderRegistryElement(statsProvider);
            }
            if (spre.isEnableAllowed(this.getMonitoringLevel(configElement))) {
                this.enableStatsProvider(spre);
            }
        } else {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(" enabled is false ");
            }
            this.statsProviderRegistry.registerStatsProvider(spInfo);
            spre = this.statsProviderRegistry.getStatsProviderRegistryElement(statsProvider);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(spre.toString());
            LOGGER.fine("=========================================================");
        }
    }

    private void createConfigElement(final String configElement) {
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<MonitoringService>(){

                public Object run(MonitoringService param) throws PropertyVetoException, TransactionFailure {
                    ContainerMonitoring newItem = (ContainerMonitoring)param.createChild(ContainerMonitoring.class);
                    newItem.setName(configElement);
                    param.getContainerMonitoring().add(newItem);
                    return newItem;
                }
            }, (ConfigBeanProxy)this.monitoringService);
        }
        catch (TransactionFailure tf) {
            String msg = localStrings.getLocalString("NCLS-MNTG-00210", "Unable to create container-monitoring for", configElement);
            LOGGER.log(Level.SEVERE, msg, tf);
        }
    }

    public void unregister(Object statsProvider) {
        try {
            Collection<ProbeClientMethodHandle> handles;
            List nodeList;
            StatsProviderRegistry.StatsProviderRegistryElement spre = this.statsProviderRegistry.getStatsProviderRegistryElement(statsProvider);
            if (spre == null) {
                LOGGER.log(Level.INFO, "NCLS-MNTG-00202", new Object[]{statsProvider.getClass().getName()});
                return;
            }
            String parentNodePath = spre.getParentTreeNodePath();
            List<String> childNodeNames = spre.getChildTreeNodeNames();
            TreeNode rootNode = this.mrdr.get(this.instanceName);
            if (rootNode != null && parentNodePath != null && !(nodeList = rootNode.getNodes(parentNodePath, false, true)).isEmpty()) {
                TreeNode parentNode = (TreeNode)nodeList.get(0);
                Collection childNodes = parentNode.getChildNodes();
                for (TreeNode childNode : childNodes) {
                    if (!childNodeNames.contains(childNode.getName())) continue;
                    parentNode.removeChild(childNode);
                }
                if (!parentNode.hasChildNodes()) {
                    this.removeParentNode(parentNode);
                }
            }
            if ((handles = spre.getHandles()) != null) {
                for (ProbeClientMethodHandle handle : handles) {
                    handle.disable();
                }
            }
            if (spre.getManagedObjectManager() != null) {
                this.unregisterGmbal(spre);
            }
            this.statsProviderRegistry.unregisterStatsProvider(statsProvider);
        }
        catch (Exception ex) {
            String msg = MessageFormat.format("NCLS-MNTG-00208", statsProvider.getClass().getName());
            LOGGER.log(Level.SEVERE, msg, ex);
        }
    }

    private void removeParentNode(TreeNode parentNode) {
        TreeNode superParentNode = parentNode.getParent();
        if (superParentNode != null) {
            superParentNode.removeChild(parentNode);
            if (!superParentNode.hasChildNodes()) {
                this.removeParentNode(superParentNode);
            }
        }
    }

    public void updateAllStatsProviders() {
        for (String configElement : this.statsProviderRegistry.getConfigElementList()) {
            List<StatsProviderRegistry.StatsProviderRegistryElement> spreList = this.statsProviderRegistry.getStatsProviderRegistryElement(configElement);
            boolean isConfigEnabled = this.getEnabledValue(configElement);
            if (!isConfigEnabled) continue;
            for (StatsProviderRegistry.StatsProviderRegistryElement spre : spreList) {
                boolean isEnableAllowed = spre.isEnableAllowed(this.getMonitoringLevel(configElement));
                if (!isEnableAllowed) continue;
                this.enableStatsProvider(spre);
            }
        }
    }

    public void disableAllStatsProviders() {
        for (String configElement : this.statsProviderRegistry.getConfigElementList()) {
            List<StatsProviderRegistry.StatsProviderRegistryElement> spreList = this.statsProviderRegistry.getStatsProviderRegistryElement(configElement);
            for (StatsProviderRegistry.StatsProviderRegistryElement spre : spreList) {
                if (!spre.isEnabled) continue;
                this.disableStatsProvider(spre);
            }
        }
    }

    public void enableStatsProviders(String configElement) {
        List<StatsProviderRegistry.StatsProviderRegistryElement> spreList;
        if (!this.getMonitoringEnabled()) {
            return;
        }
        String configLevel = this.getMonitoringLevel(configElement);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Enabling all the statsProviders for - {0}", configElement);
        }
        if ((spreList = this.statsProviderRegistry.getStatsProviderRegistryElement(configElement)) == null) {
            return;
        }
        for (StatsProviderRegistry.StatsProviderRegistryElement spre : spreList) {
            boolean isEnableAllowed = spre.isEnableAllowed(configLevel);
            if (!spre.isEnabled()) {
                if (!isEnableAllowed) continue;
                this.enableStatsProvider(spre);
                continue;
            }
            if (isEnableAllowed) continue;
            this.disableStatsProvider(spre);
        }
    }

    public void disableStatsProviders(String configElement) {
        List<StatsProviderRegistry.StatsProviderRegistryElement> spreList;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Disabling all the statsProviders for - {0}", configElement);
        }
        if ((spreList = this.statsProviderRegistry.getStatsProviderRegistryElement(configElement)) == null) {
            return;
        }
        for (StatsProviderRegistry.StatsProviderRegistryElement spre : spreList) {
            if (!spre.isEnabled()) continue;
            this.disableStatsProvider(spre);
        }
    }

    public void setHandlesForStatsProviders(Object statsProvider, Collection<ProbeClientMethodHandle> handles) {
        StatsProviderRegistry.StatsProviderRegistryElement spre = this.statsProviderRegistry.getStatsProviderRegistryElement(statsProvider);
        spre.setHandles(handles);
    }

    private boolean getMonitoringEnabled() {
        return Boolean.parseBoolean(this.monitoringService.getMonitoringEnabled());
    }

    private void enableStatsProvider(StatsProviderRegistry.StatsProviderRegistryElement spre) {
        Object statsProvider = spre.getStatsProvider();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Enabling the statsProvider - {0}", statsProvider.getClass().getName());
        }
        if (spre.getParentTreeNodePath() == null) {
            PluginPoint pp = spre.getPluginPoint();
            String subTreePath = spre.getSubTreePath();
            TreeNode ppNode = this.getPluginPointNode(pp, this.serverNode);
            TreeNode parentNode = this.createSubTree(ppNode, subTreePath);
            List<String> childNodeNames = this.createTreeForStatsProvider(parentNode, statsProvider);
            spre.setParentTreeNodePath(parentNode.getCompletePathName());
            spre.setChildNodeNames(childNodeNames);
        } else {
            this.updateTreeNodes(spre, true);
        }
        this.resetStatistics(spre);
        if (spre.getHandles() == null) {
            Collection<ProbeClientMethodHandle> handles = this.registerStatsProviderToFlashlight(statsProvider);
            spre.setHandles(handles);
        } else {
            for (ProbeClientMethodHandle handle : spre.getHandles()) {
                if (handle.isEnabled()) continue;
                handle.enable();
            }
        }
        if (this.AMXReady && this.getMbeanEnabledValue()) {
            String subTreePath = spre.getSubTreePath();
            ManagedObjectManager mom = spre.getManagedObjectManager();
            if (mom == null) {
                mom = this.registerGmbal(statsProvider, subTreePath);
                spre.setManagedObjectManager(mom);
            }
        }
        spre.setEnabled(true);
    }

    private void disableStatsProvider(StatsProviderRegistry.StatsProviderRegistryElement spre) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Disabling the statsProvider - {0}", spre.getStatsProvider().getClass().getName());
        }
        this.updateTreeNodes(spre, false);
        for (ProbeClientMethodHandle handle : spre.getHandles()) {
            if (!handle.isEnabled()) continue;
            handle.disable();
        }
        this.unregisterGmbal(spre);
        spre.setEnabled(false);
    }

    public void registerAllGmbal() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Registering all the statsProviders whose enabled flag is 'on' with Gmbal");
        }
        for (StatsProviderRegistry.StatsProviderRegistryElement spre : this.statsProviderRegistry.getSpreList()) {
            ManagedObjectManager mom;
            if (!spre.isEnabled() || (mom = spre.getManagedObjectManager()) != null) continue;
            mom = this.registerGmbal(spre.getStatsProvider(), spre.getMBeanName());
            spre.setManagedObjectManager(mom);
        }
    }

    public void unregisterAllGmbal() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Unregistering all the statsProviders whose enabled flag is 'off' with Gmbal");
        }
        for (StatsProviderRegistry.StatsProviderRegistryElement spre : this.statsProviderRegistry.getSpreList()) {
            if (!spre.isEnabled()) continue;
            this.unregisterGmbal(spre);
        }
    }

    private void updateTreeNodes(StatsProviderRegistry.StatsProviderRegistryElement spre, boolean enable) {
        String parentNodePath = spre.getParentTreeNodePath();
        List<String> childNodeNames = spre.getChildTreeNodeNames();
        TreeNode rootNode = this.mrdr.get(this.instanceName);
        if (rootNode != null) {
            List nodeList = rootNode.getNodes(parentNodePath, false, true);
            if (nodeList.isEmpty()) {
                LOGGER.warning(String.format("MonitoringRuntimeData not found for %s. Unable to set to '%s'", parentNodePath, enable ? "Enabled" : "Disabled"));
                return;
            }
            TreeNode parentNode = (TreeNode)nodeList.get(0);
            Collection childNodes = parentNode.getChildNodes();
            boolean hasUpdatedNode = false;
            for (TreeNode childNode : childNodes) {
                if (!childNodeNames.contains(childNode.getName()) || childNode.isEnabled() == enable) continue;
                childNode.setEnabled(enable);
                hasUpdatedNode = true;
            }
            if (!hasUpdatedNode) {
                return;
            }
            if (enable) {
                this.enableTreeNode(parentNode);
            } else {
                this.disableTreeNode(parentNode);
            }
        }
    }

    private void enableTreeNode(TreeNode treeNode) {
        if (!treeNode.isEnabled()) {
            treeNode.setEnabled(true);
            if (treeNode.getParent() != null) {
                this.enableTreeNode(treeNode.getParent());
            }
        }
    }

    private void disableTreeNode(TreeNode treeNode) {
        if (treeNode.isEnabled()) {
            boolean isAnyChildEnabled = false;
            Collection childNodes = treeNode.getChildNodes();
            if (childNodes != null) {
                for (TreeNode childNode : childNodes) {
                    if (!childNode.isEnabled()) continue;
                    isAnyChildEnabled = true;
                    break;
                }
            }
            if (!isAnyChildEnabled) {
                treeNode.setEnabled(false);
                if (treeNode.getParent() != null) {
                    this.disableTreeNode(treeNode.getParent());
                }
            }
        }
    }

    private void resetStatistics(StatsProviderRegistry.StatsProviderRegistryElement spre) {
        if (spre.getResetMethod() == null) {
            String parentNodePath = spre.getParentTreeNodePath();
            List<String> childNodeNames = spre.getChildTreeNodeNames();
            String statsProviderName = spre.getStatsProvider().getClass().getName();
            this.resetChildNodeStatistics(parentNodePath, childNodeNames, statsProviderName);
        } else {
            this.invokeStatsProviderResetMethod(spre.getResetMethod(), spre.getStatsProvider());
        }
    }

    private void resetChildNodeStatistics(String parentNodePath, List<String> childNodeNames, String statsProviderName) {
        TreeNode rootNode = this.mrdr.get(this.instanceName);
        if (rootNode != null) {
            List nodeList = rootNode.getNodes(parentNodePath, false, true);
            if (!nodeList.isEmpty()) {
                TreeNode parentNode = (TreeNode)nodeList.get(0);
                Collection childNodes = parentNode.getChildNodes();
                for (TreeNode childNode : childNodes) {
                    if (!childNodeNames.contains(childNode.getName())) continue;
                    this.invokeStatisticResetMethod(childNode.getValue());
                }
            } else {
                LOGGER.log(Level.WARNING, "NCLS-MNTG-00203", new Object[]{parentNodePath, statsProviderName});
            }
        }
    }

    private void invokeStatisticResetMethod(Object value) {
        if (value instanceof Statistic) {
            if (Proxy.isProxyClass(value.getClass())) {
                ((StatisticImpl)Proxy.getInvocationHandler(value)).reset();
            } else {
                ((StatisticImpl)value).reset();
            }
        } else if (value instanceof StatsImpl) {
            ((StatsImpl)value).reset();
        }
    }

    private void invokeStatsProviderResetMethod(Method m, Object statsProvider) {
        if (m != null) {
            Exception gotOne = null;
            try {
                m.invoke(statsProvider, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                gotOne = ex;
            }
            if (gotOne != null) {
                String msg = MessageFormat.format("NCLS-MNTG-00209", statsProvider.getClass().getName());
                LOGGER.log(Level.SEVERE, msg, gotOne);
            }
        }
    }

    private List<String> createTreeForStatsProvider(TreeNode parentNode, Object statsProvider) {
        ArrayList<String> childNodeNames = new ArrayList<String>();
        for (Method m : statsProvider.getClass().getMethods()) {
            String methodNameLower;
            ManagedAttribute ma = m.getAnnotation(ManagedAttribute.class);
            Reset resetMeth = m.getAnnotation(Reset.class);
            if (resetMeth != null) {
                StatsProviderRegistry.StatsProviderRegistryElement spre = this.statsProviderRegistry.getStatsProviderRegistryElement(statsProvider);
                spre.setResetMethod(m);
            }
            if (ma == null) continue;
            String methodName = m.getName();
            String id = ma.id();
            if (id.isEmpty() && (methodNameLower = methodName.toLowerCase(Locale.ENGLISH)).startsWith("get") && methodNameLower.length() > 3) {
                id = methodNameLower.substring(3);
            }
            TreeNode attrNode = TreeNodeFactory.createMethodInvoker(id, statsProvider, id, m);
            parentNode.addChild(attrNode);
            childNodeNames.add(attrNode.getName());
        }
        return childNodeNames;
    }

    private Collection<ProbeClientMethodHandle> registerStatsProviderToFlashlight(Object statsProvider) {
        LOGGER.log(Level.FINEST, "****** Registering the StatsProvider ({0}) with flashlight", statsProvider.getClass().getName());
        StatsProviderRegistry.StatsProviderRegistryElement spre = this.statsProviderRegistry.getStatsProviderRegistryElement(statsProvider);
        Collection handles = spre != null ? this.pcm.registerListener(statsProvider, spre.getInvokerId()) : this.pcm.registerListener(statsProvider);
        LOGGER.log(Level.FINEST, "********* handles = {0}", handles);
        return handles;
    }

    private TreeNode createSubTree(TreeNode parent, String subTreePath) {
        StringTokenizer st = new StringTokenizer(subTreePath, "/");
        TreeNode parentNode = parent;
        this.enableTreeNode(parentNode);
        while (st.hasMoreTokens()) {
            parentNode = this.createSubTreeNode(parentNode, st.nextToken());
        }
        return parentNode;
    }

    private TreeNode createSubTreeNode(TreeNode parent, String child) {
        TreeNode childNode = parent.getChild(child);
        if (childNode == null) {
            childNode = TreeNodeFactory.createTreeNode(child, null, child);
            parent.addChild(childNode);
        } else {
            this.enableTreeNode(childNode);
        }
        return childNode;
    }

    public boolean hasListeners(String probeStr) {
        FlashlightProbe probe = this.probeRegistry.getProbe(probeStr);
        if (probe != null) {
            return probe.isEnabled();
        }
        return false;
    }

    public void mbeanRegistered(ObjectName objectName, MBeanListener listener) {
        super.mbeanRegistered(objectName, listener);
        this.AMXReady = true;
        this.statsProviderRegistry.setAMXReady(true);
        if (this.getMbeanEnabledValue()) {
            for (StatsProviderRegistry.StatsProviderRegistryElement spre : this.statsProviderRegistry.getSpreList()) {
                ManagedObjectManager mom;
                if (!spre.isEnabled() || (mom = spre.getManagedObjectManager()) != null) continue;
                mom = this.registerGmbal(spre.getStatsProvider(), spre.getMBeanName());
                spre.setManagedObjectManager(mom);
            }
        }
    }

    StatsProviderRegistry getStatsProviderRegistry() {
        return this.statsProviderRegistry;
    }

    private ManagedObjectManager registerGmbal(Object statsProvider, String mbeanName) {
        ManagedObjectManager mom;
        try {
            mom = ManagedObjectManagerFactory.createFederated((ObjectName)this.monitoringServer);
            if (mom != null) {
                mom.setJMXRegistrationDebug(false);
                if (mom.isManagedObject(statsProvider)) {
                    mom.stripPackagePrefix();
                    if (mbeanName != null && !mbeanName.isEmpty()) {
                        if (mbeanName.indexOf(92) > 0) {
                            mbeanName = StringUtils.removeChar(mbeanName, '\\');
                        }
                        mbeanName = mbeanName.replaceAll("___SLASH___", "/");
                        mom.createRoot(statsProvider, mbeanName);
                    } else {
                        mom.createRoot(statsProvider);
                    }
                } else {
                    String spName = statsProvider.getClass().getName();
                    LOGGER.log(Level.INFO, "NCLS-MNTG-00204", new Object[]{spName});
                }
            }
        }
        catch (IllegalArgumentException ex) {
            if (ex.getCause().getCause() instanceof InstanceAlreadyExistsException) {
                mom = null;
                LOGGER.log(Level.INFO, "Could not register MBean - MBean already exists: {0}", ex.getCause().getCause().getMessage());
            } else {
                mom = null;
                LOGGER.log(Level.SEVERE, "NCLS-MNTG-00205", ex);
            }
        }
        catch (Exception e) {
            mom = null;
            LOGGER.log(Level.SEVERE, "NCLS-MNTG-00205", e);
        }
        return mom;
    }

    private void unregisterGmbal(StatsProviderRegistry.StatsProviderRegistryElement spre) {
        ManagedObjectManager mom = spre.getManagedObjectManager();
        if (mom != null) {
            mom.unregister(spre.getStatsProvider());
            try {
                mom.close();
            }
            catch (IOException ioe) {
                LOGGER.log(Level.SEVERE, "NCLS-MNTG-00206", ioe);
            }
            spre.setManagedObjectManager(null);
        }
    }

    private TreeNode getPluginPointNode(PluginPoint pp, TreeNode serverNode) {
        if (pp == PluginPoint.APPLICATIONS) {
            return this.createSubTree(serverNode, "applications");
        }
        return serverNode;
    }

    private TreeNode constructServerPP() {
        TreeNode srvrNode = this.mrdr.get(this.instanceName);
        if (srvrNode != null) {
            return srvrNode;
        }
        srvrNode = TreeNodeFactory.createTreeNode(this.instanceName, null, this.instanceName);
        srvrNode.setEnabled(false);
        this.mrdr.add(this.instanceName, srvrNode);
        return srvrNode;
    }

    boolean getEnabledValue(String configElement) {
        boolean enabled = true;
        String level = this.getMonitoringLevel(configElement);
        if (level != null) {
            if (level.equals("OFF")) {
                enabled = false;
            }
        } else {
            LOGGER.log(Level.WARNING, "NCLS-MNTG-00207", new Object[]{configElement});
        }
        return enabled;
    }

    private String getMonitoringLevel(String configElement) {
        return this.monitoringService.getMonitoringLevel(configElement);
    }

    private boolean getMbeanEnabledValue() {
        return Boolean.parseBoolean(this.monitoringService.getMbeanEnabled());
    }

    public boolean isStatsProviderRegistered(Object statsProvider, String subTreePath) {
        boolean isStatsProviderRegistered = false;
        Collection<StatsProviderRegistry.StatsProviderRegistryElement> spreList = this.statsProviderRegistry.getSpreList();
        for (StatsProviderRegistry.StatsProviderRegistryElement spre : spreList) {
            if (!spre.getStatsProvider().equals(statsProvider) || !spre.getMBeanName().equals(subTreePath)) continue;
            isStatsProviderRegistered = true;
            break;
        }
        return isStatsProviderRegistered;
    }

    public ObjectName getObjectName(Object statsProvider, String subTreePath) {
        String typeValue = this.getTypeValue(statsProvider);
        String nameValue = this.getNameValue(subTreePath);
        return AMXGlassfish.DEFAULT.newObjectName(this.parentPath, typeValue, nameValue);
    }

    public String getTypeValue(Object statsProvider) {
        String type = null;
        AMXMetadata am = statsProvider.getClass().getAnnotation(AMXMetadata.class);
        if (am != null) {
            type = am.type();
        }
        if (type == null) {
            type = statsProvider.getClass().getSimpleName();
        }
        return type;
    }

    public String getNameValue(String subTreePath) {
        return subTreePath;
    }
}

