/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.micro.cdi.extension.cluster;

import com.hazelcast.core.IAtomicLong;
import fish.payara.cluster.Clustered;
import fish.payara.cluster.DistributedLockType;
import fish.payara.micro.cdi.extension.cluster.ClusterScopeContext;
import fish.payara.micro.cdi.extension.cluster.ClusteredSingletonLookupImpl;
import fish.payara.micro.cdi.extension.cluster.annotations.ClusterScoped;
import fish.payara.micro.cdi.extension.cluster.annotations.ClusterScopedIntercepted;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Priority;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.internal.api.Globals;

@Interceptor
@ClusterScopedIntercepted
@Priority(value=4000)
public class ClusterScopedInterceptor
implements Serializable {
    private final BeanManager beanManager = CDI.current().getBeanManager();
    private transient ClusteredSingletonLookupImpl clusteredLookup;
    private static final long serialVersionUID = 1L;

    public ClusterScopedInterceptor() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object lockAndRefresh(InvocationContext invocationContext) throws Exception {
        Class<?> beanClass = invocationContext.getMethod().getDeclaringClass();
        Clustered clusteredAnnotation = ClusterScopeContext.getAnnotation(this.beanManager, beanClass);
        try {
            this.lock(beanClass, clusteredAnnotation);
            Object object = invocationContext.proceed();
            return object;
        }
        finally {
            this.refresh(beanClass);
            this.unlock(beanClass, clusteredAnnotation);
        }
    }

    @PostConstruct
    Object postConstruct(InvocationContext invocationContext) throws Exception {
        Class<?> beanClass = invocationContext.getTarget().getClass().getSuperclass();
        this.clusteredLookup.setClusteredSessionKey(beanClass);
        this.clusteredLookup.getClusteredUsageCount().incrementAndGet();
        return invocationContext.proceed();
    }

    @PreDestroy
    Object preDestroy(InvocationContext invocationContext) throws Exception {
        Class<?> beanClass = invocationContext.getTarget().getClass().getSuperclass();
        Clustered clusteredAnnotation = ClusterScopeContext.getAnnotation(this.beanManager, beanClass);
        this.clusteredLookup.setClusteredSessionKey(beanClass);
        IAtomicLong count = this.clusteredLookup.getClusteredUsageCount();
        if (count.decrementAndGet() <= 0L) {
            this.clusteredLookup.getClusteredSingletonMap().delete((Object)this.clusteredLookup.getClusteredSessionKey());
            count.destroy();
        } else if (!clusteredAnnotation.callPreDestoyOnDetach()) {
            return null;
        }
        return invocationContext.proceed();
    }

    private void lock(Class<?> beanClass, Clustered clusteredAnnotation) {
        if (clusteredAnnotation.lock() == DistributedLockType.LOCK) {
            this.clusteredLookup.setClusteredSessionKey(beanClass);
            this.clusteredLookup.getDistributedLock().lock();
        }
    }

    private void unlock(Class<?> beanClass, Clustered clusteredAnnotation) {
        if (clusteredAnnotation.lock() == DistributedLockType.LOCK) {
            this.clusteredLookup.setClusteredSessionKey(beanClass);
            this.clusteredLookup.getDistributedLock().unlock();
        }
    }

    private void refresh(Class<?> beanClass) {
        Set managedBeans = this.beanManager.getBeans(beanClass, new Annotation[0]);
        if (managedBeans.size() > 1) {
            throw new IllegalArgumentException("Multiple beans found for " + beanClass);
        }
        Bean bean = (Bean)managedBeans.iterator().next();
        String beanName = ClusterScopeContext.getBeanName(bean, ClusterScopeContext.getAnnotation(this.beanManager, bean));
        Context ctx = this.beanManager.getContext(ClusterScoped.class);
        this.clusteredLookup.getClusteredSingletonMap().put((Object)beanName, ctx.get((Contextual)bean));
    }

    private void init() {
        String moduleName = ((InvocationManager)Globals.getDefaultHabitat().getService(InvocationManager.class, new Annotation[0])).getCurrentInvocation().getAppName();
        this.clusteredLookup = new ClusteredSingletonLookupImpl(this.beanManager, moduleName);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }
}

