/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.micro.cdi.extension.cluster;

import com.sun.enterprise.container.common.impl.util.ClusteredSingletonLookupImplBase;
import com.sun.enterprise.container.common.spi.ClusteredSingletonLookup;
import fish.payara.micro.cdi.extension.cluster.ClusterScopeContext;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;

public class ClusteredSingletonLookupImpl
extends ClusteredSingletonLookupImplBase {
    private final BeanManager beanManager;
    private final ThreadLocal<String> sessionKey = new ThreadLocal();

    public ClusteredSingletonLookupImpl(BeanManager beanManager, String componentId) {
        super(componentId, ClusteredSingletonLookup.SingletonType.CDI);
        this.beanManager = beanManager;
    }

    public String getClusteredSessionKey() {
        return this.sessionKey.get();
    }

    void setClusteredSessionKey(Class<?> beanClass) {
        Set managedBeans = this.beanManager.getBeans(beanClass, new Annotation[0]);
        if (managedBeans.size() > 1) {
            throw new IllegalArgumentException("Multiple beans found for " + beanClass);
        }
        if (managedBeans.size() == 1) {
            Bean bean = (Bean)managedBeans.iterator().next();
            this.sessionKey.set(ClusterScopeContext.getBeanName(bean, ClusterScopeContext.getAnnotation(this.beanManager, bean)));
            this.invalidateKeys();
        }
    }
}

