/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl;

import com.sun.enterprise.v3.server.ApplicationLifecycle;
import com.sun.enterprise.v3.services.impl.GrizzlyService;
import fish.payara.microprofile.openapi.api.OpenAPIBuildException;
import fish.payara.microprofile.openapi.impl.admin.OpenApiServiceConfiguration;
import fish.payara.microprofile.openapi.impl.config.OpenApiConfiguration;
import fish.payara.microprofile.openapi.impl.model.OpenAPIImpl;
import fish.payara.microprofile.openapi.impl.processor.ApplicationProcessor;
import fish.payara.microprofile.openapi.impl.processor.BaseProcessor;
import fish.payara.microprofile.openapi.impl.processor.FileProcessor;
import fish.payara.microprofile.openapi.impl.processor.FilterProcessor;
import fish.payara.microprofile.openapi.impl.processor.ModelReaderProcessor;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.classmodel.reflect.Parser;
import org.glassfish.hk2.classmodel.reflect.Type;
import org.glassfish.hk2.classmodel.reflect.Types;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.analysis.StructuredDeploymentTracing;
import org.glassfish.web.deployment.descriptor.WebBundleDescriptorImpl;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service(name="microprofile-openapi-service")
@RunLevel(value=10)
public class OpenApiService
implements PostConstruct,
PreDestroy,
EventListener,
ConfigListener {
    private static final Logger LOGGER = Logger.getLogger(OpenApiService.class.getName());
    private OpenAPI allDocuments;
    private Deque<OpenApiMapping> mappings;
    @Inject
    private Events events;
    @Inject
    private OpenApiServiceConfiguration config;
    @Inject
    private ServerEnvironment environment;
    @Inject
    private ServiceLocator habitat;
    @Inject
    private ApplicationLifecycle applicationLifecycle;

    public void postConstruct() {
        this.mappings = new ConcurrentLinkedDeque<OpenApiMapping>();
        this.events.register((EventListener)this);
    }

    public void preDestroy() {
        this.events.unregister((EventListener)this);
    }

    public boolean isEnabled() {
        return Boolean.parseBoolean(this.config.getEnabled());
    }

    public boolean isSecurityEnabled() {
        return Boolean.parseBoolean(this.config.getSecurityEnabled());
    }

    public boolean withCorsHeaders() {
        return Boolean.parseBoolean(this.config.getCorsHeaders());
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] event) {
        return ConfigSupport.sortAndDispatch((PropertyChangeEvent[])event, (Changed)new Changed(){

            public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type, Class<T> tClass, T t) {
                if (tClass == OpenApiServiceConfiguration.class && type == Changed.TYPE.CHANGE) {
                    if (OpenApiService.this.isEnabled()) {
                        LOGGER.info("OpenAPIService enabled.");
                    } else {
                        LOGGER.info("OpenAPIService disabled.");
                    }
                }
                return null;
            }
        }, (Logger)LOGGER);
    }

    public void event(EventListener.Event<?> event) {
        block3: {
            block2: {
                if (!event.is(Deployment.APPLICATION_STARTED)) break block2;
                ApplicationInfo appInfo = (ApplicationInfo)event.hook();
                if (!OpenApiService.isValidApp(appInfo)) break block3;
                OpenApiMapping mapping = new OpenApiMapping(appInfo);
                this.mappings.add(mapping);
                this.allDocuments = null;
                break block3;
            }
            if (event.is(Deployment.APPLICATION_UNLOADED)) {
                ApplicationInfo appInfo = (ApplicationInfo)event.hook();
                for (OpenApiMapping mapping : this.mappings) {
                    if (!mapping.getAppInfo().equals(appInfo)) continue;
                    this.mappings.remove(mapping);
                    this.allDocuments = null;
                    break;
                }
            }
        }
    }

    public OpenAPI getDocument() throws OpenAPIBuildException, IOException {
        if (this.mappings.isEmpty() || !this.isEnabled()) {
            return null;
        }
        if (this.mappings.size() == 1) {
            OpenAPI document = this.mappings.peekLast().getDocument();
            if (document == null) {
                document = this.mappings.peekLast().buildDocument();
            }
            return document;
        }
        ArrayList<OpenAPI> docs = new ArrayList<OpenAPI>();
        for (OpenApiMapping mapping : this.mappings) {
            if (mapping.getDocument() == null) {
                this.allDocuments = null;
                mapping.buildDocument();
            }
            docs.add(mapping.getDocument());
        }
        if (this.allDocuments == null) {
            this.allDocuments = new OpenAPIImpl();
            OpenAPIImpl.merge(this.allDocuments, docs, true);
        }
        return this.allDocuments;
    }

    public static OpenApiService getInstance() {
        return (OpenApiService)Globals.getStaticBaseServiceLocator().getService(OpenApiService.class, new Annotation[0]);
    }

    private static boolean isValidApp(ApplicationInfo appInfo) {
        return appInfo.getMetaData(WebBundleDescriptorImpl.class) != null && !appInfo.getSource().getURI().getPath().contains("glassfish/lib/install") && !appInfo.getSource().getURI().getPath().contains("h2db/bin") && !appInfo.getSource().getURI().getPath().contains("mq/lib");
    }

    private static String getContextRoot(ApplicationInfo appInfo) {
        return ((WebBundleDescriptorImpl)appInfo.getMetaData(WebBundleDescriptorImpl.class)).getContextRoot();
    }

    private Set<Type> filterTypes(ApplicationInfo appInfo, OpenApiConfiguration config, Types hk2Types) {
        ReadableArchive archive = appInfo.getSource();
        HashSet<Type> types = new HashSet<Type>(this.filterLibTypes(config, hk2Types, archive));
        types.addAll(Collections.list(archive.entries()).stream().filter(clazz -> clazz.endsWith(".class")).map(clazz -> clazz.replaceAll("WEB-INF/classes/", "").replace("/", ".").replace(".class", "")).map(clazz -> hk2Types.getBy(clazz)).filter(Objects::nonNull).collect(Collectors.toSet()));
        return config == null ? types : config.getValidClasses(types);
    }

    private Set<Type> filterLibTypes(OpenApiConfiguration config, Types hk2Types, ReadableArchive archive) {
        HashSet<Type> types = new HashSet<Type>();
        if (config != null && config.getScanLib()) {
            Enumeration subArchiveItr = archive.entries();
            while (subArchiveItr.hasMoreElements()) {
                String subArchiveName = (String)subArchiveItr.nextElement();
                if (!subArchiveName.startsWith("WEB-INF/lib/") || !subArchiveName.endsWith(".jar")) continue;
                try {
                    ReadableArchive subArchive = archive.getSubArchive(subArchiveName);
                    types.addAll(Collections.list(subArchive.entries()).stream().filter(clazz -> clazz.endsWith(".class")).map(clazz -> clazz.replace("/", ".").replace(".class", "")).map(clazz -> hk2Types.getBy(clazz)).filter(Objects::nonNull).collect(Collectors.toSet()));
                }
                catch (IOException ex) {
                    throw new IllegalStateException(ex);
                }
            }
        }
        return types;
    }

    private List<URL> getServerURL(String contextRoot) {
        String hostName;
        ArrayList<URL> result = new ArrayList<URL>();
        ServerContext context = (ServerContext)Globals.get(ServerContext.class);
        try {
            hostName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException ex) {
            hostName = "localhost";
        }
        String instanceType = this.environment.getRuntimeType().toString();
        ArrayList httpPorts = new ArrayList();
        ArrayList httpsPorts = new ArrayList();
        List networkListeners = context.getConfigBean().getConfig().getNetworkConfig().getNetworkListeners().getNetworkListener();
        String adminListener = context.getConfigBean().getConfig().getAdminListener().getName();
        networkListeners.stream().filter(networkListener -> Boolean.parseBoolean(networkListener.getEnabled())).forEach(networkListener -> {
            List ports;
            int port;
            try {
                port = ((GrizzlyService)this.habitat.getService(GrizzlyService.class, new Annotation[0])).getRealPort(networkListener);
            }
            catch (MultiException ex) {
                LOGGER.log(Level.WARNING, "Failed to get running Grizzly listener.", ex);
                port = Integer.parseInt(networkListener.getPort());
            }
            boolean securityEnabled = Boolean.parseBoolean(networkListener.findProtocol().getSecurityEnabled());
            List list = ports = securityEnabled ? httpsPorts : httpPorts;
            if (!networkListener.getName().equals(adminListener)) {
                ports.add(port);
            } else if (instanceType.equals("MICRO")) {
                ports.add(port);
            }
        });
        for (Integer httpPort : httpPorts) {
            try {
                result.add(new URL("http", hostName, httpPort, contextRoot));
            }
            catch (MalformedURLException malformedURLException) {}
        }
        for (Integer httpsPort : httpsPorts) {
            try {
                result.add(new URL("https", hostName, httpsPort, contextRoot));
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return result;
    }

    private class OpenApiMapping {
        private final ApplicationInfo appInfo;
        private final OpenApiConfiguration appConfig;
        private volatile OpenAPI document;

        OpenApiMapping(ApplicationInfo appInfo) {
            this.appInfo = appInfo;
            this.appConfig = new OpenApiConfiguration(appInfo.getAppClassLoader());
        }

        ApplicationInfo getAppInfo() {
            return this.appInfo;
        }

        private OpenAPI getDocument() throws OpenAPIBuildException {
            return this.document;
        }

        private synchronized OpenAPI buildDocument() throws OpenAPIBuildException, IOException {
            if (this.document != null) {
                return this.document;
            }
            Parser parser = OpenApiService.this.applicationLifecycle.getDeployableParser(this.appInfo.getSource(), true, true, StructuredDeploymentTracing.create((String)this.appInfo.getName()), LOGGER);
            Types types = parser.getContext().getTypes();
            OpenAPI doc = new OpenAPIImpl();
            try {
                String contextRoot = OpenApiService.getContextRoot(this.appInfo);
                List baseURLs = OpenApiService.this.getServerURL(contextRoot);
                doc = new ModelReaderProcessor().process(doc, this.appConfig);
                doc = new FileProcessor(this.appInfo.getAppClassLoader()).process(doc, this.appConfig);
                doc = new ApplicationProcessor(types, OpenApiService.this.filterTypes(this.appInfo, this.appConfig, types), this.appInfo.getAppClassLoader()).process(doc, this.appConfig);
                doc = new BaseProcessor(baseURLs).process(doc, this.appConfig);
                doc = new FilterProcessor().process(doc, this.appConfig);
            }
            catch (Throwable t) {
                throw new OpenAPIBuildException(t);
            }
            finally {
                this.document = doc;
            }
            LOGGER.info("OpenAPI document created.");
            return this.document;
        }
    }
}

