/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.admin;

import com.sun.enterprise.util.ColumnFormatter;
import fish.payara.microprofile.openapi.impl.admin.OpenApiServiceConfiguration;
import java.util.HashMap;
import java.util.Properties;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@Service(name="get-openapi-configuration")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.DEPLOYMENT_GROUP, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=OpenApiServiceConfiguration.class, opType=RestEndpoint.OpType.GET, path="get-openapi-configuration", description="Gets the OpenAPI Configuration")})
public class GetOpenApiConfigurationCommand
implements AdminCommand {
    private final String[] OUTPUT_HEADERS = new String[]{"Enabled", "VirtualServers", "CorsHeaders", "Security Enabled", "Roles"};
    @Inject
    private Target targetUtil;
    @Param(optional=true, defaultValue="server-config")
    private String target;

    public void execute(AdminCommandContext context) {
        ActionReport actionReport = context.getActionReport();
        if (this.targetUtil.getConfig(this.target) == null) {
            actionReport.setMessage("No such config name: " + this.targetUtil);
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        OpenApiServiceConfiguration openApiConfig = (OpenApiServiceConfiguration)this.targetUtil.getConfig(this.target).getExtensionByType(OpenApiServiceConfiguration.class);
        ColumnFormatter columnFormatter = new ColumnFormatter(this.OUTPUT_HEADERS);
        Object[] outputValues = new Object[]{openApiConfig.getEnabled(), openApiConfig.getVirtualServers(), openApiConfig.getCorsHeaders(), openApiConfig.getSecurityEnabled(), openApiConfig.getRoles()};
        columnFormatter.addRow(outputValues);
        actionReport.appendMessage(columnFormatter.toString());
        HashMap<String, String> extraPropertiesMap = new HashMap<String, String>();
        extraPropertiesMap.put("enabled", openApiConfig.getEnabled());
        extraPropertiesMap.put("virtualServers", openApiConfig.getVirtualServers());
        extraPropertiesMap.put("corsHeaders", openApiConfig.getCorsHeaders());
        extraPropertiesMap.put("securityenabled", openApiConfig.getSecurityEnabled());
        extraPropertiesMap.put("roles", openApiConfig.getRoles());
        Properties extraProperties = new Properties();
        extraProperties.put("openApiConfiguration", extraPropertiesMap);
        actionReport.setExtraProperties(extraProperties);
    }
}

