/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.model;

import fish.payara.microprofile.openapi.api.visitor.ApiContext;
import fish.payara.microprofile.openapi.impl.model.ComponentsImpl;
import fish.payara.microprofile.openapi.impl.model.ExtensibleImpl;
import fish.payara.microprofile.openapi.impl.model.ExternalDocumentationImpl;
import fish.payara.microprofile.openapi.impl.model.PathsImpl;
import fish.payara.microprofile.openapi.impl.model.info.InfoImpl;
import fish.payara.microprofile.openapi.impl.model.security.SecurityRequirementImpl;
import fish.payara.microprofile.openapi.impl.model.servers.ServerImpl;
import fish.payara.microprofile.openapi.impl.model.tags.TagImpl;
import fish.payara.microprofile.openapi.impl.model.util.ModelUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.eclipse.microprofile.openapi.models.tags.Tag;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;

public class OpenAPIImpl
extends ExtensibleImpl<OpenAPI>
implements OpenAPI {
    protected String openapi;
    protected Info info;
    protected ExternalDocumentation externalDocs;
    protected List<Server> servers = new ArrayList<Server>();
    protected List<SecurityRequirement> security = new ArrayList<SecurityRequirement>();
    protected List<Tag> tags = new ArrayList<Tag>();
    protected Paths paths = new PathsImpl();
    protected Components components = new ComponentsImpl();
    private ApiContext context;

    public static OpenAPI createInstance(AnnotationModel annotation, ApiContext context) {
        AnnotationModel externalDocs;
        OpenAPIImpl from = new OpenAPIImpl();
        from.context = context;
        AnnotationModel info = (AnnotationModel)annotation.getValue("info", AnnotationModel.class);
        if (info != null) {
            from.setInfo(InfoImpl.createInstance(info));
        }
        if ((externalDocs = (AnnotationModel)annotation.getValue("externalDocs", AnnotationModel.class)) != null) {
            from.setExternalDocs(ExternalDocumentationImpl.createInstance(externalDocs));
        }
        ModelUtils.extractAnnotations(annotation, context, "security", SecurityRequirementImpl::createInstance, from.getSecurity());
        ModelUtils.extractAnnotations(annotation, context, "servers", ServerImpl::createInstance, from.getServers());
        ModelUtils.extractAnnotations(annotation, context, "tags", TagImpl::createInstance, from.getTags());
        AnnotationModel components = (AnnotationModel)annotation.getValue("components", AnnotationModel.class);
        if (components != null) {
            from.setComponents(ComponentsImpl.createInstance(components, context));
        }
        return from;
    }

    public final ApiContext getContext() {
        return this.context;
    }

    @Override
    public String getOpenapi() {
        return this.openapi;
    }

    @Override
    public void setOpenapi(String openapi) {
        this.openapi = openapi;
    }

    @Override
    public Info getInfo() {
        return this.info;
    }

    @Override
    public void setInfo(Info info) {
        this.info = info;
    }

    @Override
    public ExternalDocumentation getExternalDocs() {
        return this.externalDocs;
    }

    @Override
    public void setExternalDocs(ExternalDocumentation externalDocs) {
        this.externalDocs = externalDocs;
    }

    @Override
    public List<Server> getServers() {
        return this.servers;
    }

    @Override
    public void setServers(List<Server> servers) {
        this.servers = servers;
    }

    @Override
    public OpenAPI addServer(Server server) {
        if (server.getUrl() != null) {
            for (Server existingServer : this.getServers()) {
                if (!server.getUrl().equals(existingServer.getUrl())) continue;
                ModelUtils.merge(server, existingServer, true);
                return this;
            }
        }
        this.servers.add(server);
        return this;
    }

    @Override
    public void removeServer(Server server) {
        this.servers.remove(server);
    }

    @Override
    public List<SecurityRequirement> getSecurity() {
        return this.security;
    }

    @Override
    public void setSecurity(List<SecurityRequirement> security) {
        this.security = security;
    }

    @Override
    public OpenAPI addSecurityRequirement(SecurityRequirement securityRequirement) {
        this.security.add(securityRequirement);
        return this;
    }

    @Override
    public void removeSecurityRequirement(SecurityRequirement securityRequirement) {
        this.security.remove(securityRequirement);
    }

    @Override
    public List<Tag> getTags() {
        return this.tags;
    }

    @Override
    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    @Override
    public OpenAPI addTag(Tag tag) {
        this.tags.add(tag);
        return this;
    }

    @Override
    public void removeTag(Tag tag) {
        this.tags.remove(tag);
    }

    @Override
    public Paths getPaths() {
        return this.paths;
    }

    @Override
    public void setPaths(Paths paths) {
        this.paths = paths;
    }

    @Override
    public OpenAPI path(String name, PathItem path) {
        this.paths.addPathItem(name, path);
        return this;
    }

    @Override
    public Components getComponents() {
        return this.components;
    }

    @Override
    public void setComponents(Components components) {
        this.components = components;
    }

    public static OpenAPI merge(OpenAPI parent, List<OpenAPI> children, boolean override) {
        for (OpenAPI child : children) {
            OpenAPIImpl.merge(child, parent, override, null);
        }
        return parent;
    }

    public static void merge(OpenAPI from, OpenAPI to, boolean override, ApiContext context) {
        if (from == null) {
            return;
        }
        to.setOpenapi(ModelUtils.mergeProperty(to.getOpenapi(), from.getOpenapi(), override));
        if (from.getInfo() != null) {
            if (to.getInfo() == null) {
                to.setInfo(new InfoImpl());
            }
            InfoImpl.merge(from.getInfo(), to.getInfo(), override);
        }
        if (from.getServers() != null) {
            for (Server server : from.getServers()) {
                if (server == null) continue;
                ServerImpl newServer = new ServerImpl();
                ServerImpl.merge(server, newServer, true);
                if (to.getServers().contains(newServer)) continue;
                to.addServer(newServer);
            }
        }
        if (from.getExternalDocs() != null) {
            if (to.getExternalDocs() == null) {
                to.setExternalDocs(new ExternalDocumentationImpl());
            }
            ExternalDocumentationImpl.merge(from.getExternalDocs(), to.getExternalDocs(), override);
        }
        if (from.getSecurity() != null) {
            for (SecurityRequirement requirement : from.getSecurity()) {
                if (requirement == null) continue;
                SecurityRequirementImpl newRequirement = new SecurityRequirementImpl();
                SecurityRequirementImpl.merge(requirement, newRequirement);
                if (to.getSecurity().contains(newRequirement)) continue;
                to.addSecurityRequirement(newRequirement);
            }
        }
        if (from.getTags() != null) {
            for (Tag tag : from.getTags()) {
                if (tag == null) continue;
                if (to.getTags() == null) {
                    to.setTags(new ArrayList<Tag>());
                }
                TagImpl newTag = new TagImpl();
                TagImpl.merge(tag, newTag, override);
                to.addTag(newTag);
            }
        }
        ComponentsImpl.merge(from.getComponents(), to.getComponents(), override, context);
        PathsImpl.merge(from.getPaths(), to.getPaths(), override);
    }
}

