/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.model.headers;

import fish.payara.microprofile.openapi.api.visitor.ApiContext;
import fish.payara.microprofile.openapi.impl.model.ExtensibleImpl;
import fish.payara.microprofile.openapi.impl.model.examples.ExampleImpl;
import fish.payara.microprofile.openapi.impl.model.media.ContentImpl;
import fish.payara.microprofile.openapi.impl.model.media.SchemaImpl;
import fish.payara.microprofile.openapi.impl.model.util.ModelUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;
import org.glassfish.hk2.classmodel.reflect.EnumModel;

public class HeaderImpl
extends ExtensibleImpl<Header>
implements Header {
    private String ref;
    private String description;
    private Boolean required;
    private Boolean deprecated;
    private Boolean allowEmptyValue;
    private Header.Style style;
    private Boolean explode;
    private Schema schema;
    private Map<String, Example> examples = new HashMap<String, Example>();
    private Object example;
    private Content content = new ContentImpl();
    private List<ContentImpl> contents = new ArrayList<ContentImpl>();

    public static Map<String, Header> createInstances(AnnotationModel annotation, ApiContext context) {
        HashMap<String, Header> map = new HashMap<String, Header>();
        List headers = (List)annotation.getValue("headers", List.class);
        if (headers != null) {
            for (AnnotationModel header : headers) {
                String headerName = (String)header.getValue("name", String.class);
                if (headerName == null) {
                    headerName = (String)header.getValue("ref", String.class);
                }
                map.put(headerName, HeaderImpl.createInstance(header, context));
            }
        }
        return map;
    }

    public static Header createInstance(AnnotationModel annotation, ApiContext context) {
        HeaderImpl from = new HeaderImpl();
        String ref = (String)annotation.getValue("ref", String.class);
        if (ref != null && !ref.isEmpty()) {
            from.setRef(ref);
        }
        from.setDescription((String)annotation.getValue("description", String.class));
        from.setRequired((Boolean)annotation.getValue("required", Boolean.class));
        from.setDeprecated((Boolean)annotation.getValue("deprecated", Boolean.class));
        from.setAllowEmptyValue((Boolean)annotation.getValue("allowEmptyValue", Boolean.class));
        EnumModel styleEnum = (EnumModel)annotation.getValue("style", EnumModel.class);
        if (styleEnum != null) {
            from.setStyle(Header.Style.valueOf(styleEnum.getValue()));
        }
        from.setExplode((Boolean)annotation.getValue("explode", Boolean.class));
        AnnotationModel schemaAnnotation = (AnnotationModel)annotation.getValue("schema", AnnotationModel.class);
        if (schemaAnnotation != null) {
            from.setSchema(SchemaImpl.createInstance(schemaAnnotation, context));
        }
        ModelUtils.extractAnnotations(annotation, context, "examples", "name", ExampleImpl::createInstance, from.getExamples());
        from.setExample(annotation.getValue("example", Object.class));
        ModelUtils.extractAnnotations(annotation, context, "content", ContentImpl::createInstance, from.getContents());
        return from;
    }

    @Override
    public String getRef() {
        return this.ref;
    }

    @Override
    public void setRef(String ref) {
        if (ref != null && !ref.contains(".") && !ref.contains("/")) {
            ref = "#/components/headers/" + ref;
        }
        this.ref = ref;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Boolean getRequired() {
        return this.required;
    }

    @Override
    public void setRequired(Boolean required) {
        this.required = required;
    }

    @Override
    public Boolean getDeprecated() {
        return this.deprecated;
    }

    @Override
    public void setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
    }

    @Override
    public Boolean getAllowEmptyValue() {
        return this.allowEmptyValue;
    }

    @Override
    public void setAllowEmptyValue(Boolean allowEmptyValue) {
        this.allowEmptyValue = allowEmptyValue;
    }

    @Override
    public Header.Style getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(Header.Style style) {
        this.style = style;
    }

    @Override
    public Boolean getExplode() {
        return this.explode;
    }

    @Override
    public void setExplode(Boolean explode) {
        this.explode = explode;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    @Override
    public Map<String, Example> getExamples() {
        return this.examples;
    }

    @Override
    public void setExamples(Map<String, Example> examples) {
        this.examples = examples;
    }

    @Override
    public Header addExample(String key, Example examplesItem) {
        if (examplesItem != null) {
            this.examples.put(key, examplesItem);
        }
        return this;
    }

    @Override
    public void removeExample(String key) {
        this.examples.remove(key);
    }

    @Override
    public Object getExample() {
        return this.example;
    }

    @Override
    public void setExample(Object example) {
        this.example = example;
    }

    @Override
    public Content getContent() {
        return this.content;
    }

    @Override
    public void setContent(Content content) {
        this.content = content;
    }

    public List<ContentImpl> getContents() {
        return this.contents;
    }

    public void setContents(List<ContentImpl> contents) {
        this.contents = contents;
    }

    public static void merge(Header from, Header to, boolean override, ApiContext context) {
        HeaderImpl fromImpl;
        if (from == null) {
            return;
        }
        if (from.getRef() != null && !from.getRef().isEmpty()) {
            ModelUtils.applyReference(to, from.getRef());
            return;
        }
        to.setDescription(ModelUtils.mergeProperty(to.getDescription(), from.getDescription(), override));
        to.setRequired(ModelUtils.mergeProperty(to.getRequired(), from.getRequired(), override));
        to.setDeprecated(ModelUtils.mergeProperty(to.getDeprecated(), from.getDeprecated(), override));
        to.setAllowEmptyValue(ModelUtils.mergeProperty(to.getAllowEmptyValue(), from.getAllowEmptyValue(), override));
        to.setStyle(Header.Style.SIMPLE);
        to.setExplode(ModelUtils.mergeProperty(to.getExplode(), from.getExplode(), override));
        if (from.getSchema() != null) {
            if (to.getSchema() == null) {
                to.setSchema(new SchemaImpl());
            }
            SchemaImpl.merge(from.getSchema(), to.getSchema(), override, context);
        }
        to.setExample(ModelUtils.mergeProperty(to.getExample(), from.getExample(), override));
        if (from.getExamples() != null) {
            for (String exampleName : from.getExamples().keySet()) {
                if (exampleName == null) continue;
                ExampleImpl example = new ExampleImpl();
                ExampleImpl.merge(from.getExamples().get(exampleName), example, override);
                to.addExample(exampleName, example);
            }
        }
        if (from instanceof HeaderImpl && (fromImpl = (HeaderImpl)from).getContents() != null) {
            if (to.getContent() == null) {
                to.setContent(new ContentImpl());
            }
            for (ContentImpl content : fromImpl.getContents()) {
                ContentImpl.merge(content, to.getContent(), override, context);
            }
        }
        if (from.getContent() != null) {
            if (to.getContent() == null) {
                to.setContent(new ContentImpl());
            }
            ContentImpl.merge((ContentImpl)from.getContent(), to.getContent(), override, context);
        }
    }

    public static void merge(String headerName, Header header, Map<String, Header> headers, boolean override, ApiContext context) {
        if (header == null) {
            return;
        }
        if (headerName == null || headerName.isEmpty()) {
            headerName = "?";
        }
        Header model = headers.getOrDefault(headerName, new HeaderImpl());
        headers.put(headerName, model);
        HeaderImpl.merge(header, model, override, context);
        if (model.getRef() != null) {
            headers.remove(headerName);
            headers.put(model.getRef().split("/")[3], model);
        }
    }
}

