/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.model.links;

import fish.payara.microprofile.openapi.api.visitor.ApiContext;
import fish.payara.microprofile.openapi.impl.model.ExtensibleImpl;
import fish.payara.microprofile.openapi.impl.model.servers.ServerImpl;
import fish.payara.microprofile.openapi.impl.model.util.ModelUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.links.Link;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;

public class LinkImpl
extends ExtensibleImpl<Link>
implements Link {
    private String operationRef;
    private String operationId;
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private Object requestBody;
    private String description;
    private String ref;
    private Server server;

    public static Link createInstance(AnnotationModel annotation, ApiContext context) {
        AnnotationModel serverAnnotation;
        LinkImpl from = new LinkImpl();
        from.setOperationRef((String)annotation.getValue("operationRef", String.class));
        from.setOperationId((String)annotation.getValue("operationId", String.class));
        List parametersAnnotation = (List)annotation.getValue("parameters", List.class);
        if (parametersAnnotation != null) {
            for (AnnotationModel parameterAnnotation : parametersAnnotation) {
                from.getParameters().put((String)parameterAnnotation.getValue("name", String.class), parameterAnnotation.getValue("expression", String.class));
            }
        }
        from.setRequestBody(annotation.getValue("requestBody", String.class));
        from.setDescription((String)annotation.getValue("description", String.class));
        String ref = (String)annotation.getValue("ref", String.class);
        if (ref != null && !ref.isEmpty()) {
            from.setRef(ref);
        }
        if ((serverAnnotation = (AnnotationModel)annotation.getValue("server", AnnotationModel.class)) != null) {
            from.setServer(ServerImpl.createInstance(serverAnnotation, context));
        }
        return from;
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    @Override
    public void setServer(Server server) {
        this.server = server;
    }

    @Override
    public String getOperationRef() {
        return this.operationRef;
    }

    @Override
    public void setOperationRef(String operationRef) {
        this.operationRef = operationRef;
    }

    @Override
    public Object getRequestBody() {
        return this.requestBody;
    }

    @Override
    public void setRequestBody(Object requestBody) {
        this.requestBody = requestBody;
    }

    @Override
    public String getOperationId() {
        return this.operationId;
    }

    @Override
    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    @Override
    public Link addParameter(String name, Object parameter) {
        if (parameter != null) {
            this.parameters.put(name, parameter);
        }
        return this;
    }

    @Override
    public void removeParameter(String name) {
        this.parameters.remove(name);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getRef() {
        return this.ref;
    }

    @Override
    public void setRef(String ref) {
        if (ref != null && !ref.contains(".") && !ref.contains("/")) {
            ref = "#/components/links/" + ref;
        }
        this.ref = ref;
    }

    public static void merge(Link from, Link to, boolean override) {
        if (from == null) {
            return;
        }
        if (from.getRef() != null && !from.getRef().isEmpty()) {
            ModelUtils.applyReference(to, from.getRef());
            return;
        }
        to.setDescription(ModelUtils.mergeProperty(to.getDescription(), from.getDescription(), override));
        to.setOperationId(ModelUtils.mergeProperty(to.getOperationId(), from.getOperationId(), override));
        to.setOperationRef(ModelUtils.mergeProperty(to.getOperationRef(), from.getOperationRef(), override));
        to.setRequestBody(ModelUtils.mergeProperty(to.getRequestBody(), from.getRequestBody(), override));
        for (String parameterName : from.getParameters().keySet()) {
            LinkImpl.applyLinkParameter(parameterName, from.getParameters().get(parameterName), to.getParameters());
        }
    }

    public static void merge(String linkName, Link link, Map<String, Link> links, boolean override) {
        if (link == null) {
            return;
        }
        if (linkName == null || linkName.isEmpty()) {
            linkName = "?";
        }
        Link model = links.getOrDefault(linkName, new LinkImpl());
        links.put(linkName, model);
        LinkImpl.merge(link, model, override);
        if (model.getRef() != null) {
            links.remove(linkName);
            links.put(model.getRef().split("/")[3], model);
        }
    }

    private static void applyLinkParameter(String parameterName, Object parameter, Map<String, Object> linkParameters) {
        if (parameterName == null || parameterName.isEmpty()) {
            parameterName = "?";
        }
        Object model = linkParameters.get(parameterName);
        model = ModelUtils.mergeProperty(model, parameter, true);
        linkParameters.put(parameterName, model);
    }
}

