/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.model.media;

import fish.payara.microprofile.openapi.api.visitor.ApiContext;
import fish.payara.microprofile.openapi.impl.model.examples.ExampleImpl;
import fish.payara.microprofile.openapi.impl.model.media.EncodingImpl;
import fish.payara.microprofile.openapi.impl.model.media.MediaTypeImpl;
import fish.payara.microprofile.openapi.impl.model.media.SchemaImpl;
import fish.payara.microprofile.openapi.impl.model.util.ModelUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;

public class ContentImpl
extends LinkedHashMap<String, MediaType>
implements Content {
    private static final long serialVersionUID = 1575356277308242221L;

    public ContentImpl() {
    }

    public ContentImpl(Map<? extends String, ? extends MediaType> items) {
        super(items);
    }

    public static ContentImpl createInstance(AnnotationModel annotation, ApiContext context) {
        ContentImpl from = new ContentImpl();
        String typeName = (String)annotation.getValue("mediaType", String.class);
        if (typeName == null || typeName.isEmpty()) {
            typeName = "*/*";
        }
        MediaTypeImpl mediaType = new MediaTypeImpl();
        from.addMediaType(typeName, mediaType);
        ModelUtils.extractAnnotations(annotation, context, "examples", "name", ExampleImpl::createInstance, mediaType.getExamples());
        mediaType.setExample(annotation.getValue("example", String.class));
        AnnotationModel schemaAnnotation = (AnnotationModel)annotation.getValue("schema", AnnotationModel.class);
        if (schemaAnnotation != null) {
            mediaType.setSchema(SchemaImpl.createInstance(schemaAnnotation, context));
        }
        ModelUtils.extractAnnotations(annotation, context, "encoding", "name", EncodingImpl::createInstance, mediaType.getEncoding());
        return from;
    }

    @Override
    public Content addMediaType(String name, MediaType item) {
        if (item != null) {
            this.put(name, item);
        }
        return this;
    }

    @Override
    public void removeMediaType(String name) {
        this.remove(name);
    }

    @Override
    public Map<String, MediaType> getMediaTypes() {
        return new ContentImpl(this);
    }

    @Override
    public void setMediaTypes(Map<String, MediaType> mediaTypes) {
        this.clear();
        this.putAll(mediaTypes);
    }

    public static void merge(ContentImpl from, Content to, boolean override, ApiContext context) {
        if (from == null) {
            return;
        }
        for (String typeName : from.getMediaTypes().keySet()) {
            MediaType fromMediaType = from.getMediaType(typeName);
            MediaType toMediaType = to.getOrDefault(typeName, new MediaTypeImpl());
            to.addMediaType(typeName, toMediaType);
            for (String encodingName : fromMediaType.getEncoding().keySet()) {
                EncodingImpl.merge(encodingName, fromMediaType.getEncoding().get(encodingName), to.getMediaType(typeName).getEncoding(), override, context);
            }
            for (String exampleName : fromMediaType.getExamples().keySet()) {
                ExampleImpl.merge(exampleName, fromMediaType.getExamples().get(exampleName), to.getMediaType(typeName).getExamples(), override);
            }
            if (fromMediaType.getExample() != null) {
                to.getMediaType(typeName).setExample(fromMediaType.getExample());
            }
            if (fromMediaType.getSchema() == null) continue;
            if (toMediaType.getSchema() == null) {
                toMediaType.setSchema(new SchemaImpl());
            }
            Schema schema = toMediaType.getSchema();
            SchemaImpl.merge(fromMediaType.getSchema(), schema, true, context);
        }
    }
}

