/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.model.media;

import fish.payara.microprofile.openapi.api.visitor.ApiContext;
import fish.payara.microprofile.openapi.impl.model.ExtensibleImpl;
import fish.payara.microprofile.openapi.impl.model.headers.HeaderImpl;
import fish.payara.microprofile.openapi.impl.model.util.ModelUtils;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.media.Encoding;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;

public class EncodingImpl
extends ExtensibleImpl<Encoding>
implements Encoding {
    private String contentType;
    private Map<String, Header> headers = new HashMap<String, Header>();
    private Encoding.Style style;
    private Boolean explode;
    private Boolean allowReserved;

    public static Encoding createInstance(AnnotationModel annotation, ApiContext context) {
        EncodingImpl from = new EncodingImpl();
        from.setContentType((String)annotation.getValue("contentType", String.class));
        from.getHeaders().putAll(HeaderImpl.createInstances(annotation, context));
        String styleEnum = (String)annotation.getValue("style", String.class);
        if (styleEnum != null) {
            from.setStyle(Encoding.Style.valueOf(styleEnum.toUpperCase()));
        }
        from.setExplode((Boolean)annotation.getValue("explode", Boolean.class));
        from.setAllowReserved((Boolean)annotation.getValue("allowReserved", Boolean.class));
        return from;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public Map<String, Header> getHeaders() {
        return this.headers;
    }

    @Override
    public void setHeaders(Map<String, Header> headers) {
        this.headers = headers;
    }

    @Override
    public Encoding addHeader(String key, Header header) {
        if (header != null) {
            this.headers.put(key, header);
        }
        return this;
    }

    @Override
    public void removeHeader(String key) {
        this.headers.remove(key);
    }

    @Override
    public Encoding.Style getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(Encoding.Style style) {
        this.style = style;
    }

    @Override
    public Boolean getExplode() {
        return this.explode;
    }

    @Override
    public void setExplode(Boolean explode) {
        this.explode = explode;
    }

    @Override
    public Boolean getAllowReserved() {
        return this.allowReserved;
    }

    @Override
    public void setAllowReserved(Boolean allowReserved) {
        this.allowReserved = allowReserved;
    }

    public static void merge(Encoding from, Encoding to, boolean override, ApiContext context) {
        if (from == null) {
            return;
        }
        to.setContentType(ModelUtils.mergeProperty(to.getContentType(), from.getContentType(), override));
        to.setStyle(ModelUtils.mergeProperty(to.getStyle(), from.getStyle(), override));
        to.setExplode(ModelUtils.mergeProperty(to.getExplode(), from.getExplode(), override));
        to.setAllowReserved(ModelUtils.mergeProperty(to.getAllowReserved(), from.getAllowReserved(), override));
        if (from.getHeaders() != null) {
            for (String headerName : from.getHeaders().keySet()) {
                if (headerName == null) continue;
                HeaderImpl.merge(headerName, from.getHeaders().get(headerName), to.getHeaders(), override, context);
            }
        }
    }

    public static void merge(String encodingName, Encoding encoding, Map<String, Encoding> encodings, boolean override, ApiContext context) {
        if (encoding == null) {
            return;
        }
        if (encodingName != null && !encodingName.isEmpty()) {
            Encoding model = encodings.getOrDefault(encodingName, new EncodingImpl());
            encodings.put(encodingName, model);
            EncodingImpl.merge(encoding, model, override, context);
        }
    }
}

