/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.model.parameters;

import fish.payara.microprofile.openapi.api.visitor.ApiContext;
import fish.payara.microprofile.openapi.impl.model.ExtensibleImpl;
import fish.payara.microprofile.openapi.impl.model.media.ContentImpl;
import fish.payara.microprofile.openapi.impl.model.util.ModelUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;

public class RequestBodyImpl
extends ExtensibleImpl<RequestBody>
implements RequestBody {
    private String description;
    private Content content = new ContentImpl();
    private List<ContentImpl> contents = new ArrayList<ContentImpl>();
    private Boolean required;
    private String ref;

    public static RequestBody createInstance(AnnotationModel annotation, ApiContext context) {
        RequestBodyImpl from = new RequestBodyImpl();
        from.setDescription((String)annotation.getValue("description", String.class));
        from.setRequired((Boolean)annotation.getValue("required", Boolean.class));
        String ref = (String)annotation.getValue("ref", String.class);
        if (ref != null && !ref.isEmpty()) {
            from.setRef(ref);
        }
        ModelUtils.extractAnnotations(annotation, context, "content", ContentImpl::createInstance, from.getContents());
        return from;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Content getContent() {
        return this.content;
    }

    @Override
    public void setContent(Content content) {
        this.content = content;
    }

    @Override
    public Boolean getRequired() {
        return this.required;
    }

    @Override
    public void setRequired(Boolean required) {
        this.required = required;
    }

    @Override
    public String getRef() {
        return this.ref;
    }

    @Override
    public void setRef(String ref) {
        if (ref != null && !ref.contains(".") && !ref.contains("/")) {
            ref = "#/components/requestBodies/" + ref;
        }
        this.ref = ref;
    }

    public List<ContentImpl> getContents() {
        return this.contents;
    }

    public void setContents(List<ContentImpl> contents) {
        this.contents = contents;
    }

    public static void merge(RequestBody from, RequestBody to, boolean override, ApiContext context) {
        RequestBodyImpl fromImpl;
        if (from == null) {
            return;
        }
        if (from.getRef() != null && !from.getRef().isEmpty()) {
            ModelUtils.applyReference(to, from.getRef());
            return;
        }
        to.setDescription(ModelUtils.mergeProperty(to.getDescription(), from.getDescription(), override));
        to.setRequired(ModelUtils.mergeProperty(to.getRequired(), from.getRequired(), override));
        if (from instanceof RequestBodyImpl && (fromImpl = (RequestBodyImpl)from).getContents() != null) {
            if (to.getContent() == null) {
                to.setContent(new ContentImpl());
            }
            for (ContentImpl content : fromImpl.getContents()) {
                ContentImpl.merge(content, to.getContent(), override, context);
            }
        }
        if (from.getContent() != null) {
            if (to.getContent() == null) {
                to.setContent(new ContentImpl());
            }
            ContentImpl.merge((ContentImpl)from.getContent(), to.getContent(), override, context);
        }
    }
}

